#include <windows.h>
#include <Winsock.h>
#include "Server.h"

#define  WM_ASYNC (WM_USER + 1)	/*   ޽ */
#define  CHAT_PORT 7001
#define  MAX_CLIENT 50			/*   ִ ִ Ŭ̾Ʈ  */

BOOL CALLBACK HandleDialog(HWND, UINT, WPARAM, LPARAM);
BOOL InitSocket(HWND);
HWND hWnd;
SOCKET m_sAccept;
SOCKET m_sClient[MAX_CLIENT];
char m_strMsg[80];
int  m_Total;				/* ä   */

/*---------------------------------------------------------------------------------------------------------------
	WinMain()                                                            
-----------------------------------------------------------------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR 
		lpCmdLine, int nCmdShow) {
	MSG msg;
	if((hWnd = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_SERVER),
	  NULL, HandleDialog)) == NULL) {
		MessageBox(NULL, "ʱȭ ", "Ȯ", MB_OK);
		return FALSE;
	}
	/* ---------------------------- ޽  ---------------------------- */
	while(GetMessage(&msg, NULL, 0, 0)) {
		 if(!IsDialogMessage(hWnd, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return msg.wParam;
}

/*---------------------------------------------------------------------------------------------------------------
	HandleDialog()                                                        
-----------------------------------------------------------------------------------------------------------------*/
BOOL CALLBACK HandleDialog(HWND hWnd, UINT iMsg, WPARAM wParam, 
 	     LPARAM lParam) {
	static 		HWND hListBox;
	static char 	buf[512];
	int 		cli_len, recv_len, i;
	SOCKET 	sock_tmp;
	SOCKADDR_IN	cli_addr;

	switch(iMsg) {
	   /* ---------------- ̾α ڽ   ߻ϴ ޽ ---------------- */
	   case WM_INITDIALOG:	
		hListBox = GetDlgItem(hWnd, IDC_OUTPUT);
 		InitSocket(hWnd);
		SendMessage(hListBox, LB_INSERTSTRING, 0,
			     (LPARAM)m_strMsg);
		return TRUE;
	   /* ---------------- ̾α ڽ "" ư   ------------- */
	   case WM_COMMAND:
		switch(wParam) {
			case IDC_EXIT:
				DestroyWindow(hWnd);
				return TRUE;
		}
		return TRUE;
	   /* ------------------------   ޽ ó -------------------------------------- */
	   case WM_DESTROY:
		PostQuitMessage(0);
		return TRUE;
	   /* -------------------------------- 񵿱 ޽ ó -------------------------------- */
	   case WM_ASYNC:
		sock_tmp = LOBYTE(wParam);
		if (sock_tmp == m_sAccept) {		
		/* ------- ο Ŭ̾Ʈ  ó ------- */
			if (m_Total < MAX_CLIENT - 1) {
			   cli_len = sizeof(cli_addr);
			   m_sClient[m_Total] = accept(m_sAccept,
			  	 (LPSOCKADDR)&cli_addr, &cli_len);
			   if(m_sClient[m_Total] == INVALID_SOCKET) {
			      wsprintf(m_strMsg, "%d ° accept() ", m_Total);
			   } else {
			   WSAAsyncSelect(m_sClient[m_Total], hWnd,
			     WM_ASYNC, FD_READ | FD_WRITE | FD_CLOSE);
			   wsprintf(m_strMsg, "%d° Ŭ̾Ʈ ߰", m_Total);
			   m_Total++ ;
			   }
				SendMessage(hListBox, LB_INSERTSTRING, 0,
				     (LPARAM)m_strMsg);
			}
		} else {			
		
		/* -----------------  ä   ó ------------------ */
		    switch(lParam) {		/* ̺Ʈ  */
			/*  ----------------   ޽ ----------------------- */
			case FD_READ:
			   memset(buf, '\0', 512);
			   recv_len = recv(sock_tmp, buf, 512, 0);
			   if ( recv_len == SOCKET_ERROR ) {
				wsprintf(m_strMsg, "recv() : %d",
				        WSAGetLastError());
				SendMessage(hListBox, LB_INSERTSTRING, 0,
					     (LPARAM)m_strMsg);
			   } else {
			       PostMessage(hWnd, WM_ASYNC, sock_tmp,
				       WSAMAKESELECTREPLY(FD_WRITE,0));
			   }
			   break;
			/* ----------------  ۽ ޽ ---------------- */
			case FD_WRITE:
			   for(i = 0; i < m_Total; i++) {
				send(m_sClient[i], buf, sizeof(buf), 0);
			   }
			break;
			/* ----------------   ޽ ------------------ */
			case FD_CLOSE:
			   for(i = 0; i < m_Total; i++) {
				if (sock_tmp == m_sClient[i]) {
				   closesocket(m_sClient[i]);
				   if( i != (m_Total - 1) ) {
					m_sClient[i] = m_sClient[m_Total-1];
				   }
				   m_Total--;
				   break;
				}
			   }
			wsprintf(m_strMsg, "%d° Ŭ̾Ʈ ", i);
			SendMessage(hListBox, LB_INSERTSTRING, 0,
				     (LPARAM)m_strMsg);
			if (m_Total == 0)
			   memset(buf, '\0', 512);
			   break;
			}
		}
		return 0;
	default:
		break;
	}
	return 0L;
}

/*---------------------------------------------------------------------------------------------------------------
	InitSocket(),   Լ 
-----------------------------------------------------------------------------------------------------------------*/
BOOL InitSocket(HWND hWnd) {
	WORD 		wVer;
	WSADATA 	wsaData;
	SOCKADDR_IN 	serv_addr;
	RECT 		rect;

	wVer = MAKEWORD(1,1);
	if(WSAStartup(wVer, &wsaData) != 0) {
		wsprintf(m_strMsg, "WSAStartup()  : %d", WSAGetLastError());
		return FALSE;
	}

	m_sAccept = socket(AF_INET, SOCK_STREAM, 0);
	if ( m_sAccept == INVALID_SOCKET ) {
		wsprintf(m_strMsg, "socket()  : %d", WSAGetLastError());
		return FALSE;
	}

	serv_addr.sin_family = AF_INET;
	serv_addr.sin_port = htons(CHAT_PORT);
	serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

	if (bind(m_sAccept, (LPSOCKADDR)&serv_addr, sizeof(serv_addr)) ==
	   SOCKET_ERROR) {
		wsprintf(m_strMsg, "bind()  : %d", WSAGetLastError());
		return FALSE;
	}
	if (listen(m_sAccept, 5) == SOCKET_ERROR) {
		wsprintf(m_strMsg, "listen()  : %d", WSAGetLastError());
		return FALSE;
	}

	if ( WSAAsyncSelect(m_sAccept, hWnd, WM_ASYNC, FD_ACCEPT) ==
	    SOCKET_ERROR ) {
 		wsprintf(m_strMsg, "WSAAsyncSelect(FD_ACCEPT)  : %d",
			 WSAGetLastError());
		return FALSE;
	}
	wsprintf(m_strMsg, " ʱȭ ");
	return TRUE;
}
