/*---------------------------------------------------------------------------------------------------------------------
	ϸ : Display_Server.java 
	   : Ŭ̾Ʈ  óϸ ޽ ۿû Ŭ̾Ʈ
			Ͽ  ޽ Ѵ. 
	 : javac Display_Server.java 
	뿹 : java Display_Server
---------------------------------------------------------------------------------------------------------------------*/

import java.io.*;
import java.net.*;
/*-----------------------------------------------------------------------------------------------------------
	Display_Server Ŭ 
-----------------------------------------------------------------------------------------------------------*/
public class Display_Server extends Thread  {
    public final static int port = 6000;
    protected int numOfConnect_thread = 0;
    protected final static int MAX_CLIENT = 4;
    public ServerSocket SSocket = null;
    public Socket s = null;
    public Connect_thread client[] = null;

	  /*------------------- main() ޼ҵ ----------------------*/
    public static void main(String args[]) {
	    new Display_Server();
		System.out.println("Display Server Start...");
    }

	  /*------- Display_Server()  ޼ҵ --------*/
    public Display_Server() {
        try {
            SSocket = new ServerSocket( port );
        } catch(IOException e) {
            System.err.println("Can't make ServerSocket!!!");
            return ;
        }
  		 client = new Connect_thread[MAX_CLIENT];
        this.start();			/* Display_Server   */
    }

	  /*------------------- run() ޼ҵ ----------------------*/
    public void run() {
        try {
            while(true) {
				if (numOfConnect_thread < MAX_CLIENT) {
					s = SSocket.accept();
    	           	 	client[numOfConnect_thread] = new Connect_thread( this, s );
        	       		client[numOfConnect_thread].start();
                   	numOfConnect_thread ++;
					System.out.println(numOfConnect_thread + "'th client is accepted");
                }
				yield();
            }
        } catch(IOException e) {
            System.err.println("Can't make Socket!!!");
            return ;
        }
    }

	/*------------------- Bye_client() ޼ҵ ----------------------*/
	public void Bye_client( Connect_thread c ) {
		for(int i = 0; i < numOfConnect_thread; i++) {
			if (client[i] == c) {
				try {
					if(client[i].s != null) client[i].s.close();
					if(client[i].sin != null) client[i].sin.close();
					if(client[i].sout != null )client[i].sout.close();
				} catch(IOException e) {
					System.out.println("IOExcepion error");
				}
				
				client[i] = client[numOfConnect_thread - 1];
				client[numOfConnect_thread - 1] = null;
				System.out.println(numOfConnect_thread + " clients are left");
				numOfConnect_thread--;
				return;
			} else {
				System.out.println(client[i].s);
			}
		}
	}
}

/*-----------------------------------------------------------------------------------------------------------
	Connect_thread Ŭ 
-----------------------------------------------------------------------------------------------------------*/
class Connect_thread extends Thread {
    Display_Server parentServer;
    Socket s;
    DataInputStream sin;
    DataOutputStream sout;

    /*--------- Conncetion()  ޼ҵ -----------*/
    public Connect_thread(Display_Server p, Socket s) {
		super();
        this.parentServer = p;
        this.s = s;

		/*  Ʈ 	*/       
        try {
            sin = new DataInputStream(s.getInputStream());
            sout = new DataOutputStream(s.getOutputStream());
        } catch(IOException e) {
            System.err.println("Can't get client's stream!!!");
            return;
        }
    }

	/*------------------- run() ޼ҵ ----------------------*/
    public void run() {
		String msg;

        while(true) {
        	try {
            	msg = sin.readLine();
	       
		       	if(msg == null) break;
				else if (msg.equals("BYE")) {
					System.out.println("Try Bye_client()");
					parentServer.Bye_client(this);
					return ;
				} else if (msg.equals("TRANS")) {
					msg = File_read();
				   	System.out.println(msg);
					Data_trans(msg);
				}
	       		yield(); 
            } catch(IOException e) {
    			    System.out.println("IOExcepted Bye_client()");
				parentServer.Bye_client(this);
				return;
            }
        }
    }

	  /*------------------- File_read() ޼ҵ ----------------------*/
	  public String File_read() {
		FileInputStream fis;
		DataInputStream is;
		String msg = null;

		try {
			fis = new FileInputStream("time.dat");
			is = new DataInputStream(fis);

			msg = is.readLine();
		} catch(Throwable e) {
			File_read();
		}
		return msg;
	}

	/*---------------- Data_trans() ޼ҵ ---------------------*/
	public void Data_trans(String msg) {
	   if(msg == null) return;
	   try {
		  sout.writeChars(msg);
		  sout.flush();
	   } catch(IOException e) {
		   System.out.println("IOException error");
	   }
	}
}
