/*-------------------------------------------------------------------------------------
	ϸ : Display_Client.java
	   :  Ͽ ͸ 䱸Ѵ
	 : javac Display_Client.java
	뿹 :  
---------------------------------------------------------------------------------------*/
import java.applet.Applet;
import java.awt.*;
import java.io.*;
import java.net.*;

/*------------------------------------------------------------------------------------
	Display_Client Ŭ 
---------------------------------------------------------------------------------------*/
public class Display_Client extends Applet implements Runnable  {
	Socket CSocket;
	DataInputStream is;
	PrintStream os;
	TextArea newslist;
	Button connect;
	Button bye;
	boolean Flag_Connected = false;
	Thread thread;
	String data = null;
	public final static int port = 6000;

	/*---------- init() ޼ҵ ----------*/
	public void init() {
		newslist = new TextArea(10, 50);
		newslist.setEditable(false);
		connect = new Button("Connect");
		bye = new Button("Bye");

		add(newslist);
		add(connect);
		add(bye);
	}

	/*---------- start() ޼ҵ ----------*/
	public void start() {
		thread = new Thread(this);
		thread.start();
	}

	/*---------- run() ޼ҵ ----------*/
	public void run() {
		while(true) {
			if(Flag_Connected == false || is == null || os == null)
				continue;
			else {
				os.println("TRANS");
				os.flush();
			}

			try {
				if(is.available() > 0)
					data = is.readLine() + '\n';
			} catch(IOException e) {
				System.out.println("IO exception");
			}
			newslist.appendText(data);
			try {
				thread.sleep(1000);
			} catch(InterruptedException e) {
				System.out.println("Interrupt exception");
			}
		}
	}

	/*---------- stop() ޼ҵ ----------*/
	public void stop() {		
		if(Flag_Connected == true) {
			os.println("BYE");
			os.flush();

			try {
				if(os != null) os.close();
				if(is != null) is.close();
				if(CSocket != null) CSocket.close();
			}
			catch(IOException e) {
				System.out.println("Can't close stream");
			}

			newslist.appendText("Disconnect.\n");
			Flag_Connected = false;
		}
		else {
			newslist.appendText("Not connect.\n");
		}
	}

	/*---------- destroy() ޼ҵ ----------*/
	public void destroy() {
		if(Flag_Connected == true) {
			os.println("BYE");
			os.flush();

			try {
				if(os != null) os.close();
				if(is != null) is.close();
				if(CSocket != null) CSocket.close();
			}
			catch(IOException e) {
				System.out.println("Can't close stream");
			}

			newslist.appendText("Disconnect.\n");
			Flag_Connected = false;
		}
		else {
			newslist.appendText("Not connect.\n");
		}
	}

	/*---------- handleEvent() ޼ҵ ----------*/
	public boolean handleEvent(Event evt) {
		if(evt.id == Event.ACTION_EVENT) {
			/* Connect ư  */
			if(evt.target == connect) {
				newslist.appendText("Connecting...\n");
				if(Flag_Connected == false) {
					try {
						CSocket = new Socket(getCodeBase().getHost(), port);
					}
					catch(IOException e) {
						newslist.appendText("Error::Can not Connect");
						return super.handleEvent(evt);
					}
					try {
						is = new DataInputStream(new					
							BufferedInputStream(CSocket.getInputStream()));
						os = new PrintStream(new 
							BufferedOutputStream(CSocket.getOutputStream(), 	
							1024), false);
					}
					catch(IOException e) {
					}
					Flag_Connected = true;
					newslist.appendText("Connect Success.\n");
				}
				else {
					newslist.appendText("Already Connect.\n");
				}
			}

			/* (Bye) ư  */
			if(evt.target == bye) {
				if(Flag_Connected == true) {
					os.println("BYE");
					os.flush();

					try {
						if(os != null) os.close();
						if(is != null) is.close();
						if(CSocket != null) CSocket.close();
					}
					catch(IOException e) {
					}
						newslist.appendText("Disconnect.\n");
						Flag_Connected = false;
				}
				else {
					newslist.appendText("Already disconnect.\n");
				}
			}
		}
		return super.handleEvent(evt);
	}
}
