/*---------------------------------------------------------------------------------------------
ϸ : socket_delay.c
   :  Լ ó ҿ ð [nsec]   
 : cc -o socket_delay socket_delay.c -lsocket -lnsl -lposix4
࿹ : socket_delay
----------------------------------------------------------------------------------------------*/

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/times.h>
#include <netinet/in.h>
#include <time.h>
#include <stdio.h>

#define   IP_addr   "203.252.65.3"		/*  IP ּ */
#define   port_number    7				/* echo  Ʈȣ */

long calclock (struct timespec *myclock);		/* ð ̸ ϴ Լ */
void insertnull (char *ps, int len);			/* ʱȭ Լ*/

void main(void) {
   int 	s;				/* Ϲȣ */
   int 	cd, wd, rd;
   struct 	sockaddr_in serv_addr;
   struct 	timespec myclock[2];
   long	timedelay;
   char 	wmsg[] = " To be or not to be, that is the problem...";
   char 	rbuf[100];
   
   bzero((char *)&serv_addr, sizeof(serv_addr));
   serv_addr.sin_family = AF_INET;
   serv_addr.sin_addr.s_addr = inet_addr(IP_addr);
   serv_addr.sin_port = htons(port_number);

   /* ------------------- socket() ó ð  ---------------------- */
   clock_gettime(CLOCK_REALTIME, &myclock[0]);
   s = socket(PF_INET, SOCK_STREAM, 0);
   clock_gettime(CLOCK_REALTIME, &myclock[1]);
   
   timedelay = calclock( myclock );
   printf("For 'socket' call :	%10ld nsec \n", timedelay); 

   /* -------------------- connect() ó ð  ---------------------- */
   clock_gettime(CLOCK_REALTIME, &myclock[0]);
   cd = connect(s, (struct sockaddr *)&serv_addr, sizeof(serv_addr));
   clock_gettime(CLOCK_REALTIME, &myclock[1]);
   
   timedelay = calclock(myclock);
   printf("For 'connect' call :	%10ld nsec \n", timedelay);

   /* -------------------- write() ó ð  ------------------------ */
   clock_gettime(CLOCK_REALTIME, &myclock[0]);
   wd = write(s, wmsg, sizeof(wmsg));
   clock_gettime(CLOCK_REALTIME, &myclock[1]);

   timedelay = calclock( myclock );
   printf("For 'write' call :	%10ld nsec \n", timedelay);
   
   /* --------------------- read() ó ð  ------------------------- */
   clock_gettime(CLOCK_REALTIME, &myclock[0]);
   rd = read(s, rbuf, sizeof(rbuf));
   clock_gettime(CLOCK_REALTIME, &myclock[1]);
   
   timedelay = calclock( myclock );
   printf("For 'read' call :	%10ld nsec \n", timedelay); 
   
   /* --------------------- close() ó ð  ------------------------- */
   clock_gettime(CLOCK_REALTIME, &myclock[0]);
   close(s);
   clock_gettime(CLOCK_REALTIME, &myclock[1]);
   timedelay = calclock( myclock );
   printf("For 'close' call :	%10ld nsec \n", timedelay);
}

/*--------------------------------------------------------------------------------------------
	 迭 myclock[]  ð ϴ Լ 
---------------------------------------------------------------------------------------------*/
long calclock( struct timespec *myclock ) {
	
   long    timedelay, temp, temp_n;

   if (myclock[1].tv_nsec >= myclock[0].tv_nsec) {
      temp = myclock[1].tv_sec - myclock[0].tv_sec;
      temp_n = myclock[1].tv_nsec - myclock[0].tv_nsec;
      timedelay = 1000000000 * temp + temp_n;
   } else {
      temp = myclock[1].tv_sec - myclock[0].tv_sec - 1;
      temp_n = 1000000000 + myclock[1].tv_nsec - myclock[0].tv_nsec;
      timedelay = 1000000000 * temp + temp_n;
   }

   return timedelay;
}