/*----------------------------------------------------------------------------------------------
ϸ : talk_server.c
   : ũ Ŭ̾Ʈ 1:1  Ѵ.
 : cc -o talk_server talk_server.c readline.c -lsocket -lnsl                    
뿹 : talk_server 3000
----------------------------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#define MAXLINE 1024

int readline(int, char *, int);
char *escapechar = "exit\n";		/* Ṯ */

int main(int argc, char *argv[]) {
   int server_fd, client_fd;		/* Ϲȣ */
   int clilen, num;			
   char sendline[MAXLINE], rbuf[MAXLINE];
   int size;
   pid_t pid;
   struct sockaddr_in client_addr, server_addr;
   
   if (argc < 2)  {
      printf("Usage: %s TCP_PORT\n", argv[0]);
      return -1;
   }

   /*   */
   if((server_fd=socket(PF_INET, SOCK_STREAM, 0)) < 0) {
      printf("Server: Can't open stream socket\n");
      return -1;
   }
   
   /*  ּ ü server_addr '0' ʱȭ */
   bzero((char *)&server_addr, sizeof(server_addr));
   
   /* server_addr  */
   server_addr.sin_family = AF_INET;
   server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
   server_addr.sin_port = htons(atoi(argv[1]));
   
   /* bind() ȣ */
   if(bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
      printf("Server: Can't bind local address \n");
      return -1;
   }
   
   printf("Server started.\nWaiting for client..");
   listen(server_fd, 1);
         
   /* Ŭ̾Ʈ û  */
   clilen = sizeof(client_addr);
   if((client_fd = accept(server_fd,(struct sockaddr *)&client_addr, &clilen)) != -1) {
      printf("Server: client connected\n");
   } else {
      printf("Server: failed in accepting.\n");
      return -1;
   }
   
   /* θ μ Ű Է Ŭ̾Ʈ  */
   if((pid = fork()) > 0) {
      while(readline(0, sendline, MAXLINE) != 0) {
         size = strlen(sendline);
         if(write(client_fd, sendline, size) != size) {
            printf("Server: fail in writing\n");
         }
         /*  ڿ Է Ȯ */
         if(strncmp(sendline, escapechar, 4) == 0) {   
	        kill(pid, SIGQUIT);
            break;
         }
      }

    /* ڽμ κ  ޽ ȭ鿡  */
    } else if (pid == 0) {
      while(1) {
         if((size = read(client_fd, rbuf, MAXLINE)) > 0) {
            rbuf[size] = '\0';
            /* Ṯڿ  ó */
            if (strncmp(rbuf, escapechar, 4) == 0)  break;   
            printf("%s", rbuf);
         }
      }
   }
   close(server_fd);
   close(client_fd);
}
