/* -----------------------------------------------------------------------------
 ϸ : test_bind.c
    : ý ڵ  Ʈȣ ϴ α׷ 
  : cc -o test_bind test_bind.c -lsocket -lnsl
 ࿹ : test_bind 
 ---------------------------------------------------------------------------- */
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#define	MSG	"Test Message"

int main() {
   int                sd1, sd2 ;			    /* Ϲȣ */
   struct sockaddr_in ServerAddr, ClientAddr ;   /* ּ ü */
   u_short            rtn1, rtn2;                /* Ʈȣ */
   int			  addr_len ;

   /* ּ ü ʱȭ */
   ServerAddr.sin_family = ClientAddr.sin_family = PF_INET ;
   ServerAddr.sin_addr.s_addr = ClientAddr.sin_addr.s_addr = htonl(INADDR_ANY) ;
   ServerAddr.sin_port = htons(7);
   ClientAddr.sin_port = htons(0) ;              /* ý Ʈȣ  */

   sd1=socket(AF_INET, SOCK_STREAM, 0);
   sd2=socket(AF_INET, SOCK_DGRAM, 0);

   addr_len=sizeof(ClientAddr);
   if(bind(sd1, (struct sockaddr*)&ClientAddr, addr_len)) printf("bind error!\n");
   if(connect(sd1, (struct sockaddr*)&ServerAddr, sizeof(ServerAddr))<0) { 
	printf("Error : Connect failed!!!\n") ; 
	exit(1) ; 
   } 
   getsockname(sd1, (struct sockaddr*)&ClientAddr, &addr_len) ;
   rtn1 = ClientAddr.sin_port ; 

   sendto(sd2, MSG, strlen(MSG), 0, (struct sockaddr*)&ServerAddr, sizeof(ServerAddr)) ;
   getsockname(sd2, (struct sockaddr*)&ClientAddr, &addr_len) ;
   rtn2 = ClientAddr.sin_port ; 

   printf("stream socket's bind return = %d\n", rtn1 ) ; 
   printf("datagram socket's bind return = %d\n", rtn2) ;

   close(sd1) ;
   close(sd2) ;
}
