   /* ------------------------------------------------------------------------------------------
     ϸ : pktdfin.c
        : Ŷ ̹ ϱ  ̺귯 Լ 
   ---------------------------------------------------------------------------------------------- */
    #include "pktdfin.h"
    /*------------------------------------------------------------------*/
    driver_info(int intno ,struct packet_info *pptr) {
	union REGS regs;
	struct SREGS sregs;

	regs.x.ax = DRIVER_INFO*256+0xff;
	regs.x.bx = 0;
	int86x(intno, &regs, &regs, &sregs);
	if(regs.x.cflag){
		Derr = regs.h.dh;
		printf("Error at DRIVER_INFO function : %c",Derr);
		return -1;
	} else {
		pptr->packet_version  = regs.x.bx;
		pptr->packet_class    = regs.h.ch;
		pptr->packet_type     = regs.x.dx;
		pptr->packet_ifnumber = regs.h.cl;
		pptr->packet_name     = (char *)MK_FP(sregs.ds, regs.x.si);
		pptr->packet_extended = regs.h.al == 2 ? 2 : 1;
	return 0;
	}
   }
   /*------------------------------------------------------------------*/
   int access_type(int intno, int if_class, int if_type,
	       int if_number, char *type, unsigned typelen,
	       int interrupt (*receiver)()) {
      union REGS regs;
      struct SREGS sregs;
      printf("intno : %0x\n",intno);
      segread(&sregs);

      regs.h.dl = if_number;
      sregs.ds  = FP_SEG(type);
      regs.x.si = FP_OFF(type);
      regs.x.cx = typelen;
      sregs.es  = FP_SEG(receiver);
      regs.x.di = FP_OFF(receiver);
      regs.x.bx = if_type;
      regs.h.ah = ACCESS_TYPE;
      regs.h.al = if_class;
      int86x(intno,&regs,&regs,&sregs);
      if(regs.x.cflag) {
         Derr=regs.h.dh;
         printf("Error at Access type function : %x",regs.h.dh);
         return -1;
      } else
         return regs.x.ax;/* retrun Handle value*/
   }
   /*------------------------------------------------------------------*/
   int get_rcv_mode(int intno, int thandle, int mode) {
	union REGS regs;
	char far *param;
	int oldmode;                              
	regs.h.ah = GET_RCV_MODE;
	regs.x.bx = thandle;
	int86(intno,&regs,&regs);
	if(regs.x.cflag){
		Derr = regs.h.dh;
		printf("Error at Get Receiver Mode function : %x",Derr);
		return -1;
	}
	oldmode = regs.x.ax;
	return oldmode;
   }
   /*------------------------------------------------------------------*/
   int set_rcv_mode(int intno, int thandle, int mode) {
	union REGS regs;
	regs.h.ah	= SET_RCV_MODE;
	regs.x.cx = mode;
	regs.x.bx = thandle;
	int86(intno,&regs,&regs);
	if(regs.x.cflag){
		Derr = regs.h.dh;
		printf("Error at Set Receiver mode : %x\n",Derr);
		return -1;
	} else
	return 0;
   }
   /*------------------------------------------------------------------*/
   int send_pkt(int intno, char *buffer,unsigned length) {
     union REGS regs;
     struct SREGS sregs;

     segread(&sregs);
     sregs.ds = FP_SEG(buffer);
     sregs.es = FP_SEG(buffer);
     regs.x.si = FP_OFF(buffer);
     regs.x.cx = length;
     regs.h.ah = SEND_PKT;
     printf("intno : %0x\n",intno);
     int86x(intno,&regs,&regs,&sregs);
     if(regs.x.cflag){
        Derr = regs.h.dh;
        printf("Error at Send Packet function : %x", Derr);
        return -1;
     } else
        return 0;
   }
  /*------------------------------------------------------------------*/
  int release_type(int intno, int thandle) { 
    union REGS regs;
    regs.x.bx = thandle;
    regs.h.ah = RELEASE_TYPE;
    int86(intno,&regs,&regs);
    if(regs.x.cflag){
       Derr = regs.h.dh;
       printf("Error at release_type : %c",regs.h.dh);
       return -1;
    }else
       return 0;
  }
  /*------------------------------------------------------------------*/
  int get_address(int intno, int thandle, char *buf,int len) {
    union REGS regs;
    struct SREGS sregs;

    segread(&sregs);
    sregs.es  = FP_SEG(buf);
    regs.x.di = FP_OFF(buf);
    regs.x.cx = len;
    regs.x.bx = thandle;
    regs.h.ah = GET_ADDRESS;
    int86x(intno,&regs,&regs,&sregs);
    if(regs.x.cflag){
       Derr = regs.h.dh;
       printf("Error at get address function : %x",Derr);
       return -1;
    } else
       return 0;
  }
  /*------------------------------------------------------------------*/
  int test_for_pd(int intno) {
    long drvvec;
    char sig[8];/* Copy of driver signature "PKT DRVR" */
    /* Finding interrupt vector of Packet Driver routine
     * with Comparing Driver's signature */
    drvvec = (long)getvect(intno);
    _fmemcpy(sig, MK_FP(FP_SEG(drvvec),FP_OFF(drvvec)+3), strlen(Pkt_sig));
    return !strncmp(sig, Pkt_sig,strlen(Pkt_sig));
  }
  /*------------------------------------------------------------------*/
  int find_vector(void) {
     int count;
     for(intno=0x60,count=1;intno<=0x80;intno++,count++) {
        if(!test_for_pd(intno)){
        /*clrscr();*/
        /*printf("\nNo packet driver was found\n");*/
     intno = intno - 1;
	printf("intno : %d\n",intno);
	return intno;
     }
     printf("%d'th intno(%0x)\n",count,intno);
   }
  }