/*
    ettercap -- dissector POP3 -- TCP 110

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: ec_dissector_pop.c,v 1.7 2002/06/28 17:04:28 alor Exp $
*/

#include "include/ec_main.h"

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"

// protos

FUNC_DISSECTOR(Dissector_pop);

// --------------------


FUNC_DISSECTOR(Dissector_pop)
{

   TCP_header *tcp;
   u_char *payload;
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (ntohs(tcp->source) == SERV_PORT) return 0;     // skip server messages...
   if (data_to_ettercap->datalen == 0) return 0;      // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);

   if ( !strncasecmp(payload, "USER", 4) )
   {
      DEBUG_MSG("\tDissector_POP USER");
      strlcpy(data_to_ettercap->user, payload + strlen("USER "), sizeof(data_to_ettercap->user));
   }

   if ( !strncasecmp(payload, "PASS", 4) )
   {
      DEBUG_MSG("\tDissector_POP PASS");
      strlcpy(data_to_ettercap->pass, payload + strlen("PASS "), sizeof(data_to_ettercap->pass));
   }

   if ( !strncasecmp(payload, "APOP", 4) )
   {
      char collector[MAX_DATA];
      char *p;

      DEBUG_MSG("\tDissector_POP APOP");

      memset(collector, 0, MAX_DATA);
      memcpy(collector, payload, data_to_ettercap->datalen);

      p = strtok(collector + strlen("APOP "), " ");
      if (p)
      {
         snprintf(data_to_ettercap->user, sizeof(data_to_ettercap->user), "%s\n", p);
         sprintf(data_to_ettercap->pass, "\n");
         p = strtok(NULL, " ");
         snprintf(data_to_ettercap->info, sizeof(data_to_ettercap->info), "Authenticated with APOP %s\n", (p) ? p : "");
      }
   }

   return 0;
}


/* EOF */

// vim:ts=3:expandtab

