/*
    ettercap -- debug module

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: ec_debug.c,v 1.16 2002/05/17 13:48:20 alor Exp $
*/

#include "include/ec_main.h"

#ifdef DEBUG

#include <stdarg.h>
#ifdef HAVE_SYS_UTSNAME_H
   #include <sys/utsname.h>
   #ifdef LINUX
      #include <features.h>
   #endif
#endif
#ifdef HAVE_NCURSES
   #ifdef HAVE_NCURSES_H
      #include <ncurses.h>
   #else
      #include <curses.h>
   #endif
#endif

#ifdef CYGWIN
	#include <Packet32.h>
#endif

#ifndef DEBUG_FILE
   #define DEBUG_FILE "ettercap_debug.log"
#endif

#include "include/ec_thread.h"
#include "include/ec_debug_info.h"

FILE *debug_dev;

void debug_init(void);
void debug_close(void);

#ifdef MACOSX
void DEBUG_MSG(char *message, ...);
#else
void debug_msg(char *message, ...);
#endif

//----------------------------

void debug_init(void)
{
#ifdef HAVE_SYS_UTSNAME_H
   struct utsname buf;
#endif

   if ((debug_dev = fopen (DEBUG_FILE, "w")) == NULL) {
      ERROR_MSG("Couldn't open DEBUG FILE!");
   }
   
   fprintf (debug_dev, "\n==============================================================\n\n");
   fprintf (debug_dev, "Configured with  :  %s \n\n", configure_line);
   fprintf (debug_dev, "Detected options :  NCURSES  %s \n", configure_ncurses);
   fprintf (debug_dev, "                    FORM     %s \n", configure_form);
   fprintf (debug_dev, "                    PLUGINS  %s \n", configure_plugins);
   fprintf (debug_dev, "                    SSH      %s \n", configure_ssh);
   fprintf (debug_dev, "                    HTTPS    %s \n\n", configure_https);
   fprintf (debug_dev, "Programs path    :  wget     %s \n", WGET_PATH);
   fprintf (debug_dev, "                    openssl  %s \n", OPENSSL_PATH);
   fprintf (debug_dev, "\n==============================================================\n");
                   
   #if DEVEL_RELEASE == 1
   	fprintf (debug_dev, "\n-> %s %s beta %s\n\n", PROGRAM, VERSION, RELEASE_DATE);
   #else
   	fprintf (debug_dev, "\n-> %s %s\n\n", PROGRAM, VERSION);
   #endif
   #ifdef HAVE_SYS_UTSNAME_H
      uname(&buf);
      fprintf (debug_dev, "-> running on %s %s %s\n", buf.sysname, buf.release, buf.machine);
   #endif
   #if defined (__GLIBC__) && defined (__GLIBC_MINOR__)
      fprintf (debug_dev, "-> glibc version %d.%d\n", __GLIBC__, __GLIBC_MINOR__);
   #endif
   #ifdef CYGWIN
   	fprintf (debug_dev, "-> packet driver version %s\n", PacketGetVersion());
   #endif
   #if defined (__GNUC__) && defined (__GNUC_MINOR__)
      fprintf (debug_dev, "-> compiled with gcc %d.%d\n", __GNUC__, __GNUC_MINOR__);
   #endif
   #ifdef HAVE_NCURSES
   	#ifdef CYGWIN
   		fprintf (debug_dev, "-> pdcurses %d \n", PDC_BUILD);
   	#else
   		fprintf (debug_dev, "-> %s\n", curses_version());
   	#endif
   #endif
   fprintf (debug_dev, "\n\nDEVICE OPENED FOR %s DEBUGGING\n\n", PROGRAM);
   fflush(debug_dev);
   atexit(debug_close);
}



void debug_close(void)
{
   fprintf (debug_dev, "\n\nDEBUGGING DEVICE FOR %s WAS CLOSED\n\n", ECThread_getname(pthread_self()));
   fclose (debug_dev);
}



#ifdef MACOSX
void DEBUG_MSG(char *message, ...)
#else
void debug_msg(char *message, ...)
#endif
{
   va_list ap;
   char debug_message[strlen(message)+2];

   fprintf (debug_dev, "%-10s\t", ECThread_getname(pthread_self()));

   strlcpy(debug_message, message, sizeof(debug_message));
   strlcat(debug_message, "\n", sizeof(debug_message));

   va_start(ap, message);
   vfprintf(debug_dev, debug_message, ap);
   va_end(ap);

   fflush(debug_dev);

}

#else /* not defined DEBUG */

#ifdef MACOSX
   /*
    * damned MACOSX  cc compiler !!
    * it doesn't support our macro DEBUG_MSG(x, args...)
    */

   void DEBUG_MSG(char *message, ...);

   void DEBUG_MSG(char *message, ...)
   {
      return;
   }
#endif

#endif /* DEBUG */

/* EOF */

// vim:ts=3:expandtab

