#!/usr/local/bin/perl

#####################################################################
##
## Rcs_ID="$RCSfile: nbu.pl,v $"
## Rcs_ID="$Revision: 1.13 $ $Date: 2000/05/31 22:18:25 $"
##
#####################################################################

#Right now this is the maxslot variable.  It says how many slots are
#in the importexport door
$maxslots=1 ;
$expire_for_db_tapes=34128000 ;



use Config;
my $osname = $Config{'osname'};

if ( $osname eq MSWin32 ) {
	$openv='c:\\veritas\\netbackup' ;
	$volmgr='c:\\veritas\\volmgr' ;
	$ENV{'PATH'} = "C:\\WINNT\\System32;C:\\Veritas\\Netbackup\bin;C:\\Veritas\\Netbackup\\bin\\goodies;C:\\Veritas\\Netbackup\\bin\\admincmd;C:\\Veritas\\Volmgr\\bin;C:\\Veritas\\Volmgr\\bin\goodies";
	$bg="";
	$cat="type";
	$db="\\db\\sr.0";
	$hostname=`hostname`; chomp $hostname;
	$mail="Blat -";
	$mailtoarg="-t";
	$mailccarg="-c";
	$mailsubarg="-s";
	$mt=0;
	$ps=0;
	$symlinks=0;
	$rcscript=undef;
	$tmp="C:\\TEMP\\";
}

else {
	open(VERSION,"/usr/openv/netbackup/version");
	while ( my $line = <VERSION> ) {
	 chomp $line;
	 if ( $line =~ /VERSION/ ) {
	   @line = split(/\s+/, $line);
	   $nbuversion=$line[3];
	 }
	}
	$openv='/usr/openv/netbackup' ;
	$volmgr='/usr/openv/volmgr' ;
	$ENV{'PATH'} = "/usr/sbin:/bin:/usr/bin:/usr/local/bin:/usr/ucb:$openv/bin:$openv/bin/goodies:$openv/bin/admincmd:$volmgr/bin:$volmgr/bin/goodies";
	$bg='&';
	$cat="cat";
	$db="/db";
	$mail="mhmail";
	$mailtoarg="";
	$mailccarg="-cc";
	$mailsubarg="-s";
	$mt=1;
	$ps=1;
	$rcscript="/etc/init.d/netbackup";
	$symlinks=1;
	$tmp="/var/tmp/";
	use Sys::Hostname ;
	$master = hostname() ;
}

#Set this debug flag to "Y" to turn on some verbose output

if (defined($ARGV[0])) {

if ( $ARGV[0] eq "-d" ) {
	$debug="Y"
	}
else {
	$debug="N"
	}

if ( $ARGV[0] eq "-c" ) {
	$show_commands="Y"
	}
else {
	$show_commands="N"
	}
}

if (defined($ARGV[1])) {

if ( $ARGV[1] eq "-d" ) {
	$debug="Y"
	}
else {
	$debug="N"
	}

if ( $ARGV[1] eq "-c" ) {
	$show_commands="Y"
	}
else {
	$show_commands="N"
	}
}

sub Get_robots {

if ( $debug ne Y ) { &Clear_screen }  

print "\nQuerying Netbackup for a list of robots.  (Please wait...)\n" ;

$vmquery_cmd='vmquery -a' ;
if ( $show_commands eq Y ) {print "($vmquery_cmd)\n"}

open(VMQUERY,"$vmquery_cmd|");

while (<VMQUERY>) {
	next unless 
	( $_ =~ /media ID:|media type:|robot type:|robot number:|robot host:/ ) ;
	if ( $_ =~ /media ID:/ ) {
		if ( defined $robot_num ) { undef $robot_num } ;
		if ( defined $density_num ) { undef $density_num } ;
		if ( defined $density ) { undef $density } ;
		if ( defined $robot_type_num ) { undef $robot_type_num } ;
		if ( defined $robot_type ) { undef $robot_type } ;
		if ( defined $robot_host ) { undef $robot_host } ;
	}
	if ( $_ =~ /robot number:/ ) {
		@line=split /\s+/ ;
		$robot_num=$line[2] ;
        #print "rn=$line[2]\n";
	}
	elsif ( $_ =~ /media type:/ ) {
		s/.*\(// ;
		s/\).*// ;
		$density_num = $_ ;
		$density=&Get_media_type($density_num) ;
        #print "dens=$density\n";
	}
	elsif ( $_ =~ /robot type:/ ) {
		s/.*\(// ;
		s/\).*// ;
		$robot_type_num = $_ ;
		$robot_type=&Get_robot_type($robot_type_num) ;
        #print "rt=$robot_type\n";
	}
	else {
		@line=split /\s+/ ;
		$robot_host=$line[2] ;
		if (defined $density and defined $robot_type ) {
		unless ( defined ($robot_hosts{$robot_num})) {
			$robot_hosts{$robot_num} = $robot_host ;
			$robot_densities{$robot_num} = $density ;
			$robot_types{$robot_num} = $robot_type ;
		}
		}
        #print "robot_host=$robot_host\n";
	}
}

} ;

sub Get_robot_type {
	my $robot_type_num=$_[0];
	my $robot_type;
	if    ( $robot_type_num == "8"  ) { $robot_type = "TLD"  }
	elsif ( $robot_type_num == "10" ) { $robot_type = "TSD"  }
	elsif ( $robot_type_num == "1"  ) { $robot_type = "ACS"  }
	elsif ( $robot_type_num == "2"  ) { $robot_type = "TS8"  }
	elsif ( $robot_type_num == "3"  ) { $robot_type = "TC8"  }
	elsif ( $robot_type_num == "6"  ) { $robot_type = "TL8"  }
	elsif ( $robot_type_num == "7"  ) { $robot_type = "TL4"  }
	elsif ( $robot_type_num == "9"  ) { $robot_type = "TC4"  }
	elsif ( $robot_type_num == "5"  ) { $robot_type = "ODL"  }
	elsif ( $robot_type_num == "11" ) { $robot_type = "TSH"  }
	elsif ( $robot_type_num == "12" ) { $robot_type = "TLH"  }
	elsif ( $robot_type_num == "13" ) { $robot_type = "TLM"  }
	elsif ( $robot_type_num == "17" ) { $robot_type = "LMF"  }
	elsif ( $robot_type_num == "0"  ) { $robot_type = "NONE" }
	return $robot_type;
}

sub Get_density {
 my $density_num=$_[0] ;
 my $density;
 if    ( $density_num == "13"  ) { $density = "dlt"    }
 elsif ( $density_num == "N/A"  ) { $density = "N/A"  }
 elsif ( $density_num == "16" ) { $density = "8mm"    }
 elsif ( $density_num == "12"  ) { $density = "4mm"    }
 elsif ( $density_num == "6"  ) { $density = "hcart"  }
 elsif ( $density_num == "19" ) { $density = "dtf"    }
 elsif ( $density_num == "9"  ) { $density = "odiskwm"  }
 elsif ( $density_num == "10"  ) { $density = "odiskwo"  }
 elsif ( $density_num == "0"  ) { $density = "qscsi"  }
 elsif ( $density_num == "15" ) { $density = "dlt2"   }
 elsif ( $density_num == "14" ) { $density = "hcart2" }
 elsif ( $density_num == "20" ) { $density = "hcart3" }
 return $density;
}

sub Get_media_type {
	my $density_num=$_[0] ;
	if    ( $density_num == "11"  )  { $density = "dlt"    }
        elsif ( $density_num == "N/A"  ) { $density = "N/A"  }
        elsif ( $density_num == "4" )    { $density = "8mm"    }
        elsif ( $density_num == "9"  )   { $density = "4mm"    }
        elsif ( $density_num == "6"  )   { $density = "hcart"  }
        elsif ( $density_num == "22" )   { $density = "dtf"    }
        elsif ( $density_num == "1"  )   { $density = "odiskwm"  }
        elsif ( $density_num == "2"  )   { $density = "odiskwo"  }
        elsif ( $density_num == "8"  )   { $density = "qscsi"  }
        elsif ( $density_num == "16" )   { $density = "dlt2"   }
        elsif ( $density_num == "14" )   { $density = "hcart2" }
        elsif ( $density_num == "24" )   { $density = "hcart3" }
        elsif ( $density_num == "12"  )  { $density = "dlt"    }
        elsif ( $density_num == "5" )    { $density = "8mm"    }
        elsif ( $density_num == "10"  )  { $density = "4mm"    }
        elsif ( $density_num == "13"  )  { $density = "hcart"  }
        elsif ( $density_num == "23" )   { $density = "dtf"    }
        elsif ( $density_num == "17" )   { $density = "dtf"    }
        elsif ( $density_num == "15" )   { $density = "hcart2"    }
        elsif ( $density_num == "25" )   { $density = "hcart3"    }
        return $density;
sity;
}

sub Get_density_num {
	my $density=$_[0] ;
	my $density_num;
	$density =~  tr/A-Z/a-z/ ;
	if    ( $density eq "dlt"  ) { $density_num = "13"    }
	elsif ( $density eq "8mm" ) { $density_num = "16"    }
	elsif ( $density eq "4mm"  ) { $density_num = "12"    }
	elsif ( $density eq "hcart"  ) { $density_num = "6"  }
	elsif ( $density eq "dtf" ) { $density_num = "19"    }
	elsif ( $density eq "odiskwm"  ) { $density_num = "9"  }
	elsif ( $density eq "odiskwo"  ) { $density_num = "10"  }
	elsif ( $density eq "qscsi"  ) { $density_num = "0"  }
	elsif ( $density eq "dlt2" ) { $density_num = "15"   }
	elsif ( $density eq "hcart2" ) { $density_num = "14" }
	elsif ( $density eq "hcart3" ) { $density_num = "20" }
	return $density_num;
}

#I'm not sure where this is used, but it's here in case I need it...
#(It got built accidentally...) ;)
sub Get_drive_type {
	my $drive_type_num=$_[0] ;
	my $drive_type;
	if    ( $drive_type_num == "9"  ) { $drive_type = "dlt"    }
	elsif ( $drive_type_num == "12" ) { $drive_type = "8mm"    }
	elsif ( $drive_type_num == "8"  ) { $drive_type = "4mm"    }
	elsif ( $drive_type_num == "3"  ) { $drive_type = "hcart"  }
	elsif ( $drive_type_num == "15" ) { $drive_type = "dtf"    }
	elsif ( $drive_type_num == "6"  ) { $drive_type = "odisk"  }
	elsif ( $drive_type_num == "0"  ) { $drive_type = "qscsi"  }
	elsif ( $drive_type_num == "11" ) { $drive_type = "dlt2"   }
	elsif ( $drive_type_num == "10" ) { $drive_type = "hcart2" }
	elsif ( $drive_type_num == "16" ) { $drive_type = "hcart3" }
	return $drive_type;
}


sub Choose_robots {

# determine if the function has any parameters passed to it

if ( @_ == () ) {

while (1) {
	print  <<EOF ;

CLAM can only work with one robot at a time.
Please choose from the following list of robots by entering
its corresponding robot number:

EOF

	printf("%-6s   %-10s   %-20s\n", "ROBOT","DRIVE","ROBOT");
	printf("%-6s   %-10s   %-20s\n", "NUMBER","TYPE","HOST");
	print "------   ----------   --------------------\n" ;

	foreach $robot_num ( keys (%robot_hosts) ) {
		$robot_host = $robot_hosts{$robot_num} ;
		$density = $robot_densities{$robot_num} ;
		if ( "$density" ) { 
			printf("%-6s   %-10s   %-20s\n", "$robot_num","$density","$robot_host")
				}
	}
			
	print "\nWhich robot number would you like to work with? " ;
	
	$choice=<STDIN> ;
	chomp $choice ;

	unless ( defined ($robot_hosts{$choice}) ) {
		print "\nThe number \"$choice\" is not a valid choice from the list above!\n";
		sleep 2 ;
		if ( $debug ne Y ) { &Clear_screen } 
		next ;
		}
	last ;
}

} # of unless


print "\nObtaining information about robot $choice...\n" ;

 $robot_num=$choice ;
 $robot_host = $robot_hosts{$robot_num} ;
 $robot_type =  $robot_types{$robot_num} ;
 $density = $robot_densities{$robot_num} ;
 $lc_robot_type = $robot_type ;
 $lc_robot_type =~ tr/A-Z/a-z/ ;

	$loopit="doit";
	while ( "$loopit" eq "doit" ) {
		print "\nCLAM uses a default value of $maxslots for the number of slots in the\n";
		print "import/export door of the robot.  If you have a different number of slots\n";
		print "in the import/export door of robot $robot_num, enter it here: ";
		$newmaxslots=<STDIN>;
		chomp $newmaxslots;
		if ( "$newmaxslots" ) {
			if ( $newmaxslots < 0 or $newmaxslots > 25 ) {
				print "You must specify a value greater than 0 and less than 25.\n\n";
				sleep 2;
			}
			else {
				$loopit="goon";
				$maxslots=$newmaxslots;
			}
		}
		else {$loopit="goon"}
		print "\nYou will be able to import or export $maxslots tapes at a time.\n";
		sleep 2;
	}

}

sub Clear_screen {

	print <<EOF





















































EOF
}

sub by_number {
	if    ($a < $b)  { -1; }
	elsif ($a == $b) {  0; }
	elsif ($a > $b)  {  1; }
}

sub List_media {
		%media_ids_w_data=() ;
		%media_kbytes=() ;
		%media_density=() ;
		%media_allocated=() ;
		%media_updated=() ;
		%media_expires=() ;
		%media_read=() ;
		%media_ids=() ;
		%media_slots=() ;
		%media_sides=() ;

	#First, we start with a list of all used tapes.  These are the ones that
	#will be listed by bpmedialist

	$arguments="" ;
	foreach $thisarg (@_) {
		$arguments="$arguments $thisarg";
	}

	if ( $arguments =~ /null/) {
		$bpmedia_cmd="bpmedialist -l" ;
		print "\nObtaining information about all NetBackup media...\n\n" ;
	}
	else {
		$bpmedia_cmd="bpmedialist -l $arguments" ;
		print "\nObtaining information about media in robot $robot_num...\n\n" ;
	}

	if ( $show_commands eq Y ) {print "($bpmedia_cmd)\n"}
	
	open(MEDIALIST, "$bpmedia_cmd |");

	if ( $debug eq "Y" ) { print "Media with stuff on it: " }
	while (<MEDIALIST>) {
		@media= split(/\s+/,$_) ;
		$media_id = $media[0] ;
		if ( $debug eq "Y" ) { print "$media_id, " }
		$media_ids_w_data{$media_id} = 1 ;
		$media_kbytes{$media_id} = $media[8] ;
		$media_density{$media_id} = $media[3] ;
		$media_allocated{$media_id} = $media[4] ;
		$media_updated{$media_id} = $media[5] ;
		$media_expires{$media_id} = $media[6] ;
		$media_read{$media_id} = $media[7] ;
		}

	close(MEDIALIST) ;

	@robot_hosts=() ;
	if ( $arguments =~ /null/) {

		foreach $robot_num (keys %robot_hosts) {
			if ( $robot_num >= 0 ) {
				#print "Adding robot $robot_num\n ";
				$robot_host=$robot_hosts{$robot_host};
				$robot_type=$robot_types{$robot_host} ;
				push @robot_hosts, $robot_host ;
			}
		}
	}
	else {
		push @robot_hosts, $robot_host ;
	}

 foreach $robot_host (@robot_hosts) {
	$vmopr_cmd="vmoprcmd -M $robot_host -d ds" ;
	if ( $show_commands eq Y ) { print "($vmopr_cmd)\n" }
	open(ASSIGNED, "$vmopr_cmd |");
	while (<ASSIGNED>) {
		next if ( $_ =~ /DRIVE STATUS|^$|^Drv Type/ ) ;
			$rvsn = substr($_,37,6) ;
			$evsn = substr($_,45,6) ;
			$_ =~ s/^\s+// ;
			@line= split('\s+',$_);
			$drive_num=$line[0] ;

			#If either of these values are non-null, then
			#there is a volume assigned
			$vsn=$rvsn ne "      " ? $rvsn:$evsn ;
			if ( $vsn ne "      " ) {
				$assigned_volumes{$vsn} = $drive_num ;
				}

			}

	#print join(',', keys %assigned_volumes) ;
	close(ASSIGNED) ;
	}

	if ( ! (defined $robot_num) or $arguments =~ /null/ ) {
		$vmquery_cmd="vmquery -b -a" ;
	}
	else {
		$vmquery_cmd="vmquery -b -rn $robot_num" ;
	}

	if ( $show_commands eq Y ) {print "($vmquery_cmd)\n"} ;

	if ( scalar keys %assigned_volumes ) {

		print <<EOF ;

*****************SPECIAL NOTE FROM CLAM*****************************
* There are volumes currently mounted in drive.  Even if these     *
* volumes match your selection criteria, they will not be ejected. *
* This is because ejecting currently mounted volumes should only   *
* be done MANUALLY by an experienced NetBackup administrator.      *
* If you wish to manually unmount these volumes, you will need to  *
* issue the command "vmoprcmd -M <robot_host> -reset <drive_num>   *
* Execute these  commands with great caution!                      *
********************************************************************
EOF
		}

	open(LOCATIONLIST, "$vmquery_cmd |");
	while (<LOCATIONLIST>) {
		next if ( $_ =~ /media\s+media\s+robot\s+robot/ ) ;
		next if ( $_ =~ /ID\s+type\s+type\s+#/ ) ;
		next if ( $_ =~ /-----/ ) ;
		@media= split(/\s+/,$_) ;
		$media_id = $media[0] ;
		if (defined ($media_ids_w_data{$media_id}) ) {
			$slot = $media[4] ;
			#If it's in slot '-', that means that its not in the library
			if ( $slot ne "-" ) {

				#Look to see if its "assigned," that is, put in a drive
				#if its an assigned volume, it can't be ejected
				
				if (defined ($assigned_volumes{$media_id}) ) {
					$drive_num=$assigned_volumes{$media_id} ;
					print "Volume $media_id is in use. It is not eligible for auto-ejection.\n" ;
				}
				#Go ahead and add it to the list of tapes to be ejected
				else {
					#print "$media_id has data. It is in slot $media[4]\n" ;
					$media_ids{$media_id} = 1 ;
					$media_slots{$media_id} = $media[4] ;
					$media_sides{$media_id} = $media[5] ;
					}
				}
			}
		else {
			if ($arguments =~ /null/) {
				$media_kbytes{$media_id} = "DBBU" ;
				$media_density{$media_id} = "N/A" ;
				$media_allocated{$media_id} = "N/A" ; 
				$media_updated{$media_id} = "N/A" ;
				$currenttime=time() ;
				$expires=$currenttime+$expire_for_db_tapes ;
				#print "$media_id set to $expires \n" ;
				$media_expires{$media_id} = "$expires" ;
				$media_read{$media_id} = "N/A" ;
				$media_ids{$media_id} = 1 ;
				$media_slots{$media_id} = $media[4] ;
				$media_sides{$media_id} = $media[5] ;
			}
		}
		}

	close(LOCATIONLIST) ;

}

sub Usage {
		#If it's out of range, complain and reloop
		if ( $debug ne Y ) { &Clear_screen } 
		print "Invalid response! ($main_menu_option).\n" ;
		print "Your answer must be between $low and $high.\n" ;
		sleep 2 ;
}
sub Exit_splash {
	if ( $debug ne Y ) { &Clear_screen }
	
	print <<EOF ;
Thank you for using this program!
	
It has been brought to you by W. Curtis Preston

NO WARRANTIES, EITHER EXPRESS OR IMPLIED, ARE INCLUDED WITH THIS SOFTWARE,
INCLUDING WITHOUT LIMITATION, THE WARRANTY OR MERCHANTIBILITY OR FITNESS 
FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR 
ANY INCIDENTAL OR CONSEQUENTIAL DAMAGES FROM THE USE OF THIS PRODUCT.  

EOF

	exit ;
}
sub Get_real_date {
	#get the data from the command line
	$epoch=$_[0];
	
	unless ( "$epoch" =~ /N.A/ ) {
		#an array to translate [0-11] into [Jan-Dec]
		@months=("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep",
         		"Oct","Nov","Dec");
		
		#Do the translation of epoch time into local time.
		($seconds, $minutes, $hours, $dayofmonth, $month, $year,
			$wday, $yday, $isdst) = localtime($epoch);
		if ($hours < 10 ) { $hours = "0$hours" }
		if ($minutes < 10 ) { $minutes = "0$minutes" }
		if ($seconds < 10 ) { $seconds = "0$seconds" }
		if ($dayofmonth < 10 ) { $dayofmonth = "0$dayofmonth" }
		$year += 1900 ;
		return "$months[$month]/$dayofmonth/$year";
	}
	else {
		return "00/00/0000" ;
		}

}

sub Eject_tapes {

print "\nPLEASE NOTE:\n" ;
print "Before ejecting tapes, you need to make sure that the import/export\n";
print "door on robot $robot_num is empty. ";
print "Once you have done so, please press <RETURN>...";

$ready=<STDIN>;

print <<EOF ;

*------------------------------------------------------------------------*
| CLAM will now issue a series of eject commands until it fills the      |
| import/export door.  Once it is full, it will prompt you to empty that |
| door and press <ENTER> when you're done.                               |
*------------------------------------------------------------------------*

EOF

	$ejected_tapes=0 ;
	my @tapes_to_eject=@_ ;

	foreach $media_id (@tapes_to_eject) {

		if ( $ejected_tapes == $maxslots ) {
			print "The export door of robot $robot_num only holds $maxslots tape(s),\n";
			print "and CLAM has now ejected that many tapes.  Please go empty the\n";
			print "the import/export door and press <ENTER> when you're finished";
			$ready=<STDIN>;
			$ejected_tapes=0;
			}

		$slot=$media_slots{$media_id} ;
		$side=$media_sides{$media_id} ;

		print "Ejecting $media_id\n";
		if (defined ($media_to_offsite{$media_id} )) {
			$volume_group=$media_to_offsite{$media_id} ;
			$eject_cmd = "vmchange -vh $master -res -m $media_id -mt $density -rt none -v $volume_group -rc1 0 -rc2 0 -e -sec 5 >/dev/null 2>&1" ;
		}
		else {
			$eject_cmd = "vmchange -vh $master -res -m $media_id -mt $density -rt none -rc1 0 -rc2 0 -e -sec 5 >/dev/null 2>&1" ;
		}

		if ( $show_commands eq Y ) {print "\n($eject_cmd)\n"} ;
		$return = system($eject_cmd) ;

		if ( $return != 0 ) {
			print "\n**********************************************************\n" ;
			print   "*  The export of $media_id failed!                       *\n" ;
			print   "* PLEASE EMPTY THE DOOR and press <RETURN> to continue...*\n" ;
			print   "**********************************************************\n" ;
			$ready = <STDIN> ;
			$ejected_tapes=0 ;
				}
		else {
			$ejected_tapes++ ;
		}
	}
	print "\nThe requested volumes have been exported.  Please go empty the\n";
	print "import/export door of robot $robot_num.\n";
}
sub Validate_options {
	$low = $_[0] ;
	$high = $_[1] ;
	$exit_opt = $_[2] ;
	$exit_cmd = $_[3] ;
	$menu_option = $_[4] ;

	#Test for a non-numeric answer
	if ( $menu_option =~ /^\d$/ ) {

		#Test if the answer is out of range
		if ( $menu_option > $high or $menu_option < $low ) {
			#If it's out of range, complain and reloop
			#if ( $debug) { print "It's out of range!\n" }
			&Usage ;
			next ;
			}
	}
	#Else the answer is non-numeric.  Complain and exit.
	else {
		if ( $menu_option eq "q" or $menu_option eq "Q" ) {
			#If they choose q or Q, go ahead and exit
			$menu_option = $exit_opt ;
			}
		else {
			&Usage ;
			next ;
			}
		}
	
	if ( $menu_option == $exit_opt ) {
		if ( $exit_cmd =~ /next/ ) {
			eval $exit_cmd ;
			}
		elsif ( $exit_cmd eq "exit" ){
			#
			&Exit_splash ;
			}
		}
}

sub Print_tapes {

	if ( $savetofile eq "yes" ) {
		open (REPORT, ">$fullreportname" ) || die "Cannot open $fullreportname for writing!" ;
		print REPORT "*********************************************\n";
		print REPORT "* CLAM EJECTION REPORT for $master\n";
		print REPORT "*********************************************\n";
		print REPORT "\nThis report was saved in:\n$reportdir on:\n$master\nas:\n$reportname\n\n" ;
		print REPORT "\nThe following tapes were ejected $mon/$mday/$year at $hour:$min:$sec:\n\n" ;
		printf REPORT ("%-6s %-5s %-15s %-10s %-10s %-11s %-11s\n",
			"MEDIA","DENS","KBYTES","SLOT","SIDE","LAST UPDATE","EXPIRES");
		print REPORT "------ ----- --------------- ---------- ---------- ----------- -----------\n" ;
	}
	else {
		print "\nThese volumes match your criteria and are not in a drive:\n\n" ;
		printf ("%-6s %-5s %-15s %-10s %-10s %-11s %-11s\n",
			"MEDIA","DENS","KBYTES","SLOT","SIDE","LAST UPDATE","EXPIRES");
		print "------ ----- --------------- ---------- ---------- ----------- -----------\n" ;
	}

	for $media_id (@tapes_to_eject) {
		$slot=$media_slots{$media_id} ;
		$side=$media_sides{$media_id} ;
		$kbytes=$media_kbytes{$media_id} ;
		$density_number=$media_density{$media_id} ;
		$density = &Get_density($density_number) ;
		$updated=$media_updated{$media_id} ;
		$updated=(&Get_real_date($updated)) ;
		$expires=$media_expires{$media_id} ;
		$expires=(&Get_real_date($expires)) ;
		if ( $savetofile eq "yes" ) {
			printf REPORT ("%-6s %-5s %-15s %-10d %-10s %-11s %-11s\n",
  		$media_id,$density,$kbytes,$slot,$side,$updated,$expires);
		}
		else {
			printf ("%-6s %-5s %-15s %-10d %-10s %-11s %-11s\n",
  		$media_id,$density,$kbytes,$slot,$side,$updated,$expires);
		}
	}
	
		if ( $savetofile eq "yes" ) { close(REPORT) };
}


sub Display_tapes_to_eject {

	print "\nPress <ENTER> to see the volumes that match your criteria. " ;
	$ready=<STDIN> ;

	my @tapes_to_eject=@_ ;
	$now = time();
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($now);
	$mon++ ;
	$year+=1900 ;
	$reportdir="/usr/openv/netbackup/logs/ejectreports" ;
	unless ( -d $reportdir ) { mkdir($reportdir, 0755) } 
	$reportname="ejected-tapes.$master.robot-$robot_num.$year.$mon.$mday.$hour.$min";
	$fullreportname="$reportdir/ejected-tapes.$master.robot-$robot_num.$year.$mon.$mday.$hour.$min";

	$savetofile="";
	&Print_tapes() ;
	print  "\nWould you like to eject these tapes (Y/N)? " ;

	$eject = <STDIN> ;
	chomp $eject ;

	if ( $eject eq "Y" or $eject eq "y" or $eject eq "" ) {
		print "\nA report of the ejected tapes will be saved in:\n" ;
		print "$reportdir as:\n" ;
		print "$reportname\n" ;
		sleep 2 ;
		$savetofile="yes";
		&Print_tapes() ;
		$savetofile="";
		&Eject_tapes(@tapes_to_eject) ;

		print "Would you like a print a copy of the saved report (y|n)? " ;
		$doreport = <STDIN> ;
		chomp $doreport ;
		if ( $doreport eq "Y" or $doreport eq "y" or $doreport eq "" ) {
			if ( $printer ) {
				print "\nThe current default printer is $printer.\n" ;
				print "To print to this printer, just hit <RETURN> or <ENTER>.\n" ;
			 	print "To use another printer, enter its name here: " ;
				$printeranswer = <STDIN> ;
				chomp $printeranswer ;
				if ( $printeranswer ne "" ) { $printer=$printeranswer};
				system("lp -d $printer $fullreportname") ;
			}
			else {
				print "lpstat -d reports \"no system default destination\".\n";
				print "Please set a default printer.\n" ;
			}
		}
	}
	else {
		print "\nExiting without ejecting tapes.\n" ;
		}
		
}

sub Look_for_empties {
 print "\nExamining robot $robot_num for empty slots. (Takes a minute or so.)\n";
 $vmcheck_cmd = "vmcheckxxx -rt $lc_robot_type -rn $robot_num -rh $robot_host";
 if ( $show_commands eq Y ) {print "($vmcheck_cmd)\n"} ;

	open(SLOTCOM, "$vmcheck_cmd|");

	%empty_slots=() ;
	$slot_ct=1 ;
	while(<SLOTCOM>) {
	if ( $nbuversion =~ /3\.[12]/ ) {
		next if (!( $_ =~ /slot.*is empty/) ) ;
		$slot = $_ ;
		$slot =~ s/.*slot\s+// ;
		$slot =~ s/\s+.*// ;
		chomp $slot ;
	}
	else {
		next if ( $_ =~ /Yes/) ;
		@line = split(/\s+/,$_);
		$slot = $line[0];
	}
	$empty_slots{$slot_ct} = $slot ;
	$slot_ct++ ;
	}
	close(SLOTCOM);
}

sub Insert_any_tapes {

	$num_of_slots=scalar keys %empty_slots ;

	print <<EOF ;

There are $num_of_slots empty slots in this library, and it has a $maxslots slot 
import/export door, so you will be able to import $maxslots at a time, up to a 
total of $num_of_slots.

EOF

	print "What is the TOTAL number of tapes that would you like to insert? " ;
	$num_to_insert=<STDIN> ;
	chomp $num_to_insert ;

	$tapes_inserted=0;
	while ( $tapes_inserted < $num_to_insert ) {

print "\nPlease put $maxslots (or less) tapes in the import export door.\n";
print "Press <ENTER> once you have loaded the door and closed it.";

	$ready_to_import=<STDIN>;

print "\nNow importing volumes into the library. (May take a minute or so.)\n";

	$vmupdate_cmd ="vmupdate -rn $robot_num -rt $lc_robot_type -M $master -use_barcode_rules -vh $master -rh $robot_host -empty_ie" ;
	if ( $show_commands eq Y ) {print "($vmupdate_cmd)\n"}
	system("$vmupdate_cmd") ;

	print "\nThe tapes that were in the import/export door have been imported.\n" ;

	$tapes_inserted = $tapes_inserted + $maxslots

	}

}

sub Update_contents {
	
	$vmupdate_cmd ="vmupdate -rn $robot_num -rt $lc_robot_type -M $master -use_barcode_rules -vh $master -rh $robot_host" ;

	if ( $_[0] eq "s" ) {
		if ( $show_commands eq Y ) {print "($vmupdate_cmd)\n"}
		system("$vmupdate_cmd >/dev/null 2>&1") ;
		}
	else {

		print "\nUpdating the contents of robot $robot_num...\n" ;

		if ( $show_commands eq Y ) {print "($vmupdate_cmd)\n"}
			system("$vmupdate_cmd") ;
		}
}

sub Look_for_wanderers {
	$vmquery_cmd="vmquery -b -rn $robot_num" ;
	if ( $show_commands eq Y ) {print "($vmquery_cmd)\n"} ;
	open(VMQUERY, "$vmquery_cmd |");
	while (<VMQUERY>) {
		next if ( $_ =~ /media\s+media\s+robot\s+robot/ ) ;
		next if ( $_ =~ /ID\s+type\s+type\s+#/ ) ;
		next if ( $_ =~ /-----/ ) ;
		@media= split(/\s+/,$_) ;
		$media_id = $media[0] ;
		$slot = $media[4] ;
		unless ( $slot =~ /-/ ) {
			$bpmedia_cmd="bpmedialist -ev $media_id" ;
			if ( $show_commands eq Y ) {print "($bpmedia_cmd)\n"} ;
			open(LOCATIONLIST, "$bpmedia_cmd |");
			if ( $_ =~ /^Server Host/ ) {
				@line=split ('\s+', $_) ;
				$realhost=$line[3] ;
				$real_shorthost = $realhost ;
				$real_shorthost =~ s/\..*// ;
				$this_shorthost = $master ;
				$this_shorthost =~ s/\..*// ;
				if ( $this_shorthost ne $real_shorthost ) {
					print "The media $media_id actually belongs to server $real_shorthost.\n";
					print "Would you like to permanently move it to this host (Y|N) ?" ;
					$thishost=<STDIN> ;
					chomp $thishost ;
					if ( $thishost eq "Y" or $thishost eq "y" or $thishost eq "" ) {
						$media_to_move{$media_id} = 1 ;
						}
					else {
						print "Ejecting $media_id\n";

						$slot=$media_slots{$media_id} ;
						$side=$media_sides{$media_id} ;

						$eject_cmd = "vmchange -vh $master -res -m $media_id -mt $density -rt none -v $volume_group -rc1 0 -rc2 0 -e -sec 5" ;

						if ( $show_commands eq Y ) {print "\n($eject_cmd)\n"} ;
						$return = system($eject_cmd) ;
						}
					}
				}
			}
			close (LOCATIONLIST) ;
		}
	close (VMQUERY);

	$number=scalar keys %pending_requests ;
	if ( $number > 0 ) {
		print "You chose to have some volumes moved into this library permanently.\n";
		print "Please wait while they are added to the database.  This can \n.";
		print "(This can take quite some time...)" ;
		for $number (scalar keys %media_ids) {
						$bpmedia_cmd = "bpmedia -res -m $media_id -rt $lc_robot_type -mt $density -rn $robot_num -rh $robot_host -rc1 $slot -rc2 $side -e" ;
						if ( $show_commands eq Y ) {print "\n($bpmedia_cmd)\n"} ;
						print "Moving volume $media_id to this librart." ;
						$return = system($bpmedia_cmd) ;
			}
		}
}

sub Clean_drives {

	while ( 1 ) {
	$clean_list_cmd ="tpclean -l" ;
	if ( $show_commands eq Y ) {print "($clean_list_cmd)\n"}
	system("$clean_list_cmd");
	print "\nTo clean one of the drives above, enter its number below.\n";
	print "\nWhich one of these drive numbers would you like to clean? " ;
	$drive_num=<STDIN> ;
	chomp $drive_num ;
	
	$drive_name=$drive_nums{$drive_num} ;

	unless ( defined ($drive_name) ) {
		print "\nThe number \"$drive_num\" is not a valid choice from the list above!\n";
		sleep 2 ;
		if ( $debug ne Y ) { &Clear_screen }  
		next
		}

	$clean_cmd ="tpclean -C $drive_name" ;
	if ( $show_commands eq Y ) {print "($clean_cmd)\n"}
	$return = system("$clean_cmd");

	print "Would you like to clean more drives? " ;
	$clean_answer=<STDIN>;
	chomp $clean_answer ;
	
	if ( $clean_answer eq "Y" or $clean_answer eq "y" or $clean_answer eq "" ) {
		next ;
		}
	else {
		last ;
		}
	
	}
}

sub Drive_num_to_name {
	$vmopr_cmd="vmoprcmd -d ad" ;
	if ( $show_commands eq Y ) { print "($vmopr_cmd)\n" }
	open(ASSIGNED, "$vmopr_cmd |");
	while (<ASSIGNED>) {
		if ( $_ =~ /^$|ADDITIONAL DRIVE|^Drv DriveName/ ) {next}
		$_ =~ s/^\s+// ;
		@line= split('\s+',$_);
		$drive_num=$line[0] ;
		$drive_name=$line[1] ;
		$drive_nums{$drive_num} = $drive_name ;
		}

	close(ASSIGNED) ;
}

sub Find_requests {
	$vmopr_cmd="vmoprcmd -M $robot_host -d pr" ;
	if ( $show_commands eq Y ) { print "($vmopr_cmd)\n" }
	%pending_requests=();
	open(REQUESTS, "$vmopr_cmd |");
	while (<REQUESTS>) {
		next if ( $_ =~ /^$|PENDING|^ReqId.*User|NONE/ ) ;
		$_ =~ s/^\s+// ;
		@line= split('\s+',$_);
		$req_id=$line[0] ;
		$media_id=$line[2] ;
		$pending_requests{$media_id}=$req_id ;
		}
	close (REQUESTS);
}

sub Satisfy_requests {

	$number=scalar keys %pending_requests ;
	if ( $number > 0 ) {
		foreach $volume (keys %pending_requests) {
	  $req_id = $pending_requests{$media_id} ;
					$vmopr_cmd	= "vmoprcmd -M $robot_host -resubmit $req_id" ;
					if ( $show_commands eq Y ) {print "($vmopr_cmd)\n"}
					$return=system("$vmopr_cmd") ;
					print "Resubmitted request $req_id\n" ;
				}
			}
	else {
		print "\nThere are no pending requests!\n";
		}
}

sub Choose_pool {
	while (1) {
		$vmquery_cmd="vmquery -w -rn $robot_num" ;
		if ( $show_commands eq Y ) {print "($vmquery_cmd)\n"} 
		$poolsct=1 ;
		open(POOLLIST, "$vmquery_cmd |");
		while (<POOLLIST>) {
			next if ( $_ =~ /media.*optical.*media/ ) ;
			next if ( $_ =~ /ID.*partner.*type/ ) ;
			next if ( $_ =~ /-----------------/ ) ;
			@media=split(/\s+/, $_) ;
			unless (defined ($pools{$media[11]})) {
				$pools{$media[11]} = $poolsct ;
				$pool_nums{$poolsct} = $media[11] ;
				$poolsct++ ;
				}
			}
		close (POOLLIST) ;
		
		foreach $key ( keys %pool_nums ) {
     					$pool =$pool_nums{$key} ;
     					print "$key:  $pool\n" ;
		}
		
		print "\nWhich pool would you like to eject volumes from? " ;
		$choice=<STDIN> ;
		chomp $choice ;
		
		$pool=$pool_nums{$choice} ;
		unless ( defined ($pool) )	{
		print "\nThe number \"$choice\" is not a valid choice from the list above!\n";
		sleep 2 ;
		if ( $debug ne Y ) { &Clear_screen }  
		next ;
		}
		last ;
	}

}

sub Look_for_offsite_tapes {

%robots=() ;
%volume_groups=() ;
%media_to_offsite=() ;
%tapes_in_robots=();

$vmquery_cmd="vmquery -b -a" ;
if ( $show_commands eq Y ) {print "($vmquery_cmd)\n"} ;
open(VMQUERY, "$vmquery_cmd|") || die "Can't run vmquery!\n";

$junk = <VMQUERY> ;
$junk = <VMQUERY> ;
$junk = <VMQUERY> ;

while ($line = <VMQUERY>) {
	chomp $line ;
	@line = split /\s+/, $line ;
	$media_id=$line[0] ;
	$media_robot=$line[3] ;
	if ( $media_robot ne "-" ) {
		$tapes_in_robots{$media_id} = $media_robot  ;
		#print "$media_id $media_robot\n" ;
		unless (defined ( $robots{$media_robot} )) {
			$robots{$media_robot} = 1 ;
		}
	}
}

close(VMQUERY);

$vaultdir="/usr/openv/netbackup/vault" ;

foreach $dir  (<$vaultdir/*>) {
	#We have a list of directories
	#Let's find a list of vaults
	if ( -d $dir ) {
		foreach $dupdir (<$dir/*>) {
			if ( -f "$dupdir/eject_tapes" ) {
				$eject_script="$dupdir/eject_tapes" ;
				#print "eject_script=$eject_script\n";
				open(EJECTSCRIPT, "$eject_script") 
					|| die "Can't open $eject_script!\n";
				while ($line = <EJECTSCRIPT> ) {
					chomp $line ;
					next unless ( $line =~ /vmchange/ ) ;
					$media_id = $line ;
					$volume_group = $line ;
					$media_id =~ s/.*-m // ;
					$media_id =~ s/\s.*// ;
					$volume_group =~ s/.*-v // ;
					$volume_group =~ s/\s.*// ;
		
					if (defined ( $tapes_in_robots{$media_id} )) {
		
						unless (defined ( $volume_groups{$volume_group} )) {
							$volume_groups{$volume_group} = 1 ;
							#print "Defining the $volume_group volume group\n";
						}
						unless (defined ( $media_to_offsite{$media_id} )) {
							$media_to_offsite{$media_id} = $volume_group ;
							#print "Adding the media id $media_id to the offsite pool\n";
						}
					}
				}
				close(EJECTSCRIPT) ;
			}
		}
	}
}

foreach $robot_num ( keys %robots) {

	$robot_host = $robot_hosts{$robot_num} ;
	$density = $robot_densities{$robot_num} ;
	$robot_type =  $robot_types{$robot_num} ;
	$lc_robot_type = $robot_type ;
	$lc_robot_type =~ tr/A-Z/a-z/ ;
	
	if ( $debug eq Y ) {
	print  "
	robot_host = $robot_host
	density_num = $density_num
	robot_type_num =  $robot_type_num
	robot_type = $robot_type
	density = $density
	lc_robot_type = $robot_type
	"
	}

	@tapes_to_eject=();

	print "\n\nChecking robot $robot_num for tapes that should go offsite:\n\n" ;
	foreach $volume_group ( keys %volume_groups ) {
	print "	Looking for volumes for the \"$volume_group\" volume group\n";
		foreach $media_id ( sort (keys %tapes_in_robots) ) {
			if ($tapes_in_robots{$media_id} == $robot_num ) {
				if (defined ($media_to_offsite{$media_id})) {
					if (defined ($assigned_volumes{$media_id}) ) {
						$drive_num=$assigned_volumes{$media_id} ;
						print "Volume $media_id is in use. It is not eligible for auto-ejection.\n" ;
					}
					else {
						push @tapes_to_eject, $media_id ;
					}
				}
			}
		}
	}
	if (@tapes_to_eject) {
		Display_tapes_to_eject(@tapes_to_eject) ; 
	}
}
@tapes_to_eject=();
undef $robot_num ;
undef $robot_host ;
undef $density_num ;
undef $robot_type_num ;
undef $robot_type ;
undef $density ;
undef $robot_type ;
%volume_groups=() ;
%media_to_offsite=() ;
%tapes_in_robots=();
}

1;
