#!/bin/sh

## Rcs_ID="$RCSfile: rsh.sh,v $"
## Rcs_ID="$Revision: 1.1 $ $Date: 2000/01/20 20:50:14 $"    

Usage() {
	echo "This program adds or deletes /.rhosts entries for the NetBackup master"
	echo "on all active Unix hosts or selected hosts."
	echo "Usage: $0 <on|off> [host1 ... hostn]"
}

PATH=/bin:/usr/bin:/usr/sbin:/sbin:/usr/openv/volmgr/bin:/usr/openv/netbackup/bin:/usr/openv/netbackup/bin/admincmd:/usr/openv/netbackup/bin/goodies:/usr/openv/volmgr/goodies:/usr/symmapps/bin:/usr/local/bin:/usr/openv/local/bin:/usr/EMCpower/bin:/etc
export PATH

if [ $# -lt 1 ] ; then
	Usage
	exit 1
fi

master=`hostname|cut -d. -f1`
master_fqdn=`nslookup $master | grep 'Name:' | awk '{print $2}'`

action=$1
case $action in
	off ) 
		echo "Disabling rsh from $master to selected hosts...."
		echo ""
	;;
	on ) 
		echo "Enabling rsh from $master to selected hosts....."
		echo ""
	;;
	* )
		Usage
		exit 1
	;;
esac

shift 1

if [ $# -eq 0 ] ; then
	#Get a list of active unix hosts
	cd /usr/openv/netbackup/db/class
	for class in *
	do
	
		ACTIVE=`grep 'ACTIVE[ 	][	]*0' $class/info`
		UNIX=`grep 'CLIENT_TYPE[	 ][	 ]*0' $class/info`
		
		if [ -n "$ACTIVE" -a -n "$UNIX" ] ; then
			awk '{print $1}' $class/clients
		fi
	
	done >/tmp/$$.unixhosts.txt
	hosts=`sort -u /tmp/$$.unixhosts.txt`
else
	for host
	do
		hosts="$hosts $host"
	done
fi

for host in $hosts ; do

	echo "Updating $host"

	echo "	bpgp from $host /.rhosts /tmp/rhosts.$host"
	bpgp from $host /.rhosts /tmp/rhosts.$host

	echo "	Taking out any references to $master in the .rhosts file"
	grep -v $master /tmp/rhosts.$host >/tmp/rhosts.$host.tmp
	mv /tmp/rhosts.$host.tmp /tmp/rhosts.$host
	
	if [ $action = on ] ; then
		echo "	Adding entries for $master to the .rhosts file"
		echo "$master" >> /tmp/rhosts.$host	
		echo "${master_fqdn}" >> /tmp/rhosts.$host	
	fi

	echo "	bpgp to $host /tmp/rhosts.$host /.rhosts"
	bpgp to $host /tmp/rhosts.$host /.rhosts
done
