#!/bin/sh
TNG=/opt/tng/tng_custom/tools/sendTrap.ksh
HOSTNAME=`hostname`
## Rcs_ID="$RCSfile: makedbtape.sh,v $"
## Rcs_ID="$Revision: 1.2 $ $Date: 2000/05/31 22:17:58 $"    

if [ $# -lt 2 ] ; then
	echo "Missing arguments!" 
	echo "Usage: $0 <robot_num> <db_dup_pool>"
	exit 1
fi

PATH=/usr/bin:/usr/sbin/:/sbin:/usr/local/bin:/usr/ccs/bin:/usr/lib/lp/bin:/usr/lib/fs/vxfs/bin:/usr/lib/vxvm/bin:/usr/lib/vxvm/voladm.d/bin:/usr/openwin/bin:/usr/dt/appconfig/hotjava/bin:/usr/dt/appconfig/hotjava/runtime/bin:/usr/dt/bin:/usr/demo/SOUND/bin:/usr/sadm/bin:/usr/sadm/install/bin:/usr/sadm/sysadm/bin:/usr/xpg4/bin:/usr/proc/bin:/usr/snadm/bin:/usr/oasys/bin:/usr/vmsys/bin:/usr/java1.1/bin:/usr/symmapps/bin:/usr/symmapps/packages/SInquiry/3.2.1/bin:/usr/symmapps/packages/TFinder/3.2.2/bin:/etc/opt/SUNWleo/bin:/etc/opt/SUNWqfetr/bin:/usr/openv/bin:/usr/openv/java/jre/bin:/usr/openv/local/bin:/usr/openv/netbackup/bin:/usr/openv/netbackup/vault/bin:/usr/openv/netbackup/vault/production:/usr/openv/volmgr/bin:/usr/openv/volmgr/bin/goodies:/usr/openv/netbackup/bin/goodies:/usr/openv/netbackup/bin/admincmd:/usr/EMCpower/bin:/etc
export PATH

#Takes input from command line and assigns to variables
robot_num=$1
db_dup_pool=$2

#Identify scratch pool from VM.CONF
scratch_pool=`grep SCRATCH_POOL /usr/openv/volmgr/vm.conf |awk '{print $3}'`

#Identifies all volumes in the robot numbers current volume database and redirects to outfile
vmquery -b -rn $robot_num | egrep -v '^media|^  *ID|^-------' |awk '{print $1}' \
	>/tmp/$$.tapesinrobot

#Identifies all volumes that are a part of the Scratch pool on robot_num and assigns to VOLIDS
VOLIDS=`vmquery -b -pn $scratch_pool | egrep -v '^media|^  *ID|^-------' \
	|awk '{print $1}'`

#For each VOLID in VOLIDS check to see if the tape is part of the scratch pool and in the robot, if true break 
for VOLID in $VOLIDS ;do
	grep $VOLID /tmp/$$.tapesinrobot >/dev/null
	[ $? -eq 0 ] && break
done

#Finds the proper pool number for db dup pool
pool_num=`vmpool -listall \
        |awk '$0 ~ /pool number/ { printf $0 } $0 ~ /pool name/ { print $0 }' \
        |grep $db_dup_pool|sed 's/pool name.*//'|sed 's/.* //'`

#Change the volume in the scratch pool to be available to the NBB_dupp pool and sends TNG trap if not successful
vmchange -p $pool_num -m $VOLID
	[ $? -ne 0 ] && $TNG NETBACKUP CRIT BOTH "FAILED TO CHANGE SCRATCH POOL VOLUME FOR MAKEDB. Page oncall admin immediately. makedbtape.sh failed on $HOSTNAME"
