#!/bin/sh

echo "====================================================="
echo "Checking vaults: \c"
date
echo "====================================================="

set -x


PATH=/usr/bin:/usr/sbin:/sbin:/usr/local/bin
export PATH

WAIT_MINUTES=60
X=$$
host=`uname -n`

TNG=/opt/tng/tng_custom/tools
MSGTXT="Bpvault was still running and $0 ran the \"haltdups.now VAULT\" command. Bpvault should finish as soon as it finishes dup'ing the image that it started dup'ing before the haltdups.now command was run. If it is not finished in $WAIT_MINUTES minutes, it will be killed. (You will get another alert if this happens.)"

cd /usr/openv/netbackup/vault/production

param_files=''
for param_file in `file *|grep 'text'|cut -d: -f1`
do
grep "^vault[ ]" $param_file >/dev/null && \
	grep "^bpvault_dir[ ]" $param_file >/dev/null && \
	grep "^vault_type[ ]" $param_file >/dev/null &&
	param_files="$param_files $param_file"
done

[ -f /tmp/$X.servers ] && rm /tmp/$X.servers

for param_file in $param_files ; do
	RUNNING=`ps -ef|grep "bpvault.all $param_file" |grep -vc grep`
	if [ $RUNNING -gt 0 ] ; then
		VAULT=`grep "^vault[ ]" $param_file |awk '{print $2}'`
		echo "/usr/openv/netbackup/vault/production/haltdups.now $VAULT"
		#/usr/openv/netbackup/vault/production/haltdups.now $VAULT
		MESSAGE=`echo $MSGTXT|sed "s/VAULT/$VAULT/"`
   		$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE
   		#echo "$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE"
	fi

	if [ -n "`grep 'vault_type[ 	]*normal' $param_file`" ] ; then
		for serverline in `grep '^server' $param_file\
				|sed 's/server[ 	][ 	]*//'\
				|sed 's/[ 	][	 ]*[0-9][0-9]*[ 	][	 ]*/=/' \
				|sed 's/[ 	][ 	]*/=/g'`
		do
			echo $serverline >>/tmp/$X.servers
		done
	fi

done

serverlists=`sort -u /tmp/$X.servers`

WAIT_SECONDS=`expr $WAIT_MINUTES \* 60`
sleep $WAIT_SECONDS

for serverlist in $serverlists
do
	local=NO

	for server in `echo $serverlist |sed 's/=/ /g'`
	do
		[ "$server" = "$host" ] && local=YES
		nslookup $server|grep 'Name:' >/dev/null
		[ $? -eq 0 ] && remote_host=$server
	done

	if [ $local = YES ] ; then
		ssh='' ; remote_host=''
	else
		ssh=ssh
	fi

	$ssh $remote_host ps -ef >/tmp/$X.all.procs

	if [ $? -gt 0 ] ; then
		MESSAGE="Could not run the 'ps -ef' command on $server from $host. The script $0 needs to run this command in order to kill duplication processes.  A failure of this command usually means that $host cannot successfully rsh/ssh to $server."
   		$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE
   		#echo "$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE"
	fi

	cat /tmp/$X.all.procs \
		| egrep 'bptm.*\-copy |bptm.*\-dup |bpduplicate' \
		|grep -v grep >/tmp/$X.dup.procs

	if [ -s /tmp/$X.dup.procs ] ; then
		for proc in `awk '{print $2}' /tmp/$X.dup.procs`
		do
			#echo "$ssh $remote_host kill -9 $proc"
			$ssh $remote_host kill -9 $proc
			if [ $? -gt 0 ] ; then
				MESSAGE="Could not run the 'kill' command on $server from $host. The script $0 needs to run this command in order to kill duplication processes.  A failure of this command usually means that $host cannot successfully rsh/ssh to $server."
   				$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE
   				#echo "$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE"
			fi
		done
		killed_servers="$killed_servers $server"
	fi

done

if [ -n "$killed_servers" ] ; then
	MESSAGE="After waiting $WAIT_MINUTES minutes, $0 checked for remaining bpduplicate/bptm processes.  Remaining processes were found and killed on the following server(s): $killed_servers. No further action is required.  This is a notification only."
	$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE
	#echo "$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE"
fi

WAIT_SECONDS=`expr $WAIT_MINUTES \* 60 \* 2`

sleep $WAIT_SECONDS

ps -ef|grep bpvault |grep -v grep| awk '{print $2}' >/tmp/$X.bpvault.procs

if [ -s /tmp/$X.bpvault.procs ] ; then

	for i in `cat /tmp/$X.bpvault.procs` ; do
		#echo "kill -9 $i"
		kill -9 $i
	done

	MESSAGE="After waiting another $WAIT_MINUTES minutes, $0 checked for remaining bpvault processes on $host.  Bpvault was still running, but it was killed."
  $TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE
  #echo "$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE"

fi

sleep 120

ps -ef|grep bpvault |grep -v grep| awk '{print $2}' >/tmp/$X.bpvault.procs

if [ -s /tmp/$X.bpvault.procs ] ; then
	MESSAGE="There are still bpvault processes on $host, even though they were killed with a -9.  Someone needs to look at this manually."
  $TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE
  #echo "$TNG/sendTrap.ksh NETBACKUP CRIT BOTH $MESSAGE"
fi

rm /tmp/$X.*
