#!/bin/sh

/usr/openv/volmgr/bin/tldtest -r /dev/sg/c3t7l0 -d1 /dev/rmt/5cbn -d2 /dev/rmt/6cbn -d3 /dev/rmt/7cbn -d4 /dev/rmt/8cbn -d5 /dev/rmt/1cbn -d6 /dev/rmt/2cbn -d7 /dev/rmt/3cbn -d8 /dev/rmt/4cbn <<EOF >/tmp/$$.tapes
s s
EOF

for i in /dev/rmt/5cbn /dev/rmt/6cbn /dev/rmt/7cbn /dev/rmt/8cbn /dev/rmt/1cbn /dev/rmt/2cbn /dev/rmt/3cbn /dev/rmt/4cbn
do
  mt -t $i offl &
done
sleep 15

/usr/openv/volmgr/bin/tldtest -r /dev/sg/c3t7l0 -d1 /dev/rmt/5cbn -d2 /dev/rmt/6cbn -d3 /dev/rmt/7cbn -d4 /dev/rmt/8cbn -d5 /dev/rmt/1cbn -d6 /dev/rmt/2cbn -d7 /dev/rmt/3cbn -d8 /dev/rmt/4cbn <<EOF >/tmp/$$.drives
s d
EOF

DRIVES=`grep "Contains Cartridge" /tmp/$$.drives|grep -c .`
SLOTS=`grep "contains Cartridge = yes" /tmp/$$.tapes|head -$DRIVES|awk '{print $2}'`

cat /tmp/$$.drives |awk '$0 ~ /^Source/ {print $0} $0 ~ /^drive/ {printf "\r"$0" "}'|grep Source|while read line
do
drive=`echo $line|awk '{print $2}'`
slot=`echo $line|sed 's/.*slot //'| sed 's/).*//'`
/usr/openv/volmgr/bin/tldtest -r /dev/sg/c3t7l0 -d1 /dev/rmt/5cbn -d2 /dev/rmt/6cbn -d3 /dev/rmt/7cbn -d4 /dev/rmt/8cbn -d5 /dev/rmt/1cbn -d6 /dev/rmt/2cbn -d7 /dev/rmt/3cbn -d8 /dev/rmt/4cbn <<EOF 
m d$drive s$slot
EOF
done

CT=1

for SLOT in $SLOTS
do
/usr/openv/volmgr/bin/tldtest -r /dev/sg/c3t7l0 -d1 /dev/rmt/5cbn -d2 /dev/rmt/6cbn -d3 /dev/rmt/7cbn -d4 /dev/rmt/8cbn -d5 /dev/rmt/1cbn -d6 /dev/rmt/2cbn -d7 /dev/rmt/3cbn -d8 /dev/rmt/4cbn <<EOF >/tmp/$$.drives
m s$SLOT d$CT
EOF

CT=`expr $CT + 1`
done

sleep 15

OK=1

while [ $OK -gt 0 ] ; do
  OK=0
  for i in /dev/rmt/5cbn /dev/rmt/6cbn /dev/rmt/7cbn /dev/rmt/8cbn /dev/rmt/1cbn /dev/rmt/2cbn /dev/rmt/3cbn /dev/rmt/4cbn
  do
    mt -t $i rewind
    SUC=$?
    OK=`expr $OK + $SUC`
  done
done

for i in /dev/rmt/5cbn /dev/rmt/6cbn /dev/rmt/7cbn /dev/rmt/8cbn /dev/rmt/1cbn /dev/rmt/2cbn /dev/rmt/3cbn /dev/rmt/4cbn
do
  mt -t $i offl &
done

sleep 30

/usr/openv/volmgr/bin/tldtest -r /dev/sg/c3t7l0 -d1 /dev/rmt/5cbn -d2 /dev/rmt/6cbn -d3 /dev/rmt/7cbn -d4 /dev/rmt/8cbn -d5 /dev/rmt/1cbn -d6 /dev/rmt/2cbn -d7 /dev/rmt/3cbn -d8 /dev/rmt/4cbn <<EOF >/tmp/$$.newdrives
s d
EOF

cat /tmp/$$.newdrives |awk '$0 ~ /^Source/ {print $0} $0 ~ /^drive/ {printf $0" "}'|grep Source|while read line
do
drive=`echo $line|awk '{print $2}'`
slot=`echo $line|awk '{print $17}'|sed 's/).*//'`
/usr/openv/volmgr/bin/tldtest -r /dev/sg/c3t7l0 -d1 /dev/rmt/5cbn -d2 /dev/rmt/6cbn -d3 /dev/rmt/7cbn -d4 /dev/rmt/8cbn -d5 /dev/rmt/1cbn -d6 /dev/rmt/2cbn -d7 /dev/rmt/3cbn -d8 /dev/rmt/4cbn <<EOF 
m d$drive s$slot
EOF
done

