#!/usr/local/bin/perl

#####################################################################
##
## Rcs_ID="$RCSfile: autosched.pl,v $"
## Rcs_ID="$Revision: 1.3 $ $Date: 2000/03/06 17:54:44 $"
##
#####################################################################

$scheddatfile="/usr/openv/local/data/autosched.dat";
$schedfile="/usr/openv/local/etc/autosched.conf";
$classdir="/usr/openv/netbackup/db/class";
$bpcllistcmd="/usr/openv/netbackup/bin/admincmd/bpcllist";
$bpclschedcmd="/usr/openv/netbackup/bin/admincmd/bpclsched";
$dom_freq=10; #Frequency for day-of-month scheduled full backups
$dow_freq=3; #Frequency for day-of-week scheduled backups
@weekdays=("sun","mon","tue","wed","thu","fri","sat");
$retention=8;
$master=`hostname`;
chomp $master ;
$tngcmd="/opt/tng/tng_custom/tools/sendTrap.ksh" ;

if ( -f $tngcmd ) {$tngcall="$tngcmd NETBACKUP CRIT BOTH" }

#Such the schule data out of the schedule file
open (SCHED,"<$schedfile");
@sched=<SCHED>;
close (SCHED);

#Massage the schedule data to strip out comments and get it into an 
#expected form
map {chomp($_)} @sched; #Chomp each line in sched
map {s/([^#]*)#.*/$1/} @sched; #Strip out comments
map {s/^\s*(\S*)\s*$/$1/} @sched; #Strip leading & trailing white space
#Lowercase the bit of the string that comes after the colon
map {s/^([^:]+):(.*)$/$1:\L$2/} @sched;
@sched=grep {$_ ne ""} @sched; #Throw away empty lines
#Put the schedule data into an associative array
for (@sched) {
   /^([^:]+):(.*)$/;
   $sched{$1}=$2;
}

#check the values in the sched array to see if they're valid
foreach $i (keys %sched) {
   #Assume value is invalid unless shown otherwise
   $valid=0;

   #If the value is all numeric and is between 1 & 31 then it's OK
   if (($sched{$i}=~/^[0-9]+$/)&&($sched{$i}>=1)&&($sched{$i}<=31)) {
      $valid=1;
      #While we're here, If the value is > 28 then print a warning
      if ($sched{$i}>28) {
	 $warning="WARNING from autosched.pl on $master: Date for class $i is $sched{$i}. You will miss full backups on months with more than 28 days.";
         print STDERR "$warning\n";
   	 system ("$tngcall $warning");
	
      }
   }

   #If the value is one of the days of the week or "never"then it's valid 
   if ($sched{$i} eq "sun") {$valid=1;}
   if ($sched{$i} eq "mon") {$valid=1;}
   if ($sched{$i} eq "tue") {$valid=1;}
   if ($sched{$i} eq "wed") {$valid=1;}
   if ($sched{$i} eq "thu") {$valid=1;}
   if ($sched{$i} eq "fri") {$valid=1;}
   if ($sched{$i} eq "sat") {$valid=1;}
   if ($sched{$i} eq "never") {$valid=1;}
      
   #if we haven't shown the value to be good then print out a warning
   #and remove the class from the sched array
   if ($valid != 1) {
	$warning="WARNING from autosched.pl on $master: Value $sched{$i} for class $i is invalid. Entry ignored.";
	print STDERR "$warning\n";
	system ("$tngcall $warning");
      delete $sched{$i}
   }
}
#Now get a list of classes from netbackup 
open (CLASS,"ls -1 $classdir|");
while ($class=<CLASS>) {
   chomp ($class);
   if ((-d "$classdir/$class") && (-r "$classdir/$class/info")) {
      open (INFO,"<$classdir/$class/info");
      while ($info=<INFO>) {
         if ($info=~/^ACTIVE\s+(\d).*/) {$validclass{$class}=$1;}
      }
      close (INFO);
   }
}
close (CLASS);
#we now have a list of classes in the %validclass hash, the value
#of the hash indicated wether or not the class is active 0=active 1=inactive

#Now make sure that each active class is listed in our conf file 
foreach $i (keys %validclass) {
   if ($validclass{$i} eq "0") { 
      unless (defined $sched{$i}) {
	$warning="WARNING from autosched.pl on $master: Active class $i does not have an entry in $schedfile.";
	print STDERR "$warning\n";
	system ("$tngcall $warning");
	 $noclass=1;
      }
   }
}
if (defined $noclass) { sleep 5 };

#Find out what the time is and then schedule full backups
$epoch=time;
($seconds,$minutes,$hours,$day_of_month,$month,$year,$wday,$yday,$isdst)=
   localtime($epoch);
$day_of_month=int($day_of_month * 1); #cheap way to strip leading zeroes
foreach $i (keys %sched) {
   $freq=0;
   if ($weekdays[$wday] eq $sched{$i}) {$freq=$dow_freq;}
   if ($day_of_month eq $sched{$i}) {$freq=$dom_freq;}
   #If this isn't an active class then don't back it up.
   if ($validclass{$i}==1) {$freq=0;}
   $freq=$freq*86400;
   if ($freq==0) {
      #If $freq is 0 then we don't have a backup to schedule today
      #In this snippit of code $freq gets used as a do/don't back 
      #it up flag: if $freq is 0 then skip the backup scheduling
      next;
   }

   #search through each schedule's info file to determine which
   #schedule is the daily incremental
   $start=0;
   $schedname="";
   foreach $j (<$classdir/$i/schedule/*/info>) {
      open (INFO,"<$j"); @info=<INFO>; close (INFO);
      if (grep{/SCHED_TYPE\s+1/} @info) {
         #SCHED_TYPE was 1; this is the file we want, let's get some data
         $mpx=(grep{/MAX_MPX\s+\d+/} @info)[0];
         chomp ($mpx);$mpx=~s/MAX_MPX\s+(\d+)/$1/;
         $dayfile=$j; $dayfile=~s/(.*)\/info/$1\/days/;
         open(DAYINFO,"<$dayfile");@dayinfo=<DAYINFO>;close(DAYINFO);
         $start=(grep{/$wday\s+.*/} @dayinfo)[0];
         chomp ($start);
         $duration=$start;
         $start=~s/$wday\s+(\d+)\s+(\d+)/$1/;
         $duration=~s/$wday\s+(\d+)\s+(\d+)/$2/;
	 $schedname=$j;
	 $schedname=~s/.*\/schedule\/(.*)\/info/$1/;
         last;
      }
   }
   if ($schedname eq "") {
	$warning="WARNING from autosched.pl on $master: No daily incremental schedule defined for class $i.";
	print STDERR "$warning\n";
	system ("$tngcall $warning");
      sleep 5 ;
      next;
   }
   $sname="Automatic_Full";
   #
   # we run the Netbackup command as an easy way to
   # set the schedule paramaters, then we overwrite this new
   # "days" file with the "days" file used by the incremental
   # schedule.  This copy step was added to prevent problems
   # processing an incremental schedule with "holes" in
   # it's backup window definitions.  RW 12/99
   #print "$bpclschedcmd $i -add $sname -st FULL -rl $retention -freq $freq -mpxmax $mpx -window $start $duration\n";
   $return=system ("$bpclschedcmd $i -add $sname -st FULL -rl $retention -freq $freq -mpxmax $mpx -window $start $duration");
   if ($return == 0) {
       #print "cp -p $classdir/$i/schedule/$schedname/days $classdir/$i/schedule/$sname/days\n";
       $return2=system ("cp -p $classdir/$i/schedule/$schedname/days $classdir/$i/schedule/$sname/days\n");
   }
   if ( ($return > 0)||($return2 > 0)) {
	$warning="WARNING from autosched.pl on $master: Failure creating schedule $sname in class $i!";
	print STDERR "$warning\n";
	system ("$tngcall $warning");
   } else {
      $expepoch=int($freq+$epoch);
      open (SCHEDDAT,">>$scheddatfile");
      print SCHEDDAT "$i:$sname:$expepoch\n";
      close (SCHEDDAT);
   }
}

#Hokay, now that we've scheduled backups, let's go eliminate old backups

#Hang out just a couple seconds so we give old backups a chance to expire.
sleep 5;

#Suck the schedule data out of the schedule file
open (SCHEDDAT,"<$scheddatfile");
@sched=<SCHEDDAT>;
close (SCHEDDAT);

map {chomp($_)} @sched; #Chomp each line in sched
map {s/^\s*(\S*)\s*$/$1/} @sched; #Strip leading & trailing white space
@sched=grep {$_ ne ""} @sched; #Throw away empty lines

open (SCHEDDAT,">$scheddatfile");
$epoch=time;
foreach $i (@sched) {
   ($class,$sname,$expepoch)=split(/:/,$i);
   if ($expepoch>=($epoch + 90000)) { # we delete it 25 hours in advace 
      print SCHEDDAT "$i\n";
   } else {
      #print "$bpclschedcmd $class -delete $sname\n";
      $return = system ("$bpclschedcmd $class -delete $sname");
      if ( $return > 0 ) {
	$warning="WARNING from autosched.pl on $master: Failed to delete schedule $sname in class $class!";
	print STDERR "$warning\n";
	system ("$tngcall $warning");
         print SCHEDDAT "$i\n";
      }
   }
}
close (SCHEDDAT);
