#!/usr/local/bin/perl
# info.pl - perl port of Curtis Preston's info.sh
#    liza weissler <liza@colltech.com>, collective technologies

use lib "/nsr/etc";
require "getopts.pl";
require "nwlib.pl";

#--------------
# os-independent stuff
#--------------
$whoami=$0;
$whoami=~ s-.*/-- ;

if (defined $ARGV[0]) {  # only possible arg is jukebox
    $xjbox=$ARGV[0];
    $jbox = FindJB($whoami,$xjbox);  # this sub exits if bogus jukebox
} else {
    $jbox = FindJB($whoami); 
}

$jbstring = "-j $jbox";

#------------------------
# deposit any tapes that may be in the mail slot
# (note need to filter out errors...)
#------------------------
if ($debug) {
    print "nsrjb -d $jbstring\n";
} else {
# skip this for now -- it sometimes hangs!
#    `nsrjb -d $jbstring`;   
}

#------------------------
# determine slots
#------------------------
open(NSRJB,"nsrjb $jbstring|") || die "Cannot run \"nsrjb $jbstring\"\n";
while(<NSRJB>) {
    if (/\*  \*$/) {
	chop;
	($s) = (split(/:/,$_));
	$s =~ s/  \*//g;
	$slots{$s} = 1;
    }
}
close(NSRJB);

#------------------------
# inventory each slot
#------------------------
foreach $s (keys %slots) {
    if ($debug) {
	print "nsrjb -I $jbstring -S $s\n";
    } else {
	`nsrjb -I $jbstring -S $s`;
    }
}
exit(0);
