#!/bin/sh
#
# Rcs_ID="$RCSfile: infback.sh,v $"
# Rcs_ID="$Revision: 1.1 $ $Date: 2000/06/30 18:00:17 $"
#
# Copyright (c) 1998 Curtis Preston curtis@colltech.com
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# For a copy of the license, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139
#
#######################################################
##Site-specific section (change as appopriate)

PATH=/bin:/usr/bin:/usr/sbin:/sbin:/usr:/etc

#Set this variable to Y to turn on set -x for all functions
DEBUG=Y

ulimit 4194303
umask 003

BINDIR=/informix/local/bin
LOGDIR=/informix/logfiles
LOG=$LOGDIR/infback.log
INFCONF=/informix/local/bin/infback.conf
INFORMIX=informix
INFTAB=/informix/etc/inftab
TMP=/var/tmp
COMPSUFF='Z'  #If using gzip, change this to 'gz'


Preback() {             #Run prior to backup 
[ "$DEBUG" = Y ] && set -x 
}

Postback() {          #Run after entire backup finishes
[ "$DEBUG" = Y ] && set -x 
}

export PATH TMP ulimit umask COMPRESS BINDIR LOGDIR LOG INFCONF INFORMIX
export INFTAB TMP

#
#############################################################################

[ "$DEBUG" = Y ] && set -x

Usage()
{
[ "$DEBUG" = Y ] && set -x 
 echo "
To run all archives for this machine as set up in $INFCONF:
\$ $SCRIPT

To run infback.sh manually selecting all arguments:
\$ $SCRIPT level device server_list 
Where:
device       = tape device name.  (e.g. /dev/rmt/0 or host:/dev/rmt/0)
server_list  = list of informix servers (instances) to back up"
 echo 
 exit 1
}

Log_error() #Sends errors to various places
{
[ "$DEBUG" = Y ] && set -x 
 if [ "$1" -gt 0 ] ; then
  TIME="`date '+%b %e %T'` $SERVER"
  MSG=" `basename $0` $SERVER: WARNING:"
  ERR=`echo $2|sed "s/^/$TIME $MSG /"`
  echo "$ERR" |$TLOG
  echo "$ERR" >>$TMP/$X.Mail
  if [ "$3" = exit ] ; then
   Mail_dba
   exit 1
  fi
 fi
}

Error_chk() {     #Check isql output files for errors
[ "$DEBUG" = Y ] && set -x 
 ERROR=`egrep -i 'error' $1`
 [ -n "$ERROR" ] && Log_error 1 "$ERROR"
 [ ! -s $1 ] && Log_error 99 "Bus error on isql"
}

Mail_dba() {
[ "$DEBUG" = Y ] && set -x 
 #If there were errors, mail them to the dba
 [ -s $TMP/$X.Mail ] && cat $TMP/$X.Mail | $L_MAIL $L_S "$MESS" $DBAS
 rm -f $TMP/$X.*
}

Check_if_client_is_remote()
{
[ "$DEBUG" = Y ] && set -x
 if [ $DEVICE_SERVER = $SERVER ] ; then
  RSH_IF_REMOTE=
  CLIENT_IF_REMOTE=
 else
  RSH_IF_REMOTE=$L_RSH
  CLIENT_IF_REMOTE=$DEVICE_SERVER
  HOSTOK=`$L_RSH $DEVICE_SERVER uname`
  if [ -z "$HOSTOK" ] ; then
   echo "Cannot $L_RSH to remote device host $DEVICE_SERVER!"|$TLOG
   Mail_dba
   exit 1
  fi
 fi
 export RSH_IF_REMOTE CLIENT_IF_REMOTE

}

echo "Parsing arguments and determing OS type and command pathnames..."

X=$$
L_MAIL=mail
L_S=''
MESS=''
DBAS='informix,root'
export X L_MAIL L_S MESS DBAS

SERVER=`uname -n|awk -F'.' '{print $1}'`
[ -n "$SERVER" ] || SERVER=`hostname|awk -F'.' '{print $1}'`

if [ -z "$SERVER" ] ; then
 Log_error 1 "Unable to obtain hostname!" exit
fi

DBAS=`grep "^$SERVER.master:" $INFCONF|awk -F: '{print $10}'`
[ -n "$DBAS" ] || DBAS='informix, root' 
SCRIPT=`basename $0`
TLOG="tee -a $LOG"
ORIG_PATH=$PATH

export SCRIPT DBAS TLOG ORIG_PATH

#config.guess is the GNU platform guessing script.

if [ ! -f $BINDIR/config.guess -o ! -x $BINDIR/config.guess ] ; then
 Log_error $? "$BINDIR/config.guess missing or not executable!" exit
else
 LOCAL_OSnR=`$BINDIR/config.guess`
 export LOCAL_OSnR
fi

ENTRY=`grep "^$SERVER.master:" $INFCONF`
if [ -z "$ENTRY" ] ; then
 Log_error 1 "There is no entry for $SERVER in $INFCONF" exit
fi

DAY=`date +%a` ; export DAY

if [ "$1" = at ] ; then
  ARG=at
  shift 1
fi

if [ $# -eq 0 ] ; then

#format of infback.conf
#node.master::Full Day:Full Time:Inc Time:dev_server:device_file_or_dir:informix ids:compress?:mail ids

 FULL_DAY=`echo $ENTRY|awk -F: '{print $3}'|sed 's/ //g'`
 [ "$FULL_DAY" = "$DAY" ] && LEVEL=0 || LEVEL=1
 DEVICE_SERVER=`echo $ENTRY|awk -F: '{print $6}'|sed 's/ //g'`
 DEVICE_FILE=`echo $ENTRY|awk -F: '{print $7}'|sed 's/ //g'`
 DEVICE="$DEVICE_SERVER:$DEVICE_FILE"
 INSTANCE_LIST=`grep -v '^#' $INFTAB|awk -F: '{print $1}'`
else
 LEVEL=$1
 DEVICE=$2
 if [ -n "`echo $DEVICE|grep ':'" ] ; then
  DEVICE_SERVER=`echo $DEVICE|awk -F: '{print $1}'`
  DEVICE_FILE=`echo $DEVICE|awk -F: '{print $2}'`
 else
  DEVICE_SERVER=$SERVER
  DEVICE_FILE=$DEVICE
 fi
 shift 2

 #If it's given a list of instances, it will back them up, if not it will backup all 
 if [ $# -gt 0 ] ; then
  INSTANCE_LIST=$*
 else
  INSTANCE_LIST=`grep -v '^#' $INFTAB|awk -F: '{print $1}'`
 fi

fi

. $BINDIR/localpath.sh
Log_error $? "Could not execute $BINDIR/localpath.sh." exit

Check_if_client_is_remote

USERS=`echo $ENTRY|awk -F: '{print $8}'|sed 's/ //g'`
 [ -z "$USERS" ]  &&  USERS=informix
WHO=`id | awk -F'(' '{print $2}' | awk -F')' '{print $1}' `

if [ -z "`echo $WHO | egrep \"$USERS\"`" ] ; then
 echo "WRONG LOGIN!\n"
 Usage
fi

SKIP=`echo $ENTRY| awk -F':' '{print $2}'`
touch $INFCONF ${INFCONF}.2
Log_error $? "Unable to create $INFCONF.2 (Needed 4 SKIP feature.)" exit

                    #Skip b/u if find "skip" in INFCONF
if [ "$SKIP" = "skip" ]; then
 sed "s/$HOST.*:skip:/$HOST.master::/" $INFCONF >${INFCONF}.2
 mv -f ${INFCONF}.2 $INFCONF 
 echo "SKIPPING $0 ON $HOST TONIGHT ONLY DUE"   |$TLOG
 echo "TO THE WORD \"skip\" IN $INFCONF!!"      |$TLOG
 exit 0
fi

if [ "$ARG" = at ] ; then
 if [ $LEVEL = 0 ] ; then
  TIME=`echo $ENTRY|awk -F: '{print $4}'`
 else
  TIME=`echo $ENTRY|awk -F: '{print $5}'`
 fi

 if [ -z "$TIME" ]; then
  Log_error 1 "No backup time found in $INFCONF" exit
  exit 1
 fi

 case $LOCAL_OSnR in
  *hpux* ) _S=''   ;;
  * )     _S='-s' ;;
 esac
 
 at $_S $TIME<<EOF_AT          
 #Start an at job w/Bourne sh
$BINDIR/infback.sh > $TMP/infback.out 2>&1
EOF_AT

exit 0

fi

COMPRESS=`echo $ENTRY|awk -F: '{print $9}'`
DBAS=`echo $ENTRY|awk -F: '{print $10}'|sed 's/ //g'`

case $LEVEL in
 0|1|2) echo ;;
     *) clear
        Log_error 1  "Invalid level (Must be 0,1, or 2)" exit
esac

echo "Determining device server OS type and command pathnames..."

if [ -n "$RSH_IF_REMOTE" ] ; then
 rcp $BINDIR/config.guess $DEVICE_SERVER:$TMP/$X.config.guess
else
 cp $BINDIR/config.guess $TMP/$X.config.guess
fi

RSH_TO_CLIENT1=$?

REMOTE_OSnR=`$RSH_IF_REMOTE $CLIENT_IF_REMOTE $TMP/$X.config.guess`
RSH_TO_CLIENT2=$?

RSH_TO_CLIENT=`expr $RSH_TO_CLIENT1 + $RSH_TO_CLIENT2`
if [ "$L_RSH_TO_CLIENT" -gt 0 ] ; then
 Log_error $L_RSH_TO_CLIENT "Could not $L_RSH to client"
fi

export REMOTE_OSnR

. $BINDIR/rempath.sh
Log_error $? "Could not execute $BINDIR/rempath.sh." exit

MESS="INFORMIX BACKUP ERROR!" ; export MESS

[ -s $INFTAB ] || Log_error 1 "NO $INFTAB - ABORTING BACKUP" exit

[ -d $LOGDIR ] || mkdir $LOGDIR
Log_error $? "Could not mkdir $LOGDIR!" exit

touch $LOG
Log_error $? "Unable to create $LOG" exit

chown $INFORMIX $LOG
Log_error $? "Unable to chown owner of $LOG to $INFORMIX " exit

#Start the archive log
date|$TLOG
echo $N "Using $SCRIPT to perform a level $LEVEL archive of: $C" |$TLOG
echo "$INSTANCE_LIST"|$TLOG

for INSTANCE in $INSTANCE_LIST #for each server listed in the options 
do

 TBCONFIG=${INSTANCE}
 ONCONFIG=${INSTANCE}
 INFORMIXDIR=`grep "^$INSTANCE:"  $INFTAB|awk -F: '{print $2}'`
 PATH=$ORIG_PATH:$INFORMIXDIR:$INFORMIXDIR/bin

 #Since ONCONFIG and INFORMIXSERVER can be different, get it from onconfig
 INFORMIXSERVER=`grep DBSERVERNAME $INFORMIXDIR/etc/$ONCONFIG|awk '{print $2}'`

 export TBCONFIG ONCONFIG INFORMIXDIR PATH INFORMIXSERVER

 #This next section does two things... If the database is up, we will get the
 #version of informix, if it is not, we will get "shared memory" problems
 #This will cause $VERSION to be null, and the archive to be skipped

 [ -f $INFORMIXDIR/bin/onstat ] && ONSTAT=onstat || ONSTAT=tbstat
 
 VERSION=`$ONSTAT - |grep " Version "| sed '/^$/d'|awk '{print $3}'\
  |awk -F'.' '{print $1}'`

 PATH=$PATH:$INFORMIXDIR:$INFORMIXDIR/bin

 export INFORMIXDIR PATH
 
 #zero out the tbmon.file
 cp /dev/null $TMP/$X.tbmon.out.$INSTANCE
 Log_error $? "Could not cp /dev/null to $TMP/$X.tbmon.out.$INSTANCE!" exit
  
 # Make sure the tape is rewound before performing the archive
 # The elaborate structure is necessary, since the return code
 # is that of the remsh, not of the mt $R_T, so we redirect std.error
 # to a file and see if there's anything there.  If there is, then there
 # was an error.         

 cat >$TMP/$X.DEVICE.TEST <<EOF
#!/bin/sh
PATH=/bin:/usr/bin:/usr/sbin:/sbin:/etc
export PATH
$R_CD $DEVICE_FILE
if [ \$? -eq 0 ] ; then
 [ -d $DEVICE_FILE ]             || mkdir $DEVICE_FILE
 [ -d $DEVICE_FILE/$INSTANCE ]   || mkdir $DEVICE_FILE/$INSTANCE
 $R_TOUCH $DEVICE_FILE/$INSTANCE/$INSTANCE.level.$LEVEL
 [ \$? -eq 0 ] && $R_ECHO "FILE" || $R_ECHO "NOFILE"
 chmod 775 $DEVICE_FILE/$INSTANCE/$INSTANCE.level.$LEVEL
 [ \$? -eq 0 ] || $R_ECHO "NOFILE"
else
 $R_MT $R_F $DEVICE_FILE $R_REWIND
 [ \$? -eq 0 ] && $R_ECHO "TAPE" || $R_ECHO "NOREWIND"
fi
EOF

 chmod 755 $TMP/$X.DEVICE.TEST

 if [ -n "$RSH_IF_REMOTE" ] ; then
  rcp $TMP/$X.DEVICE.TEST $DEVICE_SERVER:$TMP/$X.DEVICE.TEST
 fi

 DEVICE_STAT=`$RSH_IF_REMOTE $CLIENT_IF_REMOTE $TMP/$X.DEVICE.TEST`

 if [ -z "$DEVICE_STAT" ] ; then
   Log_error 1 "Something went wrong while setting up $DEVICE_FILE" exit
 fi

 if [ "$DEVICE_STAT" = NOFILE ] ; then
   Log_error 1 "Could not create backup file $DEVICE_FILE" exit
 fi

 if [ "$DEVICE_STAT" = NOREWIND ] ; then
   Log_error 1 "Could not create rewind $DEVICE_FILE" exit
 fi

 if [ "$DEVICE_STAT" = FILE ] ; then
  BACKUPDIR=$DEVICE_FILE 
  DEVICE_FILE=$BACKUPDIR/$INSTANCE/$INSTANCE.level.$LEVEL
  if [ -n "$COMPRESS" ] ; then
   $RSH_IF_REMOTE $CLIENT_IF_REMOTE $R_RM $DEVICE_FILE
   COMPRESSED_FILE="$DEVICE_FILE.$COMPSUFF"
   DEVICE_FILE=$INFORMIXDIR/$INSTANCE.level.$LEVEL.fifo
  fi
  export BACKUPDIR DEVICE_FILE
 fi

 if [ $SERVER = $DEVICE_SERVER -o -n "$COMPRESS" ] ; then
   DEVICE=$DEVICE_FILE
 else
   DEVICE=$DEVICE_SERVER:$DEVICE_FILE
 fi

 #Test if there is sufficient space on the machine to modify the config 
 #file by changing the tape parameters...
 #An interesting feature of the config file is that if you try to change
 #any of the parameters while the file system is full, the file will
 #disappear!

 #Save the config file JUST IN CASE!
 cp $INFORMIXDIR/etc/${INSTANCE} $INFORMIXDIR/${INSTANCE}.`date +%m%d`

 #The extra copy is to make sure there's enough space to make the change
 cp $INFORMIXDIR/etc/${INSTANCE} $INFORMIXDIR/${INSTANCE}.temp

 if [ $? -gt 0 ] ; then
  #If there was not sufficient space to change the tape parameters,

  date|$TLOG
  Log_error 1 "Insufficient space in $INFORMIXDIR to change tape parameters."
  Log_error 1 "Archive on ${INSTANCE} not completed on $DEVICE"
  exit 1
 else
  rm $INFORMIXDIR/${INSTANCE}.temp
 fi

 cd $INFORMIXDIR/etc

 find $INFORMIXDIR/etc -name "${INSTANCE}.*" -mtime +5 -exec rm {} \;

 if [ "$DEVICE_STAT" = "FILE" -a -n "$COMPRESS" ] ; then
  
  rm -f $DEVICE_FILE 2>/dev/null
  $L_MKNOD $DEVICE_FILE $L_P
  
  $COMPRESS -c <$DEVICE_FILE |$RSH_IF_REMOTE $CLIENT_IF_REMOTE $R_DD of=$COMPRESSED_FILE &
  
  sleep 2

 fi

 #Below acceses on/tbconfig and changes the tape params in ~/etc/$INSTANCE
 #The ^[e e is not junk, it is <ESC> and two e's, which on/tbmonitor
 #interprets as save the changes, exit, exit  
 #NOTE: Both on/tbmonitor and ontape are very picky about how the here doc is 
 #arranged.. DO NOT modify the hear doc below unless you yy and pp it out 
 #It is very difficult to get right again. DO NOT use a mouse to cut and
 #paste it... You must use vi's "yy" and "pp" options
 #The "garbage" you see is not...It is the escape character, that 
 #onmonitor reads

 if test "$VERSION"
 then

  #A second note - version 6 is completely opposite in the way it calls
  #tbtape, so we find out the version then run it the appropriate way

 if [ $VERSION -lt 6 ] ; then
  $INFORMIXDIR/bin/tbmonitor ${INSTANCE} <<EOF >/dev/null
lt$DEVICE                     ee                      
EOF

echo "
${LEVEL}
"| tbtape -s |head -100 >$TMP/$X.tbtape.out.$INSTANCE

 else
        $INFORMIXDIR/bin/onmonitor ${INSTANCE} <<EOF >/dev/null
lt$DEVICE                     ee
EOF

echo "$LEVEL

"| ontape -s  |head -100 >$TMP/$X.ontape.out.$INSTANCE

 fi

 if [ $? = 0 ] 
 then
  echo |$TLOG
  date|$TLOG
  echo "Level ${LEVEL} archive on ${INSTANCE} successful" |$TLOG

  else
   echo |$TLOG
   date| $TLOG
   echo "Level ${LEVEL} archive on ${INSTANCE} NOT SUCCESSFUL."|$TLOG
  fi
 
else  #The database was not up!!

 echo |$TLOG
 date|$TLOG
 echo "$INSTANCE archive NOT SUCCESSFUL, $INSTANCE was off-line" |$TLOG
fi

done

Mail_dba
