#!/bin/sh

# Rcs_ID="$RCSfile: dbstart.informix.sh,v $"
# Rcs_ID="$Revision: 1.1 $ $Date: 2000/06/30 17:59:49 $"
#

INFTAB=/informix/etc/inftab

Usage()
{
 echo "Usage: [dbshut|dbstart] [start|stop]"
 echo "/n(Either this script must be called with the name of dbshut or dbstart,"
 echo "or it must be called with a start or stop argument.)"
 echo "\nIf called by the name dbstart, or with the argment of 'start,'"
 echo "it will start all Informix instances listed in $INFTAB"
 echo "\nIf called by the name dbshut, or with the argument of 'stop,'"
 echo "it will STOP all Informix instances listed in $INFTAB."
}


#This script starts up all instance on this box specified in $INFTAB
#It is of the form:
#$ONCONFIG:$INFORMIXDIR:<Y|N>

SCRIPT=`basename $0`

if [ $SCRIPT != dbstart -a "$1" != start ] ; then
 if [ $SCRIPT != dbshut -a "$1" != stop ] ; then
  Usage
  exit
 fi
fi

WHO=`id | awk -F'(' '{print $2}' | awk -F')' '{print $1}' `

if [ "$WHO" = root ] ; then
  su informix -c $0 $*
  exit $?
fi

grep -v '^#' $INFTAB \
|while read LINE
do

 STARTUP=`echo $LINE|cut -d: -f3`
 TBCONFIG=`echo $LINE|cut -d: -f1`
 ONCONFIG=`echo $LINE|cut -d: -f1`
 #INFORMIXSERVER and ONCONFIG can be different, so get it from the onconfig file
 INFORMIXSERVER=`grep DBSERVERNAME $INFORMIXDIR/etc/$ONCONFIG|awk '{print $2}'`
 INFORMIXDIR=`echo $LINE|cut -d: -f2`
 BINDIR=$INFORMIXDIR/local/bin
 PATH=$INFORMIXDIR/bin:$BINDIR:$PATH
 export TBCONFIG ONCONFIG INFORMIXSERVER INFORMIXDIR PATH BINDIR

 if [ `basename $0` = dbstart -o "$1" = start ] ; then
  if [ "$STARTUP" = "Y" ] ; then
   echo "Starting Informix Instance $ONCONFIG"
   oninit
   [ -f $BINDIR/rclogs.sh ] && rclogs.sh start
  else
   echo "NOT Starting Informix Instance $ONCONFIG.  (No 'Y' in $INFTAB.)"
  fi
 else
  echo "Stopping Informix Instance $ONCONFIG"
  [ -f $BINDIR/rclogs.sh ] && rclogs.sh stop
  onmode -ky
 fi

done

