unit u_sockhdr;

interface

type
  WordArray = ^TWordArray;
  TWordArray = array [0..0] of Word;

type
  PIPhdr = ^TIPhdr;
  TIPhdr = packed record
    ip_verlen: Byte;
    ip_tos: Byte;
    ip_len: Word;
    ip_id: Word;
    ip_off: Word;
    ip_ttl: Byte;
    ip_p: Byte;
    ip_sum: Word;
    ip_src: Cardinal;
    ip_dst: Cardinal;
  end;

  PICMPhdr = ^TICMPhdr;
  TICMPhdr = packed record
    icmp_type: Byte;
    icmp_code: Byte;
    icmp_sum: Word;
    icmp_id: Word;
    icmp_seq: Word;
  end;

  PUDPHdr = ^TUDPHdr;
  TUDPHdr = packed record
    udp_sport: word;
    udp_dport: word;
    udp_ulen: word;
    udp_sum: word;
  end;

function CheckSum(data: WordArray; size: Integer): Word;

implementation

function CheckSum(data: WordArray; size: Integer): Word;
var
  i, sum: Integer;
begin
  sum := 0;
  i := 0;
  while size > 1 do begin
    Inc(sum, data^[i]);
    Dec(size, 2);
    Inc(i);
  end;
  if size <> 0 then
    Inc(sum, data^[i]);
  sum := (sum shr 16) + (sum and $ffff);
  Inc(sum, sum shr 16);
  Result := not sum;
end;

end.
 