/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.VecMathI18N;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;

public class Matrix4d
implements Serializable {
    static final long serialVersionUID = 8223903484171633710L;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;
    double[] tmp = new double[16];
    double[] tmp_rot = new double[9];
    double[] tmp_scale = new double[3];
    private static final double EPS = 1.0E-10;

    public Matrix4d() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public Matrix4d(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m03 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.m12 = d8;
        this.m13 = d9;
        this.m20 = d10;
        this.m21 = d11;
        this.m22 = d12;
        this.m23 = d13;
        this.m30 = d14;
        this.m31 = d15;
        this.m32 = d16;
        this.m33 = d17;
    }

    public Matrix4d(Matrix3d matrix3d, Vector3d vector3d, double d2) {
        this.m00 = matrix3d.m00 * d2;
        this.m01 = matrix3d.m01 * d2;
        this.m02 = matrix3d.m02 * d2;
        this.m03 = vector3d.x;
        this.m10 = matrix3d.m10 * d2;
        this.m11 = matrix3d.m11 * d2;
        this.m12 = matrix3d.m12 * d2;
        this.m13 = vector3d.y;
        this.m20 = matrix3d.m20 * d2;
        this.m21 = matrix3d.m21 * d2;
        this.m22 = matrix3d.m22 * d2;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public Matrix4d(Matrix3f matrix3f, Vector3d vector3d, double d2) {
        this.m00 = (double)matrix3f.m00 * d2;
        this.m01 = (double)matrix3f.m01 * d2;
        this.m02 = (double)matrix3f.m02 * d2;
        this.m03 = vector3d.x;
        this.m10 = (double)matrix3f.m10 * d2;
        this.m11 = (double)matrix3f.m11 * d2;
        this.m12 = (double)matrix3f.m12 * d2;
        this.m13 = vector3d.y;
        this.m20 = (double)matrix3f.m20 * d2;
        this.m21 = (double)matrix3f.m21 * d2;
        this.m22 = (double)matrix3f.m22 * d2;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public Matrix4d(Matrix4d matrix4d) {
        this.m00 = matrix4d.m00;
        this.m01 = matrix4d.m01;
        this.m02 = matrix4d.m02;
        this.m03 = matrix4d.m03;
        this.m10 = matrix4d.m10;
        this.m11 = matrix4d.m11;
        this.m12 = matrix4d.m12;
        this.m13 = matrix4d.m13;
        this.m20 = matrix4d.m20;
        this.m21 = matrix4d.m21;
        this.m22 = matrix4d.m22;
        this.m23 = matrix4d.m23;
        this.m30 = matrix4d.m30;
        this.m31 = matrix4d.m31;
        this.m32 = matrix4d.m32;
        this.m33 = matrix4d.m33;
    }

    public Matrix4d(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public Matrix4d(Quat4d quat4d, Vector3d vector3d, double d2) {
        this.m00 = d2 * (1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z);
        this.m10 = d2 * (2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z));
        this.m20 = d2 * (2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y));
        this.m01 = d2 * (2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z));
        this.m11 = d2 * (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z);
        this.m21 = d2 * (2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x));
        this.m02 = d2 * (2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y));
        this.m12 = d2 * (2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x));
        this.m22 = d2 * (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y);
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public Matrix4d(Quat4f quat4f, Vector3d vector3d, double d2) {
        this.m00 = d2 * (1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z);
        this.m10 = d2 * (2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z));
        this.m20 = d2 * (2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y));
        this.m01 = d2 * (2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z));
        this.m11 = d2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z);
        this.m21 = d2 * (2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x));
        this.m02 = d2 * (2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y));
        this.m12 = d2 * (2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x));
        this.m22 = d2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y);
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public Matrix4d(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    public final void add(double d2) {
        this.m00 += d2;
        this.m01 += d2;
        this.m02 += d2;
        this.m03 += d2;
        this.m10 += d2;
        this.m11 += d2;
        this.m12 += d2;
        this.m13 += d2;
        this.m20 += d2;
        this.m21 += d2;
        this.m22 += d2;
        this.m23 += d2;
        this.m30 += d2;
        this.m31 += d2;
        this.m32 += d2;
        this.m33 += d2;
    }

    public final void add(double d2, Matrix4d matrix4d) {
        this.m00 = matrix4d.m00 + d2;
        this.m01 = matrix4d.m01 + d2;
        this.m02 = matrix4d.m02 + d2;
        this.m03 = matrix4d.m03 + d2;
        this.m10 = matrix4d.m10 + d2;
        this.m11 = matrix4d.m11 + d2;
        this.m12 = matrix4d.m12 + d2;
        this.m13 = matrix4d.m13 + d2;
        this.m20 = matrix4d.m20 + d2;
        this.m21 = matrix4d.m21 + d2;
        this.m22 = matrix4d.m22 + d2;
        this.m23 = matrix4d.m23 + d2;
        this.m30 = matrix4d.m30 + d2;
        this.m31 = matrix4d.m31 + d2;
        this.m32 = matrix4d.m32 + d2;
        this.m33 = matrix4d.m33 + d2;
    }

    public final void add(Matrix4d matrix4d) {
        this.m00 += matrix4d.m00;
        this.m01 += matrix4d.m01;
        this.m02 += matrix4d.m02;
        this.m03 += matrix4d.m03;
        this.m10 += matrix4d.m10;
        this.m11 += matrix4d.m11;
        this.m12 += matrix4d.m12;
        this.m13 += matrix4d.m13;
        this.m20 += matrix4d.m20;
        this.m21 += matrix4d.m21;
        this.m22 += matrix4d.m22;
        this.m23 += matrix4d.m23;
        this.m30 += matrix4d.m30;
        this.m31 += matrix4d.m31;
        this.m32 += matrix4d.m32;
        this.m33 += matrix4d.m33;
    }

    public final void add(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.m00 = matrix4d.m00 + matrix4d2.m00;
        this.m01 = matrix4d.m01 + matrix4d2.m01;
        this.m02 = matrix4d.m02 + matrix4d2.m02;
        this.m03 = matrix4d.m03 + matrix4d2.m03;
        this.m10 = matrix4d.m10 + matrix4d2.m10;
        this.m11 = matrix4d.m11 + matrix4d2.m11;
        this.m12 = matrix4d.m12 + matrix4d2.m12;
        this.m13 = matrix4d.m13 + matrix4d2.m13;
        this.m20 = matrix4d.m20 + matrix4d2.m20;
        this.m21 = matrix4d.m21 + matrix4d2.m21;
        this.m22 = matrix4d.m22 + matrix4d2.m22;
        this.m23 = matrix4d.m23 + matrix4d2.m23;
        this.m30 = matrix4d.m30 + matrix4d2.m30;
        this.m31 = matrix4d.m31 + matrix4d2.m31;
        this.m32 = matrix4d.m32 + matrix4d2.m32;
        this.m33 = matrix4d.m33 + matrix4d2.m33;
    }

    public final double determinant() {
        double d2 = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        d2 -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        d2 += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return d2 -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    public boolean epsilonEquals(Matrix4d matrix4d, double d2) {
        double d3 = this.m00 - matrix4d.m00;
        double d4 = d3 < 0.0 ? -d3 : d3;
        if (d4 > d2) {
            return false;
        }
        d3 = this.m01 - matrix4d.m01;
        double d5 = d3 < 0.0 ? -d3 : d3;
        if (d5 > d2) {
            return false;
        }
        d3 = this.m02 - matrix4d.m02;
        double d6 = d3 < 0.0 ? -d3 : d3;
        if (d6 > d2) {
            return false;
        }
        d3 = this.m03 - matrix4d.m03;
        double d7 = d3 < 0.0 ? -d3 : d3;
        if (d7 > d2) {
            return false;
        }
        d3 = this.m10 - matrix4d.m10;
        double d8 = d3 < 0.0 ? -d3 : d3;
        if (d8 > d2) {
            return false;
        }
        d3 = this.m11 - matrix4d.m11;
        double d9 = d3 < 0.0 ? -d3 : d3;
        if (d9 > d2) {
            return false;
        }
        d3 = this.m12 - matrix4d.m12;
        double d10 = d3 < 0.0 ? -d3 : d3;
        if (d10 > d2) {
            return false;
        }
        d3 = this.m13 - matrix4d.m13;
        double d11 = d3 < 0.0 ? -d3 : d3;
        if (d11 > d2) {
            return false;
        }
        d3 = this.m20 - matrix4d.m20;
        double d12 = d3 < 0.0 ? -d3 : d3;
        if (d12 > d2) {
            return false;
        }
        d3 = this.m21 - matrix4d.m21;
        double d13 = d3 < 0.0 ? -d3 : d3;
        if (d13 > d2) {
            return false;
        }
        d3 = this.m22 - matrix4d.m22;
        double d14 = d3 < 0.0 ? -d3 : d3;
        if (d14 > d2) {
            return false;
        }
        d3 = this.m23 - matrix4d.m23;
        double d15 = d3 < 0.0 ? -d3 : d3;
        if (d15 > d2) {
            return false;
        }
        d3 = this.m30 - matrix4d.m30;
        double d16 = d3 < 0.0 ? -d3 : d3;
        if (d16 > d2) {
            return false;
        }
        d3 = this.m31 - matrix4d.m31;
        double d17 = d3 < 0.0 ? -d3 : d3;
        if (d17 > d2) {
            return false;
        }
        d3 = this.m32 - matrix4d.m32;
        double d18 = d3 < 0.0 ? -d3 : d3;
        if (d18 > d2) {
            return false;
        }
        d3 = this.m33 - matrix4d.m33;
        double d19 = d3 < 0.0 ? -d3 : d3;
        return !(d19 > d2);
    }

    public boolean epsilonEquals(Matrix4d matrix4d, float f2) {
        return this.epsilonEquals(matrix4d, (double)f2);
    }

    public boolean equals(Object object) {
        try {
            Matrix4d matrix4d = (Matrix4d)object;
            return this.m00 == matrix4d.m00 && this.m01 == matrix4d.m01 && this.m02 == matrix4d.m02 && this.m03 == matrix4d.m03 && this.m10 == matrix4d.m10 && this.m11 == matrix4d.m11 && this.m12 == matrix4d.m12 && this.m13 == matrix4d.m13 && this.m20 == matrix4d.m20 && this.m21 == matrix4d.m21 && this.m22 == matrix4d.m22 && this.m23 == matrix4d.m23 && this.m30 == matrix4d.m30 && this.m31 == matrix4d.m31 && this.m32 == matrix4d.m32 && this.m33 == matrix4d.m33;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(Matrix4d matrix4d) {
        try {
            return this.m00 == matrix4d.m00 && this.m01 == matrix4d.m01 && this.m02 == matrix4d.m02 && this.m03 == matrix4d.m03 && this.m10 == matrix4d.m10 && this.m11 == matrix4d.m11 && this.m12 == matrix4d.m12 && this.m13 == matrix4d.m13 && this.m20 == matrix4d.m20 && this.m21 == matrix4d.m21 && this.m22 == matrix4d.m22 && this.m23 == matrix4d.m23 && this.m30 == matrix4d.m30 && this.m31 == matrix4d.m31 && this.m32 == matrix4d.m32 && this.m33 == matrix4d.m33;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public final void get(Matrix3d matrix3d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3d.m00 = this.tmp_rot[0];
        matrix3d.m01 = this.tmp_rot[1];
        matrix3d.m02 = this.tmp_rot[2];
        matrix3d.m10 = this.tmp_rot[3];
        matrix3d.m11 = this.tmp_rot[4];
        matrix3d.m12 = this.tmp_rot[5];
        matrix3d.m20 = this.tmp_rot[6];
        matrix3d.m21 = this.tmp_rot[7];
        matrix3d.m22 = this.tmp_rot[8];
    }

    public final double get(Matrix3d matrix3d, Vector3d vector3d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3d.m00 = this.tmp_rot[0];
        matrix3d.m01 = this.tmp_rot[1];
        matrix3d.m02 = this.tmp_rot[2];
        matrix3d.m10 = this.tmp_rot[3];
        matrix3d.m11 = this.tmp_rot[4];
        matrix3d.m12 = this.tmp_rot[5];
        matrix3d.m20 = this.tmp_rot[6];
        matrix3d.m21 = this.tmp_rot[7];
        matrix3d.m22 = this.tmp_rot[8];
        vector3d.x = this.m03;
        vector3d.y = this.m13;
        vector3d.z = this.m23;
        return Matrix3d.max3(this.tmp_scale);
    }

    public final void get(Matrix3f matrix3f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3f.m00 = (float)this.tmp_rot[0];
        matrix3f.m01 = (float)this.tmp_rot[1];
        matrix3f.m02 = (float)this.tmp_rot[2];
        matrix3f.m10 = (float)this.tmp_rot[3];
        matrix3f.m11 = (float)this.tmp_rot[4];
        matrix3f.m12 = (float)this.tmp_rot[5];
        matrix3f.m20 = (float)this.tmp_rot[6];
        matrix3f.m21 = (float)this.tmp_rot[7];
        matrix3f.m22 = (float)this.tmp_rot[8];
    }

    public final double get(Matrix3f matrix3f, Vector3d vector3d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        matrix3f.m00 = (float)this.tmp_rot[0];
        matrix3f.m01 = (float)this.tmp_rot[1];
        matrix3f.m02 = (float)this.tmp_rot[2];
        matrix3f.m10 = (float)this.tmp_rot[3];
        matrix3f.m11 = (float)this.tmp_rot[4];
        matrix3f.m12 = (float)this.tmp_rot[5];
        matrix3f.m20 = (float)this.tmp_rot[6];
        matrix3f.m21 = (float)this.tmp_rot[7];
        matrix3f.m22 = (float)this.tmp_rot[8];
        vector3d.x = this.m03;
        vector3d.y = this.m13;
        vector3d.z = this.m23;
        return Matrix3d.max3(this.tmp_scale);
    }

    public final void get(Quat4d quat4d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        double d2 = 0.25 * (1.0 + this.tmp_rot[0] + this.tmp_rot[4] + this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4d.w = Math.sqrt(d2);
            d2 = 0.25 / quat4d.w;
            quat4d.x = (this.tmp_rot[7] - this.tmp_rot[5]) * d2;
            quat4d.y = (this.tmp_rot[2] - this.tmp_rot[6]) * d2;
            quat4d.z = (this.tmp_rot[3] - this.tmp_rot[1]) * d2;
            return;
        }
        quat4d.w = 0.0;
        d2 = -0.5 * (this.tmp_rot[4] + this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4d.x = Math.sqrt(d2);
            d2 = 0.5 / quat4d.x;
            quat4d.y = this.tmp_rot[3] * d2;
            quat4d.z = this.tmp_rot[6] * d2;
            return;
        }
        quat4d.x = 0.0;
        d2 = 0.5 * (1.0 - this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4d.y = Math.sqrt(d2);
            quat4d.z = this.tmp_rot[7] / (2.0 * quat4d.y);
            return;
        }
        quat4d.y = 0.0;
        quat4d.z = 1.0;
    }

    public final void get(Quat4f quat4f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        double d2 = 0.25 * (1.0 + this.tmp_rot[0] + this.tmp_rot[4] + this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4f.w = (float)Math.sqrt(d2);
            d2 = 0.25 / (double)quat4f.w;
            quat4f.x = (float)((this.tmp_rot[7] - this.tmp_rot[5]) * d2);
            quat4f.y = (float)((this.tmp_rot[2] - this.tmp_rot[6]) * d2);
            quat4f.z = (float)((this.tmp_rot[3] - this.tmp_rot[1]) * d2);
            return;
        }
        quat4f.w = 0.0f;
        d2 = -0.5 * (this.tmp_rot[4] + this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4f.x = (float)Math.sqrt(d2);
            d2 = 0.5 / (double)quat4f.x;
            quat4f.y = (float)(this.tmp_rot[3] * d2);
            quat4f.z = (float)(this.tmp_rot[6] * d2);
            return;
        }
        quat4f.x = 0.0f;
        d2 = 0.5 * (1.0 - this.tmp_rot[8]);
        if (!((d2 < 0.0 ? -d2 : d2) < 1.0E-30)) {
            quat4f.y = (float)Math.sqrt(d2);
            quat4f.z = (float)(this.tmp_rot[7] / (2.0 * (double)quat4f.y));
            return;
        }
        quat4f.y = 0.0f;
        quat4f.z = 1.0f;
    }

    public final void get(Vector3d vector3d) {
        vector3d.x = this.m03;
        vector3d.y = this.m13;
        vector3d.z = this.m23;
    }

    public final void getColumn(int n2, Vector4d vector4d) {
        if (n2 == 0) {
            vector4d.x = this.m00;
            vector4d.y = this.m10;
            vector4d.z = this.m20;
            vector4d.w = this.m30;
        } else if (n2 == 1) {
            vector4d.x = this.m01;
            vector4d.y = this.m11;
            vector4d.z = this.m21;
            vector4d.w = this.m31;
        } else if (n2 == 2) {
            vector4d.x = this.m02;
            vector4d.y = this.m12;
            vector4d.z = this.m22;
            vector4d.w = this.m32;
        } else if (n2 == 3) {
            vector4d.x = this.m03;
            vector4d.y = this.m13;
            vector4d.z = this.m23;
            vector4d.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d3"));
        }
    }

    public final void getColumn(int n2, double[] dArray) {
        if (n2 == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m10;
            dArray[2] = this.m20;
            dArray[3] = this.m30;
        } else if (n2 == 1) {
            dArray[0] = this.m01;
            dArray[1] = this.m11;
            dArray[2] = this.m21;
            dArray[3] = this.m31;
        } else if (n2 == 2) {
            dArray[0] = this.m02;
            dArray[1] = this.m12;
            dArray[2] = this.m22;
            dArray[3] = this.m32;
        } else if (n2 == 3) {
            dArray[0] = this.m03;
            dArray[1] = this.m13;
            dArray[2] = this.m23;
            dArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d3"));
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public final double getElement(int n2, int n3) {
        switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                    case 3: {
                        return this.m03;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d1"));
                    }
                }
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                    case 3: {
                        return this.m13;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d1"));
                    }
                }
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                    case 3: {
                        return this.m23;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d1"));
                    }
                }
            }
            case 3: {
                switch (n3) {
                    case 0: {
                        return this.m30;
                    }
                    case 1: {
                        return this.m31;
                    }
                    case 2: {
                        return this.m32;
                    }
                    case 3: {
                        return this.m33;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d1"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d1"));
            }
        }
    }

    public final void getRotationScale(Matrix3d matrix3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
    }

    public final void getRotationScale(Matrix3f matrix3f) {
        matrix3f.m00 = (float)this.m00;
        matrix3f.m01 = (float)this.m01;
        matrix3f.m02 = (float)this.m02;
        matrix3f.m10 = (float)this.m10;
        matrix3f.m11 = (float)this.m11;
        matrix3f.m12 = (float)this.m12;
        matrix3f.m20 = (float)this.m20;
        matrix3f.m21 = (float)this.m21;
        matrix3f.m22 = (float)this.m22;
    }

    public final void getRow(int n2, Vector4d vector4d) {
        if (n2 == 0) {
            vector4d.x = this.m00;
            vector4d.y = this.m01;
            vector4d.z = this.m02;
            vector4d.w = this.m03;
        } else if (n2 == 1) {
            vector4d.x = this.m10;
            vector4d.y = this.m11;
            vector4d.z = this.m12;
            vector4d.w = this.m13;
        } else if (n2 == 2) {
            vector4d.x = this.m20;
            vector4d.y = this.m21;
            vector4d.z = this.m22;
            vector4d.w = this.m23;
        } else if (n2 == 3) {
            vector4d.x = this.m30;
            vector4d.y = this.m31;
            vector4d.z = this.m32;
            vector4d.w = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d2"));
        }
    }

    public final void getRow(int n2, double[] dArray) {
        if (n2 == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m01;
            dArray[2] = this.m02;
            dArray[3] = this.m03;
        } else if (n2 == 1) {
            dArray[0] = this.m10;
            dArray[1] = this.m11;
            dArray[2] = this.m12;
            dArray[3] = this.m13;
        } else if (n2 == 2) {
            dArray[0] = this.m20;
            dArray[1] = this.m21;
            dArray[2] = this.m22;
            dArray[3] = this.m23;
        } else if (n2 == 3) {
            dArray[0] = this.m30;
            dArray[1] = this.m31;
            dArray[2] = this.m32;
            dArray[3] = this.m33;
        } else {
            throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d2"));
        }
    }

    public final double getScale() {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        return Matrix3d.max3(this.tmp_scale);
    }

    private final void getScaleRotate(double[] dArray, double[] dArray2) {
        this.tmp[0] = this.m00;
        this.tmp[1] = this.m01;
        this.tmp[2] = this.m02;
        this.tmp[3] = this.m10;
        this.tmp[4] = this.m11;
        this.tmp[5] = this.m12;
        this.tmp[6] = this.m20;
        this.tmp[7] = this.m21;
        this.tmp[8] = this.m22;
        Matrix3d.compute_svd(this.tmp, dArray, dArray2, false);
    }

    public int hashCode() {
        long l2 = 1L;
        l2 = 31L * l2 + Double.doubleToLongBits(this.m00);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m01);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m02);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m03);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m10);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m11);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m12);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m13);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m20);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m21);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m22);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m23);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m30);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m31);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m32);
        l2 = 31L * l2 + Double.doubleToLongBits(this.m33);
        return (int)(l2 ^ l2 >> 32);
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    public final void invert(Matrix4d matrix4d) {
        this.invertGeneral(matrix4d);
    }

    final void invertGeneral(Matrix4d matrix4d) {
        double[] dArray = new double[16];
        int[] nArray = new int[4];
        this.tmp[0] = matrix4d.m00;
        this.tmp[1] = matrix4d.m01;
        this.tmp[2] = matrix4d.m02;
        this.tmp[3] = matrix4d.m03;
        this.tmp[4] = matrix4d.m10;
        this.tmp[5] = matrix4d.m11;
        this.tmp[6] = matrix4d.m12;
        this.tmp[7] = matrix4d.m13;
        this.tmp[8] = matrix4d.m20;
        this.tmp[9] = matrix4d.m21;
        this.tmp[10] = matrix4d.m22;
        this.tmp[11] = matrix4d.m23;
        this.tmp[12] = matrix4d.m30;
        this.tmp[13] = matrix4d.m31;
        this.tmp[14] = matrix4d.m32;
        this.tmp[15] = matrix4d.m33;
        if (!Matrix4d.luDecomposition(this.tmp, nArray)) {
            throw new SingularMatrixException(VecMathI18N.getString("Matrix4d10"));
        }
        int n2 = 0;
        while (n2 < 16) {
            dArray[n2] = 0.0;
            ++n2;
        }
        dArray[0] = 1.0;
        dArray[5] = 1.0;
        dArray[10] = 1.0;
        dArray[15] = 1.0;
        Matrix4d.luBacksubstitution(this.tmp, nArray, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    static void luBacksubstitution(double[] dArray, int[] nArray, double[] dArray2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4;
            int n5 = n3;
            int n6 = -1;
            int n7 = 0;
            while (n7 < 4) {
                int n8 = nArray[n2 + n7];
                double d2 = dArray2[n5 + 4 * n8];
                dArray2[n5 + 4 * n8] = dArray2[n5 + 4 * n7];
                if (n6 >= 0) {
                    n4 = n7 * 4;
                    int n9 = n6;
                    while (n9 <= n7 - 1) {
                        d2 -= dArray[n4 + n9] * dArray2[n5 + 4 * n9];
                        ++n9;
                    }
                } else if (d2 != 0.0) {
                    n6 = n7;
                }
                dArray2[n5 + 4 * n7] = d2;
                ++n7;
            }
            n4 = 12;
            int n10 = n5 + 12;
            dArray2[n10] = dArray2[n10] / dArray[n4 + 3];
            dArray2[n5 + 8] = (dArray2[n5 + 8] - dArray[(n4 -= 4) + 3] * dArray2[n5 + 12]) / dArray[n4 + 2];
            dArray2[n5 + 4] = (dArray2[n5 + 4] - dArray[(n4 -= 4) + 2] * dArray2[n5 + 8] - dArray[n4 + 3] * dArray2[n5 + 12]) / dArray[n4 + 1];
            dArray2[n5] = (dArray2[n5] - dArray[(n4 -= 4) + 1] * dArray2[n5 + 4] - dArray[n4 + 2] * dArray2[n5 + 8] - dArray[n4 + 3] * dArray2[n5 + 12]) / dArray[n4];
            ++n3;
        }
    }

    static boolean luDecomposition(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        while (n4-- != 0) {
            double d2 = 0.0;
            int n5 = 4;
            while (n5-- != 0) {
                double d3 = dArray[n2++];
                if (!((d3 = Math.abs(d3)) > d2)) continue;
                d2 = d3;
            }
            if (d2 == 0.0) {
                return false;
            }
            dArray2[n3++] = 1.0 / d2;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < 4) {
            double d4;
            int n8;
            int n9;
            int n10;
            double d5;
            int n11;
            int n12 = 0;
            while (n12 < n7) {
                n11 = n6 + 4 * n12 + n7;
                d5 = dArray[n11];
                n10 = n12;
                n9 = n6 + 4 * n12;
                n8 = n6 + n7;
                while (n10-- != 0) {
                    d5 -= dArray[n9] * dArray[n8];
                    ++n9;
                    n8 += 4;
                }
                dArray[n11] = d5;
                ++n12;
            }
            double d6 = 0.0;
            int n13 = -1;
            n12 = n7;
            while (n12 < 4) {
                double d7;
                n11 = n6 + 4 * n12 + n7;
                d5 = dArray[n11];
                n10 = n7;
                n9 = n6 + 4 * n12;
                n8 = n6 + n7;
                while (n10-- != 0) {
                    d5 -= dArray[n9] * dArray[n8];
                    ++n9;
                    n8 += 4;
                }
                dArray[n11] = d5;
                d4 = dArray2[n12] * Math.abs(d5);
                if (d7 >= d6) {
                    d6 = d4;
                    n13 = n12;
                }
                ++n12;
            }
            if (n13 < 0) {
                throw new RuntimeException(VecMathI18N.getString("Matrix4d11"));
            }
            if (n7 != n13) {
                n10 = 4;
                n9 = n6 + 4 * n13;
                n8 = n6 + 4 * n7;
                while (n10-- != 0) {
                    d4 = dArray[n9];
                    dArray[n9++] = dArray[n8];
                    dArray[n8++] = d4;
                }
                dArray2[n13] = dArray2[n7];
            }
            nArray[n7] = n13;
            if (dArray[n6 + 4 * n7 + n7] == 0.0) {
                return false;
            }
            if (n7 != 3) {
                d4 = 1.0 / dArray[n6 + 4 * n7 + n7];
                n11 = n6 + 4 * (n7 + 1) + n7;
                n12 = 3 - n7;
                while (n12-- != 0) {
                    int n14 = n11;
                    dArray[n14] = dArray[n14] * d4;
                    n11 += 4;
                }
            }
            ++n7;
        }
        return true;
    }

    public final void mul(double d2) {
        this.m00 *= d2;
        this.m01 *= d2;
        this.m02 *= d2;
        this.m03 *= d2;
        this.m10 *= d2;
        this.m11 *= d2;
        this.m12 *= d2;
        this.m13 *= d2;
        this.m20 *= d2;
        this.m21 *= d2;
        this.m22 *= d2;
        this.m23 *= d2;
        this.m30 *= d2;
        this.m31 *= d2;
        this.m32 *= d2;
        this.m33 *= d2;
    }

    public final void mul(double d2, Matrix4d matrix4d) {
        this.m00 = matrix4d.m00 * d2;
        this.m01 = matrix4d.m01 * d2;
        this.m02 = matrix4d.m02 * d2;
        this.m03 = matrix4d.m03 * d2;
        this.m10 = matrix4d.m10 * d2;
        this.m11 = matrix4d.m11 * d2;
        this.m12 = matrix4d.m12 * d2;
        this.m13 = matrix4d.m13 * d2;
        this.m20 = matrix4d.m20 * d2;
        this.m21 = matrix4d.m21 * d2;
        this.m22 = matrix4d.m22 * d2;
        this.m23 = matrix4d.m23 * d2;
        this.m30 = matrix4d.m30 * d2;
        this.m31 = matrix4d.m31 * d2;
        this.m32 = matrix4d.m32 * d2;
        this.m33 = matrix4d.m33 * d2;
    }

    public final void mul(Matrix4d matrix4d) {
        double d2 = this.m00 * matrix4d.m00 + this.m01 * matrix4d.m10 + this.m02 * matrix4d.m20 + this.m03 * matrix4d.m30;
        double d3 = this.m00 * matrix4d.m01 + this.m01 * matrix4d.m11 + this.m02 * matrix4d.m21 + this.m03 * matrix4d.m31;
        double d4 = this.m00 * matrix4d.m02 + this.m01 * matrix4d.m12 + this.m02 * matrix4d.m22 + this.m03 * matrix4d.m32;
        double d5 = this.m00 * matrix4d.m03 + this.m01 * matrix4d.m13 + this.m02 * matrix4d.m23 + this.m03 * matrix4d.m33;
        double d6 = this.m10 * matrix4d.m00 + this.m11 * matrix4d.m10 + this.m12 * matrix4d.m20 + this.m13 * matrix4d.m30;
        double d7 = this.m10 * matrix4d.m01 + this.m11 * matrix4d.m11 + this.m12 * matrix4d.m21 + this.m13 * matrix4d.m31;
        double d8 = this.m10 * matrix4d.m02 + this.m11 * matrix4d.m12 + this.m12 * matrix4d.m22 + this.m13 * matrix4d.m32;
        double d9 = this.m10 * matrix4d.m03 + this.m11 * matrix4d.m13 + this.m12 * matrix4d.m23 + this.m13 * matrix4d.m33;
        double d10 = this.m20 * matrix4d.m00 + this.m21 * matrix4d.m10 + this.m22 * matrix4d.m20 + this.m23 * matrix4d.m30;
        double d11 = this.m20 * matrix4d.m01 + this.m21 * matrix4d.m11 + this.m22 * matrix4d.m21 + this.m23 * matrix4d.m31;
        double d12 = this.m20 * matrix4d.m02 + this.m21 * matrix4d.m12 + this.m22 * matrix4d.m22 + this.m23 * matrix4d.m32;
        double d13 = this.m20 * matrix4d.m03 + this.m21 * matrix4d.m13 + this.m22 * matrix4d.m23 + this.m23 * matrix4d.m33;
        double d14 = this.m30 * matrix4d.m00 + this.m31 * matrix4d.m10 + this.m32 * matrix4d.m20 + this.m33 * matrix4d.m30;
        double d15 = this.m30 * matrix4d.m01 + this.m31 * matrix4d.m11 + this.m32 * matrix4d.m21 + this.m33 * matrix4d.m31;
        double d16 = this.m30 * matrix4d.m02 + this.m31 * matrix4d.m12 + this.m32 * matrix4d.m22 + this.m33 * matrix4d.m32;
        double d17 = this.m30 * matrix4d.m03 + this.m31 * matrix4d.m13 + this.m32 * matrix4d.m23 + this.m33 * matrix4d.m33;
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m03 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.m12 = d8;
        this.m13 = d9;
        this.m20 = d10;
        this.m21 = d11;
        this.m22 = d12;
        this.m23 = d13;
        this.m30 = d14;
        this.m31 = d15;
        this.m32 = d16;
        this.m33 = d17;
    }

    public final void mul(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (this != matrix4d && this != matrix4d2) {
            this.m00 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m01 * matrix4d2.m10 + matrix4d.m02 * matrix4d2.m20 + matrix4d.m03 * matrix4d2.m30;
            this.m01 = matrix4d.m00 * matrix4d2.m01 + matrix4d.m01 * matrix4d2.m11 + matrix4d.m02 * matrix4d2.m21 + matrix4d.m03 * matrix4d2.m31;
            this.m02 = matrix4d.m00 * matrix4d2.m02 + matrix4d.m01 * matrix4d2.m12 + matrix4d.m02 * matrix4d2.m22 + matrix4d.m03 * matrix4d2.m32;
            this.m03 = matrix4d.m00 * matrix4d2.m03 + matrix4d.m01 * matrix4d2.m13 + matrix4d.m02 * matrix4d2.m23 + matrix4d.m03 * matrix4d2.m33;
            this.m10 = matrix4d.m10 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m10 + matrix4d.m12 * matrix4d2.m20 + matrix4d.m13 * matrix4d2.m30;
            this.m11 = matrix4d.m10 * matrix4d2.m01 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m12 * matrix4d2.m21 + matrix4d.m13 * matrix4d2.m31;
            this.m12 = matrix4d.m10 * matrix4d2.m02 + matrix4d.m11 * matrix4d2.m12 + matrix4d.m12 * matrix4d2.m22 + matrix4d.m13 * matrix4d2.m32;
            this.m13 = matrix4d.m10 * matrix4d2.m03 + matrix4d.m11 * matrix4d2.m13 + matrix4d.m12 * matrix4d2.m23 + matrix4d.m13 * matrix4d2.m33;
            this.m20 = matrix4d.m20 * matrix4d2.m00 + matrix4d.m21 * matrix4d2.m10 + matrix4d.m22 * matrix4d2.m20 + matrix4d.m23 * matrix4d2.m30;
            this.m21 = matrix4d.m20 * matrix4d2.m01 + matrix4d.m21 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m21 + matrix4d.m23 * matrix4d2.m31;
            this.m22 = matrix4d.m20 * matrix4d2.m02 + matrix4d.m21 * matrix4d2.m12 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m23 * matrix4d2.m32;
            this.m23 = matrix4d.m20 * matrix4d2.m03 + matrix4d.m21 * matrix4d2.m13 + matrix4d.m22 * matrix4d2.m23 + matrix4d.m23 * matrix4d2.m33;
            this.m30 = matrix4d.m30 * matrix4d2.m00 + matrix4d.m31 * matrix4d2.m10 + matrix4d.m32 * matrix4d2.m20 + matrix4d.m33 * matrix4d2.m30;
            this.m31 = matrix4d.m30 * matrix4d2.m01 + matrix4d.m31 * matrix4d2.m11 + matrix4d.m32 * matrix4d2.m21 + matrix4d.m33 * matrix4d2.m31;
            this.m32 = matrix4d.m30 * matrix4d2.m02 + matrix4d.m31 * matrix4d2.m12 + matrix4d.m32 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m32;
            this.m33 = matrix4d.m30 * matrix4d2.m03 + matrix4d.m31 * matrix4d2.m13 + matrix4d.m32 * matrix4d2.m23 + matrix4d.m33 * matrix4d2.m33;
        } else {
            double d2 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m01 * matrix4d2.m10 + matrix4d.m02 * matrix4d2.m20 + matrix4d.m03 * matrix4d2.m30;
            double d3 = matrix4d.m00 * matrix4d2.m01 + matrix4d.m01 * matrix4d2.m11 + matrix4d.m02 * matrix4d2.m21 + matrix4d.m03 * matrix4d2.m31;
            double d4 = matrix4d.m00 * matrix4d2.m02 + matrix4d.m01 * matrix4d2.m12 + matrix4d.m02 * matrix4d2.m22 + matrix4d.m03 * matrix4d2.m32;
            double d5 = matrix4d.m00 * matrix4d2.m03 + matrix4d.m01 * matrix4d2.m13 + matrix4d.m02 * matrix4d2.m23 + matrix4d.m03 * matrix4d2.m33;
            double d6 = matrix4d.m10 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m10 + matrix4d.m12 * matrix4d2.m20 + matrix4d.m13 * matrix4d2.m30;
            double d7 = matrix4d.m10 * matrix4d2.m01 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m12 * matrix4d2.m21 + matrix4d.m13 * matrix4d2.m31;
            double d8 = matrix4d.m10 * matrix4d2.m02 + matrix4d.m11 * matrix4d2.m12 + matrix4d.m12 * matrix4d2.m22 + matrix4d.m13 * matrix4d2.m32;
            double d9 = matrix4d.m10 * matrix4d2.m03 + matrix4d.m11 * matrix4d2.m13 + matrix4d.m12 * matrix4d2.m23 + matrix4d.m13 * matrix4d2.m33;
            double d10 = matrix4d.m20 * matrix4d2.m00 + matrix4d.m21 * matrix4d2.m10 + matrix4d.m22 * matrix4d2.m20 + matrix4d.m23 * matrix4d2.m30;
            double d11 = matrix4d.m20 * matrix4d2.m01 + matrix4d.m21 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m21 + matrix4d.m23 * matrix4d2.m31;
            double d12 = matrix4d.m20 * matrix4d2.m02 + matrix4d.m21 * matrix4d2.m12 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m23 * matrix4d2.m32;
            double d13 = matrix4d.m20 * matrix4d2.m03 + matrix4d.m21 * matrix4d2.m13 + matrix4d.m22 * matrix4d2.m23 + matrix4d.m23 * matrix4d2.m33;
            double d14 = matrix4d.m30 * matrix4d2.m00 + matrix4d.m31 * matrix4d2.m10 + matrix4d.m32 * matrix4d2.m20 + matrix4d.m33 * matrix4d2.m30;
            double d15 = matrix4d.m30 * matrix4d2.m01 + matrix4d.m31 * matrix4d2.m11 + matrix4d.m32 * matrix4d2.m21 + matrix4d.m33 * matrix4d2.m31;
            double d16 = matrix4d.m30 * matrix4d2.m02 + matrix4d.m31 * matrix4d2.m12 + matrix4d.m32 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m32;
            double d17 = matrix4d.m30 * matrix4d2.m03 + matrix4d.m31 * matrix4d2.m13 + matrix4d.m32 * matrix4d2.m23 + matrix4d.m33 * matrix4d2.m33;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m03 = d5;
            this.m10 = d6;
            this.m11 = d7;
            this.m12 = d8;
            this.m13 = d9;
            this.m20 = d10;
            this.m21 = d11;
            this.m22 = d12;
            this.m23 = d13;
            this.m30 = d14;
            this.m31 = d15;
            this.m32 = d16;
            this.m33 = d17;
        }
    }

    public final void mulTransposeBoth(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (this != matrix4d && this != matrix4d2) {
            this.m00 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m10 * matrix4d2.m01 + matrix4d.m20 * matrix4d2.m02 + matrix4d.m30 * matrix4d2.m03;
            this.m01 = matrix4d.m00 * matrix4d2.m10 + matrix4d.m10 * matrix4d2.m11 + matrix4d.m20 * matrix4d2.m12 + matrix4d.m30 * matrix4d2.m13;
            this.m02 = matrix4d.m00 * matrix4d2.m20 + matrix4d.m10 * matrix4d2.m21 + matrix4d.m20 * matrix4d2.m22 + matrix4d.m30 * matrix4d2.m23;
            this.m03 = matrix4d.m00 * matrix4d2.m30 + matrix4d.m10 * matrix4d2.m31 + matrix4d.m20 * matrix4d2.m32 + matrix4d.m30 * matrix4d2.m33;
            this.m10 = matrix4d.m01 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m01 + matrix4d.m21 * matrix4d2.m02 + matrix4d.m31 * matrix4d2.m03;
            this.m11 = matrix4d.m01 * matrix4d2.m10 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m21 * matrix4d2.m12 + matrix4d.m31 * matrix4d2.m13;
            this.m12 = matrix4d.m01 * matrix4d2.m20 + matrix4d.m11 * matrix4d2.m21 + matrix4d.m21 * matrix4d2.m22 + matrix4d.m31 * matrix4d2.m23;
            this.m13 = matrix4d.m01 * matrix4d2.m30 + matrix4d.m11 * matrix4d2.m31 + matrix4d.m21 * matrix4d2.m32 + matrix4d.m31 * matrix4d2.m33;
            this.m20 = matrix4d.m02 * matrix4d2.m00 + matrix4d.m12 * matrix4d2.m01 + matrix4d.m22 * matrix4d2.m02 + matrix4d.m32 * matrix4d2.m03;
            this.m21 = matrix4d.m02 * matrix4d2.m10 + matrix4d.m12 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m12 + matrix4d.m32 * matrix4d2.m13;
            this.m22 = matrix4d.m02 * matrix4d2.m20 + matrix4d.m12 * matrix4d2.m21 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m32 * matrix4d2.m23;
            this.m23 = matrix4d.m02 * matrix4d2.m30 + matrix4d.m12 * matrix4d2.m31 + matrix4d.m22 * matrix4d2.m32 + matrix4d.m32 * matrix4d2.m33;
            this.m30 = matrix4d.m03 * matrix4d2.m00 + matrix4d.m13 * matrix4d2.m01 + matrix4d.m23 * matrix4d2.m02 + matrix4d.m33 * matrix4d2.m03;
            this.m31 = matrix4d.m03 * matrix4d2.m10 + matrix4d.m13 * matrix4d2.m11 + matrix4d.m23 * matrix4d2.m12 + matrix4d.m33 * matrix4d2.m13;
            this.m32 = matrix4d.m03 * matrix4d2.m20 + matrix4d.m13 * matrix4d2.m21 + matrix4d.m23 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m23;
            this.m33 = matrix4d.m03 * matrix4d2.m30 + matrix4d.m13 * matrix4d2.m31 + matrix4d.m23 * matrix4d2.m32 + matrix4d.m33 * matrix4d2.m33;
        } else {
            double d2 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m10 * matrix4d2.m01 + matrix4d.m20 * matrix4d2.m02 + matrix4d.m30 * matrix4d2.m03;
            double d3 = matrix4d.m00 * matrix4d2.m10 + matrix4d.m10 * matrix4d2.m11 + matrix4d.m20 * matrix4d2.m12 + matrix4d.m30 * matrix4d2.m13;
            double d4 = matrix4d.m00 * matrix4d2.m20 + matrix4d.m10 * matrix4d2.m21 + matrix4d.m20 * matrix4d2.m22 + matrix4d.m30 * matrix4d2.m23;
            double d5 = matrix4d.m00 * matrix4d2.m30 + matrix4d.m10 * matrix4d2.m31 + matrix4d.m20 * matrix4d2.m32 + matrix4d.m30 * matrix4d2.m33;
            double d6 = matrix4d.m01 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m01 + matrix4d.m21 * matrix4d2.m02 + matrix4d.m31 * matrix4d2.m03;
            double d7 = matrix4d.m01 * matrix4d2.m10 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m21 * matrix4d2.m12 + matrix4d.m31 * matrix4d2.m13;
            double d8 = matrix4d.m01 * matrix4d2.m20 + matrix4d.m11 * matrix4d2.m21 + matrix4d.m21 * matrix4d2.m22 + matrix4d.m31 * matrix4d2.m23;
            double d9 = matrix4d.m01 * matrix4d2.m30 + matrix4d.m11 * matrix4d2.m31 + matrix4d.m21 * matrix4d2.m32 + matrix4d.m31 * matrix4d2.m33;
            double d10 = matrix4d.m02 * matrix4d2.m00 + matrix4d.m12 * matrix4d2.m01 + matrix4d.m22 * matrix4d2.m02 + matrix4d.m32 * matrix4d2.m03;
            double d11 = matrix4d.m02 * matrix4d2.m10 + matrix4d.m12 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m12 + matrix4d.m32 * matrix4d2.m13;
            double d12 = matrix4d.m02 * matrix4d2.m20 + matrix4d.m12 * matrix4d2.m21 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m32 * matrix4d2.m23;
            double d13 = matrix4d.m02 * matrix4d2.m30 + matrix4d.m12 * matrix4d2.m31 + matrix4d.m22 * matrix4d2.m32 + matrix4d.m32 * matrix4d2.m33;
            double d14 = matrix4d.m03 * matrix4d2.m00 + matrix4d.m13 * matrix4d2.m01 + matrix4d.m23 * matrix4d2.m02 + matrix4d.m33 * matrix4d2.m03;
            double d15 = matrix4d.m03 * matrix4d2.m10 + matrix4d.m13 * matrix4d2.m11 + matrix4d.m23 * matrix4d2.m12 + matrix4d.m33 * matrix4d2.m13;
            double d16 = matrix4d.m03 * matrix4d2.m20 + matrix4d.m13 * matrix4d2.m21 + matrix4d.m23 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m23;
            double d17 = matrix4d.m03 * matrix4d2.m30 + matrix4d.m13 * matrix4d2.m31 + matrix4d.m23 * matrix4d2.m32 + matrix4d.m33 * matrix4d2.m33;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m03 = d5;
            this.m10 = d6;
            this.m11 = d7;
            this.m12 = d8;
            this.m13 = d9;
            this.m20 = d10;
            this.m21 = d11;
            this.m22 = d12;
            this.m23 = d13;
            this.m30 = d14;
            this.m31 = d15;
            this.m32 = d16;
            this.m33 = d17;
        }
    }

    public final void mulTransposeLeft(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (this != matrix4d && this != matrix4d2) {
            this.m00 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m10 * matrix4d2.m10 + matrix4d.m20 * matrix4d2.m20 + matrix4d.m30 * matrix4d2.m30;
            this.m01 = matrix4d.m00 * matrix4d2.m01 + matrix4d.m10 * matrix4d2.m11 + matrix4d.m20 * matrix4d2.m21 + matrix4d.m30 * matrix4d2.m31;
            this.m02 = matrix4d.m00 * matrix4d2.m02 + matrix4d.m10 * matrix4d2.m12 + matrix4d.m20 * matrix4d2.m22 + matrix4d.m30 * matrix4d2.m32;
            this.m03 = matrix4d.m00 * matrix4d2.m03 + matrix4d.m10 * matrix4d2.m13 + matrix4d.m20 * matrix4d2.m23 + matrix4d.m30 * matrix4d2.m33;
            this.m10 = matrix4d.m01 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m10 + matrix4d.m21 * matrix4d2.m20 + matrix4d.m31 * matrix4d2.m30;
            this.m11 = matrix4d.m01 * matrix4d2.m01 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m21 * matrix4d2.m21 + matrix4d.m31 * matrix4d2.m31;
            this.m12 = matrix4d.m01 * matrix4d2.m02 + matrix4d.m11 * matrix4d2.m12 + matrix4d.m21 * matrix4d2.m22 + matrix4d.m31 * matrix4d2.m32;
            this.m13 = matrix4d.m01 * matrix4d2.m03 + matrix4d.m11 * matrix4d2.m13 + matrix4d.m21 * matrix4d2.m23 + matrix4d.m31 * matrix4d2.m33;
            this.m20 = matrix4d.m02 * matrix4d2.m00 + matrix4d.m12 * matrix4d2.m10 + matrix4d.m22 * matrix4d2.m20 + matrix4d.m32 * matrix4d2.m30;
            this.m21 = matrix4d.m02 * matrix4d2.m01 + matrix4d.m12 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m21 + matrix4d.m32 * matrix4d2.m31;
            this.m22 = matrix4d.m02 * matrix4d2.m02 + matrix4d.m12 * matrix4d2.m12 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m32 * matrix4d2.m32;
            this.m23 = matrix4d.m02 * matrix4d2.m03 + matrix4d.m12 * matrix4d2.m13 + matrix4d.m22 * matrix4d2.m23 + matrix4d.m32 * matrix4d2.m33;
            this.m30 = matrix4d.m03 * matrix4d2.m00 + matrix4d.m13 * matrix4d2.m10 + matrix4d.m23 * matrix4d2.m20 + matrix4d.m33 * matrix4d2.m30;
            this.m31 = matrix4d.m03 * matrix4d2.m01 + matrix4d.m13 * matrix4d2.m11 + matrix4d.m23 * matrix4d2.m21 + matrix4d.m33 * matrix4d2.m31;
            this.m32 = matrix4d.m03 * matrix4d2.m02 + matrix4d.m13 * matrix4d2.m12 + matrix4d.m23 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m32;
            this.m33 = matrix4d.m03 * matrix4d2.m03 + matrix4d.m13 * matrix4d2.m13 + matrix4d.m23 * matrix4d2.m23 + matrix4d.m33 * matrix4d2.m33;
        } else {
            double d2 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m10 * matrix4d2.m10 + matrix4d.m20 * matrix4d2.m20 + matrix4d.m30 * matrix4d2.m30;
            double d3 = matrix4d.m00 * matrix4d2.m01 + matrix4d.m10 * matrix4d2.m11 + matrix4d.m20 * matrix4d2.m21 + matrix4d.m30 * matrix4d2.m31;
            double d4 = matrix4d.m00 * matrix4d2.m02 + matrix4d.m10 * matrix4d2.m12 + matrix4d.m20 * matrix4d2.m22 + matrix4d.m30 * matrix4d2.m32;
            double d5 = matrix4d.m00 * matrix4d2.m03 + matrix4d.m10 * matrix4d2.m13 + matrix4d.m20 * matrix4d2.m23 + matrix4d.m30 * matrix4d2.m33;
            double d6 = matrix4d.m01 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m10 + matrix4d.m21 * matrix4d2.m20 + matrix4d.m31 * matrix4d2.m30;
            double d7 = matrix4d.m01 * matrix4d2.m01 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m21 * matrix4d2.m21 + matrix4d.m31 * matrix4d2.m31;
            double d8 = matrix4d.m01 * matrix4d2.m02 + matrix4d.m11 * matrix4d2.m12 + matrix4d.m21 * matrix4d2.m22 + matrix4d.m31 * matrix4d2.m32;
            double d9 = matrix4d.m01 * matrix4d2.m03 + matrix4d.m11 * matrix4d2.m13 + matrix4d.m21 * matrix4d2.m23 + matrix4d.m31 * matrix4d2.m33;
            double d10 = matrix4d.m02 * matrix4d2.m00 + matrix4d.m12 * matrix4d2.m10 + matrix4d.m22 * matrix4d2.m20 + matrix4d.m32 * matrix4d2.m30;
            double d11 = matrix4d.m02 * matrix4d2.m01 + matrix4d.m12 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m21 + matrix4d.m32 * matrix4d2.m31;
            double d12 = matrix4d.m02 * matrix4d2.m02 + matrix4d.m12 * matrix4d2.m12 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m32 * matrix4d2.m32;
            double d13 = matrix4d.m02 * matrix4d2.m03 + matrix4d.m12 * matrix4d2.m13 + matrix4d.m22 * matrix4d2.m23 + matrix4d.m32 * matrix4d2.m33;
            double d14 = matrix4d.m03 * matrix4d2.m00 + matrix4d.m13 * matrix4d2.m10 + matrix4d.m23 * matrix4d2.m20 + matrix4d.m33 * matrix4d2.m30;
            double d15 = matrix4d.m03 * matrix4d2.m01 + matrix4d.m13 * matrix4d2.m11 + matrix4d.m23 * matrix4d2.m21 + matrix4d.m33 * matrix4d2.m31;
            double d16 = matrix4d.m03 * matrix4d2.m02 + matrix4d.m13 * matrix4d2.m12 + matrix4d.m23 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m32;
            double d17 = matrix4d.m03 * matrix4d2.m03 + matrix4d.m13 * matrix4d2.m13 + matrix4d.m23 * matrix4d2.m23 + matrix4d.m33 * matrix4d2.m33;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m03 = d5;
            this.m10 = d6;
            this.m11 = d7;
            this.m12 = d8;
            this.m13 = d9;
            this.m20 = d10;
            this.m21 = d11;
            this.m22 = d12;
            this.m23 = d13;
            this.m30 = d14;
            this.m31 = d15;
            this.m32 = d16;
            this.m33 = d17;
        }
    }

    public final void mulTransposeRight(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (this != matrix4d && this != matrix4d2) {
            this.m00 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m01 * matrix4d2.m01 + matrix4d.m02 * matrix4d2.m02 + matrix4d.m03 * matrix4d2.m03;
            this.m01 = matrix4d.m00 * matrix4d2.m10 + matrix4d.m01 * matrix4d2.m11 + matrix4d.m02 * matrix4d2.m12 + matrix4d.m03 * matrix4d2.m13;
            this.m02 = matrix4d.m00 * matrix4d2.m20 + matrix4d.m01 * matrix4d2.m21 + matrix4d.m02 * matrix4d2.m22 + matrix4d.m03 * matrix4d2.m23;
            this.m03 = matrix4d.m00 * matrix4d2.m30 + matrix4d.m01 * matrix4d2.m31 + matrix4d.m02 * matrix4d2.m32 + matrix4d.m03 * matrix4d2.m33;
            this.m10 = matrix4d.m10 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m01 + matrix4d.m12 * matrix4d2.m02 + matrix4d.m13 * matrix4d2.m03;
            this.m11 = matrix4d.m10 * matrix4d2.m10 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m12 * matrix4d2.m12 + matrix4d.m13 * matrix4d2.m13;
            this.m12 = matrix4d.m10 * matrix4d2.m20 + matrix4d.m11 * matrix4d2.m21 + matrix4d.m12 * matrix4d2.m22 + matrix4d.m13 * matrix4d2.m23;
            this.m13 = matrix4d.m10 * matrix4d2.m30 + matrix4d.m11 * matrix4d2.m31 + matrix4d.m12 * matrix4d2.m32 + matrix4d.m13 * matrix4d2.m33;
            this.m20 = matrix4d.m20 * matrix4d2.m00 + matrix4d.m21 * matrix4d2.m01 + matrix4d.m22 * matrix4d2.m02 + matrix4d.m23 * matrix4d2.m03;
            this.m21 = matrix4d.m20 * matrix4d2.m10 + matrix4d.m21 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m12 + matrix4d.m23 * matrix4d2.m13;
            this.m22 = matrix4d.m20 * matrix4d2.m20 + matrix4d.m21 * matrix4d2.m21 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m23 * matrix4d2.m23;
            this.m23 = matrix4d.m20 * matrix4d2.m30 + matrix4d.m21 * matrix4d2.m31 + matrix4d.m22 * matrix4d2.m32 + matrix4d.m23 * matrix4d2.m33;
            this.m30 = matrix4d.m30 * matrix4d2.m00 + matrix4d.m31 * matrix4d2.m01 + matrix4d.m32 * matrix4d2.m02 + matrix4d.m33 * matrix4d2.m03;
            this.m31 = matrix4d.m30 * matrix4d2.m10 + matrix4d.m31 * matrix4d2.m11 + matrix4d.m32 * matrix4d2.m12 + matrix4d.m33 * matrix4d2.m13;
            this.m32 = matrix4d.m30 * matrix4d2.m20 + matrix4d.m31 * matrix4d2.m21 + matrix4d.m32 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m23;
            this.m33 = matrix4d.m30 * matrix4d2.m30 + matrix4d.m31 * matrix4d2.m31 + matrix4d.m32 * matrix4d2.m32 + matrix4d.m33 * matrix4d2.m33;
        } else {
            double d2 = matrix4d.m00 * matrix4d2.m00 + matrix4d.m01 * matrix4d2.m01 + matrix4d.m02 * matrix4d2.m02 + matrix4d.m03 * matrix4d2.m03;
            double d3 = matrix4d.m00 * matrix4d2.m10 + matrix4d.m01 * matrix4d2.m11 + matrix4d.m02 * matrix4d2.m12 + matrix4d.m03 * matrix4d2.m13;
            double d4 = matrix4d.m00 * matrix4d2.m20 + matrix4d.m01 * matrix4d2.m21 + matrix4d.m02 * matrix4d2.m22 + matrix4d.m03 * matrix4d2.m23;
            double d5 = matrix4d.m00 * matrix4d2.m30 + matrix4d.m01 * matrix4d2.m31 + matrix4d.m02 * matrix4d2.m32 + matrix4d.m03 * matrix4d2.m33;
            double d6 = matrix4d.m10 * matrix4d2.m00 + matrix4d.m11 * matrix4d2.m01 + matrix4d.m12 * matrix4d2.m02 + matrix4d.m13 * matrix4d2.m03;
            double d7 = matrix4d.m10 * matrix4d2.m10 + matrix4d.m11 * matrix4d2.m11 + matrix4d.m12 * matrix4d2.m12 + matrix4d.m13 * matrix4d2.m13;
            double d8 = matrix4d.m10 * matrix4d2.m20 + matrix4d.m11 * matrix4d2.m21 + matrix4d.m12 * matrix4d2.m22 + matrix4d.m13 * matrix4d2.m23;
            double d9 = matrix4d.m10 * matrix4d2.m30 + matrix4d.m11 * matrix4d2.m31 + matrix4d.m12 * matrix4d2.m32 + matrix4d.m13 * matrix4d2.m33;
            double d10 = matrix4d.m20 * matrix4d2.m00 + matrix4d.m21 * matrix4d2.m01 + matrix4d.m22 * matrix4d2.m02 + matrix4d.m23 * matrix4d2.m03;
            double d11 = matrix4d.m20 * matrix4d2.m10 + matrix4d.m21 * matrix4d2.m11 + matrix4d.m22 * matrix4d2.m12 + matrix4d.m23 * matrix4d2.m13;
            double d12 = matrix4d.m20 * matrix4d2.m20 + matrix4d.m21 * matrix4d2.m21 + matrix4d.m22 * matrix4d2.m22 + matrix4d.m23 * matrix4d2.m23;
            double d13 = matrix4d.m20 * matrix4d2.m30 + matrix4d.m21 * matrix4d2.m31 + matrix4d.m22 * matrix4d2.m32 + matrix4d.m23 * matrix4d2.m33;
            double d14 = matrix4d.m30 * matrix4d2.m00 + matrix4d.m31 * matrix4d2.m01 + matrix4d.m32 * matrix4d2.m02 + matrix4d.m33 * matrix4d2.m03;
            double d15 = matrix4d.m30 * matrix4d2.m10 + matrix4d.m31 * matrix4d2.m11 + matrix4d.m32 * matrix4d2.m12 + matrix4d.m33 * matrix4d2.m13;
            double d16 = matrix4d.m30 * matrix4d2.m20 + matrix4d.m31 * matrix4d2.m21 + matrix4d.m32 * matrix4d2.m22 + matrix4d.m33 * matrix4d2.m23;
            double d17 = matrix4d.m30 * matrix4d2.m30 + matrix4d.m31 * matrix4d2.m31 + matrix4d.m32 * matrix4d2.m32 + matrix4d.m33 * matrix4d2.m33;
            this.m00 = d2;
            this.m01 = d3;
            this.m02 = d4;
            this.m03 = d5;
            this.m10 = d6;
            this.m11 = d7;
            this.m12 = d8;
            this.m13 = d9;
            this.m20 = d10;
            this.m21 = d11;
            this.m22 = d12;
            this.m23 = d13;
            this.m30 = d14;
            this.m31 = d15;
            this.m32 = d16;
            this.m33 = d17;
        }
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
    }

    public final void negate(Matrix4d matrix4d) {
        this.m00 = -matrix4d.m00;
        this.m01 = -matrix4d.m01;
        this.m02 = -matrix4d.m02;
        this.m03 = -matrix4d.m03;
        this.m10 = -matrix4d.m10;
        this.m11 = -matrix4d.m11;
        this.m12 = -matrix4d.m12;
        this.m13 = -matrix4d.m13;
        this.m20 = -matrix4d.m20;
        this.m21 = -matrix4d.m21;
        this.m22 = -matrix4d.m22;
        this.m23 = -matrix4d.m23;
        this.m30 = -matrix4d.m30;
        this.m31 = -matrix4d.m31;
        this.m32 = -matrix4d.m32;
        this.m33 = -matrix4d.m33;
    }

    public final void rotX(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = d4;
        this.m12 = -d3;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = d3;
        this.m22 = d4;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void rotY(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cos(d2);
        this.m01 = 0.0;
        this.m02 = d4;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = -d4;
        this.m21 = 0.0;
        this.m22 = d3;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void rotZ(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cos(d2);
        this.m01 = -d4;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = d4;
        this.m11 = d3;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(double d2) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d2;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(double d2, Vector3d vector3d) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = vector3d.x;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m13 = vector3d.y;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d2;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(AxisAngle4d axisAngle4d) {
        double d2 = Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z);
        if (d2 < 1.0E-10) {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
        } else {
            d2 = 1.0 / d2;
            double d3 = axisAngle4d.x * d2;
            double d4 = axisAngle4d.y * d2;
            double d5 = axisAngle4d.z * d2;
            double d6 = Math.sin(axisAngle4d.angle);
            double d7 = Math.cos(axisAngle4d.angle);
            double d8 = 1.0 - d7;
            double d9 = d3 * d5;
            double d10 = d3 * d4;
            double d11 = d4 * d5;
            this.m00 = d8 * d3 * d3 + d7;
            this.m01 = d8 * d10 - d6 * d5;
            this.m02 = d8 * d9 + d6 * d4;
            this.m10 = d8 * d10 + d6 * d5;
            this.m11 = d8 * d4 * d4 + d7;
            this.m12 = d8 * d11 - d6 * d3;
            this.m20 = d8 * d9 - d6 * d4;
            this.m21 = d8 * d11 + d6 * d3;
            this.m22 = d8 * d5 * d5 + d7;
        }
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(AxisAngle4f axisAngle4f) {
        double d2 = Math.sqrt(axisAngle4f.x * axisAngle4f.x + axisAngle4f.y * axisAngle4f.y + axisAngle4f.z * axisAngle4f.z);
        if (d2 < 1.0E-10) {
            this.m00 = 1.0;
            this.m01 = 0.0;
            this.m02 = 0.0;
            this.m10 = 0.0;
            this.m11 = 1.0;
            this.m12 = 0.0;
            this.m20 = 0.0;
            this.m21 = 0.0;
            this.m22 = 1.0;
        } else {
            d2 = 1.0 / d2;
            double d3 = (double)axisAngle4f.x * d2;
            double d4 = (double)axisAngle4f.y * d2;
            double d5 = (double)axisAngle4f.z * d2;
            double d6 = Math.sin(axisAngle4f.angle);
            double d7 = Math.cos(axisAngle4f.angle);
            double d8 = 1.0 - d7;
            double d9 = d3 * d5;
            double d10 = d3 * d4;
            double d11 = d4 * d5;
            this.m00 = d8 * d3 * d3 + d7;
            this.m01 = d8 * d10 - d6 * d5;
            this.m02 = d8 * d9 + d6 * d4;
            this.m10 = d8 * d10 + d6 * d5;
            this.m11 = d8 * d4 * d4 + d7;
            this.m12 = d8 * d11 - d6 * d3;
            this.m20 = d8 * d9 - d6 * d4;
            this.m21 = d8 * d11 + d6 * d3;
            this.m22 = d8 * d5 * d5 + d7;
        }
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m03 = 0.0;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m13 = 0.0;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix3d matrix3d, Vector3d vector3d, double d2) {
        this.m00 = matrix3d.m00 * d2;
        this.m01 = matrix3d.m01 * d2;
        this.m02 = matrix3d.m02 * d2;
        this.m03 = vector3d.x;
        this.m10 = matrix3d.m10 * d2;
        this.m11 = matrix3d.m11 * d2;
        this.m12 = matrix3d.m12 * d2;
        this.m13 = vector3d.y;
        this.m20 = matrix3d.m20 * d2;
        this.m21 = matrix3d.m21 * d2;
        this.m22 = matrix3d.m22 * d2;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m03 = 0.0;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m13 = 0.0;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix3f matrix3f, Vector3f vector3f, float f2) {
        this.m00 = matrix3f.m00 * f2;
        this.m01 = matrix3f.m01 * f2;
        this.m02 = matrix3f.m02 * f2;
        this.m03 = vector3f.x;
        this.m10 = matrix3f.m10 * f2;
        this.m11 = matrix3f.m11 * f2;
        this.m12 = matrix3f.m12 * f2;
        this.m13 = vector3f.y;
        this.m20 = matrix3f.m20 * f2;
        this.m21 = matrix3f.m21 * f2;
        this.m22 = matrix3f.m22 * f2;
        this.m23 = vector3f.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Matrix4d matrix4d) {
        this.m00 = matrix4d.m00;
        this.m01 = matrix4d.m01;
        this.m02 = matrix4d.m02;
        this.m03 = matrix4d.m03;
        this.m10 = matrix4d.m10;
        this.m11 = matrix4d.m11;
        this.m12 = matrix4d.m12;
        this.m13 = matrix4d.m13;
        this.m20 = matrix4d.m20;
        this.m21 = matrix4d.m21;
        this.m22 = matrix4d.m22;
        this.m23 = matrix4d.m23;
        this.m30 = matrix4d.m30;
        this.m31 = matrix4d.m31;
        this.m32 = matrix4d.m32;
        this.m33 = matrix4d.m33;
    }

    public final void set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public final void set(Quat4d quat4d) {
        this.m00 = 1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z;
        this.m10 = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z);
        this.m20 = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y);
        this.m01 = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z);
        this.m11 = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z;
        this.m21 = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x);
        this.m02 = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y);
        this.m12 = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x);
        this.m22 = 1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y;
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Quat4d quat4d, Vector3d vector3d, double d2) {
        this.m00 = d2 * (1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z);
        this.m10 = d2 * (2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z));
        this.m20 = d2 * (2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y));
        this.m01 = d2 * (2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z));
        this.m11 = d2 * (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z);
        this.m21 = d2 * (2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x));
        this.m02 = d2 * (2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y));
        this.m12 = d2 * (2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x));
        this.m22 = d2 * (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y);
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Quat4f quat4f) {
        this.m00 = 1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z;
        this.m10 = 2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z);
        this.m20 = 2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y);
        this.m01 = 2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z);
        this.m11 = 1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z;
        this.m21 = 2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x);
        this.m02 = 2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y);
        this.m12 = 2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x);
        this.m22 = 1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y;
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Quat4f quat4f, Vector3d vector3d, double d2) {
        this.m00 = d2 * (1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z);
        this.m10 = d2 * (2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z));
        this.m20 = d2 * (2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y));
        this.m01 = d2 * (2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z));
        this.m11 = d2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z);
        this.m21 = d2 * (2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x));
        this.m02 = d2 * (2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y));
        this.m12 = d2 * (2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x));
        this.m22 = d2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y);
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Quat4f quat4f, Vector3f vector3f, float f2) {
        this.m00 = (double)f2 * (1.0 - 2.0 * (double)quat4f.y * (double)quat4f.y - 2.0 * (double)quat4f.z * (double)quat4f.z);
        this.m10 = (double)f2 * (2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z));
        this.m20 = (double)f2 * (2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y));
        this.m01 = (double)f2 * (2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z));
        this.m11 = (double)f2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.z * (double)quat4f.z);
        this.m21 = (double)f2 * (2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x));
        this.m02 = (double)f2 * (2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y));
        this.m12 = (double)f2 * (2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x));
        this.m22 = (double)f2 * (1.0 - 2.0 * (double)quat4f.x * (double)quat4f.x - 2.0 * (double)quat4f.y * (double)quat4f.y);
        this.m03 = vector3f.x;
        this.m13 = vector3f.y;
        this.m23 = vector3f.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Vector3d vector3d) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = vector3d.x;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = vector3d.y;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(Vector3d vector3d, double d2) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = d2 * vector3d.x;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m13 = d2 * vector3d.y;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d2;
        this.m23 = d2 * vector3d.z;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    public final void setColumn(int n2, double d2, double d3, double d4, double d5) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m10 = d3;
                this.m20 = d4;
                this.m30 = d5;
                break;
            }
            case 1: {
                this.m01 = d2;
                this.m11 = d3;
                this.m21 = d4;
                this.m31 = d5;
                break;
            }
            case 2: {
                this.m02 = d2;
                this.m12 = d3;
                this.m22 = d4;
                this.m32 = d5;
                break;
            }
            case 3: {
                this.m03 = d2;
                this.m13 = d3;
                this.m23 = d4;
                this.m33 = d5;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d7"));
            }
        }
    }

    public final void setColumn(int n2, Vector4d vector4d) {
        switch (n2) {
            case 0: {
                this.m00 = vector4d.x;
                this.m10 = vector4d.y;
                this.m20 = vector4d.z;
                this.m30 = vector4d.w;
                break;
            }
            case 1: {
                this.m01 = vector4d.x;
                this.m11 = vector4d.y;
                this.m21 = vector4d.z;
                this.m31 = vector4d.w;
                break;
            }
            case 2: {
                this.m02 = vector4d.x;
                this.m12 = vector4d.y;
                this.m22 = vector4d.z;
                this.m32 = vector4d.w;
                break;
            }
            case 3: {
                this.m03 = vector4d.x;
                this.m13 = vector4d.y;
                this.m23 = vector4d.z;
                this.m33 = vector4d.w;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d7"));
            }
        }
    }

    public final void setColumn(int n2, double[] dArray) {
        switch (n2) {
            case 0: {
                this.m00 = dArray[0];
                this.m10 = dArray[1];
                this.m20 = dArray[2];
                this.m30 = dArray[3];
                break;
            }
            case 1: {
                this.m01 = dArray[0];
                this.m11 = dArray[1];
                this.m21 = dArray[2];
                this.m31 = dArray[3];
                break;
            }
            case 2: {
                this.m02 = dArray[0];
                this.m12 = dArray[1];
                this.m22 = dArray[2];
                this.m32 = dArray[3];
                break;
            }
            case 3: {
                this.m03 = dArray[0];
                this.m13 = dArray[1];
                this.m23 = dArray[2];
                this.m33 = dArray[3];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d7"));
            }
        }
    }

    public final void setElement(int n2, int n3, double d2) {
        block0 : switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        this.m00 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m01 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m02 = d2;
                        break block0;
                    }
                    case 3: {
                        this.m03 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        this.m10 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m11 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m12 = d2;
                        break block0;
                    }
                    case 3: {
                        this.m13 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        this.m20 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m21 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m22 = d2;
                        break block0;
                    }
                    case 3: {
                        this.m23 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            case 3: {
                switch (n3) {
                    case 0: {
                        this.m30 = d2;
                        break block0;
                    }
                    case 1: {
                        this.m31 = d2;
                        break block0;
                    }
                    case 2: {
                        this.m32 = d2;
                        break block0;
                    }
                    case 3: {
                        this.m33 = d2;
                        break block0;
                    }
                }
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d0"));
            }
        }
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public final void setRotation(AxisAngle4d axisAngle4d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        double d2 = 1.0 / Math.sqrt(axisAngle4d.x * axisAngle4d.x + axisAngle4d.y * axisAngle4d.y + axisAngle4d.z * axisAngle4d.z);
        double d3 = axisAngle4d.x * d2;
        double d4 = axisAngle4d.y * d2;
        double d5 = axisAngle4d.z * d2;
        double d6 = Math.sin(axisAngle4d.angle);
        double d7 = Math.cos(axisAngle4d.angle);
        double d8 = 1.0 - d7;
        double d9 = axisAngle4d.x * axisAngle4d.z;
        double d10 = axisAngle4d.x * axisAngle4d.y;
        double d11 = axisAngle4d.y * axisAngle4d.z;
        this.m00 = (d8 * d3 * d3 + d7) * this.tmp_scale[0];
        this.m01 = (d8 * d10 - d6 * d5) * this.tmp_scale[1];
        this.m02 = (d8 * d9 + d6 * d4) * this.tmp_scale[2];
        this.m10 = (d8 * d10 + d6 * d5) * this.tmp_scale[0];
        this.m11 = (d8 * d4 * d4 + d7) * this.tmp_scale[1];
        this.m12 = (d8 * d11 - d6 * d3) * this.tmp_scale[2];
        this.m20 = (d8 * d9 - d6 * d4) * this.tmp_scale[0];
        this.m21 = (d8 * d11 + d6 * d3) * this.tmp_scale[1];
        this.m22 = (d8 * d5 * d5 + d7) * this.tmp_scale[2];
    }

    public final void setRotation(Matrix3d matrix3d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = matrix3d.m00 * this.tmp_scale[0];
        this.m01 = matrix3d.m01 * this.tmp_scale[1];
        this.m02 = matrix3d.m02 * this.tmp_scale[2];
        this.m10 = matrix3d.m10 * this.tmp_scale[0];
        this.m11 = matrix3d.m11 * this.tmp_scale[1];
        this.m12 = matrix3d.m12 * this.tmp_scale[2];
        this.m20 = matrix3d.m20 * this.tmp_scale[0];
        this.m21 = matrix3d.m21 * this.tmp_scale[1];
        this.m22 = matrix3d.m22 * this.tmp_scale[2];
    }

    public final void setRotation(Matrix3f matrix3f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (double)matrix3f.m00 * this.tmp_scale[0];
        this.m01 = (double)matrix3f.m01 * this.tmp_scale[1];
        this.m02 = (double)matrix3f.m02 * this.tmp_scale[2];
        this.m10 = (double)matrix3f.m10 * this.tmp_scale[0];
        this.m11 = (double)matrix3f.m11 * this.tmp_scale[1];
        this.m12 = (double)matrix3f.m12 * this.tmp_scale[2];
        this.m20 = (double)matrix3f.m20 * this.tmp_scale[0];
        this.m21 = (double)matrix3f.m21 * this.tmp_scale[1];
        this.m22 = (double)matrix3f.m22 * this.tmp_scale[2];
    }

    public final void setRotation(Quat4d quat4d) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (1.0 - 2.0 * quat4d.y * quat4d.y - 2.0 * quat4d.z * quat4d.z) * this.tmp_scale[0];
        this.m10 = 2.0 * (quat4d.x * quat4d.y + quat4d.w * quat4d.z) * this.tmp_scale[0];
        this.m20 = 2.0 * (quat4d.x * quat4d.z - quat4d.w * quat4d.y) * this.tmp_scale[0];
        this.m01 = 2.0 * (quat4d.x * quat4d.y - quat4d.w * quat4d.z) * this.tmp_scale[1];
        this.m11 = (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.z * quat4d.z) * this.tmp_scale[1];
        this.m21 = 2.0 * (quat4d.y * quat4d.z + quat4d.w * quat4d.x) * this.tmp_scale[1];
        this.m02 = 2.0 * (quat4d.x * quat4d.z + quat4d.w * quat4d.y) * this.tmp_scale[2];
        this.m12 = 2.0 * (quat4d.y * quat4d.z - quat4d.w * quat4d.x) * this.tmp_scale[2];
        this.m22 = (1.0 - 2.0 * quat4d.x * quat4d.x - 2.0 * quat4d.y * quat4d.y) * this.tmp_scale[2];
    }

    public final void setRotation(Quat4f quat4f) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = (1.0 - (double)(2.0f * quat4f.y * quat4f.y) - (double)(2.0f * quat4f.z * quat4f.z)) * this.tmp_scale[0];
        this.m10 = 2.0 * (double)(quat4f.x * quat4f.y + quat4f.w * quat4f.z) * this.tmp_scale[0];
        this.m20 = 2.0 * (double)(quat4f.x * quat4f.z - quat4f.w * quat4f.y) * this.tmp_scale[0];
        this.m01 = 2.0 * (double)(quat4f.x * quat4f.y - quat4f.w * quat4f.z) * this.tmp_scale[1];
        this.m11 = (1.0 - (double)(2.0f * quat4f.x * quat4f.x) - (double)(2.0f * quat4f.z * quat4f.z)) * this.tmp_scale[1];
        this.m21 = 2.0 * (double)(quat4f.y * quat4f.z + quat4f.w * quat4f.x) * this.tmp_scale[1];
        this.m02 = 2.0 * (double)(quat4f.x * quat4f.z + quat4f.w * quat4f.y) * this.tmp_scale[2];
        this.m12 = 2.0 * (double)(quat4f.y * quat4f.z - quat4f.w * quat4f.x) * this.tmp_scale[2];
        this.m22 = (1.0 - (double)(2.0f * quat4f.x * quat4f.x) - (double)(2.0f * quat4f.y * quat4f.y)) * this.tmp_scale[2];
    }

    public final void setRotationScale(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public final void setRotationScale(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void setRow(int n2, double d2, double d3, double d4, double d5) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m01 = d3;
                this.m02 = d4;
                this.m03 = d5;
                break;
            }
            case 1: {
                this.m10 = d2;
                this.m11 = d3;
                this.m12 = d4;
                this.m13 = d5;
                break;
            }
            case 2: {
                this.m20 = d2;
                this.m21 = d3;
                this.m22 = d4;
                this.m23 = d5;
                break;
            }
            case 3: {
                this.m30 = d2;
                this.m31 = d3;
                this.m32 = d4;
                this.m33 = d5;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d4"));
            }
        }
    }

    public final void setRow(int n2, Vector4d vector4d) {
        switch (n2) {
            case 0: {
                this.m00 = vector4d.x;
                this.m01 = vector4d.y;
                this.m02 = vector4d.z;
                this.m03 = vector4d.w;
                break;
            }
            case 1: {
                this.m10 = vector4d.x;
                this.m11 = vector4d.y;
                this.m12 = vector4d.z;
                this.m13 = vector4d.w;
                break;
            }
            case 2: {
                this.m20 = vector4d.x;
                this.m21 = vector4d.y;
                this.m22 = vector4d.z;
                this.m23 = vector4d.w;
                break;
            }
            case 3: {
                this.m30 = vector4d.x;
                this.m31 = vector4d.y;
                this.m32 = vector4d.z;
                this.m33 = vector4d.w;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d4"));
            }
        }
    }

    public final void setRow(int n2, double[] dArray) {
        switch (n2) {
            case 0: {
                this.m00 = dArray[0];
                this.m01 = dArray[1];
                this.m02 = dArray[2];
                this.m03 = dArray[3];
                break;
            }
            case 1: {
                this.m10 = dArray[0];
                this.m11 = dArray[1];
                this.m12 = dArray[2];
                this.m13 = dArray[3];
                break;
            }
            case 2: {
                this.m20 = dArray[0];
                this.m21 = dArray[1];
                this.m22 = dArray[2];
                this.m23 = dArray[3];
                break;
            }
            case 3: {
                this.m30 = dArray[0];
                this.m31 = dArray[1];
                this.m32 = dArray[2];
                this.m33 = dArray[3];
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(VecMathI18N.getString("Matrix4d4"));
            }
        }
    }

    public final void setScale(double d2) {
        this.getScaleRotate(this.tmp_scale, this.tmp_rot);
        this.m00 = this.tmp_rot[0] * d2;
        this.m01 = this.tmp_rot[1] * d2;
        this.m02 = this.tmp_rot[2] * d2;
        this.m10 = this.tmp_rot[3] * d2;
        this.m11 = this.tmp_rot[4] * d2;
        this.m12 = this.tmp_rot[5] * d2;
        this.m20 = this.tmp_rot[6] * d2;
        this.m21 = this.tmp_rot[7] * d2;
        this.m22 = this.tmp_rot[8] * d2;
    }

    public final void setTranslation(Vector3d vector3d) {
        this.m03 = vector3d.x;
        this.m13 = vector3d.y;
        this.m23 = vector3d.z;
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public final void sub(Matrix4d matrix4d) {
        this.m00 -= matrix4d.m00;
        this.m01 -= matrix4d.m01;
        this.m02 -= matrix4d.m02;
        this.m03 -= matrix4d.m03;
        this.m10 -= matrix4d.m10;
        this.m11 -= matrix4d.m11;
        this.m12 -= matrix4d.m12;
        this.m13 -= matrix4d.m13;
        this.m20 -= matrix4d.m20;
        this.m21 -= matrix4d.m21;
        this.m22 -= matrix4d.m22;
        this.m23 -= matrix4d.m23;
        this.m30 -= matrix4d.m30;
        this.m31 -= matrix4d.m31;
        this.m32 -= matrix4d.m32;
        this.m33 -= matrix4d.m33;
    }

    public final void sub(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.m00 = matrix4d.m00 - matrix4d2.m00;
        this.m01 = matrix4d.m01 - matrix4d2.m01;
        this.m02 = matrix4d.m02 - matrix4d2.m02;
        this.m03 = matrix4d.m03 - matrix4d2.m03;
        this.m10 = matrix4d.m10 - matrix4d2.m10;
        this.m11 = matrix4d.m11 - matrix4d2.m11;
        this.m12 = matrix4d.m12 - matrix4d2.m12;
        this.m13 = matrix4d.m13 - matrix4d2.m13;
        this.m20 = matrix4d.m20 - matrix4d2.m20;
        this.m21 = matrix4d.m21 - matrix4d2.m21;
        this.m22 = matrix4d.m22 - matrix4d2.m22;
        this.m23 = matrix4d.m23 - matrix4d2.m23;
        this.m30 = matrix4d.m30 - matrix4d2.m30;
        this.m31 = matrix4d.m31 - matrix4d2.m31;
        this.m32 = matrix4d.m32 - matrix4d2.m32;
        this.m33 = matrix4d.m33 - matrix4d2.m33;
    }

    public String toString() {
        return String.valueOf(this.m00) + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n" + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33 + "\n";
    }

    public final void transform(Point3d point3d) {
        double d2 = this.m00 * point3d.x + this.m01 * point3d.y + this.m02 * point3d.z + this.m03;
        double d3 = this.m10 * point3d.x + this.m11 * point3d.y + this.m12 * point3d.z + this.m13;
        point3d.z = this.m20 * point3d.x + this.m21 * point3d.y + this.m22 * point3d.z + this.m23;
        point3d.x = d2;
        point3d.y = d3;
    }

    public final void transform(Point3d point3d, Point3d point3d2) {
        double d2 = this.m00 * point3d.x + this.m01 * point3d.y + this.m02 * point3d.z + this.m03;
        double d3 = this.m10 * point3d.x + this.m11 * point3d.y + this.m12 * point3d.z + this.m13;
        point3d2.z = this.m20 * point3d.x + this.m21 * point3d.y + this.m22 * point3d.z + this.m23;
        point3d2.x = d2;
        point3d2.y = d3;
    }

    public final void transform(Point3f point3f) {
        float f2 = (float)(this.m00 * (double)point3f.x + this.m01 * (double)point3f.y + this.m02 * (double)point3f.z + this.m03);
        float f3 = (float)(this.m10 * (double)point3f.x + this.m11 * (double)point3f.y + this.m12 * (double)point3f.z + this.m13);
        point3f.z = (float)(this.m20 * (double)point3f.x + this.m21 * (double)point3f.y + this.m22 * (double)point3f.z + this.m23);
        point3f.x = f2;
        point3f.y = f3;
    }

    public final void transform(Point3f point3f, Point3f point3f2) {
        float f2 = (float)(this.m00 * (double)point3f.x + this.m01 * (double)point3f.y + this.m02 * (double)point3f.z + this.m03);
        float f3 = (float)(this.m10 * (double)point3f.x + this.m11 * (double)point3f.y + this.m12 * (double)point3f.z + this.m13);
        point3f2.z = (float)(this.m20 * (double)point3f.x + this.m21 * (double)point3f.y + this.m22 * (double)point3f.z + this.m23);
        point3f2.x = f2;
        point3f2.y = f3;
    }

    public final void transform(Tuple4d tuple4d) {
        double d2 = this.m00 * tuple4d.x + this.m01 * tuple4d.y + this.m02 * tuple4d.z + this.m03 * tuple4d.w;
        double d3 = this.m10 * tuple4d.x + this.m11 * tuple4d.y + this.m12 * tuple4d.z + this.m13 * tuple4d.w;
        double d4 = this.m20 * tuple4d.x + this.m21 * tuple4d.y + this.m22 * tuple4d.z + this.m23 * tuple4d.w;
        tuple4d.w = this.m30 * tuple4d.x + this.m31 * tuple4d.y + this.m32 * tuple4d.z + this.m33 * tuple4d.w;
        tuple4d.x = d2;
        tuple4d.y = d3;
        tuple4d.z = d4;
    }

    public final void transform(Tuple4d tuple4d, Tuple4d tuple4d2) {
        double d2 = this.m00 * tuple4d.x + this.m01 * tuple4d.y + this.m02 * tuple4d.z + this.m03 * tuple4d.w;
        double d3 = this.m10 * tuple4d.x + this.m11 * tuple4d.y + this.m12 * tuple4d.z + this.m13 * tuple4d.w;
        double d4 = this.m20 * tuple4d.x + this.m21 * tuple4d.y + this.m22 * tuple4d.z + this.m23 * tuple4d.w;
        tuple4d2.w = this.m30 * tuple4d.x + this.m31 * tuple4d.y + this.m32 * tuple4d.z + this.m33 * tuple4d.w;
        tuple4d2.x = d2;
        tuple4d2.y = d3;
        tuple4d2.z = d4;
    }

    public final void transform(Tuple4f tuple4f) {
        float f2 = (float)(this.m00 * (double)tuple4f.x + this.m01 * (double)tuple4f.y + this.m02 * (double)tuple4f.z + this.m03 * (double)tuple4f.w);
        float f3 = (float)(this.m10 * (double)tuple4f.x + this.m11 * (double)tuple4f.y + this.m12 * (double)tuple4f.z + this.m13 * (double)tuple4f.w);
        float f4 = (float)(this.m20 * (double)tuple4f.x + this.m21 * (double)tuple4f.y + this.m22 * (double)tuple4f.z + this.m23 * (double)tuple4f.w);
        tuple4f.w = (float)(this.m30 * (double)tuple4f.x + this.m31 * (double)tuple4f.y + this.m32 * (double)tuple4f.z + this.m33 * (double)tuple4f.w);
        tuple4f.x = f2;
        tuple4f.y = f3;
        tuple4f.z = f4;
    }

    public final void transform(Tuple4f tuple4f, Tuple4f tuple4f2) {
        float f2 = (float)(this.m00 * (double)tuple4f.x + this.m01 * (double)tuple4f.y + this.m02 * (double)tuple4f.z + this.m03 * (double)tuple4f.w);
        float f3 = (float)(this.m10 * (double)tuple4f.x + this.m11 * (double)tuple4f.y + this.m12 * (double)tuple4f.z + this.m13 * (double)tuple4f.w);
        float f4 = (float)(this.m20 * (double)tuple4f.x + this.m21 * (double)tuple4f.y + this.m22 * (double)tuple4f.z + this.m23 * (double)tuple4f.w);
        tuple4f2.w = (float)(this.m30 * (double)tuple4f.x + this.m31 * (double)tuple4f.y + this.m32 * (double)tuple4f.z + this.m33 * (double)tuple4f.w);
        tuple4f2.x = f2;
        tuple4f2.y = f3;
        tuple4f2.z = f4;
    }

    public final void transform(Vector3d vector3d) {
        double d2 = this.m00 * vector3d.x + this.m01 * vector3d.y + this.m02 * vector3d.z;
        double d3 = this.m10 * vector3d.x + this.m11 * vector3d.y + this.m12 * vector3d.z;
        vector3d.z = this.m20 * vector3d.x + this.m21 * vector3d.y + this.m22 * vector3d.z;
        vector3d.x = d2;
        vector3d.y = d3;
    }

    public final void transform(Vector3d vector3d, Vector3d vector3d2) {
        double d2 = this.m00 * vector3d.x + this.m01 * vector3d.y + this.m02 * vector3d.z;
        double d3 = this.m10 * vector3d.x + this.m11 * vector3d.y + this.m12 * vector3d.z;
        vector3d2.z = this.m20 * vector3d.x + this.m21 * vector3d.y + this.m22 * vector3d.z;
        vector3d2.x = d2;
        vector3d2.y = d3;
    }

    public final void transform(Vector3f vector3f) {
        float f2 = (float)(this.m00 * (double)vector3f.x + this.m01 * (double)vector3f.y + this.m02 * (double)vector3f.z);
        float f3 = (float)(this.m10 * (double)vector3f.x + this.m11 * (double)vector3f.y + this.m12 * (double)vector3f.z);
        vector3f.z = (float)(this.m20 * (double)vector3f.x + this.m21 * (double)vector3f.y + this.m22 * (double)vector3f.z);
        vector3f.x = f2;
        vector3f.y = f3;
    }

    public final void transform(Vector3f vector3f, Vector3f vector3f2) {
        float f2 = (float)(this.m00 * (double)vector3f.x + this.m01 * (double)vector3f.y + this.m02 * (double)vector3f.z);
        float f3 = (float)(this.m10 * (double)vector3f.x + this.m11 * (double)vector3f.y + this.m12 * (double)vector3f.z);
        vector3f2.z = (float)(this.m20 * (double)vector3f.x + this.m21 * (double)vector3f.y + this.m22 * (double)vector3f.z);
        vector3f2.x = f2;
        vector3f2.y = f3;
    }

    public final void transpose() {
        double d2 = this.m10;
        this.m10 = this.m01;
        this.m01 = d2;
        d2 = this.m20;
        this.m20 = this.m02;
        this.m02 = d2;
        d2 = this.m30;
        this.m30 = this.m03;
        this.m03 = d2;
        d2 = this.m21;
        this.m21 = this.m12;
        this.m12 = d2;
        d2 = this.m31;
        this.m31 = this.m13;
        this.m13 = d2;
        d2 = this.m32;
        this.m32 = this.m23;
        this.m23 = d2;
    }

    public final void transpose(Matrix4d matrix4d) {
        if (this != matrix4d) {
            this.m00 = matrix4d.m00;
            this.m01 = matrix4d.m10;
            this.m02 = matrix4d.m20;
            this.m03 = matrix4d.m30;
            this.m10 = matrix4d.m01;
            this.m11 = matrix4d.m11;
            this.m12 = matrix4d.m21;
            this.m13 = matrix4d.m31;
            this.m20 = matrix4d.m02;
            this.m21 = matrix4d.m12;
            this.m22 = matrix4d.m22;
            this.m23 = matrix4d.m32;
            this.m30 = matrix4d.m03;
            this.m31 = matrix4d.m13;
            this.m32 = matrix4d.m23;
            this.m33 = matrix4d.m33;
        } else {
            this.transpose();
        }
    }
}

