/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class BasicCursorFactory {
    private static Cursor onItemCursor;
    private static BasicCursorFactory theFactory;
    private static final boolean debug = false;

    public static Cursor getOnItemCursor() {
        BasicCursorFactory.debug("getOnItemCursor");
        if (theFactory == null) {
            theFactory = new BasicCursorFactory();
        }
        if (onItemCursor == null) {
            onItemCursor = theFactory.createCursor("OnItemCursor");
        }
        return onItemCursor;
    }

    private Cursor createCursor(String string) {
        int n2;
        Object object;
        Object object2;
        String string2 = null;
        String string3 = null;
        BasicCursorFactory.debug("CreateCursor for " + string);
        InputStream inputStream = this.getClass().getResourceAsStream("images/" + string + ".properties");
        if (inputStream == null) {
            BasicCursorFactory.debug(this.getClass().getName() + "/" + "images/" + string + ".properties" + " not found.");
            return null;
        }
        try {
            object2 = new PropertyResourceBundle(inputStream);
            string2 = ((ResourceBundle)object2).getString("Cursor.File");
            string3 = ((ResourceBundle)object2).getString("Cursor.HotSpot");
        }
        catch (MissingResourceException missingResourceException) {
            BasicCursorFactory.debug(this.getClass().getName() + "/" + "images/" + string + ".properties" + " invalid.");
            return null;
        }
        catch (IOException iOException) {
            BasicCursorFactory.debug(this.getClass().getName() + "/" + "images/" + string + ".properties" + " invalid.");
            return null;
        }
        object2 = null;
        try {
            InputStream inputStream2 = this.getClass().getResourceAsStream(string2);
            if (inputStream2 == null) {
                BasicCursorFactory.debug(this.getClass().getName() + "/" + string2 + " not found.");
                return null;
            }
            object = new BufferedInputStream(inputStream2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            object2 = new byte[1024];
            while ((n2 = ((FilterInputStream)object).read((byte[])object2)) > 0) {
                byteArrayOutputStream.write((byte[])object2, 0, n2);
            }
            ((BufferedInputStream)object).close();
            byteArrayOutputStream.flush();
            object2 = byteArrayOutputStream.toByteArray();
            if (((Object)object2).length == 0) {
                BasicCursorFactory.debug("warning: " + string2 + " is zero-length");
                return null;
            }
        }
        catch (IOException iOException) {
            BasicCursorFactory.debug(iOException.toString());
            return null;
        }
        ImageIcon imageIcon = new ImageIcon((byte[])object2);
        int n3 = string3.indexOf(44);
        Point point = new Point(Integer.parseInt(string3.substring(0, n3)), Integer.parseInt(string3.substring(n3 + 1)));
        BasicCursorFactory.debug("Toolkit fetching cursor");
        try {
            object = imageIcon.getImage();
            int n4 = imageIcon.getIconWidth();
            n2 = imageIcon.getIconHeight();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getBestCursorSize(n4, n2);
            if (dimension.width > n4 || dimension.height > n2) {
                try {
                    BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
                    ((Image)bufferedImage).getGraphics().drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
                    object = bufferedImage;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return toolkit.createCustomCursor((Image)object, point, string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }

    private static void debug(String string) {
    }
}

