/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.EventListenerList;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelEvent;
import javax.help.event.TextHelpModelListener;

public class DefaultHelpModel
implements TextHelpModel,
Serializable {
    private HelpSet helpset;
    private Map.ID currentID;
    private URL currentURL;
    private String navID;
    private Vector highlights = new Vector();
    private String title;
    protected EventListenerList listenerList = new EventListenerList();
    protected EventListenerList textListenerList = new EventListenerList();
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$event$HelpModelListener;
    static /* synthetic */ Class class$javax$help$event$TextHelpModelListener;

    public DefaultHelpModel(HelpSet helpSet) {
        this.helpset = helpSet;
    }

    public void setHelpSet(HelpSet helpSet) {
        HelpSet helpSet2 = this.helpset;
        this.helpset = helpSet;
        this.changes.firePropertyChange("helpSet", helpSet2, helpSet);
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        if (iD == null) {
            iD = this.helpset.getHomeID();
        }
        if (iD == null || iD.equals(this.currentID)) {
            return;
        }
        String string = iD.id;
        HelpSet helpSet = iD.hs;
        if (!this.helpset.contains(helpSet)) {
            throw new InvalidHelpSetContextException("Wrong context", this.helpset, helpSet);
        }
        Map map = this.helpset.getCombinedMap();
        this.currentID = iD;
        try {
            Object object;
            URL uRL;
            Map.ID iD2 = iD;
            if (helpSet == this.helpset) {
                uRL = map.getURLFromID(iD);
            } else {
                object = helpSet.getLocalMap();
                uRL = object.getURLFromID(iD);
            }
            if (this.currentURL != null && this.currentURL.equals(uRL)) {
                object = this.currentURL.getRef();
                String string2 = uRL.getRef();
                if (object == null && string2 == null) {
                    return;
                }
                if (object != null && string2 != null && ((String)object).compareTo(string2) == 0) {
                    return;
                }
            }
            this.currentURL = uRL;
        }
        catch (Exception exception) {
            this.currentURL = null;
        }
        this.highlights.setSize(0);
        this.fireIDChanged(this, this.currentID, this.currentURL);
    }

    public Map.ID getCurrentID() {
        return this.currentID;
    }

    public void setCurrentURL(URL uRL) {
        boolean bl = false;
        if (this.currentURL == null) {
            if (this.currentURL != uRL) {
                this.currentURL = uRL;
                bl = true;
            }
        } else if (!this.currentURL.equals(uRL)) {
            this.currentURL = uRL;
            bl = true;
        }
        if (this.currentURL == null) {
            if (this.currentID != null) {
                this.currentID = null;
                bl = true;
            }
        } else {
            Map.ID iD = this.helpset.getCombinedMap().getIDFromURL(this.currentURL);
            if (this.currentID == null) {
                if (this.currentID != iD) {
                    this.currentID = iD;
                    bl = true;
                }
            } else if (!this.currentID.equals(iD)) {
                this.currentID = iD;
                bl = true;
            }
        }
        if (bl) {
            this.highlights.setSize(0);
            this.fireIDChanged(this, this.currentID, this.currentURL);
        }
    }

    public URL getCurrentURL() {
        return this.currentURL;
    }

    public void addHighlight(int n2, int n3) {
        DefaultHelpModel.debug("addHighlight(" + n2 + ", " + n3 + ")");
        this.highlights.addElement(new DefaultHighlight(n2, n3));
        this.fireHighlightsChanged(this);
    }

    public void removeAllHighlights() {
        DefaultHelpModel.debug("removeAllHighlights");
        this.highlights.setSize(0);
        this.fireHighlightsChanged(this);
    }

    public void setHighlights(TextHelpModel.Highlight[] highlightArray) {
        this.highlights.setSize(0);
        if (highlightArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < highlightArray.length) {
            this.highlights.addElement(new DefaultHighlight(highlightArray[n2].getStartOffset(), highlightArray[n2].getEndOffset()));
            ++n2;
        }
        if (this.highlights.size() > 0) {
            this.fireHighlightsChanged(this);
        }
    }

    public TextHelpModel.Highlight[] getHighlights() {
        Object[] objectArray = new DefaultHighlight[this.highlights.size()];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    public void addHelpModelListener(HelpModelListener helpModelListener) {
        DefaultHelpModel.debug("addHelpModelListener: ");
        DefaultHelpModel.debug("  l:" + helpModelListener);
        if (debug) {
            try {
                throw new Exception("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.listenerList.add(class$javax$help$event$HelpModelListener == null ? (class$javax$help$event$HelpModelListener = DefaultHelpModel.class$("javax.help.event.HelpModelListener")) : class$javax$help$event$HelpModelListener, helpModelListener);
    }

    public void removeHelpModelListener(HelpModelListener helpModelListener) {
        this.listenerList.remove(class$javax$help$event$HelpModelListener == null ? (class$javax$help$event$HelpModelListener = DefaultHelpModel.class$("javax.help.event.HelpModelListener")) : class$javax$help$event$HelpModelListener, helpModelListener);
    }

    public void addTextHelpModelListener(TextHelpModelListener textHelpModelListener) {
        DefaultHelpModel.debug("addTextHelpModelListener: ");
        DefaultHelpModel.debug("  l:" + textHelpModelListener);
        if (debug) {
            try {
                throw new Exception("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.textListenerList.add(class$javax$help$event$TextHelpModelListener == null ? (class$javax$help$event$TextHelpModelListener = DefaultHelpModel.class$("javax.help.event.TextHelpModelListener")) : class$javax$help$event$TextHelpModelListener, textHelpModelListener);
    }

    public void removeTextHelpModelListener(TextHelpModelListener textHelpModelListener) {
        this.textListenerList.remove(class$javax$help$event$TextHelpModelListener == null ? (class$javax$help$event$TextHelpModelListener = DefaultHelpModel.class$("javax.help.event.TextHelpModelListener")) : class$javax$help$event$TextHelpModelListener, textHelpModelListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setDocumentTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.changes.firePropertyChange("documentTitle", string2, string);
    }

    public String getDocumentTitle() {
        return this.title;
    }

    protected void fireIDChanged(Object object, Map.ID iD, URL uRL) {
        Object[] objectArray = this.listenerList.getListenerList();
        HelpModelEvent helpModelEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$help$event$HelpModelListener == null ? DefaultHelpModel.class$("javax.help.event.HelpModelListener") : class$javax$help$event$HelpModelListener)) {
                if (helpModelEvent == null) {
                    helpModelEvent = new HelpModelEvent(object, iD, uRL);
                }
                DefaultHelpModel.debug("fireIDChanged: ");
                DefaultHelpModel.debug("  " + objectArray[n2 + 1]);
                DefaultHelpModel.debug("  id=" + helpModelEvent.getID() + " url=" + helpModelEvent.getURL());
                ((HelpModelListener)objectArray[n2 + 1]).idChanged(helpModelEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireHighlightsChanged(Object object) {
        Object[] objectArray = this.textListenerList.getListenerList();
        TextHelpModelEvent textHelpModelEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$help$event$TextHelpModelListener == null ? DefaultHelpModel.class$("javax.help.event.TextHelpModelListener") : class$javax$help$event$TextHelpModelListener)) {
                if (textHelpModelEvent == null) {
                    textHelpModelEvent = new TextHelpModelEvent(object);
                }
                DefaultHelpModel.debug("fireHighlightsChanged: ");
                DefaultHelpModel.debug("  " + objectArray[n2 + 1]);
                DefaultHelpModel.debug("  " + textHelpModelEvent);
                ((TextHelpModelListener)objectArray[n2 + 1]).highlightsChanged(textHelpModelEvent);
            }
            n2 -= 2;
        }
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("DefaultHelpModel: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DefaultHighlight
    implements TextHelpModel.Highlight {
        public int start;
        public int end;

        public DefaultHighlight(int n2, int n3) {
            if (n2 < 0) {
                throw new IllegalArgumentException("start");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("end");
            }
            this.start = n2;
            this.end = n3;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }
    }
}

