/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.SwingHelpUtilities;
import javax.help.UnsupportedOperationException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class DefaultHelpBroker
implements HelpBroker,
KeyListener {
    protected HelpSet helpset = null;
    protected JFrame frame = null;
    protected JHelp jhelp = null;
    protected Locale locale = null;
    protected Font font = null;
    protected JDialog dialog = null;
    protected Window ownerWindow = null;
    protected boolean modallyActivated = false;
    static boolean on1dot1 = true;
    private int HELP_WIDTH = 645;
    private int HELP_HEIGHT = 495;
    WindowListener dl;
    boolean modalDeactivated = true;
    protected ActionListener displayHelpFromFocus;
    protected ActionListener displayHelpFromSource;
    private static final boolean debug = false;
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$javax$swing$JDialog;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Window;

    public DefaultHelpBroker(HelpSet helpSet) {
        this.setHelpSet(helpSet);
    }

    public DefaultHelpBroker() {
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public void setHelpSet(HelpSet helpSet) {
        if (helpSet != null && this.helpset != helpSet) {
            if (this.jhelp != null) {
                DefaultHelpModel defaultHelpModel = new DefaultHelpModel(helpSet);
                this.jhelp.setModel(defaultHelpModel);
            }
            this.helpset = helpSet;
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.jhelp != null) {
            this.jhelp.setLocale(this.locale);
        }
    }

    public Font getFont() {
        this.createHelpWindow();
        if (this.font == null) {
            return this.jhelp.getFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.jhelp != null) {
            this.jhelp.setFont(this.font);
        }
    }

    public void setCurrentView(String string) {
        this.createHelpWindow();
        JHelpNavigator jHelpNavigator = null;
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (jHelpNavigator.getNavigatorName().equals(string)) break;
            jHelpNavigator = null;
        }
        if (jHelpNavigator == null) {
            throw new IllegalArgumentException("Invalid view name");
        }
        this.jhelp.setCurrentNavigator(jHelpNavigator);
    }

    public String getCurrentView() {
        this.createHelpWindow();
        return this.jhelp.getCurrentNavigator().getNavigatorName();
    }

    public void initPresentation() {
        this.createHelpWindow();
    }

    public void setDisplayed(boolean bl) {
        DefaultHelpBroker.debug("setDisplayed");
        this.createHelpWindow();
        if (this.modallyActivated) {
            if (bl) {
                this.dialog.show();
            } else {
                this.dialog.hide();
            }
        } else {
            this.frame.setVisible(bl);
            try {
                Class[] classArray = new Class[]{Integer.TYPE};
                Method method = (class$java$awt$Frame == null ? (class$java$awt$Frame = DefaultHelpBroker.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("setState", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{new Integer(0)};
                    method.invoke((Object)this.frame, objectArray);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isDisplayed() {
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.isShowing();
            }
            return false;
        }
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                return false;
            }
            try {
                Method method = (class$java$awt$Frame == null ? (class$java$awt$Frame = DefaultHelpBroker.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("getState", null);
                if (method != null) {
                    int n2 = (Integer)method.invoke((Object)this.frame, null);
                    return n2 == 0;
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void setLocation(Point point) throws UnsupportedOperationException {
        this.createHelpWindow();
        if (this.modallyActivated) {
            this.dialog.setLocation(point);
        } else {
            this.frame.setLocation(point);
        }
    }

    public Point getLocation() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.getLocation();
            }
        } else if (this.frame != null) {
            return this.frame.getLocation();
        }
        return null;
    }

    public void setSize(Dimension dimension) throws UnsupportedOperationException {
        this.HELP_WIDTH = dimension.width;
        this.HELP_HEIGHT = dimension.height;
        this.createHelpWindow();
        if (this.modallyActivated) {
            this.dialog.setSize(dimension);
            this.dialog.validate();
        } else {
            this.frame.setSize(dimension);
            this.frame.validate();
        }
    }

    public Dimension getSize() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.getSize();
            }
        } else if (this.frame != null) {
            return this.frame.getSize();
        }
        return null;
    }

    public void setViewDisplayed(boolean bl) {
        this.createHelpWindow();
        this.jhelp.setNavigatorDisplayed(bl);
    }

    public boolean isViewDisplayed() {
        this.createHelpWindow();
        return this.jhelp.isNavigatorDisplayed();
    }

    public void setCurrentID(String string) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create(string, this.helpset));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("setCurrentID");
        this.createJHelp();
        this.jhelp.getModel().setCurrentID(iD);
    }

    public Map.ID getCurrentID() {
        if (this.jhelp != null) {
            return this.jhelp.getModel().getCurrentID();
        }
        return null;
    }

    public void setCurrentURL(URL uRL) {
        this.createHelpWindow();
        this.jhelp.getModel().setCurrentURL(uRL);
        if (this.modallyActivated) {
            this.dialog.setVisible(true);
            this.dialog.show();
        } else {
            this.frame.setVisible(true);
            this.frame.show();
        }
    }

    public URL getCurrentURL() {
        return this.jhelp.getModel().getCurrentURL();
    }

    public void enableHelpKey(Component component, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(156, 0), 1);
            jComponent.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(112, 0), 1);
        } else {
            component.addKeyListener(this);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (n2 == 112 || n2 == 156) {
            ActionListener actionListener = this.getDisplayHelpFromFocus();
            actionListener.actionPerformed(new ActionEvent(keyEvent.getComponent(), 1001, null));
        }
    }

    public void enableHelp(Component component, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
    }

    public void enableHelp(MenuItem menuItem, String string, HelpSet helpSet) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
    }

    public void enableHelpOnButton(Component component, String string, HelpSet helpSet) {
        if (!(component instanceof AbstractButton) && !(component instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(component, string);
        if (helpSet != null) {
            CSH.setHelpSet(component, helpSet);
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.addActionListener(this.getDisplayHelpFromSource());
        } else if (component instanceof Button) {
            Button button = (Button)component;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(MenuItem menuItem, String string, HelpSet helpSet) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (string == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(menuItem, string);
        if (helpSet != null) {
            CSH.setHelpSet(menuItem, helpSet);
        }
        menuItem.addActionListener(this.getDisplayHelpFromSource());
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus(this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource(this);
        }
        return this.displayHelpFromSource;
    }

    public void setActivationWindow(Window window) {
        if (window != null && window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            if (dialog.isModal()) {
                this.ownerWindow = window;
                this.modallyActivated = true;
            } else {
                this.ownerWindow = null;
                this.modallyActivated = false;
            }
        } else {
            this.ownerWindow = null;
            this.modallyActivated = false;
        }
    }

    private synchronized void createJHelp() {
        DefaultHelpBroker.debug("createJHelp");
        if (this.jhelp == null) {
            this.jhelp = new JHelp(this.helpset);
            if (this.font != null) {
                this.jhelp.setFont(this.font);
            }
            if (this.locale != null) {
                this.jhelp.setLocale(this.locale);
            }
        }
    }

    private synchronized void createHelpWindow() {
        DefaultHelpBroker.debug("createHelpWindow");
        Point point = null;
        Dimension dimension = null;
        JDialog jDialog = null;
        this.createJHelp();
        String string = this.helpset.getTitle();
        if (this.modallyActivated) {
            Window window = null;
            try {
                Method method = (class$java$awt$Window == null ? (class$java$awt$Window = DefaultHelpBroker.class$("java.awt.Window")) : class$java$awt$Window).getMethod("getOwner", null);
                if (method != null && this.dialog != null) {
                    window = (Window)method.invoke((Object)this.dialog, null);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (this.dialog == null || window != this.ownerWindow || this.modalDeactivated) {
                if (this.frame != null) {
                    point = this.frame.getLocation();
                    dimension = this.frame.getSize();
                    this.frame.dispose();
                }
                if (this.dialog != null) {
                    point = this.dialog.getLocation();
                    dimension = this.dialog.getSize();
                    jDialog = this.dialog;
                }
                if (on1dot1) {
                    this.dialog = new JDialog();
                    this.dialog.setTitle(string);
                } else {
                    this.dialog = new JDialog((Dialog)this.ownerWindow, string);
                    this.dl = new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            DefaultHelpBroker.debug("modal window closing");
                            if (DefaultHelpBroker.this.dialog.isShowing()) {
                                DefaultHelpBroker.this.dialog.hide();
                            }
                            if (DefaultHelpBroker.this.ownerWindow != null) {
                                DefaultHelpBroker.this.ownerWindow.removeWindowListener(DefaultHelpBroker.this.dl);
                            }
                            DefaultHelpBroker.this.ownerWindow = null;
                            DefaultHelpBroker.this.modalDeactivated = true;
                        }
                    };
                    DefaultHelpBroker.debug("adding windowlistener");
                    this.ownerWindow.addWindowListener(this.dl);
                    this.modalDeactivated = false;
                }
                if (dimension != null) {
                    this.dialog.setSize(dimension);
                } else {
                    this.dialog.setSize(this.HELP_WIDTH, this.HELP_HEIGHT);
                }
                if (point != null) {
                    this.dialog.setLocation(point);
                }
                this.dialog.getContentPane().add(this.jhelp);
                if (jDialog != null) {
                    jDialog.dispose();
                }
            }
        } else {
            if (this.frame == null) {
                this.frame = new JFrame(string);
                WindowAdapter windowAdapter = new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        DefaultHelpBroker.this.frame.setVisible(false);
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        DefaultHelpBroker.this.frame.setVisible(false);
                    }
                };
                this.frame.addWindowListener(windowAdapter);
            }
            if (this.dialog != null) {
                point = this.dialog.getLocation();
                dimension = this.dialog.getSize();
                this.dialog.dispose();
                this.dialog = null;
                this.ownerWindow = null;
            }
            if (dimension != null) {
                this.frame.setSize(dimension);
            } else {
                this.frame.setSize(this.HELP_WIDTH, this.HELP_HEIGHT);
            }
            if (point != null) {
                this.frame.setLocation(point);
            }
            this.frame.getContentPane().add(this.jhelp);
            this.frame.setTitle(this.helpset.getTitle());
        }
    }

    private static void debug(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class[] classArray = new Class[]{class$java$awt$Dialog == null ? (class$java$awt$Dialog = DefaultHelpBroker.class$("java.awt.Dialog")) : class$java$awt$Dialog, Boolean.TYPE};
            Constructor constructor = (class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = DefaultHelpBroker.class$("javax.swing.JDialog")) : class$javax$swing$JDialog).getConstructor(classArray);
            on1dot1 = constructor == null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            on1dot1 = true;
        }
        SwingHelpUtilities.installLookAndFeelDefaults();
    }
}

