/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.Schema;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class FullBtreeDict
extends BtreeDict {
    protected BtreeDictParameters params;
    private boolean update = false;
    private boolean debug = false;

    protected FullBtreeDict() {
    }

    public FullBtreeDict(BtreeDictParameters btreeDictParameters, boolean bl) throws Exception {
        this.init(btreeDictParameters, bl, new BlockFactory(){

            public Block makeBlock() {
                return new FullDictBlock();
            }
        });
        this.blocks = new int[300000];
        this.params = btreeDictParameters;
        this.update = bl;
    }

    public void close(int n2) throws Exception {
        this.params.setFreeID(n2);
        if (this.update) {
            this.params.updateSchema();
        }
        super.close();
    }

    public void store(String string, int n2) throws Exception {
        byte[] byArray = string.getBytes("UTF8");
        Entry entry = this.insert((FullDictBlock)this.accessBlock(this.root), new Entry(byArray, byArray.length, n2));
        if (entry != null) {
            FullDictBlock fullDictBlock = this.getNewBlock();
            fullDictBlock.initInternal(this.root, entry);
            this.blocks[entry.id] = this.root = fullDictBlock.number;
            this.params.setRoot(this.root);
        }
    }

    private void setModified(Block block) {
        this.blockManager.setModified(block.number);
    }

    private FullDictBlock getNewBlock() throws Exception {
        FullDictBlock fullDictBlock = (FullDictBlock)this.blockManager.getNewBlock();
        this.setModified(fullDictBlock);
        return fullDictBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry insert(FullDictBlock fullDictBlock, Entry entry) throws Exception {
        if (fullDictBlock.isLeaf) {
            return this.insertHere(fullDictBlock, entry);
        }
        int n2 = fullDictBlock.insertInternal(entry);
        if (n2 != -1) {
            try {
                this.lock(fullDictBlock);
                entry = this.insert((FullDictBlock)this.child(fullDictBlock, n2), entry);
                Entry entry2 = entry == null ? null : this.insertHere(fullDictBlock, entry);
                Object var6_5 = null;
                this.unlock(fullDictBlock);
                return entry2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.unlock(fullDictBlock);
                throw throwable;
            }
        }
        return null;
    }

    private Entry insertHere(FullDictBlock fullDictBlock, Entry entry) throws Exception {
        this.setModified(fullDictBlock);
        if (fullDictBlock.insert(entry)) {
            return null;
        }
        FullDictBlock fullDictBlock2 = this.getNewBlock();
        Entry entry2 = fullDictBlock.split(fullDictBlock2);
        fullDictBlock2.setBlockNumbers(this.blocks);
        if (!(entry2.smallerThan(entry) ? fullDictBlock2 : fullDictBlock).insert(entry)) {
            throw new Exception("entry didn't fit into a freshly split block");
        }
        return entry2;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Schema schema = new Schema(null, stringArray[0], true);
            BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
            if (!btreeDictParameters.readState()) {
                btreeDictParameters.setBlockSize(2048);
                btreeDictParameters.setRoot(0);
                btreeDictParameters.setFreeID(1);
            }
            FullBtreeDict fullBtreeDict = new FullBtreeDict(btreeDictParameters, true);
            int n2 = btreeDictParameters.getFreeID();
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(stringArray[1])));
            while ((string = lineNumberReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("storing")) {
                        fullBtreeDict.store(stringTokenizer.nextToken(), n2++);
                        continue;
                    }
                    if (!string2.equals("fetching")) continue;
                    fullBtreeDict.fetch(stringTokenizer.nextToken());
                }
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("FullBtreeDict: " + string);
        }
    }

    protected class FullDictBlock
    extends BtreeDict.DictBlock {
        protected FullDictBlock() {
        }

        public void setFree(int n2) {
            this.free = n2 - this.firstEntry();
            this.data[n2 + 1] = 0;
            this.data[n2] = 0;
        }

        public void setNumberOfEntries(int n2) {
            this.setIntegerAt(0, n2);
        }

        protected void setChildIndex(int n2, int n3) {
            this.setIntegerAt(4 * (508 - n2 + 1), n3);
        }

        public void setEntryID(int n2, int n3) {
            this.setIntegerAt(n2 + 2, n3);
        }

        private boolean insert(Entry entry) {
            byte[] byArray = entry.key;
            int n2 = byArray.length - 1;
            int n3 = this.free();
            int n4 = this.firstEntry();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n4 != n3) {
                if (n7 == n5) {
                    int n9 = this.entryKeyLength(n4);
                    int n10 = this.entryKey(n4);
                    n6 = n5;
                    int n11 = 0;
                    while (n11 < n9 && byArray[n5] == this.data[n10 + n11]) {
                        ++n5;
                        ++n11;
                    }
                    if (n11 == n9) {
                        if (n5 == n2) {
                            this.setEntryID(n4, entry.id);
                            return true;
                        }
                    } else if ((byArray[n5] & 0xFF) < (this.data[n10 + n11] & 0xFF)) {
                        return this.insert(entry, n4, n6, n5, n8);
                    }
                } else if (n7 < n5) {
                    return this.insert(entry, n4, n5, n7, n4 == n3 ? this.numberOfEntries() : n8);
                }
                do {
                    n4 = this.nextEntry(n4);
                    ++n8;
                } while (this.entryCompression(n4) > n5);
                n7 = this.entryCompression(n4);
            }
            return this.insert(entry, n4, n5, 0, this.numberOfEntries());
        }

        public void makeEntry(int n2, byte[] byArray, int n3, int n4, int n5) {
            this.data[n2] = (byte)n4;
            this.data[n2 + 1] = (byte)n5;
            this.setEntryID(n2, n3);
            System.arraycopy(byArray, n5, this.data, this.entryKey(n2), n4);
        }

        private boolean insert(Entry entry, int n2, int n3, int n4, int n5) {
            int n6;
            byte[] byArray = entry.key;
            int n7 = byArray.length - 1 - n3;
            int n8 = this.free();
            int n9 = 6 + n7;
            int n10 = 0;
            if (n2 < n8 && this.entryCompression(n2) < n4) {
                n10 = n4 - this.entryCompression(n2);
            }
            int n11 = n6 = this.isLeaf ? 2038 : 4 * (508 - this.numberOfEntries() - 1);
            if (n8 + n9 - n10 <= n6) {
                int n12;
                if (n2 < n8) {
                    n12 = n10 > 0 ? n2 + 6 + n10 : n2;
                    System.arraycopy(this.data, n12, this.data, n12 + n9 - n10, n8 - n12);
                    if (n10 > 0) {
                        int n13 = n2;
                        this.data[n13] = (byte)(this.data[n13] - n10);
                        int n14 = n2 + 1;
                        this.data[n14] = (byte)(this.data[n14] + n10);
                        System.arraycopy(this.data, n2, this.data, n2 + n9, 6);
                    }
                }
                this.makeEntry(n2, byArray, entry.id, n7, n3);
                if (!this.isLeaf) {
                    n12 = 4 * (508 - this.numberOfEntries() + 1);
                    System.arraycopy(this.data, n12, this.data, n12 - 4, 4 * (this.numberOfEntries() - n5));
                    this.setChildIndex(n5 + 1, entry.block);
                }
                this.setFree(n8 + n9 - n10);
                this.setNumberOfEntries(this.numberOfEntries() + 1);
                return true;
            }
            return false;
        }

        public int insertInternal(Entry entry) {
            byte[] byArray = entry.key;
            int n2 = byArray.length - 1;
            int n3 = this.firstEntry();
            int n4 = this.free();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n3 != n4) {
                if (n6 == n5) {
                    int n8 = this.entryKeyLength(n3);
                    int n9 = this.entryKey(n3);
                    int n10 = 0;
                    while (n10 < n8 && byArray[n5] == this.data[n9 + n10]) {
                        ++n5;
                        ++n10;
                    }
                    if (n10 == n8) {
                        if (n5 == n2) {
                            this.setEntryID(n3, entry.id);
                            return -1;
                        }
                    } else if ((byArray[n5] & 0xFF) < (this.data[n9 + n10] & 0xFF)) {
                        return n7;
                    }
                } else if (n6 < n5) {
                    return n3 >= n4 ? this.numberOfEntries() : n7;
                }
                do {
                    n3 = this.nextEntry(n3);
                    ++n7;
                } while (this.entryCompression(n3) > n5);
                n6 = this.entryCompression(n3);
            }
            return this.numberOfEntries();
        }

        private Entry split(FullDictBlock fullDictBlock) {
            byte[] byArray = new byte[255];
            int n2 = this.free();
            int n3 = n2 / 2;
            int n4 = 0;
            fullDictBlock.isLeaf = this.isLeaf;
            int n5 = this.firstEntry();
            while (n5 < n3) {
                this.restoreKeyInBuffer(n5, byArray);
                ++n4;
                n5 = this.nextEntry(n5);
            }
            int n6 = this.numberOfEntries() - n4 - 1;
            this.restoreKeyInBuffer(n5, byArray);
            int n7 = this.entryKeyLength(n5) + this.entryCompression(n5);
            Entry entry = new Entry(byArray, n7, this.entryID(n5));
            entry.block = fullDictBlock.number;
            int n8 = n5;
            n5 = this.nextEntry(n5);
            this.restoreKeyInBuffer(n5, byArray);
            n7 = this.entryKeyLength(n5) + this.entryCompression(n5);
            int n9 = this.firstEntry();
            fullDictBlock.makeEntry(n9, byArray, this.entryID(n5), n7, 0);
            n5 = this.nextEntry(n5);
            System.arraycopy(this.data, n5, fullDictBlock.data, fullDictBlock.nextEntry(n9), n2 - n5);
            fullDictBlock.setNumberOfEntries(n6);
            fullDictBlock.setFree(fullDictBlock.nextEntry(n9) + n2 - n5);
            if (!this.isLeaf) {
                int n10 = 4 * (508 - this.numberOfEntries() + 1);
                System.arraycopy(this.data, n10, fullDictBlock.data, n10 + 4 * (n4 + 1), 4 * (n6 + 1));
            }
            this.setFree(n8);
            this.setNumberOfEntries(n4);
            return entry;
        }

        public void initInternal(int n2, Entry entry) {
            this.isLeaf = false;
            this.setNumberOfEntries(1);
            this.setChildIndex(0, n2);
            this.setChildIndex(1, entry.block);
            int n3 = this.firstEntry();
            this.makeEntry(n3, entry.key, entry.id, entry.key.length - 1, 0);
            this.setFree(this.nextEntry(n3));
        }
    }

    private final class Entry {
        public byte[] key;
        public int id;
        public int block = -1;

        public Entry(byte[] byArray, int n2, int n3) {
            this.key = new byte[n2 + 1];
            System.arraycopy(byArray, 0, this.key, 0, n2);
            this.key[n2] = 0;
            this.id = n3;
        }

        public boolean smallerThan(Entry entry) {
            int n2 = 0;
            while (n2 < Math.min(this.key.length, entry.key.length)) {
                if (this.key[n2] != entry.key[n2]) {
                    return (this.key[n2] & 0xFF) < (entry.key[n2] & 0xFF);
                }
                ++n2;
            }
            return false;
        }
    }
}

