/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class PNGEncoder
extends AbstractImageEncoder {
    long[] crc_table = null;

    public int compress(byte[] byArray, byte[] byArray2, int n2, int n3) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray3 = new byte[byArray2.length + n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray3[n4 * (n2 + 1)] = AbstractImageEncoder.byteFromInt(0);
            int n5 = 0;
            while (n5 < n2) {
                byArray3[n4 * (n2 + 1) + n5 + 1] = byArray2[n4 * n2 + n5];
                ++n5;
            }
            ++n4;
        }
        deflater.setInput(byArray3, 0, byArray3.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            this.error("PNG encoding error: Deflater could not compress image data.");
        }
        return deflater.getTotalOut();
    }

    public int compress(byte[] byArray, int[] nArray, ColorModel colorModel, int n2, int n3) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray2 = new byte[nArray.length * 4 + n3];
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            n4 = n6 * (n2 * 4 + 1);
            byArray2[n4++] = AbstractImageEncoder.byteFromInt(0);
            int n7 = 0;
            while (n7 < n2 * 4) {
                n5 = nArray[n6 * n2 + (int)Math.floor(n7 / 4)];
                byArray2[n4++] = (byte)colorModel.getRed(n5);
                byArray2[n4++] = (byte)colorModel.getGreen(n5);
                byArray2[n4++] = (byte)colorModel.getBlue(n5);
                byArray2[n4++] = (byte)colorModel.getAlpha(n5);
                n7 += 4;
            }
            ++n6;
        }
        deflater.setInput(byArray2, 0, byArray2.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            this.error("PNG encoding error: Deflater could not compress image data.");
        }
        byte[] byArray3 = AbstractImageEncoder.bytesFromLong(deflater.getAdler());
        return deflater.getTotalOut();
    }

    long end_crc(long l2) {
        return l2 ^ 0xFFFFFFFFL;
    }

    void make_crc_table() {
        this.crc_table = new long[256];
        int n2 = 0;
        while (n2 < 256) {
            long l2 = n2;
            int n3 = 0;
            while (n3 < 8) {
                l2 = (l2 & 1L) != 0L ? 0xEDB88320L ^ l2 >> 1 : (l2 >>= 1);
                ++n3;
            }
            this.crc_table[n2] = l2;
            ++n2;
        }
    }

    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        int n2;
        byte by;
        if (image == null) {
            this.error("PNG encoding error: Image is NULL.");
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.error("PNG encoding error: Unable to retrieve pixels from image.");
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n3 = colorModel.getPixelSize();
        int n4 = (int)Math.pow(2.0, n3);
        if (n3 < 8 || n3 > 32) {
            this.error("PNG encoding error: PNG method needs color mode to be between 8 and 32 bits.");
        }
        int[] nArray = null;
        byte[] byArray = null;
        if (n3 > 8) {
            nArray = (int[])pixelGrabber.getPixels();
        } else {
            byArray = (byte[])pixelGrabber.getPixels();
        }
        outputStream.write(AbstractImageEncoder.byteFromInt(137));
        outputStream.write(AbstractImageEncoder.byteFromInt(80));
        outputStream.write(AbstractImageEncoder.byteFromInt(78));
        outputStream.write(AbstractImageEncoder.byteFromInt(71));
        outputStream.write(AbstractImageEncoder.byteFromInt(13));
        outputStream.write(AbstractImageEncoder.byteFromInt(10));
        outputStream.write(AbstractImageEncoder.byteFromInt(26));
        outputStream.write(AbstractImageEncoder.byteFromInt(10));
        long l2 = this.start_crc();
        outputStream.write(AbstractImageEncoder.bytesFromLong(13L));
        outputStream.write(AbstractImageEncoder.byteFromChar('I'));
        outputStream.write(AbstractImageEncoder.byteFromChar('H'));
        outputStream.write(AbstractImageEncoder.byteFromChar('D'));
        outputStream.write(AbstractImageEncoder.byteFromChar('R'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('I'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('H'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('D'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('R'));
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        l2 = this.update_crc(l2, AbstractImageEncoder.bytesFromLong(n5));
        l2 = this.update_crc(l2, AbstractImageEncoder.bytesFromLong(n6));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromInt(8));
        l2 = n3 > 8 ? this.update_crc(l2, AbstractImageEncoder.byteFromInt(6)) : this.update_crc(l2, AbstractImageEncoder.byteFromInt(3));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromInt(0));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromInt(0));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.bytesFromLong(n5));
        outputStream.write(AbstractImageEncoder.bytesFromLong(n6));
        outputStream.write(AbstractImageEncoder.byteFromInt(8));
        if (n3 > 8) {
            outputStream.write(AbstractImageEncoder.byteFromInt(6));
        } else {
            outputStream.write(AbstractImageEncoder.byteFromInt(3));
        }
        outputStream.write(AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l2)));
        if (n3 == 8) {
            l2 = this.start_crc();
            outputStream.write(AbstractImageEncoder.bytesFromLong(n4 * 3));
            outputStream.write(AbstractImageEncoder.byteFromChar('P'));
            outputStream.write(AbstractImageEncoder.byteFromChar('L'));
            outputStream.write(AbstractImageEncoder.byteFromChar('T'));
            outputStream.write(AbstractImageEncoder.byteFromChar('E'));
            l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('P'));
            l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('L'));
            l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('T'));
            l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('E'));
            int n7 = 0;
            while (n7 < n4) {
                by = AbstractImageEncoder.byteFromInt(colorModel.getRed(n7));
                n2 = AbstractImageEncoder.byteFromInt(colorModel.getGreen(n7));
                byte by2 = AbstractImageEncoder.byteFromInt(colorModel.getBlue(n7));
                l2 = this.update_crc(l2, by);
                l2 = this.update_crc(l2, (byte)n2);
                l2 = this.update_crc(l2, by2);
                outputStream.write(by);
                outputStream.write(n2);
                outputStream.write(by2);
                ++n7;
            }
            outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l2)));
        }
        byte[] byArray2 = null;
        byArray2 = n3 == 8 ? new byte[byArray.length + n6] : new byte[nArray.length * 4 + n6];
        by = 0;
        by = n3 > 8 ? this.compress(byArray2, nArray, colorModel, n5, n6) : this.compress(byArray2, byArray, n5, n6);
        l2 = this.start_crc();
        outputStream.write(AbstractImageEncoder.bytesFromLong(by));
        outputStream.write(AbstractImageEncoder.byteFromChar('I'));
        outputStream.write(AbstractImageEncoder.byteFromChar('D'));
        outputStream.write(AbstractImageEncoder.byteFromChar('A'));
        outputStream.write(AbstractImageEncoder.byteFromChar('T'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('I'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('D'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('A'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('T'));
        outputStream.write(byArray2, 0, by);
        n2 = 0;
        while (n2 < by) {
            l2 = this.update_crc(l2, byArray2[n2]);
            ++n2;
        }
        outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l2)));
        l2 = this.start_crc();
        outputStream.write(AbstractImageEncoder.bytesFromLong(0L));
        outputStream.write(AbstractImageEncoder.byteFromChar('I'));
        outputStream.write(AbstractImageEncoder.byteFromChar('E'));
        outputStream.write(AbstractImageEncoder.byteFromChar('N'));
        outputStream.write(AbstractImageEncoder.byteFromChar('D'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('I'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('E'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('N'));
        l2 = this.update_crc(l2, AbstractImageEncoder.byteFromChar('D'));
        outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l2)));
    }

    long start_crc() {
        return 0xFFFFFFFFL;
    }

    long update_crc(long l2, byte by) {
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        return this.crc_table[(int)((l2 ^ (long)by) & 0xFFL)] ^ l2 >> 8;
    }

    long update_crc(long l2, byte[] byArray) {
        long l3 = l2;
        int n2 = 0;
        while (n2 < byArray.length) {
            l3 = this.update_crc(l3, byArray[n2]);
            ++n2;
        }
        return l3;
    }
}

