/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCStringTokenizer;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;

public class JCSwingTypeConverter {
    public static final Color lightBlue = new Color(173, 216, 230);

    public static String fromBorder(Border border, Component component) {
        if (border == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "|";
        if (border instanceof EmptyBorder) {
            stringBuffer.append("empty");
        } else if (border instanceof SoftBevelBorder) {
            stringBuffer.append("softbevel");
        } else if (border instanceof BevelBorder) {
            stringBuffer.append("bevel");
        } else if (border instanceof EtchedBorder) {
            stringBuffer.append("etched");
        } else if (border instanceof LineBorder) {
            stringBuffer.append("line");
        } else if (border instanceof MatteBorder) {
            stringBuffer.append("matte");
        } else if (border instanceof TitledBorder) {
            stringBuffer.append("titled");
        } else {
            return null;
        }
        stringBuffer.append(string);
        if (border instanceof EmptyBorder) {
            stringBuffer.append(JCSwingTypeConverter.fromInsetsToIntList(((EmptyBorder)border).getBorderInsets(component), string));
        } else if (border instanceof BevelBorder) {
            int n2 = ((BevelBorder)border).getBevelType();
            if (n2 == 0) {
                stringBuffer.append("raised");
            } else {
                stringBuffer.append("lowered");
            }
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(((BevelBorder)border).getHighlightInnerColor(component)));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(((BevelBorder)border).getShadowOuterColor(component)));
        } else if (border instanceof EtchedBorder) {
            int n3 = ((EtchedBorder)border).getEtchType();
            if (n3 == 0) {
                stringBuffer.append("raised");
            } else {
                stringBuffer.append("lowered");
            }
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(((EtchedBorder)border).getHighlightColor(component)));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(((EtchedBorder)border).getShadowColor(component)));
        } else if (border instanceof LineBorder) {
            stringBuffer.append(JCSwingTypeConverter.fromColor(((LineBorder)border).getLineColor()));
            stringBuffer.append(string);
            stringBuffer.append(((LineBorder)border).getThickness());
        } else if (!(border instanceof MatteBorder) && border instanceof TitledBorder) {
            stringBuffer.append(((TitledBorder)border).getTitle());
        }
        return stringBuffer.toString();
    }

    public static String fromColor(Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.black)) {
            return "black";
        }
        if (color.equals(Color.blue)) {
            return "blue";
        }
        if (color.equals(Color.cyan)) {
            return "cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "gray";
        }
        if (color.equals(Color.green)) {
            return "green";
        }
        if (color.equals(lightBlue)) {
            return "lightBlue";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "magenta";
        }
        if (color.equals(Color.orange)) {
            return "orange";
        }
        if (color.equals(Color.pink)) {
            return "pink";
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.white)) {
            return "white";
        }
        if (color.equals(Color.yellow)) {
            return "yellow";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(color.getRed());
        stringBuffer.append("-");
        stringBuffer.append(color.getGreen());
        stringBuffer.append("-");
        stringBuffer.append(color.getBlue());
        return stringBuffer.toString();
    }

    public static String fromColorList(Color[] colorArray) {
        if (colorArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < colorArray.length) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(JCSwingTypeConverter.fromColor(colorArray[n2]));
            ++n2;
        }
        return new String(stringBuffer);
    }

    public static String fromFont(Font font) {
        if (font == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append("-");
        switch (font.getStyle()) {
            case 2: {
                stringBuffer.append("ITALIC");
                break;
            }
            case 1: {
                stringBuffer.append("BOLD");
                break;
            }
            case 3: {
                stringBuffer.append("BOLDITALIC");
                break;
            }
            default: {
                stringBuffer.append("PLAIN");
            }
        }
        stringBuffer.append("-");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static String fromInsets(Insets insets) {
        return String.valueOf(insets.top) + "," + insets.left + "," + insets.bottom + "," + insets.right;
    }

    public static String fromInsetsToIntList(Insets insets) {
        return JCSwingTypeConverter.fromInsetsToIntList(insets, ", ");
    }

    public static String fromInsetsToIntList(Insets insets, String string) {
        if (insets == null) {
            return "0" + string + "0" + string + "0" + string + "0";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(insets.top);
        stringBuffer.append(string);
        stringBuffer.append(insets.left);
        stringBuffer.append(string);
        stringBuffer.append(insets.bottom);
        stringBuffer.append(string);
        stringBuffer.append(insets.right);
        return stringBuffer.toString();
    }

    public static Border toBorder(String string) {
        Border border = null;
        char c2 = '|';
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String string2 = jCStringTokenizer.nextToken(c2);
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equals("empty")) {
            String string3 = jCStringTokenizer.nextToken(c2);
            String string4 = jCStringTokenizer.nextToken(c2);
            String string5 = jCStringTokenizer.nextToken(c2);
            String string6 = jCStringTokenizer.nextToken(c2);
            if (string3 == null || string4 == null || string5 == null || string6 == null) {
                return null;
            }
            border = BorderFactory.createEmptyBorder(new Integer(string3), new Integer(string4), new Integer(string5), new Integer(string6));
        } else if (string2.equals("bevel")) {
            String string7 = jCStringTokenizer.nextToken(c2);
            String string8 = jCStringTokenizer.nextToken(c2);
            String string9 = jCStringTokenizer.nextToken(c2);
            border = string8 == null || string9 == null ? BorderFactory.createBevelBorder(string7.equals("raised") ? 0 : 1) : BorderFactory.createBevelBorder(string7.equals("raised") ? 0 : 1, JCSwingTypeConverter.toColor(string8), JCSwingTypeConverter.toColor(string9));
        } else if (string2.equals("softbevel")) {
            String string10 = jCStringTokenizer.nextToken(c2);
            String string11 = jCStringTokenizer.nextToken(c2);
            String string12 = jCStringTokenizer.nextToken(c2);
            border = string11 == null || string12 == null ? new SoftBevelBorder(string10.equals("raised") ? 0 : 1) : new SoftBevelBorder(string10.equals("raised") ? 0 : 1, JCSwingTypeConverter.toColor(string11), JCSwingTypeConverter.toColor(string12));
        } else if (string2.equals("etched")) {
            String string13 = jCStringTokenizer.nextToken(c2);
            String string14 = jCStringTokenizer.nextToken(c2);
            String string15 = jCStringTokenizer.nextToken(c2);
            border = string14 == null || string15 == null ? new EtchedBorder(string13.equals("raised") ? 0 : 1) : new EtchedBorder(string13.equals("raised") ? 0 : 1, JCSwingTypeConverter.toColor(string14), JCSwingTypeConverter.toColor(string15));
        } else if (string2.equals("matte")) {
            String string16 = jCStringTokenizer.nextToken(c2);
            String string17 = jCStringTokenizer.nextToken(c2);
            String string18 = jCStringTokenizer.nextToken(c2);
            String string19 = jCStringTokenizer.nextToken(c2);
            if (string16 == null || string17 == null || string18 == null || string19 == null) {
                return null;
            }
            String string20 = jCStringTokenizer.nextToken(c2);
            border = BorderFactory.createMatteBorder((int)new Integer(string16), (int)new Integer(string17), (int)new Integer(string18), (int)new Integer(string19), JCSwingTypeConverter.toColor(string20));
        } else if (string2.equals("line")) {
            String string21 = jCStringTokenizer.nextToken(c2);
            String string22 = jCStringTokenizer.nextToken(c2);
            border = string22 == null ? BorderFactory.createLineBorder(JCSwingTypeConverter.toColor(string21)) : BorderFactory.createLineBorder(JCSwingTypeConverter.toColor(string21), new Integer(string22));
        } else if (string2.equals("titled")) {
            String string23 = jCStringTokenizer.nextToken(c2);
            border = BorderFactory.createTitledBorder(string23);
        }
        return border;
    }

    public static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightBlue")) {
            return lightBlue;
        }
        if (string2.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            if (string2.startsWith("#")) {
                if (string2.length() >= 13) {
                    return new Color(Integer.valueOf(string2.substring(1, 5), 16) / 256, Integer.valueOf(string2.substring(5, 9), 16) / 256, Integer.valueOf(string2.substring(9, 13), 16) / 256);
                }
                if (string2.length() >= 7) {
                    return new Color(Integer.valueOf(string2.substring(1, 3), 16), Integer.valueOf(string2.substring(3, 5), 16), Integer.valueOf(string2.substring(5, 7), 16));
                }
                return new Color(Integer.valueOf(string2.substring(1), 16));
            }
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            int n4 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            return new Color(n2, n3, n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Color toColor(String string, Color color) {
        Color color2 = JCSwingTypeConverter.toColor(string);
        return string != null ? color2 : color;
    }

    public static Color[] toColorList(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Color[] colorArray = new Color[jCStringTokenizer.countTokens(',')];
        int n2 = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(',').trim();
            colorArray[n2] = JCSwingTypeConverter.toColor(string2);
            if (colorArray[n2] == null) {
                JCTypeConverter.error(string, string2);
            }
            ++n2;
        }
        return colorArray;
    }

    public static Color[] toColorList(String string, Color[] colorArray) {
        Color[] colorArray2 = JCSwingTypeConverter.toColorList(string);
        return string != null ? colorArray2 : colorArray;
    }

    public static Dimension toDimension(String string, Dimension dimension) {
        int[] nArray = JCTypeConverter.toIntList(string, 'x', null);
        if (nArray != null && nArray.length == 2) {
            return new Dimension(nArray[0], nArray[1]);
        }
        return dimension;
    }

    public static Font toFont(String string) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        if (jCStringTokenizer.countTokens('-') != 3) {
            return null;
        }
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        String string3 = jCStringTokenizer.nextToken('-');
        if (string3 == null) {
            n2 = 0;
        } else {
            if ((string3 = string3.trim()).equalsIgnoreCase("PLAIN")) {
                n2 = 0;
            }
            if (string3.equalsIgnoreCase("ITALIC")) {
                n2 = 2;
            }
            if (string3.equalsIgnoreCase("BOLD")) {
                n2 = 1;
            }
            if (string3.equalsIgnoreCase("BOLDITALIC")) {
                n2 = 3;
            }
        }
        String string4 = jCStringTokenizer.nextToken('-');
        int n3 = 8;
        if (string4 != null) {
            n3 = Integer.parseInt(string4.trim());
        }
        return new Font(string2, n2, n3);
    }

    public static Font toFont(String string, Font font) {
        Font font2 = JCSwingTypeConverter.toFont(string);
        return font2 != null ? font2 : font;
    }

    public static Insets toInsets(String string, Insets insets) {
        if (string == null) {
            return insets;
        }
        int[] nArray = JCTypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 4) {
            return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return insets;
    }

    public static Point toPoint(String string, Point point) {
        int[] nArray = JCTypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 2) {
            return new Point(nArray[0], nArray[1]);
        }
        return point;
    }
}

