/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.Version;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.JCSpinBoxEditor;
import com.klg.jclass.util.value.AbstractValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class JCSpinNumberBox
extends AbstractSpinBox {
    public static final int INTEGER = 1;
    public static final int FLOATING_POINT = 2;
    protected int operation = 1;
    protected NumberFormat format = NumberFormat.getNumberInstance();
    protected Number step = new Integer(1);
    protected Number max = new Long(Long.MAX_VALUE);
    protected Number min = new Long(Long.MIN_VALUE);
    static /* synthetic */ Class class$java$lang$Number;

    public JCSpinNumberBox() {
        this.setEditor(new NumberEditor());
        this.setValueModel(new NumberModel());
    }

    protected void checkArrowButtons() {
        Number number = (Number)this.valueModel.getValue();
        Number number2 = (Number)this.spinUp();
        if (this.compare(number2, this.max) > 0) {
            this.setArrowEnabled(this.upArrow, false);
        } else {
            this.setArrowEnabled(this.upArrow, true);
        }
        number2 = (Number)this.spinDown();
        if (this.compare(number2, this.min) < 0) {
            this.setArrowEnabled(this.downArrow, false);
        } else {
            this.setArrowEnabled(this.downArrow, true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected int compare(Number number, Number number2) {
        double d2;
        if (number == null) {
            if (number2 == null) {
                return 0;
            }
            return -1;
        }
        if (number2 == null) {
            return 1;
        }
        if (this.operation == 1) {
            long l2;
            long l3 = number.longValue();
            return l3 < (l2 = number2.longValue()) ? -1 : (l3 == l2 ? 0 : 1);
        }
        double d3 = number.doubleValue();
        return d3 < (d2 = number2.doubleValue()) ? -1 : (d3 == d2 ? 0 : 1);
    }

    protected String format(Number number) {
        if (number == null) {
            return "";
        }
        String string = "";
        string = this.operation == 1 ? this.format.format(number.longValue()) : this.format.format(number.doubleValue());
        return string;
    }

    public String getAbout() {
        return Version.getVersionString();
    }

    public Number getMaximumValue() {
        return this.max;
    }

    public Number getMinimumValue() {
        return this.min;
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public int getOperation() {
        return this.operation;
    }

    public Number getSpinStep() {
        return this.step;
    }

    public Number getValue() {
        return (Number)this.valueModel.getValue();
    }

    protected Number parse(String string) {
        Number number = null;
        if (this.operation == 1) {
            this.format.setParseIntegerOnly(true);
        } else {
            this.format.setParseIntegerOnly(false);
        }
        try {
            number = this.format.parse(string);
        }
        catch (ParseException parseException) {}
        return number;
    }

    protected int preferredWidthOfView() {
        int n2 = 0;
        if (this.isEditable()) {
            Component component = this.editor.getEditorComponent();
            this.editor.setItem(this.max);
            n2 = component.getPreferredSize().width;
            this.editor.setItem(this.min);
            n2 = Math.max(n2, component.getPreferredSize().width);
            if (this.operation == 2) {
                this.editor.setItem(new Double(this.min.doubleValue() + this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
                this.editor.setItem(new Double(this.max.doubleValue() - this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
            }
            this.editor.setItem(this.getValue());
        } else {
            Component component = this.renderer.getComponent(this, this.max);
            n2 = component.getPreferredSize().width;
            this.renderer.getComponent(this, this.min);
            n2 = Math.max(n2, component.getPreferredSize().width);
            if (this.operation == 2) {
                this.renderer.getComponent(this, new Double(this.min.doubleValue() + this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
                this.renderer.getComponent(this, new Double(this.max.doubleValue() - this.step.doubleValue()));
                n2 = Math.max(n2, component.getPreferredSize().width);
            }
            this.renderer.getComponent(this, this.getValue());
        }
        return n2 += JCEnvironment.isWorking("MotifPreferedWidthAjustment");
    }

    protected void processValueChanged(JCValueEvent jCValueEvent) {
        this.editor.setItem(jCValueEvent.getNewValue());
        this.renderer.getComponent(this, jCValueEvent.getNewValue());
        super.processValueChanged(jCValueEvent);
    }

    public void setAbout(String string) {
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("NumberFormat must be non-null");
        }
        this.format = numberFormat;
    }

    public void setOperation(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("operation must be one of INTEGER or FLOATING_POINT");
        }
        if (this.operation == n2) {
            return;
        }
        int n3 = this.operation;
        this.operation = n2;
        this.firePropertyChange("operation", n3, n2);
    }

    public void setSpinStep(Number number) {
        this.step = number;
    }

    public void setValue(Number number) {
        if (number != null && (this.compare(number, this.max) > 0 || this.compare(number, this.min) < 0)) {
            return;
        }
        Number number2 = (Number)this.valueModel.getValue();
        if (number2 != null && this.compare(number, number2) == 0) {
            return;
        }
        this.valueModel.setValue(number);
    }

    public void setValueRange(Range range) {
        this.setValueRange(range.min, range.max);
    }

    public void setValueRange(Number number, Number number2) {
        if (this.compare(number, number2) > 0) {
            throw new IllegalArgumentException("Min must be less than Max");
        }
        this.max = number2;
        this.min = number;
    }

    protected Object spinDown() {
        Number number = (Number)this.valueModel.getValue();
        Number number2 = null;
        if (number == null) {
            number2 = this.step;
        } else if (this.operation == 1) {
            long l2 = number.longValue() - this.step.longValue();
            number2 = new Long(l2);
        } else {
            double d2 = number.doubleValue() - this.step.doubleValue();
            number2 = new Double(d2);
        }
        return number2;
    }

    protected Object spinUp() {
        Number number = (Number)this.valueModel.getValue();
        Number number2 = null;
        if (number == null) {
            number2 = this.step;
        } else if (this.operation == 1) {
            long l2 = number.longValue() + this.step.longValue();
            number2 = new Long(l2);
        } else {
            double d2 = number.doubleValue() + this.step.doubleValue();
            number2 = new Double(d2);
        }
        return number2;
    }

    public static class Range
    implements Serializable {
        public Number min;
        public Number max;

        public Range(Number number, Number number2) {
            this.max = number2;
            this.min = number;
        }
    }

    class NumberEditor
    extends JTextField
    implements JCSpinBoxEditor {
        NumberEditor() {
        }

        public Component getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return JCSpinNumberBox.this.parse(this.getText());
        }

        public void setItem(Object object) {
            if (object == null) {
                this.setText("");
            } else {
                this.setText(JCSpinNumberBox.this.format((Number)object));
            }
        }
    }

    static class NumberModel
    extends AbstractValueModel
    implements JCValueModel,
    Serializable {
        NumberModel() {
        }

        public Class getValueClass() {
            return class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = JCSpinNumberBox.class$("java.lang.Number"));
        }
    }
}

