/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.Version;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.DefaultSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBoxMutableModel;
import com.klg.jclass.util.value.JCValueEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JCSpinBox
extends AbstractSpinBox
implements ItemSelectable {
    protected JCSpinBoxModel model;
    protected JCListenerList itemListeners = null;
    protected JCListenerList actionListeners = null;
    protected String actionCommand = "spinBoxChanged";
    protected ListDataListener listDataListener = new ListListener();
    protected boolean modelChanging = false;
    protected KeySelectionManager keySelectionManager;
    protected Object lastSelectedItem = null;
    protected boolean firstPaint = true;

    public JCSpinBox() {
        this.setModel(new DefaultSpinBoxModel());
        this.updateUI();
    }

    public JCSpinBox(JCSpinBoxModel jCSpinBoxModel) {
        this.setModel(jCSpinBoxModel);
        this.setOpaque(true);
        this.updateUI();
    }

    public JCSpinBox(Vector vector) {
        this.setModel(new DefaultSpinBoxModel(vector));
        this.updateUI();
    }

    public JCSpinBox(Object[] objectArray) {
        this.setModel(new DefaultSpinBoxModel(objectArray));
        this.updateUI();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void addItem(Object object) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).addElement(object);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners = JCListenerList.add(this.itemListeners, itemListener);
    }

    protected void checkArrowButtons() {
    }

    protected void checkSpinBoxMutableModel() {
        if (!(this.model instanceof JCSpinBoxMutableModel)) {
            throw new InternalError("Cannot use this method with a non-Mutable data model.");
        }
    }

    public String getAbout() {
        return Version.getVersionString();
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Object getItemAt(int n2) {
        return this.model.getElementAt(n2);
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public JCSpinBoxModel getModel() {
        return this.model;
    }

    public int getSelectedIndex() {
        Object object = this.model.getSelectedItem();
        int n2 = 0;
        int n3 = this.model.getSize();
        while (n2 < n3) {
            Object e2 = this.model.getElementAt(n2);
            if (e2.equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (!this.isEditable() && this.selectWithKeyChar(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
    }

    public void insertItemAt(Object object, int n2) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).insertElementAt(object, n2);
    }

    protected void modelChanged() {
        ItemListener itemListener;
        Enumeration enumeration;
        ItemEvent itemEvent;
        this.modelChanging = true;
        this.editor.setItem(this.model.getSelectedItem());
        this.renderer.getComponent(this, this.model.getSelectedItem());
        this.modelChanging = false;
        Object object = this.model.getSelectedItem();
        if (this.lastSelectedItem != object && this.lastSelectedItem != null) {
            itemEvent = new ItemEvent(this, 701, this.lastSelectedItem, 2);
            enumeration = JCListenerList.elements(this.itemListeners);
            while (enumeration.hasMoreElements()) {
                itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
        this.lastSelectedItem = object;
        if (object != null) {
            itemEvent = new ItemEvent(this, 701, object, 1);
            enumeration = JCListenerList.elements(this.itemListeners);
            while (enumeration.hasMoreElements()) {
                itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (!this.isEditable() && this.firstPaint) {
            this.firstPaint = false;
            Object object = this.getModel().getSelectedItem();
            if (object == null) {
                object = this.getItemAt(0);
            }
            this.setValue(object);
        }
        super.paint(graphics);
    }

    protected int preferredWidthOfView() {
        int n2 = 10;
        int n3 = 0;
        while (n3 < this.getItemCount()) {
            Component component;
            if (this.isEditable()) {
                this.editor.setItem(this.getItemAt(n3));
                component = this.editor.getEditorComponent();
                n2 = Math.max(n2, component.getPreferredSize().width);
            } else {
                component = this.renderer.getComponent(this, this.getItemAt(n3));
                n2 = Math.max(n2, component.getPreferredSize().width + 8);
            }
            ++n3;
        }
        if (this.isEditable()) {
            this.editor.setItem(this.valueModel.getValue());
        } else {
            this.renderer.getComponent(this, this.valueModel.getValue());
        }
        return n2;
    }

    protected void processValueChanged(JCValueEvent jCValueEvent) {
        if (this.modelChanging) {
            JCDebug.println("spinbox", "valueChanged returns");
            return;
        }
        JCDebug.println("spinbox", "valueChanged setting selected item");
        this.model.setSelectedItem(jCValueEvent.getNewValue());
        super.processValueChanged(jCValueEvent);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void removeAllItems() {
        this.checkSpinBoxMutableModel();
        JCSpinBoxMutableModel jCSpinBoxMutableModel = (JCSpinBoxMutableModel)this.model;
        int n2 = jCSpinBoxMutableModel.getSize();
        if (jCSpinBoxMutableModel instanceof DefaultSpinBoxModel) {
            ((DefaultSpinBoxModel)jCSpinBoxMutableModel).removeAllElements();
        } else {
            int n3 = 0;
            while (n3 < n2) {
                Object e2 = jCSpinBoxMutableModel.getElementAt(0);
                jCSpinBoxMutableModel.removeElement(e2);
                ++n3;
            }
        }
    }

    public void removeItem(Object object) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).removeElement(object);
    }

    public void removeItemAt(int n2) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).removeElementAt(n2);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners = JCListenerList.remove(this.itemListeners, itemListener);
    }

    public boolean selectWithKeyChar(char c2) {
        int n2;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = new DefaultKeySelectionManager();
        }
        if ((n2 = this.keySelectionManager.selectionForKey(c2, this.getModel())) != -1) {
            this.setSelectedIndex(n2);
            return true;
        }
        return false;
    }

    public void setAbout(String string) {
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public void setModel(JCSpinBoxModel jCSpinBoxModel) {
        JCSpinBoxModel jCSpinBoxModel2 = this.model;
        if (this.model != null) {
            this.model.removeListDataListener(this.listDataListener);
        }
        this.model = jCSpinBoxModel;
        this.firePropertyChange("model", jCSpinBoxModel2, this.model);
        this.model.addListDataListener(this.listDataListener);
        if (!this.isEditable()) {
            this.setValue(this.model.getElementAt(0));
        }
        this.invalidate();
    }

    public void setSelectedIndex(int n2) {
        int n3 = this.model.getSize();
        if (n2 == -1) {
            this.setSelectedItem(null);
        } else {
            if (n2 < -1 || n2 >= n3) {
                throw new IllegalArgumentException("setSelectedIndex: " + n2 + " out of bounds");
            }
            this.setSelectedItem(this.model.getElementAt(n2));
        }
    }

    public void setSelectedItem(Object object) {
        this.setValue(object);
    }

    protected Object spinDown() {
        int n2 = this.getSelectedIndex();
        if (--n2 >= 0) {
            JCDebug.println("spinbox", "spinDown = " + this.getItemAt(n2));
            return this.getItemAt(n2);
        }
        JCDebug.println("spinbox", "spinDown = " + this.getItemAt(this.getItemCount() - 1));
        return this.getItemAt(this.getItemCount() - 1);
    }

    protected Object spinUp() {
        int n2 = this.getSelectedIndex();
        if (++n2 < this.getItemCount()) {
            JCDebug.println("spinbox", "spinUp = " + this.getItemAt(n2));
            return this.getItemAt(n2);
        }
        JCDebug.println("spinbox", "spinUp = " + this.getItemAt(0));
        return this.getItemAt(0);
    }

    class ListListener
    implements ListDataListener,
    Serializable {
        ListListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, JCSpinBoxModel var2);
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c2, JCSpinBoxModel jCSpinBoxModel) {
            String string;
            int n2;
            int n3;
            int n4 = -1;
            Object object = jCSpinBoxModel.getSelectedItem();
            if (object != null) {
                object = object.toString();
                n3 = 0;
                n2 = jCSpinBoxModel.getSize();
                while (n3 < n2) {
                    if (object.equals(jCSpinBoxModel.getElementAt(n3).toString())) {
                        n4 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            String string2 = String.valueOf(c2).toLowerCase();
            c2 = string2.charAt(0);
            n3 = ++n4;
            n2 = jCSpinBoxModel.getSize();
            while (n3 < n2) {
                string = jCSpinBoxModel.getElementAt(n3).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c2) {
                    return n3;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n4) {
                string = jCSpinBoxModel.getElementAt(n3).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c2) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
    }
}

