/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;

public class JCIconCreator {
    protected ImageIcon icon = null;
    protected int curRow;
    protected int width;
    protected int height;
    protected int[] colorMap = new int[256];
    protected int[] pixels;

    public JCIconCreator() {
        this.colorMap[32] = 0;
    }

    public JCIconCreator(int n2, int n3) {
        this.setSize(n2, n3);
    }

    public synchronized void clear() {
        if (this.width != 0 && this.height != 0) {
            this.pixels = new int[this.width * this.height];
        }
        this.icon = null;
        this.curRow = 0;
    }

    public synchronized ImageIcon getIcon() {
        if (this.pixels == null) {
            this.icon = null;
            return null;
        }
        if (this.icon == null) {
            MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
            this.icon = new ImageIcon(image);
        }
        return this.icon;
    }

    public static ImageIcon getIcon(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        return imageIcon;
    }

    public synchronized void setColor(char c2, int n2) {
        if (c2 < '\u0100') {
            this.colorMap[c2] = n2;
            this.icon = null;
        }
    }

    public synchronized void setColor(char c2, Color color) {
        this.setColor(c2, color == null ? 0 : color.getRGB());
    }

    public synchronized void setPixels(int n2, String string) {
        this.icon = null;
        if (string.length() != this.width) {
            return;
        }
        int n3 = 0;
        int n4 = n2 * this.width;
        while (n3 < this.width) {
            int n5;
            this.pixels[n3 + n4] = n5 = this.colorMap[string.charAt(n3)];
            ++n3;
        }
    }

    public synchronized void setPixels(String[] stringArray) {
        this.clear();
        int n2 = 0;
        while (n2 < stringArray.length && n2 < this.height) {
            this.setPixels(this.curRow++, stringArray[n2]);
            ++n2;
        }
        this.icon = null;
    }

    public synchronized void setSize(int n2, int n3) {
        if (n2 == this.width && n3 == this.height) {
            return;
        }
        this.width = n2;
        this.height = n3;
        this.pixels = (int[])(n2 == 0 && n3 == 0 ? null : new int[n2 * n3]);
        this.icon = null;
    }
}

