/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class JCGridLayout
extends GridLayout {
    protected int hgap;
    protected int vgap;
    protected int rows;
    protected int cols;
    protected int[] row_heights = new int[0];
    protected int[] col_widths = new int[0];
    public static final int VARIABLE = 0;

    public JCGridLayout(int n2, int n3) {
        this(n2, n3, 0, 0);
    }

    public JCGridLayout(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.rows = n2;
        this.cols = n3;
        this.hgap = n4;
        this.vgap = n5;
    }

    protected void getGridSizes(Container container, boolean bl) {
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        this.row_heights = new int[n3];
        this.col_widths = new int[n4];
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            Component component = container.getComponent(n5);
            Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
            int n7 = n5 / n4;
            if (dimension.height > this.row_heights[n7]) {
                this.row_heights[n7] = dimension.height;
            }
            if (dimension.width > this.col_widths[n6 = n5 % n4]) {
                this.col_widths[n6] = dimension.width;
            }
            ++n5;
        }
    }

    public void layoutContainer(Container container) {
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        Dimension dimension = container.getSize();
        int n5 = 0;
        int n6 = insets.left + this.hgap;
        while (n5 < n4) {
            int n7 = 0;
            int n8 = insets.top + this.vgap;
            while (n7 < n3) {
                int n9 = n7 * n4 + n5;
                if (n9 < n2) {
                    int n10 = Math.max(0, Math.min(this.col_widths[n5], dimension.width - insets.right - n6));
                    int n11 = Math.max(0, Math.min(this.row_heights[n7], dimension.height - insets.bottom - n8));
                    this.setBounds(n9, n7, n5, container.getComponent(n9), n6, n8, n10, n11);
                }
                n8 += this.row_heights[n7] + this.vgap;
                ++n7;
            }
            n6 += this.col_widths[n5] + this.hgap;
            ++n5;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, true);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    protected void setBounds(int n2, int n3, int n4, Component component, int n5, int n6, int n7, int n8) {
        component.setBounds(n5, n6, n7, n8);
    }

    final int sum(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            n2 += nArray[n3];
            ++n3;
        }
        return n2;
    }
}

