/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JComponent;

public abstract class JCFontChooser
extends JComponent {
    private JCListenerList fontListeners = null;
    private String name = "";
    private int size = 10;
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    protected Font oldFont;
    protected boolean oldUnderline;
    private String[] nameList;
    private static String[] sizeList = new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "24", "28", "32", "36", "48", "72"};
    private static final String DEFAULT_NAME = "Serif";
    private static final int DEFAULT_SIZE = 12;
    private static final int DEFAULT_STYLE = 0;
    public static final int NONE = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int ALL = 7;

    public JCFontChooser() {
        this(DEFAULT_NAME, 0, 12, false);
    }

    public JCFontChooser(Font font) {
        this(font.getName(), font.getStyle(), font.getSize(), JCFontChooser.isUnderline(font));
    }

    public JCFontChooser(Font font, boolean bl) {
        this(font.getName(), font.getStyle(), font.getSize(), bl);
    }

    public JCFontChooser(String string, int n2, int n3, boolean bl) {
        this.setFontValues(string, n2, n3, bl);
    }

    public synchronized void addJCFontListener(JCFontListener jCFontListener) {
        this.fontListeners = JCListenerList.add(this.fontListeners, jCFontListener);
    }

    protected void fireJCFontChangedEvent(JCFontEvent jCFontEvent) {
        Enumeration enumeration = JCListenerList.elements(this.fontListeners);
        while (enumeration.hasMoreElements()) {
            JCFontListener jCFontListener = (JCFontListener)enumeration.nextElement();
            jCFontListener.fontChanged(jCFontEvent);
        }
    }

    protected void fireJCFontChangingEvent(JCFontEvent jCFontEvent) {
        Enumeration enumeration = JCListenerList.elements(this.fontListeners);
        while (enumeration.hasMoreElements()) {
            JCFontListener jCFontListener = (JCFontListener)enumeration.nextElement();
            jCFontListener.fontChanging(jCFontEvent);
        }
    }

    protected String getFontName() {
        return this.name;
    }

    protected int getFontSize() {
        return this.size;
    }

    public String[] getNameList() {
        return this.nameList;
    }

    public Font getSelectedFont() {
        int n2 = 0;
        if (this.bold || this.italic) {
            if (this.bold) {
                ++n2;
            }
            if (this.italic) {
                n2 += 2;
            }
        } else {
            n2 = 0;
        }
        Font font = new Font(this.name, n2, this.size);
        Map<TextAttribute, ?> map = font.getAttributes();
        if (this.underline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        Font font2 = new Font(map);
        return font2;
    }

    protected static String[] getSizeList() {
        return sizeList;
    }

    protected boolean isBold() {
        return this.bold;
    }

    protected boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public static boolean isUnderline(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Object obj = map.get(TextAttribute.UNDERLINE);
        return obj != null && obj.equals(TextAttribute.UNDERLINE_ON);
    }

    public synchronized void removeJCFontListener(JCFontListener jCFontListener) {
        this.fontListeners = JCListenerList.remove(this.fontListeners, jCFontListener);
    }

    protected void setBold(boolean bl) {
        this.bold = bl;
    }

    protected void setFontName(String string) {
        this.name = string;
        if (string == null || string.length() == 0) {
            this.name = new String(DEFAULT_NAME);
        }
    }

    protected void setFontSize(int n2) {
        this.size = n2 > 0 ? n2 : 1;
    }

    protected void setFontValues(Font font, boolean bl) {
        this.setFontValues(font.getName(), font.getStyle(), font.getSize(), bl);
    }

    protected void setFontValues(String string, int n2, int n3, boolean bl) {
        this.setFontName(string);
        this.setFontSize(n3);
        this.bold = (n2 & 1) != 0;
        this.italic = (n2 & 2) != 0;
        this.setUnderline(bl);
    }

    protected void setItalic(boolean bl) {
        this.italic = bl;
    }

    protected void setNameList() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!(stringArray[n3].endsWith(".bold") || stringArray[n3].endsWith(".bolditalic") || stringArray[n3].endsWith(".italic"))) {
                ++n2;
            }
            ++n3;
        }
        this.nameList = new String[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (!(stringArray[n5].endsWith(".bold") || stringArray[n5].endsWith(".bolditalic") || stringArray[n5].endsWith(".italic"))) {
                this.nameList[n4++] = stringArray[n5];
            }
            ++n5;
        }
    }

    protected void setNameList(String[] stringArray) {
        this.nameList = stringArray;
    }

    protected void setOldFont() {
        this.oldFont = this.getSelectedFont();
        this.oldUnderline = this.isUnderline();
    }

    protected void setSelectedFont(Font font) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize(), JCFontChooser.isUnderline(font));
    }

    protected void setSelectedFont(Font font, boolean bl) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize(), bl);
    }

    protected void setSelectedFont(String string, int n2, int n3, boolean bl) {
        this.setFontValues(string, n2, n3, bl);
    }

    public static Font setUnderline(Font font, boolean bl) {
        Map<TextAttribute, ?> map = font.getAttributes();
        try {
            map.remove(TextAttribute.UNDERLINE);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        if (bl) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        return new Font(map);
    }

    protected void setUnderline(boolean bl) {
        this.underline = bl;
    }
}

