/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.swing.JCElastic;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;

public class JCElasticLayout
implements LayoutManager2,
Serializable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final JCElastic HORIZONTALLY_ELASTIC_CONSTRAINT = new Elastic(1, 0);
    public static final JCElastic VERTICALLY_ELASTIC_CONSTRAINT = new Elastic(0, 1);
    public static final JCElastic COMPLETELY_ELASTIC_CONSTRAINT = new Elastic(1, 1);
    public static final String HORIZONTALLY_ELASTIC_TAG = "HorizontallyElastic";
    public static final String VERTICALLY_ELASTIC_TAG = "VerticallyElastic";
    public static final String COMPLETELY_ELASTIC_TAG = "CompletelyElastic";
    protected static final int NOT_ELASTIC = 0;
    protected static final int VERTICALLY_ELASTIC = 1;
    protected static final int HORIZONTALLY_ELASTIC = 2;
    protected int alignment;
    protected int orientation;
    protected HashMap constraintMap = new HashMap();
    protected static HashMap constraintCache = null;

    public JCElasticLayout(int n2) {
        this(n2, n2 == 1 ? 2 : 1);
    }

    public JCElasticLayout(int n2, int n3) {
        this.orientation = n2;
        if (n3 != 2 && n3 != 1 && n3 != 0 && n3 != 3 && n3 != 4) {
            throw new IllegalArgumentException("Incorrect value; use one of: SwingConstants.LEFT, SwingConstants.CENTER, SwingConstants.RIGHT");
        }
        this.alignment = n3;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof JCElastic)) {
            throw new IllegalArgumentException("constraint must be null or an instance of JCElastic");
        }
        this.constraintMap.put(component, object);
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals(HORIZONTALLY_ELASTIC_TAG)) {
            this.addLayoutComponent(component, HORIZONTALLY_ELASTIC_CONSTRAINT);
        } else if (string.equals(VERTICALLY_ELASTIC_TAG)) {
            this.addLayoutComponent(component, VERTICALLY_ELASTIC_CONSTRAINT);
        } else if (string.equals(COMPLETELY_ELASTIC_TAG)) {
            this.addLayoutComponent(component, COMPLETELY_ELASTIC_CONSTRAINT);
        }
    }

    protected int calcStretch(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = n4;
        while (n7 < n4 + n3) {
            n6 += n2 + (n7 < n5 ? 1 : 0);
            ++n7;
        }
        return n6;
    }

    public static JCElastic createElasticConstraint(int n2, int n3) {
        Elastic elastic;
        if (constraintCache == null) {
            constraintCache = new HashMap();
        }
        if (constraintCache.containsKey(elastic = new Elastic(n2, n3))) {
            return (JCElastic)constraintCache.get(elastic);
        }
        constraintCache.put(elastic, elastic);
        return elastic;
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected JCElastic getElastic(Component component) {
        JCElastic jCElastic = null;
        if (component instanceof JCElastic) {
            jCElastic = (JCElastic)((Object)component);
        } else {
            Object v2 = this.constraintMap.get(component);
            if (v2 != null && v2 instanceof JCElastic) {
                jCElastic = (JCElastic)v2;
            }
        }
        return jCElastic;
    }

    protected int getElasticity(Component component) {
        int n2 = 0;
        JCElastic jCElastic = this.getElastic(component);
        if (jCElastic != null) {
            if (this.orientation == 0) {
                n2 = jCElastic.getHorizontalElasticity();
            } else if (this.orientation == 1) {
                n2 = jCElastic.getVerticalElasticity();
            }
        }
        return n2;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    protected int getPreferredLayoutSize(Container container, Dimension dimension) {
        int n2;
        int n3 = container.getComponentCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.orientation == 1) {
            n2 = 0;
            while (n2 < n3) {
                Component component = container.getComponent(n2);
                Dimension dimension2 = component.getPreferredSize();
                n4 = Math.max(n4, dimension2.width);
                n5 += dimension2.height;
                n6 = this.getElasticity(component);
                if (n6 != 0) {
                    n7 += n6;
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < n3) {
                Component component = container.getComponent(n2);
                Dimension dimension3 = component.getPreferredSize();
                n5 = Math.max(n5, dimension3.height);
                n4 += dimension3.width;
                n6 = this.getElasticity(component);
                if (n6 != 0) {
                    n7 += n6;
                }
                ++n2;
            }
        }
        Insets insets = container.getInsets();
        n4 = n4 + insets.right + insets.left;
        n5 = n5 + insets.top + insets.bottom;
        if (dimension != null) {
            dimension.width = n4;
            dimension.height = n5;
        }
        return n7;
    }

    public void invalidateLayout(Container container) {
    }

    protected boolean isDim1Elastic(Component component) {
        if (this.orientation == 1) {
            return this.isHorizontallyElastic(component);
        }
        return this.isVerticallyElastic(component);
    }

    protected boolean isHorizontallyElastic(Component component) {
        JCElastic jCElastic = this.getElastic(component);
        return jCElastic != null && jCElastic.getHorizontalElasticity() != 0;
    }

    protected boolean isVerticallyElastic(Component component) {
        JCElastic jCElastic = this.getElastic(component);
        return jCElastic != null && jCElastic.getVerticalElasticity() != 0;
    }

    public void layoutContainer(Container container) {
        int n2;
        int n3;
        int n4;
        Dimension dimension = new Dimension();
        int n5 = this.getPreferredLayoutSize(container, dimension);
        Dimension dimension2 = container.getSize();
        Insets insets = container.getInsets();
        dimension2.height -= insets.bottom;
        dimension2.width -= insets.right;
        dimension.height -= insets.bottom;
        dimension.width -= insets.right;
        if (this.orientation == 1) {
            n4 = dimension2.height - dimension.height;
            n3 = insets.left;
            n2 = insets.top;
        } else {
            n4 = dimension2.width - dimension.width;
            n3 = insets.top;
            n2 = insets.left;
        }
        int n6 = 0;
        int n7 = 0;
        if (n5 > 0) {
            n6 = n4 / n5;
            n7 = n4 % n5;
        }
        JCDebug.println("elastic", "ElasticLayout.layout(" + (container.getName() != null ? container.getName() : container.getClass().getName()) + ") to width = " + dimension2.width + "; height = " + dimension2.height);
        JCDebug.println("elastic", "\telastic_count = " + n5 + "; slice = " + n6 + "; fatter_slice_count = " + n7);
        int n8 = container.getComponentCount();
        int n9 = n2;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n8) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            Component component = container.getComponent(n11);
            int n17 = 0;
            if (this.orientation == 1) {
                n16 = dimension2.width - n3;
                n15 = dimension2.height - n2;
                n14 = component.getMaximumSize().width;
                if (n14 < 0) {
                    n14 = component.getPreferredSize().width;
                }
                n13 = component.getPreferredSize().height;
            } else {
                n16 = dimension2.height - n3;
                n15 = dimension2.width - n2;
                n14 = component.getMaximumSize().height;
                if (n14 < 0) {
                    n14 = component.getPreferredSize().height;
                }
                n13 = component.getPreferredSize().width;
            }
            n17 = Math.min(n16, n14);
            int n18 = n3;
            if (n17 != n16) {
                if (this.isDim1Elastic(component)) {
                    n18 = 0;
                    n17 = n16;
                } else if (this.alignment == 2 || this.alignment == 1) {
                    n18 = 0;
                } else if (this.alignment == 0) {
                    n18 = (n16 - n17) / 2;
                } else if (this.alignment == 4 || this.alignment == 3) {
                    n18 = n16 - n17;
                }
            }
            if ((n12 = this.getElasticity(component)) > 0) {
                int n19 = this.calcStretch(n6, n12, n10, n7);
                if (this.orientation == 1) {
                    component.setBounds(n18, n9, n17, n13 + n19);
                    JCDebug.println("elastic", "\tDim2 is Elastic " + (component.getName() != null ? component.getName() : component.getClass().getName()) + "; x = " + n18 + "; y = " + n9 + "; w = " + n17 + "; h = " + (n13 + n19));
                } else {
                    component.setBounds(n9, n18, n13 + n19, n17);
                    JCDebug.println("elastic", "\tDim2 is Elastic " + (component.getName() != null ? component.getName() : component.getClass().getName()) + "; x = " + n9 + "; y = " + n18 + "; w = " + (n13 + n19) + "; h = " + n17);
                }
                n10 += n12;
                n9 += n13 + n19;
            } else {
                JCDebug.println("elastic", "\tDim2 is Normal : " + (component.getName() != null ? component.getName() : component.getClass().getName()) + "; x = " + n18 + "; y = " + n9 + "; w = " + n17 + "; h = " + n13);
                if (this.orientation == 1) {
                    component.setBounds(n18, n9, n17, n13);
                } else {
                    component.setBounds(n9, n18, n13, n17);
                }
                n9 += n13;
            }
            ++n11;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        int n2 = container.getComponentCount();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            Component component = container.getComponent(n5);
            Dimension dimension = component.getMaximumSize();
            if (this.orientation == 1) {
                n3 = Math.max(n3, dimension.width);
                n4 += dimension.height;
            } else {
                n4 = Math.max(n4, dimension.height);
                n3 += dimension.width;
            }
            ++n5;
        }
        return new Dimension(n3, n4);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n2 = container.getComponentCount();
        int n3 = 0;
        int n4 = 0;
        if (this.orientation == 1) {
            int n5 = 0;
            while (n5 < n2) {
                Component component = container.getComponent(n5);
                Dimension dimension = component.getMinimumSize();
                n3 = Math.max(n3, dimension.width);
                n4 += dimension.height;
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                Component component = container.getComponent(n6);
                Dimension dimension = component.getMinimumSize();
                n4 = Math.max(n4, dimension.height);
                n3 += dimension.width;
                ++n6;
            }
        }
        return new Dimension(n3, n4);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        this.getPreferredLayoutSize(container, dimension);
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
        if (this.constraintMap.containsKey(component)) {
            this.constraintMap.remove(component);
        }
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    static class Elastic
    implements JCElastic,
    Serializable {
        protected int horizontal;
        protected int vertical;

        public Elastic(int n2, int n3) {
            this.horizontal = n2;
            this.vertical = n3;
        }

        public int getHorizontalElasticity() {
            return this.horizontal;
        }

        public int getVerticalElasticity() {
            return this.vertical;
        }
    }
}

