/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCIntComparator;
import com.klg.jclass.util.JCMappingSort;
import com.klg.jclass.util.swing.DefaultRowComparator;
import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DefaultRowSortTableModel
extends AbstractTableModel
implements JCRowSortTableModel,
TableModelListener {
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    protected int order = 1;
    protected TableModel tableModel = null;
    protected int sortColumn = -1;
    protected int[] indices = null;
    protected JCRowComparator rowComparator = null;
    protected int[][] keyColumnsArray;
    protected RowIntComparator rowIntComparator = null;
    protected boolean autoSort = false;
    protected boolean needsResorting = true;
    protected boolean needsReordering = true;

    public DefaultRowSortTableModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public DefaultRowSortTableModel(TableModel tableModel, JCRowComparator jCRowComparator) {
        this(tableModel);
        this.rowComparator = jCRowComparator;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public Class getColumnClass(int n2) {
        return this.tableModel.getColumnClass(n2);
    }

    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public String getColumnName(int n2) {
        return this.tableModel.getColumnName(n2);
    }

    public JCRowComparator getComparator() {
        return this.rowComparator;
    }

    public int[] getKeyColumns(int n2) {
        return this.keyColumnsArray[n2];
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getSortOrder() {
        return this.order;
    }

    public int getUnsortedRow(int n2) {
        if (this.indices == null) {
            return n2;
        }
        if (this.order == 1) {
            return this.indices[n2];
        }
        return this.indices[this.indices.length - n2 - 1];
    }

    public Object getValueAt(int n2, int n3) {
        return this.tableModel.getValueAt(this.indices == null ? n2 : this.indices[this.order == 1 ? n2 : this.indices.length - n2 - 1], n3);
    }

    public boolean isCellEditable(int n2, int n3) {
        return this.tableModel.isCellEditable(n2, n3);
    }

    public boolean isDataSorted() {
        return this.indices != null && !this.needsReordering && !this.needsResorting;
    }

    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        if (bl) {
            this.setDataSorted(true);
        }
    }

    public void setComparator(JCRowComparator jCRowComparator) {
        if (this.rowComparator == jCRowComparator) {
            return;
        }
        this.rowComparator = jCRowComparator;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void setDataSorted(boolean bl) {
        if (!bl) {
            this.unsort();
            return;
        }
        if (this.sortColumn == -1) {
            return;
        }
        if (!this.needsReordering && !this.needsResorting) {
            return;
        }
        if (this.needsResorting) {
            if (this.rowComparator == null) {
                this.rowComparator = new DefaultRowComparator(1);
            }
            if (this.keyColumnsArray == null) {
                this.keyColumnsArray = new int[this.tableModel.getColumnCount()][];
            }
            int[] nArray = new int[]{this.sortColumn};
            this.rowComparator.setKeyColumns(this.keyColumnsArray[this.sortColumn] != null ? this.keyColumnsArray[this.sortColumn] : nArray);
            this.setComparator(this.rowComparator);
            if (this.rowIntComparator == null) {
                this.rowIntComparator = new RowIntComparator();
            }
            if (this.indices == null) {
                this.indices = new int[this.tableModel.getRowCount()];
                int n2 = 0;
                while (n2 < this.indices.length) {
                    this.indices[n2] = n2;
                    ++n2;
                }
            }
            JCMappingSort.sort(this.rowIntComparator, this.indices);
            this.needsResorting = false;
        }
        this.needsReordering = false;
        this.fireTableDataChanged();
    }

    public void setKeyColumns(int n2, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.tableModel.getColumnCount()][];
        }
        this.keyColumnsArray[n2] = nArray;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == this.tableModel) {
            return;
        }
        this.tableModel = tableModel;
        tableModel.addTableModelListener(this);
    }

    public void setSortColumn(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Sorting column number is less than 0");
        }
        if (this.sortColumn == n2) {
            return;
        }
        this.sortColumn = n2;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void setSortOrder(int n2) {
        if (n2 == this.order) {
            return;
        }
        this.order = n2;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void setValueAt(Object object, int n2, int n3) {
        this.tableModel.setValueAt(object, this.indices == null ? n2 : this.indices[this.order == 1 ? n2 : this.indices.length - n2 - 1], n3);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.autoSort) {
            this.indices = null;
            this.needsResorting = true;
            this.setDataSorted(true);
        } else {
            this.unsort();
        }
    }

    public void toggleSortOrder() {
        this.order = this.order == 1 ? -1 : 1;
        this.needsReordering = true;
    }

    public void unsort() {
        if (this.indices != null) {
            this.indices = null;
            this.sortColumn = -1;
        }
        this.fireTableDataChanged();
    }

    class ComparableRow
    implements JCComparableRow {
        private int row = -1;

        ComparableRow() {
        }

        static /* synthetic */ int access$0(ComparableRow comparableRow) {
            return comparableRow.row;
        }

        public int getRowIndex() {
            return this.row;
        }

        public Object getValueAt(int n2) {
            return DefaultRowSortTableModel.this.tableModel.getValueAt(this.row, n2);
        }
    }

    class RowIntComparator
    implements JCIntComparator {
        private ComparableRow r1;
        private ComparableRow r2;

        RowIntComparator() {
            this.r1 = new ComparableRow();
            this.r2 = new ComparableRow();
        }

        public int compare(int n2, int n3) {
            this.r1.row = n2;
            this.r2.row = n3;
            return DefaultRowSortTableModel.this.rowComparator.compare(this.r1, this.r2);
        }
    }
}

