/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.legend;

import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class JCGridLegend
extends JCLegend {
    public int[] rowHeights;
    public int[] rowFirstLineHeights;
    public int[] colWidths;
    public int[] symWidths;
    public int[] strWidths;
    protected int marginGap = 2;
    protected int itemGap = 2;
    protected int insideItemGap = 2;
    protected int groupGap = 5;

    public Dimension calcLegendSize(boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        while (n2 < this.colWidths.length) {
            dimension.width += this.colWidths[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.rowHeights.length) {
            dimension.height += this.rowHeights[n3];
            ++n3;
        }
        if (bl) {
            dimension.width += (this.colWidths.length - 1) * this.getGroupGap();
            dimension.width += 2 * this.getMarginGap();
            dimension.height += (this.rowHeights.length - 1) * this.getItemGap();
            dimension.height += 2 * this.getMarginGap();
        } else {
            dimension.width += (this.colWidths.length - 1) * this.getItemGap();
            dimension.width += 2 * this.getMarginGap();
            dimension.height += (this.rowHeights.length - 1) * this.getGroupGap();
            dimension.height += 2 * this.getMarginGap();
        }
        return dimension;
    }

    Point centerItemComponentVertically(boolean bl, Dimension dimension, int n2, Point point) {
        Point point2 = new Point(point.x, point.y);
        if (n2 - point.y > dimension.height) {
            point2.y += (int)Math.ceil((double)(n2 - point.y - dimension.height) / 2.0);
        }
        return point2;
    }

    public void fillSizeArrays(List list, boolean bl, Font font) {
        int n2;
        int n3 = list.size();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n4 = Math.max(n4, ((List)list.get(n5)).size());
            ++n5;
        }
        this.rowHeights = new int[bl ? n4 : n3];
        int n6 = 0;
        while (n6 < this.rowHeights.length) {
            this.rowHeights[n6] = 0;
            ++n6;
        }
        this.rowFirstLineHeights = new int[bl ? n4 : n3];
        int n7 = 0;
        while (n7 < this.rowFirstLineHeights.length) {
            this.rowFirstLineHeights[n7] = 0;
            ++n7;
        }
        this.colWidths = new int[bl ? n3 : n4];
        int n8 = 0;
        while (n8 < this.colWidths.length) {
            this.colWidths[n8] = 0;
            ++n8;
        }
        this.symWidths = new int[bl ? n3 : n4];
        int n9 = 0;
        while (n9 < this.symWidths.length) {
            this.symWidths[n9] = 0;
            ++n9;
        }
        this.strWidths = new int[bl ? n3 : n4];
        int n10 = 0;
        while (n10 < this.strWidths.length) {
            this.strWidths[n10] = 0;
            ++n10;
        }
        int n11 = 0;
        while (n11 < n3) {
            List list2 = (List)list.get(n11);
            n2 = 0;
            while (n2 < list2.size()) {
                JCLegendItem jCLegendItem = (JCLegendItem)list2.get(n2);
                Dimension dimension = null;
                if (jCLegendItem.contents instanceof String) {
                    if (jCLegendItem.textDim != null) {
                        dimension = TextRenderer.isHTML((String)jCLegendItem.contents) ? JCLegend.textRend.calcHTMLLineSize((String)jCLegendItem.contents, jCLegendItem.textDim.width, jCLegendItem.textDim.height) : new Dimension(jCLegendItem.textDim.width, this.ascent);
                    }
                } else if (jCLegendItem.textDim != null) {
                    dimension = new Dimension(jCLegendItem.textDim.width, jCLegendItem.textDim.height);
                }
                if (bl) {
                    if (this.isTitleItem(jCLegendItem)) {
                        if (jCLegendItem.textDim != null && this.colWidths[n11] < jCLegendItem.textDim.width) {
                            this.colWidths[n11] = jCLegendItem.textDim.width;
                        }
                    } else {
                        if (jCLegendItem.symbolDim != null && this.symWidths[n11] < jCLegendItem.symbolDim.width) {
                            this.symWidths[n11] = jCLegendItem.symbolDim.width;
                        }
                        if (jCLegendItem.textDim != null && this.strWidths[n11] < jCLegendItem.textDim.width) {
                            this.strWidths[n11] = jCLegendItem.textDim.width;
                        }
                    }
                    if (jCLegendItem.symbolDim != null && this.rowHeights[n2] < jCLegendItem.symbolDim.height) {
                        this.rowHeights[n2] = jCLegendItem.symbolDim.height;
                    }
                    if (jCLegendItem.textDim != null && this.rowHeights[n2] < jCLegendItem.textDim.height) {
                        this.rowHeights[n2] = jCLegendItem.textDim.height;
                    }
                    if (dimension != null && this.rowFirstLineHeights[n2] < dimension.height) {
                        this.rowFirstLineHeights[n2] = dimension.height;
                    }
                } else {
                    if (jCLegendItem.symbolDim != null && this.rowHeights[n11] < jCLegendItem.symbolDim.height) {
                        this.rowHeights[n11] = jCLegendItem.symbolDim.height;
                    }
                    if (jCLegendItem.textDim != null && this.rowHeights[n11] < jCLegendItem.textDim.height) {
                        this.rowHeights[n11] = jCLegendItem.textDim.height;
                    }
                    if (dimension != null && this.rowFirstLineHeights[n11] < dimension.height) {
                        this.rowFirstLineHeights[n11] = dimension.height;
                    }
                    if (jCLegendItem.symbolDim != null && this.symWidths[n2] < jCLegendItem.symbolDim.width) {
                        this.symWidths[n2] = jCLegendItem.symbolDim.width;
                    }
                    if (jCLegendItem.textDim != null && this.strWidths[n2] < jCLegendItem.textDim.width) {
                        this.strWidths[n2] = jCLegendItem.textDim.width;
                    }
                }
                ++n2;
            }
            ++n11;
        }
        int n12 = 0;
        while (n12 < this.colWidths.length) {
            n2 = this.symWidths[n12] + this.strWidths[n12];
            if (this.symWidths[n12] != 0 && this.strWidths[n12] != 0) {
                n2 += this.getInsideItemGap();
            }
            if (this.colWidths[n12] < n2) {
                this.colWidths[n12] = n2;
            }
            ++n12;
        }
    }

    public int getGroupGap() {
        return this.groupGap;
    }

    public int getInsideItemGap() {
        return this.insideItemGap;
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public int getMarginGap() {
        return this.marginGap;
    }

    public Dimension layoutLegend(List list, boolean bl, Font font) {
        this.fillSizeArrays(list, bl, font);
        Dimension dimension = this.calcLegendSize(bl);
        this.layoutLegendItems(list, bl);
        return dimension;
    }

    public void layoutLegendItems(List list, boolean bl) {
        boolean bl2 = false;
        int n2 = this.getMarginGap();
        int n3 = 0;
        while (n3 < list.size()) {
            List list2 = (List)list.get(n3);
            int n4 = this.getMarginGap();
            int n5 = 0;
            while (n5 < list2.size()) {
                JCLegendItem jCLegendItem = (JCLegendItem)list2.get(n5);
                jCLegendItem.pos = new Point(bl ? n2 : n4, bl ? n4 : n2);
                jCLegendItem.dim = new Dimension(bl ? this.colWidths[n3] : this.colWidths[n5], bl ? this.rowHeights[n5] : this.rowHeights[n3]);
                if (this.isTitleItem(jCLegendItem)) {
                    jCLegendItem.textPos = this.positionItemText(bl, jCLegendItem, jCLegendItem.dim, new Point(0, 0));
                } else {
                    jCLegendItem.symbolPos = this.positionItemSymbol(bl, jCLegendItem, new Dimension(0, bl ? this.rowFirstLineHeights[n5] : this.rowFirstLineHeights[n3]), new Point(0, 0));
                    jCLegendItem.textPos = this.positionItemText(bl, jCLegendItem, new Dimension(0, bl ? this.rowFirstLineHeights[n5] : this.rowFirstLineHeights[n3]), new Point(this.getInsideItemGap() + (bl ? this.symWidths[n3] : this.symWidths[n5]), 0));
                }
                jCLegendItem.pickRectangle = new Rectangle(jCLegendItem.pos.x, jCLegendItem.pos.y, jCLegendItem.dim.width, jCLegendItem.dim.height);
                if (n5 != list2.size() - 1) {
                    if (bl) {
                        jCLegendItem.pickRectangle.height += this.getItemGap();
                    } else {
                        jCLegendItem.pickRectangle.width += this.getItemGap();
                    }
                }
                if (n3 != list.size() - 1) {
                    if (bl) {
                        jCLegendItem.pickRectangle.width += this.getGroupGap();
                    } else {
                        jCLegendItem.pickRectangle.height += this.getGroupGap();
                    }
                }
                n4 += (bl ? this.rowHeights[n5] : this.colWidths[n5]) + this.getItemGap();
                ++n5;
            }
            n2 += (bl ? this.colWidths[n3] : this.rowHeights[n3]) + this.getGroupGap();
            ++n3;
        }
    }

    public Point positionItemSymbol(boolean bl, JCLegendItem jCLegendItem, Dimension dimension, Point point) {
        if (bl) {
            if (jCLegendItem.symbolDim.height < dimension.height) {
                return this.centerItemComponentVertically(bl, jCLegendItem.symbolDim, dimension.height, point);
            }
            return point;
        }
        return this.centerItemComponentVertically(bl, jCLegendItem.symbolDim, jCLegendItem.dim.height, point);
    }

    public Point positionItemText(boolean bl, JCLegendItem jCLegendItem, Dimension dimension, Point point) {
        if (bl) {
            if (jCLegendItem.textDim.height < dimension.height) {
                return this.centerItemComponentVertically(bl, jCLegendItem.textDim, dimension.height, point);
            }
            return point;
        }
        return this.centerItemComponentVertically(bl, jCLegendItem.textDim, jCLegendItem.dim.height, point);
    }

    public void setGroupGap(int n2) {
        this.groupGap = n2;
        this.setChanged(true, 2);
    }

    public void setInsideItemGap(int n2) {
        this.insideItemGap = n2;
        this.setChanged(true, 2);
    }

    public void setItemGap(int n2) {
        this.itemGap = n2;
        this.setChanged(true, 2);
    }

    public void setMarginGap(int n2) {
        this.marginGap = n2;
        this.setChanged(true, 2);
    }
}

