/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.swing.JCSpinNumberBox;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Locale;

public class YearSpin
extends JCSpinNumberBox
implements CalendarComponent {
    protected JCValueModel calendarModel;
    protected JCCalendar specialDates;
    protected Locale locale;
    protected boolean ignoreChange = false;
    protected JCValueListener l = new ModelConduit();
    protected JCListenerList actionListeners = null;

    public YearSpin(JCValueModel jCValueModel, Locale locale) {
        this.setLocale(locale);
        this.setValueRange(new JCSpinNumberBox.Range(new Integer(0), new Integer(9999)));
        this.setCalendarModel(jCValueModel);
        this.setNumberFormat(new DecimalFormat("#"));
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        Calendar calendar = (Calendar)jCValueModel.getValue();
        if (calendar != null) {
            int n2 = calendar.get(1);
            this.ignoreChange = true;
            this.setValue(new Integer(n2));
            this.ignoreChange = false;
        } else {
            this.ignoreChange = true;
            this.setValue(null);
            this.ignoreChange = false;
        }
        if (this.calendarModel != null) {
            this.calendarModel.removeValueListener(this.l);
        }
        jCValueModel.addValueListener(this.l);
        this.valueModel.addValueListener(this.l);
        this.calendarModel = jCValueModel;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
        this.specialDates = jCCalendar;
    }

    class ModelConduit
    implements JCValueListener,
    Serializable {
        public void valueChanged(JCValueEvent jCValueEvent) {
            if (!YearSpin.this.ignoreChange && jCValueEvent.getSource() == YearSpin.this.calendarModel) {
                Calendar calendar = (Calendar)jCValueEvent.getNewValue();
                int n2 = calendar.get(1);
                if (YearSpin.this.getValue().intValue() != n2) {
                    YearSpin.this.ignoreChange = true;
                    YearSpin.this.setValue(new Integer(n2));
                    YearSpin.this.ignoreChange = false;
                }
            } else if (!YearSpin.this.ignoreChange && jCValueEvent.getSource() == YearSpin.this.getValueModel()) {
                Calendar calendar = JCCalendar.copyCalendar((Calendar)YearSpin.this.calendarModel.getValue());
                calendar.set(1, YearSpin.this.getValue().intValue());
                YearSpin.this.ignoreChange = true;
                YearSpin.this.calendarModel.setValue(calendar);
                YearSpin.this.ignoreChange = false;
            }
        }

        public void valueChanging(JCValueEvent jCValueEvent) {
        }
    }
}

