/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MonthTable
extends JTable
implements CalendarComponent,
MouseListener {
    transient JCLocaleManager li = JCLocaleManager.getDefault();
    protected Locale locale = null;
    protected JCValueModel calendarModel;
    protected MonthModel monthModel;
    protected int selectedMonth = 0;
    protected String[] months = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    protected JCListenerList actionListeners = null;
    static /* synthetic */ Class class$java$lang$String;

    public MonthTable(JCValueModel jCValueModel, Locale locale) {
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDefaultRenderer(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MonthTable.class$("java.lang.String")), new Renderer());
        this.setLocale(locale);
        int n2 = 0;
        while (n2 < this.months.length) {
            this.months[n2] = this.li.getString("Month" + n2);
            ++n2;
        }
        this.setCalendarModel(jCValueModel);
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        this.setRowHeight((fontMetrics.getAscent() + fontMetrics.getDescent()) * 2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JCValueModel getCalendarModel() {
        return this.calendarModel;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.months.length) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.months[n3]));
            ++n3;
        }
        return new Dimension(n2 * 6, this.getRowHeight() * 2);
    }

    public JCCalendar getSpecialDates(JCCalendar jCCalendar) {
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = this.rowAtPoint(mouseEvent.getPoint());
        int n3 = this.columnAtPoint(mouseEvent.getPoint());
        int n4 = n2 * 6 + n3;
        Calendar calendar = JCCalendar.copyCalendar((Calendar)this.calendarModel.getValue());
        calendar.set(2, n4);
        this.calendarModel.setValue(calendar);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (this.monthModel != null && this.calendarModel != null) {
            this.calendarModel.removeValueListener(this.monthModel);
        }
        this.calendarModel = jCValueModel;
        this.calendarModel.addValueListener(this.monthModel);
        this.repaint();
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        if (this.monthModel != null && this.calendarModel != null) {
            this.calendarModel.removeValueListener(this.monthModel);
        }
        this.monthModel = new MonthModel(locale);
        if (this.calendarModel != null) {
            this.calendarModel.addValueListener(this.monthModel);
        }
        this.setModel(this.monthModel);
        this.repaint();
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
    }

    class Renderer
    extends JLabel
    implements TableCellRenderer {
        protected Border bevel = new SoftBevelBorder(1);
        protected Border empty = new EmptyBorder(0, 0, 0, 0);

        Renderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            this.setHorizontalAlignment(0);
            Calendar calendar = (Calendar)MonthTable.this.calendarModel.getValue();
            int n4 = calendar.get(2);
            if (n4 == n3 + n2 * MonthTable.this.getColumnCount()) {
                this.setForeground(UIManager.getColor("TextField.selectionForeground"));
                this.setBackground(UIManager.getColor("TextField.selectionBackground"));
                this.setBorder(this.bevel);
                this.setOpaque(true);
            } else {
                this.setBackground(UIManager.getColor("Label.background"));
                this.setForeground(UIManager.getColor("Label.foreground"));
                this.setBorder(this.empty);
                this.setOpaque(true);
            }
            this.setText((String)object);
            return this;
        }
    }

    class MonthModel
    implements TableModel,
    JCValueListener,
    Serializable {
        protected JCListenerList tableListeners = null;
        protected int numRows = 2;

        public MonthModel(Locale locale) {
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
        }

        private Calendar copyCalendar(Calendar calendar) {
            if (calendar == null) {
                return null;
            }
            return (Calendar)calendar.clone();
        }

        public Class getColumnClass(int n2) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = MonthTable.class$("java.lang.String"));
        }

        public int getColumnCount() {
            return MonthTable.this.months.length / this.numRows;
        }

        public String getColumnName(int n2) {
            return null;
        }

        public int getRowCount() {
            return this.numRows;
        }

        public Object getValueAt(int n2, int n3) {
            return MonthTable.this.months[n3 + n2 * this.getColumnCount()];
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
        }

        public void setValueAt(Object object, int n2, int n3) {
            throw new IllegalArgumentException("This TableModel is READ ONLY");
        }

        public void valueChanged(JCValueEvent jCValueEvent) {
            if (jCValueEvent == null) {
                return;
            }
            TableModelEvent tableModelEvent = new TableModelEvent(this);
            Enumeration enumeration = JCListenerList.elements(this.tableListeners);
            while (enumeration.hasMoreElements()) {
                TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
                tableModelListener.tableChanged(tableModelEvent);
            }
        }

        public void valueChanging(JCValueEvent jCValueEvent) {
        }
    }
}

