/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.calendar.SpecialDate;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class JCCalendar {
    protected Vector specialDates = new Vector(0);
    protected static final byte[][] daytable = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};

    public void addSpecialDate(SpecialDate specialDate) {
        this.specialDates.add(specialDate);
    }

    public static Calendar copyCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return (Calendar)calendar.clone();
    }

    public static int dayOfWeek(int n2, int n3, int n4) {
        if (n3 == 0 || n3 == 1) {
            --n4;
        }
        int n5 = n4 % 100;
        int n6 = n4 / 100;
        int n7 = (n3 + 10) % 12 + 1;
        int n8 = (int)((double)n2 + Math.floor(2.6 * (double)n7 - 0.2) - (double)(2 * n6) + (double)n5 + Math.floor(n5 / 4) + Math.floor(n6 / 4)) % 7;
        n8 = (n8 + 7) % 7;
        return n8;
    }

    public static int daysInMonth(int n2, int n3) {
        int n4 = JCCalendar.isLeapYear(n3) ? 1 : 0;
        return daytable[n4][n2];
    }

    protected int isInSpecialDateList(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n6 < this.specialDates.size()) {
            SpecialDate specialDate = (SpecialDate)this.specialDates.elementAt(n6);
            if (specialDate.isSpecialDate(n2, n3, n4, n5)) {
                return n6;
            }
            ++n6;
        }
        return -1;
    }

    public static boolean isLeapYear(int n2) {
        boolean bl = false;
        if (n2 % 100 == 0) {
            if (n2 % 400 == 0) {
                bl = true;
            }
        } else if (n2 % 4 == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
        return this.isInSpecialDateList(n2, n3, n4, n5) >= 0;
    }

    public boolean isSpecialDate(Calendar calendar) {
        return this.isSpecialDate(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(4));
    }

    public void removeSpecialDate(SpecialDate specialDate) {
        this.specialDates.remove(specialDate);
    }

    public static class DateMonthYear
    implements SpecialDate {
        public int year;
        public int month;
        public int date;

        public DateMonthYear(int n2, int n3, int n4) {
            this.year = n4;
            this.month = n3;
            this.date = n2;
        }

        public DateMonthYear(Calendar calendar) {
            this(calendar.get(5), calendar.get(2), calendar.get(1));
        }

        public DateMonthYear(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.date = calendar.get(5);
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            return this.year == n2 && this.month == n3 && this.date == n4;
        }
    }

    public static class DayOfWeek
    implements SpecialDate {
        public int day_of_week;

        public DayOfWeek(int n2) {
            if (n2 < 0 || n2 > 6) {
                throw new IllegalArgumentException("invalid value for dayOfWeek");
            }
            this.day_of_week = n2;
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            int n6 = JCCalendar.dayOfWeek(n4, n3, n2);
            return this.day_of_week == n6;
        }
    }

    public static class MonthDayOfMonth
    implements SpecialDate {
        public int month;
        public int day_of_month;

        public MonthDayOfMonth(int n2, int n3) {
            this.month = n2;
            this.day_of_month = n3;
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            return this.month == n3 && this.day_of_month == n4;
        }
    }

    public class MonthWeekDayOfWeek
    implements SpecialDate {
        public int month;
        public int week;
        public int day_of_week;

        public MonthWeekDayOfWeek(int n2, int n3, int n4) {
            this.month = n2;
            this.week = n3;
            this.day_of_week = n4;
        }

        public boolean isSpecialDate(int n2, int n3, int n4, int n5) {
            int n6 = JCCalendar.dayOfWeek(n4, n3, n2);
            return this.month == n3 && this.day_of_week == n6 && this.week == n5;
        }
    }
}

