/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DayTable
extends JScrollPane
implements CalendarComponent,
MouseListener,
MouseMotionListener {
    transient JCLocaleManager li = JCLocaleManager.getDefault();
    protected JCValueModel selectedDate;
    protected JCCalendar specialDates;
    protected int componentSpacing = 4;
    protected Color otherBackground;
    protected Color otherForeground;
    protected Color specialBackground;
    protected Color specialForeground;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected int cellSize;
    protected Locale locale;
    protected String[] days = new String[]{"", "", "", "", "", "", "", ""};
    protected int firstDayOfWeek;
    protected int year;
    protected int month;
    protected int day;
    protected int startingCell;
    protected static int NUM_ROWS = 6;
    protected static int NUM_DAYS = 7;
    protected JTable table = new JTable();
    protected boolean editable = true;
    protected JCListenerList actionListeners = null;
    protected Calendar intermediateDate = null;
    protected DayModel dayModel;
    static /* synthetic */ Class class$java$lang$Integer;

    public DayTable(JCValueModel jCValueModel, JCCalendar jCCalendar, Locale locale) {
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(21);
        this.setViewportView(this.table);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setDefaultRenderer(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = DayTable.class$("java.lang.Integer")), new Renderer());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        this.setLocale(locale);
        int n2 = 1;
        while (n2 < this.days.length) {
            this.days[n2] = this.li.getString("Weekday" + n2);
            ++n2;
        }
        this.selectedDate = jCValueModel;
        this.specialDates = jCCalendar;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        this.firstDayOfWeek = (((Calendar)this.selectedDate.getValue()).getFirstDayOfWeek() + 6) % NUM_DAYS;
        this.setCalendarModel(jCValueModel);
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.calculateCalendar();
        this.calculateCellSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void addNotify() {
        super.addNotify();
        this.calculateCellSize();
        this.table.setPreferredSize(new Dimension(NUM_DAYS * this.cellSize, NUM_ROWS * this.cellSize));
    }

    protected void calculateCalendar() {
        Calendar calendar = (Calendar)this.selectedDate.getValue();
        this.month = calendar.get(2);
        this.year = calendar.get(1);
        this.day = calendar.get(5);
        this.startingCell = JCCalendar.dayOfWeek(1, this.month, this.year);
        if (this.firstDayOfWeek != 0) {
            this.startingCell = (this.startingCell - this.firstDayOfWeek + NUM_DAYS) % NUM_DAYS;
        }
    }

    protected void calculateCellSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.table.getTableHeader().getFont());
        this.cellSize = 0;
        int n2 = 1;
        while (n2 < this.days.length) {
            this.cellSize = Math.max(this.cellSize, fontMetrics.stringWidth(this.days[n2]));
            ++n2;
        }
        fontMetrics = ((Component)this).getFontMetrics(this.table.getFont());
        this.cellSize = Math.max(this.cellSize, fontMetrics.stringWidth("00"));
        this.cellSize = Math.max(this.cellSize, fontMetrics.getHeight() - fontMetrics.getDescent());
        this.cellSize += this.componentSpacing;
        this.table.setRowHeight(this.cellSize);
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setWidth(this.cellSize);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int dayFromRowColumn(int n2, int n3) {
        return n3 - (this.startingCell - 1) + n2 * NUM_DAYS;
    }

    public void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "DateSelected");
        Enumeration enumeration = JCListenerList.elements(this.actionListeners);
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected Calendar getCalendarFromPoint(Point point) {
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.columnAtPoint(point);
        int n4 = n3 - (this.startingCell - 1) + n2 * NUM_DAYS;
        Calendar calendar = JCCalendar.copyCalendar((Calendar)this.selectedDate.getValue());
        calendar.set(5, n4);
        return calendar;
    }

    public JCValueModel getCalendarModel() {
        return this.selectedDate;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Dimension getPreferredSize() {
        return new Dimension(NUM_DAYS * this.cellSize, NUM_ROWS * this.cellSize + ((JComponent)this.table.getTableHeader()).getPreferredSize().height);
    }

    public JCCalendar getSpecialDates(JCCalendar jCCalendar) {
        return this.specialDates;
    }

    protected void inferLookAndFeel() {
        this.setBackground(UIManager.getColor("Label.background"));
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setSpecialDateBackground(UIManager.getColor("Label.background"));
        this.setSpecialDateForeground(UIManager.getColor("TextField.foreground"));
        this.setSelectedDateBackground(UIManager.getColor("TextField.selectionBackground"));
        this.setSelectedDateForeground(UIManager.getColor("TextField.selectionForeground"));
        this.setOtherDateBackground(UIManager.getColor("Label.background"));
        this.setOtherDateForeground(UIManager.getColor("Label.disabledForeground"));
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isSelectedDate(int n2, int n3) {
        Calendar calendar;
        int n4 = this.dayFromRowColumn(n2, n3);
        return this.intermediateDate != null ? n4 == (calendar = this.intermediateDate).get(5) : n4 == this.day;
    }

    public boolean isSelectedMonth(int n2, int n3) {
        int n4 = this.dayFromRowColumn(n2, n3);
        return n4 >= 1 && n4 <= JCCalendar.daysInMonth(this.month, this.year);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        this.intermediateDate = this.getCalendarFromPoint(mouseEvent.getPoint());
        this.table.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        this.intermediateDate = this.getCalendarFromPoint(mouseEvent.getPoint());
        this.table.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        this.intermediateDate = null;
        this.selectedDate.setValue(this.getCalendarFromPoint(mouseEvent.getPoint()));
        this.fireActionEvent();
        this.table.repaint();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        if (this.dayModel != null && this.selectedDate != null) {
            this.selectedDate.removeValueListener(this.dayModel);
        }
        this.selectedDate = jCValueModel;
        this.selectedDate.addValueListener(this.dayModel);
        this.calculateCalendar();
        this.table.repaint();
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        if (this.dayModel != null && this.selectedDate != null) {
            this.selectedDate.removeValueListener(this.dayModel);
        }
        this.dayModel = new DayModel(locale);
        if (this.selectedDate != null) {
            this.selectedDate.addValueListener(this.dayModel);
        }
        this.table.setModel(this.dayModel);
    }

    public void setOtherDateBackground(Color color) {
        if (this.otherBackground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("otherBackground", this.otherBackground, color);
        this.otherBackground = color;
        this.repaint();
    }

    public void setOtherDateForeground(Color color) {
        if (this.otherForeground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("otherForeground", this.otherForeground, color);
        this.otherForeground = color;
        this.repaint();
    }

    public void setSelectedDateBackground(Color color) {
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("selectionBackground", this.selectionBackground, color);
        this.selectionBackground = color;
        this.repaint();
    }

    public void setSelectedDateForeground(Color color) {
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("selectionForeground", this.selectionForeground, color);
        this.selectionForeground = color;
        this.repaint();
    }

    public void setSpecialDateBackground(Color color) {
        if (this.specialBackground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("specialBackground", this.specialBackground, color);
        this.specialBackground = color;
        this.repaint();
    }

    public void setSpecialDateForeground(Color color) {
        if (this.specialForeground == color) {
            return;
        }
        if (color == null) {
            throw new IllegalArgumentException("null is an invalid color");
        }
        this.firePropertyChange("specialForeground", this.specialForeground, color);
        this.specialForeground = color;
        this.repaint();
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
        this.specialDates = jCCalendar;
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.inferLookAndFeel();
    }

    public void updateUI() {
        super.updateUI();
        this.inferLookAndFeel();
    }

    class Renderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        protected Border bevel = new SoftBevelBorder(1);
        protected Border empty = new EmptyBorder(0, 0, 0, 0);

        Renderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            this.setHorizontalAlignment(0);
            if (DayTable.this.isSelectedDate(n2, n3)) {
                this.setForeground(DayTable.this.selectionForeground);
                this.setBackground(DayTable.this.selectionBackground);
                this.setBorder(this.bevel);
                this.setOpaque(true);
            } else {
                if (DayTable.this.isSelectedMonth(n2, n3)) {
                    int n4 = DayTable.this.dayFromRowColumn(n2, n3);
                    if (DayTable.this.specialDates != null && DayTable.this.specialDates.isSpecialDate(DayTable.this.year, DayTable.this.month, n4, n2 + 1)) {
                        this.setForeground(DayTable.this.specialForeground);
                        this.setBackground(DayTable.this.specialBackground);
                    } else {
                        this.setForeground(DayTable.this.getForeground());
                        this.setBackground(DayTable.this.getBackground());
                    }
                } else {
                    this.setForeground(DayTable.this.otherForeground);
                    this.setBackground(DayTable.this.otherBackground);
                }
                this.setBorder(this.empty);
                this.setOpaque(true);
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(((Integer)object).toString());
            }
            return this;
        }
    }

    class DayModel
    implements TableModel,
    JCValueListener,
    Serializable {
        protected JCListenerList tableListeners = null;

        public DayModel(Locale locale) {
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
        }

        private Calendar copyCalendar(Calendar calendar) {
            if (calendar == null) {
                return null;
            }
            return (Calendar)calendar.clone();
        }

        public Class getColumnClass(int n2) {
            return class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = DayTable.class$("java.lang.Integer"));
        }

        public int getColumnCount() {
            return NUM_DAYS;
        }

        public String getColumnName(int n2) {
            return DayTable.this.days[(n2 + DayTable.this.firstDayOfWeek) % 7 + 1];
        }

        public int getRowCount() {
            return NUM_ROWS;
        }

        public Object getValueAt(int n2, int n3) {
            int n4 = DayTable.this.dayFromRowColumn(n2, n3);
            if (n4 < 1) {
                int n5;
                int n6;
                if (DayTable.this.month - 1 < 0) {
                    n6 = 11;
                    n5 = DayTable.this.year - 1;
                } else {
                    n6 = DayTable.this.month - 1;
                    n5 = DayTable.this.year;
                }
                return new Integer(JCCalendar.daysInMonth(n6, n5) - (DayTable.this.startingCell - n3 - 1));
            }
            if (n4 > JCCalendar.daysInMonth(DayTable.this.month, DayTable.this.year)) {
                return new Integer(n4 - JCCalendar.daysInMonth(DayTable.this.month, DayTable.this.year));
            }
            return new Integer(n4);
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
        }

        public void setValueAt(Object object, int n2, int n3) {
            throw new IllegalArgumentException("This TableModel is READ ONLY");
        }

        public void valueChanged(JCValueEvent jCValueEvent) {
            if (jCValueEvent == null) {
                return;
            }
            DayTable.this.calculateCalendar();
            TableModelEvent tableModelEvent = new TableModelEvent(this);
            Enumeration enumeration = JCListenerList.elements(this.tableListeners);
            while (enumeration.hasMoreElements()) {
                TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
                tableModelListener.tableChanged(tableModelEvent);
            }
        }

        public void valueChanging(JCValueEvent jCValueEvent) {
        }
    }
}

