/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.ServerJPanel;
import com.klg.jclass.util.ServerRenderable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ServerRenderer {
    public static Image createNewImage(int n2, int n3, int n4) {
        Image image;
        try {
            image = new BufferedImage(n2, n3, n4);
        }
        catch (Exception exception) {
            Frame frame = new Frame();
            frame.addNotify();
            image = frame.createImage(n2, n3);
        }
        return image;
    }

    public static Image createNewImage(Component component, int n2) {
        return ServerRenderer.createNewImage(component.getSize().width, component.getSize().height, n2);
    }

    public static void paintComponent(Graphics graphics, Component component) {
        if (!(component instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        serverRenderable.setGraphics(graphics);
        component.doLayout();
        component.paint(graphics);
        ServerRenderer.paintComponentAndChildren(graphics, component);
        serverRenderable.setGraphics(null);
    }

    protected static void paintComponentAndChildren(Graphics graphics, Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            Rectangle rectangle = graphics.getClipBounds();
            int n2 = container.getComponentCount() - 1;
            while (n2 >= 0) {
                Component component2 = container.getComponent(n2);
                if (component2.isVisible()) {
                    Rectangle rectangle2 = component2.getBounds();
                    graphics.translate(rectangle2.x, rectangle2.y);
                    graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
                    if (component2 instanceof JPanel) {
                        component2.doLayout();
                        ServerRenderer.paintComponentAndChildren(graphics, component2);
                    } else {
                        component2.paint(graphics);
                    }
                    graphics.translate(-rectangle2.x, -rectangle2.y);
                }
                --n2;
            }
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static void paintContainer(Graphics graphics, Container container) {
        if (!(container instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)container);
        serverRenderable.setGraphics(graphics);
        ServerRenderer.paintContainerAndChildren(graphics, container);
        serverRenderable.setGraphics(null);
    }

    protected static void paintContainerAndChildren(Graphics graphics, Container container) {
        container.doLayout();
        container.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = container.getComponentCount() - 1;
        while (n2 >= 0) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Rectangle rectangle2 = component.getBounds();
                graphics.translate(rectangle2.x, rectangle2.y);
                graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
                if (component instanceof Container) {
                    ServerRenderer.paintContainerAndChildren(graphics, (Container)component);
                } else {
                    component.paint(graphics);
                }
                graphics.translate(-rectangle2.x, -rectangle2.y);
            }
            --n2;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void paintTopLevelContainer(Graphics graphics, ServerJPanel serverJPanel) {
        if (!(serverJPanel instanceof ServerRenderable)) {
            return;
        }
        ServerJPanel serverJPanel2 = serverJPanel;
        serverJPanel2.setGraphics(graphics);
        serverJPanel.doLayout();
        serverJPanel.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = serverJPanel.getComponentCount() - 1;
        while (n2 >= 0) {
            Component component = serverJPanel.getComponent(n2);
            if (component.isVisible()) {
                Rectangle rectangle2 = component.getBounds();
                graphics.translate(rectangle2.x, rectangle2.y);
                graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
                if (component instanceof Container) {
                    ServerRenderer.paintContainer(graphics, (Container)component);
                } else {
                    component.paint(graphics);
                }
                graphics.translate(-rectangle2.x, -rectangle2.y);
            }
            --n2;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        serverJPanel2.setGraphics(null);
    }

    public static Image snapshot(Component component) {
        Image image = ServerRenderer.createNewImage(component, 2);
        ServerRenderer.snapshot(component, image);
        return image;
    }

    public static boolean snapshot(Component component, Image image) {
        if (!(component instanceof ServerRenderable)) {
            return false;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, component.getSize().width, component.getSize().height);
            serverRenderable.serverPaint(graphics);
        }
        return true;
    }
}

