/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class JCIPAddress
implements Serializable {
    protected int[] address = new int[4];
    public static int MAX_VALUE = 255;
    public static int MIN_VALUE = 0;

    public JCIPAddress(String string) {
        this.parseStringIP(string);
    }

    public JCIPAddress(InetAddress inetAddress) {
        this.parseStringIP(inetAddress.getHostAddress());
    }

    public JCIPAddress(int[] nArray) {
        int n2 = Math.min(4, nArray.length);
        int n3 = 0;
        while (n3 < n2) {
            this.address[n3] = nArray[n3];
            ++n3;
        }
    }

    public int[] getIPAddress() {
        return this.address;
    }

    public InetAddress getInetAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.toString());
        }
        catch (UnknownHostException unknownHostException) {}
        return inetAddress;
    }

    protected void parseStringIP(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return;
        }
        this.address[0] = Integer.valueOf(stringTokenizer.nextToken());
        this.address[1] = Integer.valueOf(stringTokenizer.nextToken());
        this.address[2] = Integer.valueOf(stringTokenizer.nextToken());
        this.address[3] = Integer.valueOf(stringTokenizer.nextToken());
    }

    public String toString() {
        return String.valueOf(this.address[0]) + "." + this.address[1] + "." + this.address[2] + "." + this.address[3];
    }
}

