/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d.actions;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.j3d.ActionHandlerParams;
import com.klg.jclass.chart3d.j3d.DataAdjustmentAxis;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCChart3dJava3d;
import com.klg.jclass.chart3d.j3d.MapPick;
import com.klg.jclass.chart3d.j3d.MapPickGrid;
import com.klg.jclass.chart3d.j3d.MapPickPoint;
import com.klg.jclass.chart3d.j3d.actions.BaseAction;
import java.awt.Point;
import java.awt.event.InputEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

public class EditAction
extends BaseAction {
    protected JCChart3dAreaJava3d area = null;
    protected BranchGroup objRoot = null;
    protected Canvas3D canvas3D = null;
    protected DataAdjustmentAxis adjustAxis = null;
    protected double radiusOfInfluence;
    protected double zScaleFactor;

    public void animate(InputEvent inputEvent, int n2, int n3) {
        if (this.adjustAxis != null && !this.adjustAxis.isBusy()) {
            double d2 = n2 - this.last.x;
            double d3 = n3 - this.last.y;
            double d4 = (d2 - d3) * this.zScaleFactor;
            this.adjustAxis.setZCoord(d4);
            this.last.x = n2;
            this.last.y = n3;
        }
    }

    public void cancel() {
    }

    public void end(InputEvent inputEvent, int n2, int n3) {
        if (this.adjustAxis != null) {
            this.plotCube.removePickAxis();
            this.adjustAxis = null;
        }
    }

    public double getRadiusOfInfluence() {
        return this.radiusOfInfluence;
    }

    public void initialize(Object object) {
        super.initialize(object);
        if (object instanceof ActionHandlerParams) {
            ActionHandlerParams actionHandlerParams = (ActionHandlerParams)object;
            this.area = actionHandlerParams.getChart3dAreaJava3d();
            this.canvas3D = actionHandlerParams.getCanvas3D();
            this.objRoot = actionHandlerParams.getObjectRoot();
            this.radiusOfInfluence = 4.0;
            this.zScaleFactor = 0.1;
        }
    }

    public void reanimate(int n2, int n3) {
    }

    public void setRadiusOfInfluence(double d2) {
        this.radiusOfInfluence = d2;
    }

    public void start(InputEvent inputEvent, int n2, int n3) {
        this.last = new Point(n2, n3);
        MapPick mapPick = null;
        Chart3dData chart3dData = this.getChart3d().getDataView(0).getElevationData();
        if (chart3dData instanceof Chart3dGridData) {
            mapPick = new MapPickGrid(this.getChart3d().getDataView(0).getElevationData());
            ((MapPickGrid)mapPick).enablePickClosestDataPoint(true);
        } else {
            mapPick = new MapPickPoint(this.getChart3d().getDataView(0).getElevationData());
        }
        mapPick.setCanvas3D(this.canvas3D);
        mapPick.setBranchGroup(this.objRoot);
        mapPick.setTolerance(8.0f);
        Point3d point3d = mapPick.map(n2, n3);
        if (point3d == null) {
            return;
        }
        Matrix4d matrix4d = this.area.getTransform().getAbsolute();
        matrix4d.transform(point3d);
        if (this.adjustAxis == null) {
            this.adjustAxis = new DataAdjustmentAxis((JCChart3dJava3d)this.getChart3d(), point3d, this.radiusOfInfluence);
        }
    }
}

