/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.j3d.Data3dPointIndex;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCPlotCubeJava3d;
import com.klg.jclass.chart3d.j3d.MapPick;
import com.klg.jclass.chart3d.j3d.PlotCubeTransformGroup;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.Point;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;

public class MapPickPoint
extends MapPick {
    public MapPickPoint() {
    }

    public MapPickPoint(Chart3dData chart3dData) {
        super(chart3dData);
    }

    public MapPickPoint(Chart3dData chart3dData, Canvas3D canvas3D, BranchGroup branchGroup) {
        super(chart3dData, canvas3D, branchGroup);
    }

    public Point3d map(int n2, int n3) {
        if (!(this.data instanceof Chart3dPointData)) {
            return null;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (chart3dPointData == null || !chart3dPointData.isDataOK()) {
            return null;
        }
        if (!this.isWithinCanvas3DLimits(n2, n3)) {
            return null;
        }
        return this.mapPoints(n2, n3);
    }

    public Point3d mapPoints(int n2, int n3) {
        PickCanvas pickCanvas = new PickCanvas(this.canvas3D, this.branchGroup);
        pickCanvas.setMode(1024);
        pickCanvas.setShapeLocation(n2, n3);
        pickCanvas.setTolerance(this.tolerance);
        Point3d point3d = pickCanvas.getStartPosition();
        PickResult[] pickResultArray = pickCanvas.pickAllSorted();
        if (pickResultArray != null) {
            int n4 = 0;
            while (n4 < pickResultArray.length) {
                Data3dPointIndex data3dPointIndex;
                Node node = pickResultArray[n4].getNode(1);
                if (node != null && (data3dPointIndex = (Data3dPointIndex)((Shape3D)node).getUserData()) != null) {
                    Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
                    Point3d point3d2 = new Point3d(chart3dPointData.getPoint(data3dPointIndex.getSeries(), data3dPointIndex.getPoint()));
                    return point3d2;
                }
                ++n4;
            }
        }
        return null;
    }

    public JCData3dIndex pick(int n2, int n3) {
        if (!(this.data instanceof Chart3dPointData)) {
            return null;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (chart3dPointData == null || !chart3dPointData.isDataOK()) {
            return null;
        }
        if (!this.isWithinCanvas3DLimits(n2, n3)) {
            return null;
        }
        return this.pickPoints(n2, n3);
    }

    public JCData3dIndex pickPoints(int n2, int n3) {
        PickCanvas pickCanvas = new PickCanvas(this.canvas3D, this.branchGroup);
        pickCanvas.setMode(1024);
        pickCanvas.setShapeLocation(n2, n3);
        pickCanvas.setTolerance(this.tolerance);
        Point3d point3d = pickCanvas.getStartPosition();
        PickResult[] pickResultArray = pickCanvas.pickAllSorted();
        if (pickResultArray != null) {
            int n4 = 0;
            while (n4 < pickResultArray.length) {
                Data3dPointIndex data3dPointIndex;
                Node node = pickResultArray[n4].getNode(1);
                if (node != null && (data3dPointIndex = (Data3dPointIndex)((Shape3D)node).getUserData()) != null) {
                    JCData3dPointIndex jCData3dPointIndex = new JCData3dPointIndex(data3dPointIndex.getSeries(), data3dPointIndex.getPoint());
                    Point point = this.unpick(jCData3dPointIndex);
                    double d2 = n2 - point.x;
                    double d3 = n3 - point.y;
                    double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                    jCData3dPointIndex.setDistance(d4);
                    return jCData3dPointIndex;
                }
                ++n4;
            }
        }
        return null;
    }

    public Point unpick(JCData3dIndex jCData3dIndex) {
        Point point = new Point(-1, -1);
        if (!(this.data instanceof Chart3dPointData) || !(jCData3dIndex instanceof JCData3dPointIndex)) {
            return point;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        JCData3dPointIndex jCData3dPointIndex = (JCData3dPointIndex)jCData3dIndex;
        if (chart3dPointData == null || !chart3dPointData.isDataOK() || jCData3dPointIndex == null) {
            return point;
        }
        int n2 = jCData3dPointIndex.getSeries();
        int n3 = jCData3dPointIndex.getPoint();
        Point3d point3d = new Point3d(chart3dPointData.getPoint(n2, n3));
        Chart3dDataView chart3dDataView = chart3dPointData.getDataView();
        JCChart3dAreaJava3d jCChart3dAreaJava3d = (JCChart3dAreaJava3d)chart3dDataView.getChart3d().getChart3dArea();
        Matrix4d matrix4d = jCChart3dAreaJava3d.getTransform().getAbsolute();
        matrix4d.transform(point3d);
        Transform3D transform3D = new Transform3D();
        JCPlotCubeJava3d jCPlotCubeJava3d = (JCPlotCubeJava3d)jCChart3dAreaJava3d.getPlotCube();
        PlotCubeTransformGroup plotCubeTransformGroup = jCPlotCubeJava3d.getTransformGroup();
        if (plotCubeTransformGroup != null) {
            plotCubeTransformGroup.getTransform(transform3D);
            transform3D.transform(point3d);
        }
        Transform3D transform3D2 = new Transform3D();
        this.canvas3D.getVworldToImagePlate(transform3D2);
        transform3D2.transform(point3d);
        Point2d point2d = new Point2d();
        this.canvas3D.getPixelLocationFromImagePlate(point3d, point2d);
        point = new Point((int)(point2d.x + 0.5), (int)(point2d.y + 0.5));
        return point;
    }
}

