/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.Mapping;
import com.klg.jclass.chart3d.j3d.JC3DUniverse;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCChart3dJava3d;
import com.klg.jclass.chart3d.j3d.MapPickGrid;
import com.klg.jclass.chart3d.j3d.MapPickPoint;
import java.awt.Dimension;
import java.awt.Point;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.vecmath.Point3d;

public class MapPick
implements Mapping {
    protected float tolerance = 1.0f;
    protected JCChart3dJava3d chart3d = null;
    protected Canvas3D canvas3D = null;
    protected BranchGroup branchGroup = null;
    protected Chart3dDataView dataView = null;
    protected Chart3dData data = null;

    public MapPick() {
    }

    public MapPick(Chart3dData chart3dData) {
        this.data = chart3dData;
        Chart3dDataView chart3dDataView = chart3dData.getDataView();
        this.chart3d = (JCChart3dJava3d)chart3dDataView.getChart3d();
        JCChart3dAreaJava3d jCChart3dAreaJava3d = (JCChart3dAreaJava3d)this.chart3d.getChart3dArea();
        this.canvas3D = jCChart3dAreaJava3d.getChart3dUniverse().getVirtualUniverse().getCanvas3D();
    }

    public MapPick(Chart3dData chart3dData, Canvas3D canvas3D, BranchGroup branchGroup) {
        Chart3dDataView chart3dDataView = chart3dData.getDataView();
        this.chart3d = (JCChart3dJava3d)chart3dDataView.getChart3d();
        this.data = chart3dData;
        this.canvas3D = canvas3D;
        this.branchGroup = branchGroup;
    }

    public Mapping createMapping(Chart3dData chart3dData) {
        if (chart3dData == null) {
            return null;
        }
        Chart3dDataView chart3dDataView = chart3dData.getDataView();
        JCChart3dJava3d jCChart3dJava3d = (JCChart3dJava3d)chart3dDataView.getChart3d();
        JCChart3dAreaJava3d jCChart3dAreaJava3d = (JCChart3dAreaJava3d)jCChart3dJava3d.getChart3dArea();
        JC3DUniverse jC3DUniverse = jCChart3dAreaJava3d.getChart3dUniverse().getVirtualUniverse();
        if (chart3dData instanceof Chart3dGridData) {
            return new MapPickGrid(chart3dData, jC3DUniverse.getCanvas3D(), jC3DUniverse.getSceneBranchGroup());
        }
        if (chart3dData instanceof Chart3dPointData) {
            return new MapPickPoint(chart3dData, jC3DUniverse.getCanvas3D(), jC3DUniverse.getSceneBranchGroup());
        }
        return null;
    }

    public Chart3dData getData() {
        return this.data;
    }

    protected boolean isWithinCanvas3DLimits(int n2, int n3) {
        Dimension dimension = this.canvas3D.getSize();
        return n2 >= 0 && n2 <= dimension.width && n3 >= 0 && n3 <= dimension.height;
    }

    public Point3d map(int n2, int n3) {
        return null;
    }

    public JCData3dIndex pick(int n2, int n3) {
        return null;
    }

    public void setBranchGroup(BranchGroup branchGroup) {
        this.branchGroup = branchGroup;
    }

    public void setCanvas3D(Canvas3D canvas3D) {
        this.canvas3D = canvas3D;
    }

    public void setTolerance(float f2) {
        this.tolerance = f2;
    }

    public Point unmap(Point3d point3d) {
        if (this.data == null || !this.data.isDataOK()) {
            return null;
        }
        return null;
    }

    public Point unpick(JCData3dIndex jCData3dIndex) {
        return null;
    }
}

