/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture2D;
import javax.swing.SwingConstants;

public class JCTexture2D
extends Texture2D
implements SwingConstants {
    private int width;
    private int height;
    private int imageXOffset;
    private int imageYOffset;
    private int imageWidth;
    private int imageHeight;

    protected JCTexture2D(ImageComponent2D imageComponent2D, int n2, int n3, int n4, int n5, int n6) {
        super(1, n6, imageComponent2D.getWidth(), imageComponent2D.getHeight());
        this.setImage(0, (ImageComponent)imageComponent2D);
        this.setMinFilter(1);
        this.setMagFilter(1);
        this.width = imageComponent2D.getWidth();
        this.height = imageComponent2D.getHeight();
        this.imageXOffset = n2;
        this.imageYOffset = n3;
        this.imageWidth = n4;
        this.imageHeight = n5;
    }

    public static JCTexture2D createTexture(BufferedImage bufferedImage, boolean bl, int n2, int n3, Color color) {
        Object object;
        Rectangle rectangle = new Rectangle();
        if (!JCTexture2D.isValidTextureImage(bufferedImage, bl)) {
            object = JCTexture2D.createValidTextureImage(bufferedImage, bl, n2, n3, color, rectangle);
            bufferedImage = object;
        }
        object = new TextureLoader(bufferedImage, 4);
        ImageComponent2D imageComponent2D = object.getImage();
        return new JCTexture2D(imageComponent2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 6);
    }

    public static JCTexture2D createTexture(String string, Color color) {
        return JCTexture2D.createTexture(string, true, 0, 0, color);
    }

    public static JCTexture2D createTexture(String string, boolean bl, int n2, int n3, Color color) {
        Component component = new Component(){};
        TextureLoader textureLoader = new TextureLoader(string, 4, component);
        if (textureLoader.getImage() == null) {
            System.out.println("createTexture() failed for image file " + string);
            return null;
        }
        return JCTexture2D.createTexture(textureLoader.getImage().getImage(), bl, n2, n3, color);
    }

    private static BufferedImage createValidTextureImage(BufferedImage bufferedImage, boolean bl, int n2, int n3, Color color, Rectangle rectangle) {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = JCTexture2D.getNextLargestPowerOfTwo(n4);
        int n7 = JCTexture2D.getNextLargestPowerOfTwo(n5);
        if (bl) {
            n7 = n6 = Math.max(n6, n7);
        }
        BufferedImage bufferedImage2 = new BufferedImage(n6, n7, bufferedImage.getType());
        int n8 = color.getRGB();
        int n9 = 0;
        while (n9 < n6) {
            int n10 = 0;
            while (n10 < n7) {
                bufferedImage2.setRGB(n9, n10, n8);
                ++n10;
            }
            ++n9;
        }
        switch (n2) {
            case 2: {
                rectangle.x = 0;
                break;
            }
            case 0: {
                rectangle.x = (n6 - n4) / 2;
                break;
            }
            case 4: {
                rectangle.x = n6 - n4;
                break;
            }
            default: {
                throw new IllegalArgumentException("hAlignment must be SwingConstants.LEFT, CENTER or RIGHT");
            }
        }
        switch (n3) {
            case 1: {
                rectangle.y = 0;
                break;
            }
            case 0: {
                rectangle.y = (n7 - n5) / 2;
                break;
            }
            case 3: {
                rectangle.y = n7 - n5;
                break;
            }
            default: {
                throw new IllegalArgumentException("vAlignment must be SwingConstants.TOP, CENTER, or BOTTOM.");
            }
        }
        rectangle.width = n4;
        rectangle.height = n5;
        int[] nArray = bufferedImage.getRGB(0, 0, n4, n5, null, 0, n4);
        bufferedImage2.setRGB(rectangle.x, rectangle.y, n4, n5, nArray, 0, n4);
        return bufferedImage2;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageXOffset() {
        return this.imageXOffset;
    }

    public int getImageYOffest() {
        return this.imageYOffset;
    }

    private static int getNextLargestPowerOfTwo(int n2) {
        int n3 = 2;
        while (n3 < n2) {
            n3 *= n3;
        }
        return n3;
    }

    private static boolean isPowerOfTwo(int n2) {
        if (n2 <= 1) {
            return false;
        }
        float f2 = n2;
        while ((double)f2 >= 1.0) {
            if ((double)(f2 = (float)((double)f2 / 2.0)) != 1.0) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidTextureImage(RenderedImage renderedImage, boolean bl) {
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        boolean bl2 = JCTexture2D.isPowerOfTwo(n2) && JCTexture2D.isPowerOfTwo(n3);
        return bl2 && (!bl || bl && n2 == n3);
    }

    public float toAlphaX(int n2) {
        return (float)n2 / (float)this.width;
    }

    public float toAlphaY(int n2) {
        return (float)n2 / (float)this.height;
    }
}

