/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.j3d.DataSurfaceTA;
import com.klg.jclass.chart3d.j3d.JCAppearance;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCColoringAttributes;
import com.klg.jclass.chart3d.j3d.JCMaterial;
import com.klg.jclass.chart3d.j3d.JCRenderingAttributes;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.sun.j3d.utils.picking.PickTool;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;

public class JCSolidDataSurface
extends JCBranchGroup {
    protected static final int SOLID_DATA_SURFACE = 100;
    protected static final float DEFAULT_SHININESS = 5.0f;
    private JCColoringAttributes colorAttrib = null;
    private JCShape3D solidSurface = null;

    public JCSolidDataSurface(Matrix4d matrix4d, Chart3dGridData chart3dGridData, JCContour jCContour, Color3f color3f, int n2) {
        super(n2);
        DataSurfaceTA dataSurfaceTA = new DataSurfaceTA(matrix4d, chart3dGridData, jCContour);
        TriangleStripArray triangleStripArray = dataSurfaceTA.getGeometryArray();
        JCAppearance jCAppearance = new JCAppearance();
        PolygonAttributes polygonAttributes = jCAppearance.getPolygonAttributes();
        if (polygonAttributes == null) {
            polygonAttributes = new PolygonAttributes();
        }
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        if (jCAppearance.getPolygonAttributes() == null) {
            jCAppearance.setPolygonAttributes(polygonAttributes);
        }
        JCRenderingAttributes jCRenderingAttributes = new JCRenderingAttributes();
        jCRenderingAttributes.setVisible(true);
        jCAppearance.setRenderingAttributes(jCRenderingAttributes);
        JCMaterial jCMaterial = new JCMaterial(color3f, 5.0f);
        jCMaterial.setLightingEnable(false);
        this.colorAttrib = new JCColoringAttributes();
        this.colorAttrib.setColor(color3f);
        this.colorAttrib.setShadeModel(1);
        jCAppearance.setMaterial(jCMaterial);
        jCAppearance.setColoringAttributes(this.colorAttrib);
        this.solidSurface = new JCShape3D((Geometry)triangleStripArray, jCAppearance, 100, n2);
        this.solidSurface.setCapability(1);
        PickTool.setCapabilities((Node)this.solidSurface, (int)4100);
        this.addChild((Node)this.solidSurface);
        this.compile();
    }

    public void getAmbientColor(Color3f color3f) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.getAmbientColor(color3f);
        }
    }

    public void getEmissiveColor(Color3f color3f) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.getEmissiveColor(color3f);
        }
    }

    public float getShininessColor() {
        JCAppearance jCAppearance;
        JCMaterial jCMaterial;
        float f2 = 5.0f;
        if (this.solidSurface != null && (jCMaterial = (JCMaterial)(jCAppearance = (JCAppearance)this.solidSurface.getAppearance()).getMaterial()) != null) {
            f2 = jCMaterial.getShininess();
        }
        return f2;
    }

    public void getSpecularColor(Color3f color3f) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.getSpecularColor(color3f);
        }
    }

    public void setAmbientColor(Color3f color3f) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.setAmbientColor(color3f);
            jCAppearance.setMaterial(jCMaterial);
            this.solidSurface.setAppearance(jCAppearance);
        }
    }

    public void setEmissiveColor(Color3f color3f) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.setEmissiveColor(color3f);
            jCAppearance.setMaterial(jCMaterial);
            this.solidSurface.setAppearance(jCAppearance);
        }
    }

    private void setShape3DVisible(JCShape3D jCShape3D, boolean bl) {
        if (jCShape3D == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        JCRenderingAttributes jCRenderingAttributes = (JCRenderingAttributes)jCAppearance.getRenderingAttributes();
        if (jCRenderingAttributes != null) {
            jCRenderingAttributes.setVisible(bl);
            jCAppearance.setRenderingAttributes(jCRenderingAttributes);
            jCShape3D.setAppearance(jCAppearance);
        }
    }

    public void setShininess(float f2) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.setShininess(f2);
            jCAppearance.setMaterial(jCMaterial);
            this.solidSurface.setAppearance(jCAppearance);
        }
    }

    public void setSolidSurfaceShaded(boolean bl) {
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        jCMaterial.setLightingEnable(bl);
        jCAppearance.setMaterial(jCMaterial);
        this.solidSurface.setAppearance(jCAppearance);
    }

    public void setSolidSurfaceVisible(boolean bl) {
        this.setShape3DVisible(this.solidSurface, bl);
    }

    public void setSolidSurfaceZoned(boolean bl) {
        if (this.solidSurface != null) {
            this.showSolidSurfaceZoneColors(bl, this.solidSurface);
        }
    }

    public void setSpecularColor(Color3f color3f) {
        if (this.solidSurface == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.solidSurface.getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.setSpecularColor(color3f);
            jCAppearance.setMaterial(jCMaterial);
            this.solidSurface.setAppearance(jCAppearance);
        }
    }

    private void showSolidSurfaceZoneColors(boolean bl, JCShape3D jCShape3D) {
        Appearance appearance = jCShape3D.getAppearance();
        JCRenderingAttributes jCRenderingAttributes = (JCRenderingAttributes)appearance.getRenderingAttributes();
        jCRenderingAttributes.setIgnoreVertexColors(bl ^ true);
        appearance.setRenderingAttributes((RenderingAttributes)jCRenderingAttributes);
        jCShape3D.setAppearance(appearance);
    }
}

