/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.j3d.JCAppearance;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCColoringAttributes;
import com.klg.jclass.chart3d.j3d.JCCubeLA;
import com.klg.jclass.chart3d.j3d.JCCubeSquareArray;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.klg.jclass.chart3d.j3d.JCTexture2D;
import com.klg.jclass.chart3d.j3d.JCTransformGroup;
import com.klg.jclass.chart3d.j3d.JCView3dJava3d;
import com.klg.jclass.chart3d.j3d.PlotCubeTransformGroup;
import com.sun.j3d.utils.picking.PickTool;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.BitSet;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class JCPlotCubeJava3d
extends JCPlotCube {
    private boolean fDisplaySolidSurfaces = true;
    private boolean fDisplayWireFrame = false;
    private boolean ceilingProjectionCreated = false;
    private boolean floorProjectionCreated = false;
    private Switch objSwitch = null;
    private BitSet objSwitchChildMask;
    private final int MAX_OBJECT_SWITCH_CHILDREN = 16;
    private final int PLOTCUBE_WALLS = 0;
    private final int PLOTCUBE_WIREFRAME = 1;
    private float defaultTransparency = 0.35f;
    private JCCubeSquareArray csaPlotCubeWalls = null;
    private Shape3D shPlotCubeWireFrame = null;
    private Color wireframeColor = null;
    private Color outlineColor = null;
    private JCBranchGroup bgPlotCube = null;
    private JCBranchGroup bgData = null;
    private JCBranchGroup bgPickAxis = null;
    private JCBranchGroup bgAnnotation = null;
    private int bgDataIndex = 0;
    private PlotCubeTransformGroup plotCubeTG = null;
    private JCTransformGroup scaleTG = null;

    public JCPlotCubeJava3d(JCChart3dAreaJava3d jCChart3dAreaJava3d) {
        super(jCChart3dAreaJava3d);
        this.foreground = Color.green;
        this.background = Color.white;
        this.wireframeColor = Color.red;
        this.outlineColor = Color.black;
        this.bgPlotCube = this.createPlotCube(0.0, 0.0, 0.0);
        JCView3dJava3d jCView3dJava3d = (JCView3dJava3d)jCChart3dAreaJava3d.getView3d();
        if (jCView3dJava3d != null) {
            this.rotate(jCView3dJava3d.getXRotation(), jCView3dJava3d.getYRotation(), jCView3dJava3d.getZRotation());
        } else {
            this.rotate(45.0, 0.0, 45.0);
        }
    }

    public void addAnnotationBranchGroup(JCBranchGroup jCBranchGroup) {
        this.bgAnnotation.addChild((Node)jCBranchGroup);
    }

    protected void addDataGroup(BranchGroup branchGroup) {
        this.bgData.addChild((Node)branchGroup);
        ++this.bgDataIndex;
    }

    public void addPickAxis(BranchGroup branchGroup) {
        this.bgPickAxis.addChild((Node)branchGroup);
    }

    private JCBranchGroup createPlotCube(double d2, double d3, double d4) {
        JCCubeLA jCCubeLA = null;
        Color3f color3f = new Color3f(this.foreground);
        Color3f color3f2 = new Color3f(this.background);
        JCBranchGroup jCBranchGroup = new JCBranchGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(d2, d3, d4));
        this.plotCubeTG = new PlotCubeTransformGroup((JCChart3dAreaJava3d)this.area, transform3D);
        this.plotCubeTG.setCapability(1);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setScale(1.0);
        this.scaleTG = new JCTransformGroup(transform3D2);
        this.objSwitchChildMask = new BitSet(16);
        this.objSwitch = new Switch(-3, this.objSwitchChildMask);
        this.objSwitch.setCapability(17);
        this.objSwitch.setCapability(18);
        this.objSwitch.setCapability(12);
        this.objSwitch.setCapability(13);
        this.objSwitch.setCapability(14);
        this.csaPlotCubeWalls = new JCCubeSquareArray(color3f2, new Color3f(this.outlineColor));
        this.objSwitch.addChild((Node)this.csaPlotCubeWalls);
        JCBranchGroup jCBranchGroup2 = new JCBranchGroup();
        jCCubeLA = new JCCubeLA();
        JCAppearance jCAppearance = new JCAppearance();
        Material material = new Material();
        material.setLightingEnable(false);
        jCAppearance.setMaterial(material);
        JCColoringAttributes jCColoringAttributes = new JCColoringAttributes();
        jCColoringAttributes.setColor(new Color3f(this.wireframeColor));
        jCAppearance.setColoringAttributes(jCColoringAttributes);
        this.shPlotCubeWireFrame = new Shape3D((Geometry)jCCubeLA, (Appearance)jCAppearance);
        this.shPlotCubeWireFrame.setCapability(14);
        this.shPlotCubeWireFrame.setCapability(15);
        this.shPlotCubeWireFrame.setCapability(1);
        PickTool.setCapabilities((Node)this.shPlotCubeWireFrame, (int)4100);
        jCBranchGroup2.addChild((Node)this.shPlotCubeWireFrame);
        this.objSwitch.addChild((Node)jCBranchGroup2);
        this.bgAnnotation = new JCBranchGroup();
        this.plotCubeTG.addChild((Node)this.bgAnnotation);
        this.scaleTG.addChild((Node)this.objSwitch);
        this.setSolidWallsVisible(this.fDisplaySolidSurfaces);
        this.setWireFrameVisible(this.fDisplayWireFrame);
        this.bgData = new JCBranchGroup();
        this.plotCubeTG.addChild((Node)this.bgData);
        this.bgPickAxis = new JCBranchGroup();
        this.plotCubeTG.addChild((Node)this.bgPickAxis);
        this.plotCubeTG.addChild((Node)this.scaleTG);
        jCBranchGroup.addChild((Node)this.plotCubeTG);
        jCBranchGroup.compile();
        return jCBranchGroup;
    }

    public void createProjections() {
        if (!this.hasCeilingProjection()) {
            this.removeCeilingProjection();
        }
        if (!this.hasFloorProjection()) {
            this.removeFloorProjection();
        }
        if (!this.hasProjections()) {
            return;
        }
        Image image = null;
        JCTexture2D jCTexture2D = null;
        JCContour jCContour = this.area.getChart3d().getDataView(0).getContour();
        jCContour.recalcContours();
        if (this.hasFloorProjection()) {
            image = new BufferedImage(512, 512, 2);
            this.createParallelProjection((BufferedImage)image, this.floor);
            jCTexture2D = JCTexture2D.createTexture((BufferedImage)image, true, 0, 0, Color.white);
            this.setWallTexture(4, jCTexture2D, 0.0);
            this.setWallOuterFaceVisible(4, true);
            this.floorProjectionCreated = true;
        }
        if (this.hasCeilingProjection()) {
            image = new BufferedImage(512, 512, 2);
            this.createParallelProjection((BufferedImage)image, this.ceiling);
            jCTexture2D = JCTexture2D.createTexture((BufferedImage)image, true, 0, 0, Color.white);
            this.setWallTexture(5, jCTexture2D, 0.0);
            this.setWallOuterFaceVisible(5, true);
            if (this.getCeiling().isContoured() && !this.getCeiling().isZoned()) {
                this.setWallTransparency(5, this.defaultTransparency);
            } else {
                this.setWallTransparency(5, 0.0f);
            }
            if (!this.ceilingProjectionCreated) {
                this.flipWallImage(5, 1);
            }
            this.ceilingProjectionCreated = true;
        }
        image.flush();
        image = null;
        jCTexture2D = null;
        jCContour.destroyContours();
        this.setWireFrameVisible(true);
    }

    public void flipWallImage(int n2, int n3) {
        this.csaPlotCubeWalls.flipWallImage(n2, n3);
    }

    protected JCBranchGroup getContent() {
        return this.bgPlotCube;
    }

    public float getDefaultTransparency() {
        return this.defaultTransparency;
    }

    protected int getIndex() {
        return this.bgDataIndex;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public Transform3D getPlotCubeScaling() {
        Transform3D transform3D = new Transform3D();
        this.scaleTG.getTransform(transform3D);
        return transform3D;
    }

    public PlotCubeTransformGroup getTransformGroup() {
        return this.plotCubeTG;
    }

    public double getWallImageAngle(int n2) {
        return this.csaPlotCubeWalls.getRotation(n2);
    }

    public Color getWireframeColor() {
        return this.wireframeColor;
    }

    public void removeAllAnnotation() {
        int n2 = this.bgAnnotation.numChildren();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            this.bgAnnotation.removeChild(n3);
            --n3;
        }
    }

    protected void removeAllDataGroups() {
        int n2 = this.bgData.numChildren();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            this.bgData.removeChild(n3);
            --n3;
        }
    }

    public void removeCeilingProjection() {
        if (this.ceilingProjectionCreated) {
            this.setWallTexture(5, null, 0.0);
            this.setWallTransparency(5, 0.0f);
            this.setWallOuterFaceVisible(5, false);
            this.flipWallImage(5, 1);
            this.setWireFrameVisible(false);
            this.ceilingProjectionCreated = false;
        }
    }

    public void removeFloorProjection() {
        if (this.floorProjectionCreated) {
            this.setWallTexture(4, null, 0.0);
            this.setWallTransparency(4, 0.0f);
            this.setWallOuterFaceVisible(4, false);
            this.setWireFrameVisible(false);
            this.floorProjectionCreated = false;
        }
    }

    public void removePickAxis() {
        this.bgPickAxis.removeChild(0);
    }

    protected void replaceDataGroup(BranchGroup branchGroup, int n2) {
        this.bgData.setChild((Node)branchGroup, n2);
    }

    protected void rotate(double d2, double d3, double d4) {
        double d5 = Math.toRadians(d2 - 90.0);
        double d6 = Math.toRadians(d3);
        double d7 = Math.toRadians(d4);
        Transform3D transform3D = new Transform3D();
        this.plotCubeTG.getTransform(transform3D);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.rotX((float)d5);
        Matrix3d matrix3d2 = new Matrix3d();
        matrix3d2.rotY((float)d6);
        matrix3d.mul(matrix3d2);
        matrix3d2.rotZ((float)d7);
        matrix3d.mul(matrix3d2);
        transform3D.setRotation(matrix3d);
        this.plotCubeTG.setTransform(transform3D);
    }

    public void rotateWallImage(int n2, double d2) {
        this.csaPlotCubeWalls.setRotation(n2, d2);
    }

    private void scale() {
        Transform3D transform3D = new Transform3D();
        this.scaleTG.getTransform(transform3D);
        transform3D.setScale(new Vector3d(this.xNormalizedScale, this.yNormalizedScale, this.zNormalizedScale));
        this.scaleTG.setTransform(transform3D);
    }

    public void setBackground(Color color) {
        this.background = color;
        int n2 = 0;
        while (n2 < 6) {
            JCShape3D jCShape3D = this.csaPlotCubeWalls.getFace(n2);
            this.setColor(jCShape3D, color);
            ++n2;
        }
    }

    private void setColor(Shape3D shape3D, Color color) {
        JCColoringAttributes jCColoringAttributes = null;
        Color3f color3f = new Color3f(color);
        JCAppearance jCAppearance = (JCAppearance)shape3D.getAppearance();
        if (jCAppearance == null) {
            return;
        }
        jCColoringAttributes = (JCColoringAttributes)jCAppearance.getColoringAttributes();
        if (jCColoringAttributes == null) {
            return;
        }
        jCColoringAttributes.setColor(color3f);
        jCAppearance.setColoringAttributes(jCColoringAttributes);
        shape3D.setAppearance((Appearance)jCAppearance);
    }

    public void setDefaultTransparency(float f2) {
        this.defaultTransparency = f2;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
        int n2 = 0;
        while (n2 < 6) {
            JCShape3D jCShape3D = this.csaPlotCubeWalls.getFaceOutline(n2);
            this.setColor(jCShape3D, color);
            ++n2;
        }
    }

    public void setScale(double d2) {
        Transform3D transform3D = new Transform3D();
        this.plotCubeTG.getTransform(transform3D);
        transform3D.setScale(d2);
        this.plotCubeTG.setTransform(transform3D);
    }

    public void setSolidWallsVisible(boolean bl) {
        this.fDisplaySolidSurfaces = bl;
        if (this.fDisplaySolidSurfaces) {
            this.objSwitchChildMask.set(0);
        } else {
            this.objSwitchChildMask.clear(0);
        }
        this.objSwitch.setChildMask(this.objSwitchChildMask);
    }

    public void setTexture(JCTexture2D jCTexture2D) {
        int n2 = 0;
        while (n2 < 6) {
            this.csaPlotCubeWalls.applyTexture(n2, jCTexture2D);
            ++n2;
        }
    }

    public void setWallImage(int n2, String string, double d2) {
        this.setWallTexture(n2, JCTexture2D.createTexture(string, Color.white), d2);
    }

    public void setWallImage(String string) {
        this.setTexture(JCTexture2D.createTexture(string, Color.white));
    }

    public void setWallOuterFaceVisible(int n2, boolean bl) {
        JCShape3D jCShape3D = this.csaPlotCubeWalls.getFace(n2);
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        PolygonAttributes polygonAttributes = jCAppearance.getPolygonAttributes();
        if (bl) {
            polygonAttributes.setCullFace(0);
        } else {
            polygonAttributes.setCullFace(1);
        }
        polygonAttributes.setBackFaceNormalFlip(bl);
    }

    public void setWallTexture(int n2, JCTexture2D jCTexture2D, double d2) {
        this.csaPlotCubeWalls.applyTexture(n2, jCTexture2D);
        this.csaPlotCubeWalls.setRotation(n2, d2);
    }

    public void setWallTransparency(int n2, float f2) {
        JCShape3D jCShape3D = this.csaPlotCubeWalls.getFace(n2);
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        TransparencyAttributes transparencyAttributes = jCAppearance.getTransparencyAttributes();
        transparencyAttributes.setTransparencyMode(3);
        transparencyAttributes.setTransparency(f2);
    }

    public void setWireFrameVisible(boolean bl) {
        this.fDisplayWireFrame = bl;
        if (this.fDisplayWireFrame) {
            this.objSwitchChildMask.set(1);
        } else {
            this.objSwitchChildMask.clear(1);
        }
        this.objSwitch.setChildMask(this.objSwitchChildMask);
    }

    public void setWireframeColor(Color color) {
        this.setColor(this.shPlotCubeWireFrame, color);
    }

    public void setXScale(double d2) {
        super.setXScale(d2);
        this.scale();
    }

    public void setYScale(double d2) {
        super.setYScale(d2);
        this.scale();
    }

    public void setZScale(double d2) {
        super.setZScale(d2);
        this.scale();
    }

    protected void translate(Vector3d vector3d) {
        Transform3D transform3D = new Transform3D();
        this.plotCubeTG.getTransform(transform3D);
        transform3D.setTranslation(vector3d);
        this.plotCubeTG.setTransform(transform3D);
    }
}

