/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.j3d.DataSurfaceLA;
import com.klg.jclass.chart3d.j3d.JCAppearance;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCColoringAttributes;
import com.klg.jclass.chart3d.j3d.JCLineAttributes;
import com.klg.jclass.chart3d.j3d.JCMaterial;
import com.klg.jclass.chart3d.j3d.JCRenderingAttributes;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.sun.j3d.utils.picking.PickTool;
import java.util.ArrayList;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;

public class JCMeshDataSurface
extends JCBranchGroup {
    protected static final int MESH_DATA_SURFACE = 101;
    protected static final float DEFAULT_LINEWIDTH = 1.0f;
    private JCColoringAttributes colorAttrib = null;
    private JCShape3D gridMesh = null;
    private JCShape3D[] contourLines = null;

    public JCMeshDataSurface(Matrix4d matrix4d, Chart3dGridData chart3dGridData, JCContour jCContour, Color3f color3f, int n2) {
        super(n2);
        ArrayList arrayList = jCContour.getContourStyles();
        DataSurfaceLA dataSurfaceLA = new DataSurfaceLA(matrix4d, chart3dGridData, jCContour);
        Geometry geometry = dataSurfaceLA.getGridGeometry();
        this.gridMesh = this.createGridMesh(geometry, jCContour, color3f, n2);
        this.gridMesh.setCapability(1);
        PickTool.setCapabilities((Node)this.gridMesh, (int)4100);
        this.addChild((Node)this.gridMesh);
        LineArray[] lineArrayArray = dataSurfaceLA.getContourGeometry();
        this.contourLines = new JCShape3D[lineArrayArray.length];
        int n3 = 0;
        while (n3 < lineArrayArray.length) {
            if (lineArrayArray[n3] != null) {
                this.contourLines[n3] = this.createContourLines(n3, (Geometry)lineArrayArray[n3], (JCContourStyle)arrayList.get(n3), color3f, n2);
                this.contourLines[n3].setCapability(1);
                PickTool.setCapabilities((Node)this.contourLines[n3], (int)4100);
                this.addChild((Node)this.contourLines[n3]);
            }
            ++n3;
        }
        this.compile();
    }

    private JCShape3D createContourLines(int n2, Geometry geometry, JCContourStyle jCContourStyle, Color3f color3f, int n3) {
        JCAppearance jCAppearance = new JCAppearance();
        JCMaterial jCMaterial = new JCMaterial();
        jCMaterial.setLightingEnable(false);
        jCAppearance.setMaterial(jCMaterial);
        JCLineAttributes jCLineAttributes = new JCLineAttributes();
        jCLineAttributes.setLineWidth(1.0f);
        jCLineAttributes.setLineAntialiasingEnable(false);
        jCAppearance.setLineAttributes(jCLineAttributes);
        JCRenderingAttributes jCRenderingAttributes = new JCRenderingAttributes();
        jCRenderingAttributes.setVisible(false);
        jCAppearance.setRenderingAttributes(jCRenderingAttributes);
        JCColoringAttributes jCColoringAttributes = new JCColoringAttributes();
        jCColoringAttributes.setColor(color3f);
        jCAppearance.setColoringAttributes(jCColoringAttributes);
        JCShape3D jCShape3D = new JCShape3D(geometry, jCAppearance, 101, n3);
        return jCShape3D;
    }

    private JCShape3D createGridMesh(Geometry geometry, JCContour jCContour, Color3f color3f, int n2) {
        JCAppearance jCAppearance = new JCAppearance();
        JCMaterial jCMaterial = new JCMaterial();
        jCMaterial.setLightingEnable(false);
        jCAppearance.setMaterial(jCMaterial);
        JCLineAttributes jCLineAttributes = new JCLineAttributes();
        jCLineAttributes.setLineWidth(1.0f);
        jCLineAttributes.setLineAntialiasingEnable(false);
        jCAppearance.setLineAttributes(jCLineAttributes);
        JCRenderingAttributes jCRenderingAttributes = new JCRenderingAttributes();
        jCRenderingAttributes.setVisible(false);
        jCAppearance.setRenderingAttributes(jCRenderingAttributes);
        JCColoringAttributes jCColoringAttributes = new JCColoringAttributes();
        jCColoringAttributes.setColor(color3f);
        jCAppearance.setColoringAttributes(jCColoringAttributes);
        JCShape3D jCShape3D = new JCShape3D(geometry, jCAppearance, 101, n2);
        return jCShape3D;
    }

    public int getContourLinePattern(int n2) {
        int n3 = 0;
        if (n2 >= 0) {
            n3 = this.getLinePattern(this.contourLines[n2]);
        }
        return n3;
    }

    private int getLinePattern(JCShape3D jCShape3D) {
        JCAppearance jCAppearance;
        JCLineAttributes jCLineAttributes;
        int n2 = 0;
        if (jCShape3D != null && (jCLineAttributes = (JCLineAttributes)(jCAppearance = (JCAppearance)jCShape3D.getAppearance()).getLineAttributes()) != null) {
            n2 = jCLineAttributes.getLinePattern();
        }
        return n2;
    }

    public int getMeshLinePattern() {
        return this.getLinePattern(this.gridMesh);
    }

    public void setContourLinePattern(int n2) {
        int n3 = 0;
        while (n3 < this.contourLines.length) {
            this.setLinePattern(this.contourLines[n3], n2);
            ++n3;
        }
    }

    protected void setContourLineWidth(float f2) {
        int n2 = 0;
        while (n2 < this.contourLines.length) {
            this.setLineWidth(this.contourLines[n2], f2);
            ++n2;
        }
    }

    public void setContourLinesVisible(boolean bl) {
        int n2 = 0;
        while (n2 < this.contourLines.length) {
            this.setShape3DVisible(this.contourLines[n2], bl);
            ++n2;
        }
    }

    public void setContourLinesZoned(boolean bl) {
        if (this.contourLines != null) {
            int n2 = 0;
            while (n2 < this.contourLines.length) {
                this.showLineZoneColors(bl, this.contourLines[n2]);
                ++n2;
            }
        }
    }

    private void setLinePattern(JCShape3D jCShape3D, int n2) {
        if (jCShape3D == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        JCLineAttributes jCLineAttributes = (JCLineAttributes)jCAppearance.getLineAttributes();
        if (jCLineAttributes != null) {
            jCLineAttributes.setLinePattern(n2);
            jCAppearance.setLineAttributes(jCLineAttributes);
            jCShape3D.setAppearance(jCAppearance);
        }
    }

    private void setLineWidth(JCShape3D jCShape3D, float f2) {
        if (jCShape3D == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        JCLineAttributes jCLineAttributes = (JCLineAttributes)jCAppearance.getLineAttributes();
        if (jCLineAttributes != null) {
            jCLineAttributes.setLineWidth(f2);
            jCAppearance.setLineAttributes(jCLineAttributes);
            jCShape3D.setAppearance(jCAppearance);
        }
    }

    public void setMeshLinePattern(int n2) {
        this.setLinePattern(this.gridMesh, n2);
    }

    public void setMeshLineWidth(float f2) {
        this.setLineWidth(this.gridMesh, f2);
    }

    public void setMeshSurfaceVisible(boolean bl) {
        this.setShape3DVisible(this.gridMesh, bl);
    }

    public void setMeshSurfaceZoned(boolean bl) {
        if (this.gridMesh != null) {
            this.showLineZoneColors(bl, this.gridMesh);
        }
    }

    private void setShape3DVisible(JCShape3D jCShape3D, boolean bl) {
        if (jCShape3D == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        JCRenderingAttributes jCRenderingAttributes = (JCRenderingAttributes)jCAppearance.getRenderingAttributes();
        if (jCRenderingAttributes != null) {
            jCRenderingAttributes.setVisible(bl);
            jCAppearance.setRenderingAttributes(jCRenderingAttributes);
            jCShape3D.setAppearance(jCAppearance);
        }
    }

    private void showLineZoneColors(boolean bl, JCShape3D jCShape3D) {
        if (jCShape3D == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        JCRenderingAttributes jCRenderingAttributes = (JCRenderingAttributes)jCAppearance.getRenderingAttributes();
        if (jCRenderingAttributes != null) {
            jCRenderingAttributes.setIgnoreVertexColors(bl ^ true);
            jCAppearance.setRenderingAttributes(jCRenderingAttributes);
        }
        jCShape3D.setAppearance(jCAppearance);
    }
}

