/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.j3d.Chart3dDataViewJava3d;
import com.klg.jclass.chart3d.j3d.Data3dPointIndex;
import com.klg.jclass.chart3d.j3d.DataPoint;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCChart3dAreaJava3d;
import com.klg.jclass.chart3d.j3d.JCChart3dJava3d;
import com.klg.jclass.chart3d.j3d.JCColoringAttributes;
import com.klg.jclass.chart3d.j3d.JCMaterial;
import com.klg.jclass.chart3d.j3d.JCRenderingAttributes;
import com.klg.jclass.chart3d.shape3d.JCSymbolShape3d;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

public class JCDataPoints
extends JCBranchGroup {
    private JCChart3dAreaJava3d area = null;
    protected static final int DATA_POINTS = 300;
    protected double scale = 0.03;
    private JCContour contour = null;
    private JCContourLevels contourLevels = null;
    private ArrayList contourStyles = null;
    private JCColoringAttributes colorAttrib = null;

    public JCDataPoints(Matrix4d matrix4d, Chart3dGridData chart3dGridData, JCContour jCContour, Color3f color3f, boolean bl, int n2) {
        super(n2);
        int n3;
        Chart3dDataViewJava3d chart3dDataViewJava3d = (Chart3dDataViewJava3d)chart3dGridData.getDataView();
        JCChart3dJava3d jCChart3dJava3d = (JCChart3dJava3d)chart3dDataViewJava3d.getChart3d();
        this.area = (JCChart3dAreaJava3d)jCChart3dJava3d.getChart3dArea();
        Color3f color3f2 = null;
        this.contour = jCContour;
        this.contourLevels = jCContour.getContourLevels();
        this.contourStyles = jCContour.getContourStyles();
        int n4 = chart3dGridData.getNumX();
        int n5 = chart3dGridData.getNumY();
        double[] dArray = chart3dGridData.getXGrid();
        double[] dArray2 = chart3dGridData.getYGrid();
        double[][] dArray3 = chart3dGridData.getZValues();
        double d2 = chart3dGridData.getHoleValue();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        JCChart3dStyle jCChart3dStyle = chart3dGridData.getChartStyle();
        int n6 = 0;
        int n7 = gridLimits.getXOffset();
        int n8 = n3 = gridLimits.getYOffset();
        while (n8 < n3 + n5) {
            int n9 = n7;
            while (n9 < n7 + n4) {
                if (dArray3[n9][n8] != d2) {
                    Point3d point3d = new Point3d(dArray[n9], dArray2[n8], dArray3[n9][n8]);
                    matrix4d.transform(point3d);
                    Integer n10 = new Integer(n6);
                    if (jCContour.isContoured() || jCContour.isZoned()) {
                        int n11 = this.contourLevels.getLevelFromValue(dArray3[n9][n8]);
                        color3f2 = bl ? this.getContourColor3f(n11) : new Color3f(jCChart3dStyle.getSymbolColor());
                        this.addChild((Node)new DataPoint(this.getContourStyleSymbol(n11, color3f2), this.scale * (double)this.getContourStyle(n11).getSymbolSize() / 6.0, point3d, (Object)n10));
                    } else {
                        if (jCChart3dStyle == null) {
                            return;
                        }
                        this.addChild((Node)new DataPoint(this.getChartStyleSymbol(jCChart3dStyle, new Color3f(jCChart3dStyle.getSymbolColor())), this.scale * (double)jCChart3dStyle.getSymbolSize() / 6.0, point3d, (Object)n10));
                    }
                }
                ++n6;
                ++n9;
            }
            ++n8;
        }
    }

    public JCDataPoints(Matrix4d matrix4d, Chart3dPointData chart3dPointData, Color3f color3f, int n2) {
        super(n2);
        Chart3dDataViewJava3d chart3dDataViewJava3d = (Chart3dDataViewJava3d)chart3dPointData.getDataView();
        JCChart3dJava3d jCChart3dJava3d = (JCChart3dJava3d)chart3dDataViewJava3d.getChart3d();
        this.area = (JCChart3dAreaJava3d)jCChart3dJava3d.getChart3dArea();
        double d2 = chart3dPointData.getHoleValue();
        int n3 = 0;
        while (n3 < chart3dPointData.getNumSeries()) {
            Chart3dPointSeries chart3dPointSeries = chart3dPointData.getSeries(n3);
            JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
            int n4 = 0;
            while (n4 < chart3dPointSeries.getNumPoints()) {
                Point3d point3d = new Point3d(chart3dPointSeries.getPoint(n4));
                if (point3d.z != d2) {
                    matrix4d.transform(point3d);
                    Data3dPointIndex data3dPointIndex = new Data3dPointIndex(n3, n4);
                    this.addChild((Node)new DataPoint(this.getChartStyleSymbol(jCChart3dStyle, new Color3f(jCChart3dStyle.getSymbolColor())), this.scale * (double)jCChart3dStyle.getSymbolSize() / 6.0, point3d, (Object)data3dPointIndex));
                }
                ++n4;
            }
            ++n3;
        }
    }

    private Appearance createAppearance(Color3f color3f, int n2) {
        Appearance appearance = new Appearance();
        JCRenderingAttributes jCRenderingAttributes = new JCRenderingAttributes();
        jCRenderingAttributes.setIgnoreVertexColors(true);
        appearance.setRenderingAttributes((RenderingAttributes)jCRenderingAttributes);
        JCColoringAttributes jCColoringAttributes = new JCColoringAttributes();
        jCColoringAttributes.setColor(color3f);
        jCColoringAttributes.setShadeModel(1);
        appearance.setColoringAttributes((ColoringAttributes)jCColoringAttributes);
        JCMaterial jCMaterial = new JCMaterial(color3f, 64.0f);
        jCMaterial.setLightingEnable(true);
        appearance.setMaterial((Material)jCMaterial);
        PointAttributes pointAttributes = new PointAttributes((float)n2, true);
        appearance.setPointAttributes(pointAttributes);
        return appearance;
    }

    private Shape3D getChartStyleSymbol(JCChart3dStyle jCChart3dStyle, Color3f color3f) {
        JCSymbolStyle jCSymbolStyle = jCChart3dStyle.getSymbolStyle();
        String string = jCSymbolStyle.getShape();
        Shape3D shape3D = this.getSymbol(string);
        Appearance appearance = this.createAppearance(color3f, jCSymbolStyle.getSize());
        shape3D.setAppearance(appearance);
        return shape3D;
    }

    private Color3f getContourColor3f(int n2) {
        int n3 = this.contour.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        JCFillStyle jCFillStyle = jCContourStyle.getFillStyle();
        Color color = jCFillStyle.getColor();
        return new Color3f(color);
    }

    private JCContourStyle getContourStyle(int n2) {
        int n3 = this.contour.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        return jCContourStyle;
    }

    private Shape3D getContourStyleSymbol(int n2, Color3f color3f) {
        int n3 = this.contour.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        JCSymbolStyle jCSymbolStyle = jCContourStyle.getSymbolStyle();
        String string = jCSymbolStyle.getShape();
        Shape3D shape3D = this.getSymbol(string);
        Appearance appearance = this.createAppearance(color3f, jCSymbolStyle.getSize());
        shape3D.setAppearance(appearance);
        return shape3D;
    }

    public double getScale() {
        return this.scale;
    }

    private Shape3D getSymbol(String string) {
        Object object = this.area.getShapeInstances().get(string);
        if (object == null) {
            try {
                object = Class.forName(string).newInstance();
            }
            catch (Exception exception) {}
            if (object instanceof JCSymbolShape3d) {
                this.area.getShapeInstances().put(string, object);
            }
        }
        return ((JCSymbolShape3d)object).getSymbolShape();
    }

    public void setRotation(double d2, double d3, double d4) {
        double d5 = Math.toRadians(d2);
        double d6 = Math.toRadians(d3);
        double d7 = Math.toRadians(d4);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.rotX((float)d5);
        Matrix3d matrix3d2 = new Matrix3d();
        matrix3d2.rotY((float)d6);
        matrix3d.mul(matrix3d2);
        matrix3d2.rotZ((float)d7);
        matrix3d.mul(matrix3d2);
        Transform3D transform3D = new Transform3D();
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            DataPoint dataPoint = (DataPoint)((Object)enumeration.nextElement());
            dataPoint.getTransform(transform3D);
            transform3D.setRotation(matrix3d);
            dataPoint.setTransform(transform3D);
        }
    }

    public void setScale(double d2) {
        this.scale = d2;
        Transform3D transform3D = new Transform3D();
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            DataPoint dataPoint = (DataPoint)((Object)enumeration.nextElement());
            dataPoint.getTransform(transform3D);
            transform3D.setScale(d2);
            dataPoint.setTransform(transform3D);
        }
    }
}

