/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d.j3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCGridColor;
import com.klg.jclass.chart3d.j3d.JCAppearance;
import com.klg.jclass.chart3d.j3d.JCBranchGroup;
import com.klg.jclass.chart3d.j3d.JCColoringAttributes;
import com.klg.jclass.chart3d.j3d.JCMaterial;
import com.klg.jclass.chart3d.j3d.JCRenderingAttributes;
import com.klg.jclass.chart3d.j3d.JCShape3D;
import com.sun.j3d.utils.picking.PickTool;
import java.awt.Color;
import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public abstract class JCDataBars
extends JCBranchGroup {
    protected static final float DEFAULT_SHININESS = 5.0f;
    protected static final float DEFAULT_POLYGON_OFFSET = -3.0f;
    protected float polygonOffset = -3.0f;
    protected JCBar barFormat = null;
    protected Chart3dDataView dataView = null;
    protected JCColoringAttributes colorAttrib = null;
    protected int nXBars = 0;
    protected int nYBars = 0;
    protected JCContour contour = null;
    protected JCContourLevels contourLevels = null;
    protected ArrayList contourStyles = null;
    protected JCShape3D[][] dataBars = null;

    public JCDataBars(JCBar jCBar, Matrix4d matrix4d, Chart3dGridData chart3dGridData, Color3f color3f, boolean bl, int n2) {
        super(n2);
        this.dataView = chart3dGridData.getDataView();
        this.contour = this.dataView.getContour();
        this.contourLevels = this.contour.getContourLevels();
        this.contourStyles = this.contour.getContourStyles();
        this.barFormat = jCBar;
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        double[] dArray = chart3dGridData.getXGrid();
        double[] dArray2 = chart3dGridData.getYGrid();
        double[][] dArray3 = chart3dGridData.getZValues();
        double d2 = chart3dGridData.getHoleValue();
        this.nXBars = jCBar.getXFormat() == 2 ? gridLimits.getNumX() - 1 : gridLimits.getNumX();
        this.nYBars = jCBar.getYFormat() == 2 ? gridLimits.getNumY() - 1 : gridLimits.getNumY();
        double d3 = chart3dGridData.getMinXStep();
        double d4 = chart3dGridData.getMinYStep();
        this.dataBars = new JCShape3D[gridLimits.getNumX()][gridLimits.getNumY()];
        double d5 = d3 * (jCBar.getXSpacing() / 100.0);
        double d6 = d4 * (jCBar.getYSpacing() / 100.0);
        Vector3d vector3d = new Vector3d(d5, 0.0, 0.0);
        matrix4d.transform(vector3d);
        d5 = vector3d.length();
        Vector3d vector3d2 = new Vector3d(0.0, d6, 0.0);
        matrix4d.transform(vector3d2);
        d6 = vector3d2.length();
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        int n4 = gridLimits.getYOffset();
        int n5 = gridLimits.getXOffset();
        int n6 = n4;
        while (n6 < n4 + this.nYBars) {
            int n7 = n5;
            while (n7 < n5 + this.nXBars) {
                if (dArray3[n7][n6] != d2) {
                    d7 = jCBar.getXFormat() == 2 ? dArray[n7] - d3 : dArray[n7] - d3 / 2.0;
                    d8 = jCBar.getYFormat() == 2 ? dArray2[n6] + d4 : dArray2[n6] + d4 / 2.0;
                    Color3f color3f2 = this.getBarColor(jCBar, color3f, n7, n6, dArray3);
                    this.dataBars[n7][n6] = this.createDataBar(matrix4d, d7, d8, dArray3[n7][n6], color3f2, d5, d6, color3f, bl, n3);
                    if (this.dataBars[n7][n6] != null) {
                        this.dataBars[n7][n6].setCapability(1);
                        PickTool.setCapabilities((Node)this.dataBars[n7][n6], (int)4100);
                        this.addChild((Node)this.dataBars[n7][n6]);
                    }
                }
                ++n3;
                ++n7;
            }
            ++n6;
        }
        this.compile();
    }

    protected abstract JCShape3D createDataBar(Matrix4d var1, double var2, double var4, double var6, Color3f var8, double var9, double var11, Color3f var13, boolean var14, int var15);

    public void getAmbientColor(Color3f color3f) {
        if (this.dataBars == null || this.dataBars[0][0] == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.dataBars[0][0].getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.getAmbientColor(color3f);
        }
    }

    protected Color3f getBarColor(JCBar jCBar, Color3f color3f, int n2, int n3, double[][] dArray) {
        Color color;
        JCGridColor jCGridColor;
        boolean bl;
        Color3f color3f2 = color3f;
        Chart3dGridData chart3dGridData = this.dataView.getZoneData();
        boolean bl2 = bl = chart3dGridData.isDataOK() && this.contour.isZoned();
        if (bl) {
            color3f2 = this.getContourColor3f(dArray[n2][n3]);
        } else if (!bl && (jCGridColor = this.dataView.findGridColor(n2, n3)) != null && (color = jCGridColor.getColor()) != null) {
            color3f2 = new Color3f(color);
        }
        return color3f2;
    }

    private Color3f getContourColor3f(double d2) {
        int n2 = this.contourLevels.getLevelFromValue(d2);
        int n3 = this.contour.contourIndex(n2);
        JCContourStyle jCContourStyle = (JCContourStyle)this.contourStyles.get(n3);
        JCFillStyle jCFillStyle = jCContourStyle.getFillStyle();
        Color color = jCFillStyle.getColor();
        return new Color3f(color);
    }

    public void getEmissiveColor(Color3f color3f) {
        if (this.dataBars == null || this.dataBars[0][0] == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.dataBars[0][0].getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.getEmissiveColor(color3f);
        }
    }

    public float getShininessColor() {
        JCAppearance jCAppearance;
        JCMaterial jCMaterial;
        float f2 = 5.0f;
        if (this.dataBars != null && this.dataBars[0][0] != null && (jCMaterial = (JCMaterial)(jCAppearance = (JCAppearance)this.dataBars[0][0].getAppearance()).getMaterial()) != null) {
            f2 = jCMaterial.getShininess();
        }
        return f2;
    }

    public void getSpecularColor(Color3f color3f) {
        if (this.dataBars == null || this.dataBars[0][0] == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)this.dataBars[0][0].getAppearance();
        JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
        if (jCMaterial != null) {
            jCMaterial.getSpecularColor(color3f);
        }
    }

    public void setAmbientColor(Color3f color3f) {
        if (this.dataBars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.nXBars) {
            int n3 = 0;
            while (n3 < this.nYBars) {
                JCAppearance jCAppearance;
                JCMaterial jCMaterial;
                if (this.dataBars[n2][n3] != null && (jCMaterial = (JCMaterial)(jCAppearance = (JCAppearance)this.dataBars[n2][n3].getAppearance()).getMaterial()) != null) {
                    jCMaterial.setAmbientColor(color3f);
                    jCAppearance.setMaterial(jCMaterial);
                    this.dataBars[n2][n3].setAppearance(jCAppearance);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setDataBarsLit(boolean bl) {
        int n2 = 0;
        while (n2 < this.nXBars) {
            int n3 = 0;
            while (n3 < this.nYBars) {
                if (this.dataBars[n2][n3] != null) {
                    JCAppearance jCAppearance = (JCAppearance)this.dataBars[n2][n3].getAppearance();
                    JCMaterial jCMaterial = (JCMaterial)jCAppearance.getMaterial();
                    jCMaterial.setLightingEnable(bl);
                    jCAppearance.setMaterial(jCMaterial);
                    this.dataBars[n2][n3].setAppearance(jCAppearance);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setDataBarsVisible(boolean bl) {
        if (this.dataBars != null) {
            int n2 = 0;
            while (n2 < this.nXBars) {
                int n3 = 0;
                while (n3 < this.nYBars) {
                    this.setShape3DVisible(this.dataBars[n2][n3], bl);
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public void setEmissiveColor(Color3f color3f) {
        if (this.dataBars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.nXBars) {
            int n3 = 0;
            while (n3 < this.nYBars) {
                JCAppearance jCAppearance;
                JCMaterial jCMaterial;
                if (this.dataBars[n2][n3] != null && (jCMaterial = (JCMaterial)(jCAppearance = (JCAppearance)this.dataBars[n2][n3].getAppearance()).getMaterial()) != null) {
                    jCMaterial.setEmissiveColor(color3f);
                    jCAppearance.setMaterial(jCMaterial);
                    this.dataBars[n2][n3].setAppearance(jCAppearance);
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void setShape3DVisible(JCShape3D jCShape3D, boolean bl) {
        if (jCShape3D == null) {
            return;
        }
        JCAppearance jCAppearance = (JCAppearance)jCShape3D.getAppearance();
        JCRenderingAttributes jCRenderingAttributes = (JCRenderingAttributes)jCAppearance.getRenderingAttributes();
        if (jCRenderingAttributes != null) {
            jCRenderingAttributes.setVisible(bl);
            jCAppearance.setRenderingAttributes(jCRenderingAttributes);
            jCShape3D.setAppearance(jCAppearance);
        }
    }

    public void setShininess(float f2) {
        if (this.dataBars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.nXBars) {
            int n3 = 0;
            while (n3 < this.nYBars) {
                JCAppearance jCAppearance;
                JCMaterial jCMaterial;
                if (this.dataBars[n2][n3] != null && (jCMaterial = (JCMaterial)(jCAppearance = (JCAppearance)this.dataBars[n2][n3].getAppearance()).getMaterial()) != null) {
                    jCMaterial.setShininess(f2);
                    jCAppearance.setMaterial(jCMaterial);
                    this.dataBars[n2][n3].setAppearance(jCAppearance);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setSpecularColor(Color3f color3f) {
        if (this.dataBars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.nXBars) {
            int n3 = 0;
            while (n3 < this.nYBars) {
                JCAppearance jCAppearance;
                JCMaterial jCMaterial;
                if (this.dataBars[n2][n3] != null && (jCMaterial = (JCMaterial)(jCAppearance = (JCAppearance)this.dataBars[n2][n3].getAppearance()).getMaterial()) != null) {
                    jCMaterial.setSpecularColor(color3f);
                    jCAppearance.setMaterial(jCMaterial);
                    this.dataBars[n2][n3].setAppearance(jCAppearance);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setTransparent(boolean bl) {
        if (this.dataBars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.nXBars) {
            int n3 = 0;
            while (n3 < this.nYBars) {
                JCAppearance jCAppearance;
                PolygonAttributes polygonAttributes;
                if (this.dataBars[n2][n3] != null && (polygonAttributes = (jCAppearance = (JCAppearance)this.dataBars[n2][n3].getAppearance()).getPolygonAttributes()) != null) {
                    if (bl) {
                        polygonAttributes.setPolygonMode(1);
                    } else {
                        polygonAttributes.setPolygonMode(2);
                    }
                    jCAppearance.setPolygonAttributes(polygonAttributes);
                    this.dataBars[n2][n3].setAppearance(jCAppearance);
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void showDataBarsZoneColors(boolean bl, JCShape3D jCShape3D) {
        if (jCShape3D == null) {
            return;
        }
        Appearance appearance = jCShape3D.getAppearance();
        JCRenderingAttributes jCRenderingAttributes = (JCRenderingAttributes)appearance.getRenderingAttributes();
        jCRenderingAttributes.setIgnoreVertexColors(bl ^ true);
        appearance.setRenderingAttributes((RenderingAttributes)jCRenderingAttributes);
        jCShape3D.setAppearance(appearance);
    }

    public void showDataBarsZoned(boolean bl) {
        if (this.dataBars != null) {
            int n2 = 0;
            while (n2 < this.nXBars) {
                int n3 = 0;
                while (n3 < this.nYBars) {
                    this.showDataBarsZoneColors(bl, this.dataBars[n2][n3]);
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

